/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.evaluation;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.api.SamigoApiFactory;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingComparatorByScoreAndUniqueIdentifier;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.shared.api.assessment.SecureDeliveryServiceAPI;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.HistogramBarBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.HistogramQuestionScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.HistogramScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.ItemBarBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.QuestionScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.TotalScoresBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class HistogramListener
implements ActionListener,
ValueChangeListener {
    private static Log log = LogFactory.getLog(HistogramListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        log.debug((Object)"HistogramListener.processAction()");
        TotalScoresBean totalBean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        HistogramScoresBean bean = (HistogramScoresBean)ContextUtil.lookupBean((String)"histogramScores");
        if (!this.histogramScores(bean, totalBean)) {
            String publishedId = totalBean.getPublishedId();
            if (publishedId.equals("0")) {
                publishedId = ContextUtil.lookupParam((String)"publishedAssessmentId");
            }
            log.error((Object)("Error getting statistics for assessment with published id = " + publishedId));
            FacesContext context = FacesContext.getCurrentInstance();
            FacesContext.getCurrentInstance().getApplication().createValueBinding("#{histogramScores}").setValue(FacesContext.getCurrentInstance(), null);
            return;
        }
    }

    public void processValueChange(ValueChangeEvent event) {
        if (!HtmlSelectOneMenu.class.isInstance(event.getSource()) || event.getNewValue() == null || event.getNewValue().equals(event.getOldValue())) {
            return;
        }
        HtmlSelectOneMenu selectOneMenu = (HtmlSelectOneMenu)HtmlSelectOneMenu.class.cast(event.getSource());
        if (selectOneMenu.getId() != null && selectOneMenu.getId().startsWith("allSubmissions")) {
            this.processAllSubmissionsChange(event);
        }
    }

    public void processAllSubmissionsChange(ValueChangeEvent event) {
        TotalScoresBean totalBean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        HistogramScoresBean bean = (HistogramScoresBean)ContextUtil.lookupBean((String)"histogramScores");
        QuestionScoresBean questionBean = (QuestionScoresBean)ContextUtil.lookupBean((String)"questionScores");
        String selectedvalue = (String)event.getNewValue();
        if (selectedvalue != null && !selectedvalue.equals("")) {
            log.debug((Object)"changed submission pulldown ");
            bean.setAllSubmissions(selectedvalue);
            totalBean.setAllSubmissions(selectedvalue);
            questionBean.setAllSubmissions(selectedvalue);
        }
        if (!this.histogramScores(bean, totalBean)) {
            String publishedId = totalBean.getPublishedId();
            if (publishedId.equals("0")) {
                publishedId = ContextUtil.lookupParam((String)"publishedAssessmentId");
            }
            log.error((Object)("Error getting statistics for assessment with published id = " + publishedId));
            FacesContext context = FacesContext.getCurrentInstance();
            FacesContext.getCurrentInstance().getApplication().createValueBinding("#{histogramScores}").setValue(FacesContext.getCurrentInstance(), null);
            return;
        }
    }

    public boolean histogramScores(HistogramScoresBean histogramScores, TotalScoresBean totalScores) {
        String actionString;
        DeliveryBean delivery = (DeliveryBean)ContextUtil.lookupBean((String)"delivery");
        String publishedId = totalScores.getPublishedId();
        if (publishedId.equals("0")) {
            publishedId = ContextUtil.lookupParam((String)"publishedAssessmentId");
        }
        if ((actionString = ContextUtil.lookupParam((String)"actionString")) != null && !actionString.equals("reviewAssessment")) {
            log.error((Object)("SAK-16437 happens!! publishedId = " + publishedId + ", agentId = " + AgentFacade.getAgentString()));
        }
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorMessages");
        ResourceLoader rbEval = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.EvaluationMessages");
        String assessmentName = "";
        histogramScores.clearLowerQuartileStudents();
        histogramScores.clearUpperQuartileStudents();
        String which = histogramScores.getAllSubmissions();
        if (which == null && totalScores.getAllSubmissions() != null) {
            which = totalScores.getAllSubmissions();
            histogramScores.setAllSubmissions(which);
        }
        histogramScores.setItemId(ContextUtil.lookupParam((String)"itemId"));
        histogramScores.setHasNav(ContextUtil.lookupParam((String)"hasNav"));
        GradingService delegate = new GradingService();
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        ArrayList allscores = delegate.getTotalScores(publishedId, which);
        for (AssessmentGradingData agd : allscores) {
            agd.setItemGradingSet(delegate.getItemGradingSet(String.valueOf(agd.getAssessmentGradingId())));
        }
        if (allscores.size() == 0) {
            delivery.setOutcome("reviewAssessmentError");
            delivery.setActionString(actionString);
            return true;
        }
        histogramScores.setPublishedId(publishedId);
        int callerName = 4;
        String isFromStudent = ContextUtil.lookupParam((String)"isFromStudent");
        if (isFromStudent != null && "true".equals(isFromStudent)) {
            callerName = 5;
        }
        Map useridMap = null;
        ArrayList<AssessmentGradingData> scores = new ArrayList<AssessmentGradingData>();
        if (totalScores.getReleaseToAnonymous()) {
            scores.addAll(allscores);
        } else {
            useridMap = totalScores.getUserIdMap(callerName);
            for (AssessmentGradingData data : allscores) {
                String agentid = data.getAgentId();
                if (!useridMap.containsKey(agentid)) continue;
                scores.add(data);
            }
        }
        Iterator iter = scores.iterator();
        if (!iter.hasNext()) {
            log.info((Object)"Students who have submitted may have been removed from this site");
            return false;
        }
        Map assessmentMap = this.getAssessmentStatisticsMap(scores);
        ArrayList submissionsSortedForDiscrim = new ArrayList(scores);
        boolean anonymous = Boolean.valueOf(totalScores.getAnonymous());
        Collections.sort(submissionsSortedForDiscrim, new AssessmentGradingComparatorByScoreAndUniqueIdentifier(anonymous));
        int numSubmissions = scores.size();
        int percent27 = numSubmissions * 27 / 100;
        if (percent27 == 0) {
            percent27 = 1;
        }
        for (int i = 0; i < percent27; ++i) {
            histogramScores.addToLowerQuartileStudents(((AssessmentGradingData)submissionsSortedForDiscrim.get(i)).getAgentId());
            histogramScores.addToUpperQuartileStudents(((AssessmentGradingData)submissionsSortedForDiscrim.get(numSubmissions - 1 - i)).getAgentId());
        }
        PublishedAssessmentFacade pub = pubService.getPublishedAssessment(publishedId, false);
        if (pub != null) {
            if (actionString != null && actionString.equals("reviewAssessment")) {
                String moduleId;
                if (AssessmentIfc.RETRACT_FOR_EDIT_STATUS.equals(pub.getStatus())) {
                    delivery.setOutcome("isRetractedForEdit2");
                    delivery.setActionString(actionString);
                    return true;
                }
                delivery.setOutcome("histogramScores");
                delivery.setSecureDeliveryHTMLFragment("");
                delivery.setBlockDelivery(false);
                SecureDeliveryServiceAPI secureDelivery = SamigoApiFactory.getInstance().getSecureDeliveryServiceAPI();
                if (secureDelivery.isSecureDeliveryAvaliable() && (moduleId = pub.getAssessmentMetaDataByLabel("SECURE_DELIVERY_MODULE_KEY")) != null && !"SECURE_DELIVERY_NONE_ID".equals(moduleId)) {
                    HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
                    SecureDeliveryServiceAPI.PhaseStatus status = secureDelivery.validatePhase(moduleId, SecureDeliveryServiceAPI.Phase.ASSESSMENT_REVIEW, (PublishedAssessmentIfc)pub, request);
                    delivery.setSecureDeliveryHTMLFragment(secureDelivery.getHTMLFragment(moduleId, (PublishedAssessmentIfc)pub, request, SecureDeliveryServiceAPI.Phase.ASSESSMENT_REVIEW, status, new ResourceLoader().getLocale()));
                    if (SecureDeliveryServiceAPI.PhaseStatus.FAILURE == status) {
                        delivery.setOutcome("secureDeliveryError");
                        delivery.setActionString(actionString);
                        delivery.setBlockDelivery(true);
                        return true;
                    }
                }
            }
            assessmentName = pub.getTitle();
            ArrayList parts = pub.getSectionArraySorted();
            histogramScores.setAssesmentParts((List)parts);
            ArrayList<HistogramQuestionScoresBean> info = new ArrayList<HistogramQuestionScoresBean>();
            Iterator partsIter = parts.iterator();
            int secseq = 1;
            double totalpossible = 0.0;
            boolean hasRandompart = false;
            boolean isRandompart = false;
            String poolName = null;
            HashMap itemScoresMap = delegate.getItemScores(Long.valueOf(publishedId), Long.valueOf(0L), which);
            HashMap itemScores = new HashMap();
            if (totalScores.getReleaseToAnonymous()) {
                itemScores.putAll(itemScoresMap);
            } else {
                if (useridMap == null) {
                    useridMap = totalScores.getUserIdMap(callerName);
                }
                for (Map.Entry entry : itemScoresMap.entrySet()) {
                    Long itemId = (Long)entry.getKey();
                    ArrayList itemScoresList = (ArrayList)entry.getValue();
                    ArrayList<ItemGradingData> filteredItemScoresList = new ArrayList<ItemGradingData>();
                    for (ItemGradingData idata : itemScoresList) {
                        String agentid = idata.getAgentId();
                        if (!useridMap.containsKey(agentid)) continue;
                        filteredItemScoresList.add(idata);
                    }
                    itemScores.put(itemId, filteredItemScoresList);
                }
            }
            while (partsIter.hasNext()) {
                SectionDataIfc section = (SectionDataIfc)partsIter.next();
                String authortype = section.getSectionMetaDataByLabel("AUTHOR_TYPE");
                try {
                    if (SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.equals(Integer.valueOf(authortype))) {
                        hasRandompart = true;
                        isRandompart = true;
                        poolName = section.getSectionMetaDataByLabel("POOLNAME_FOR_RANDOM_DRAW");
                    } else {
                        isRandompart = false;
                        poolName = null;
                    }
                }
                catch (NumberFormatException e) {
                    isRandompart = false;
                    poolName = null;
                }
                if (section.getSequence() == null) {
                    section.setSequence(Integer.valueOf(secseq++));
                }
                String title = rb.getString("p") + " " + section.getSequence().toString();
                title = title + ", " + rb.getString("q") + " ";
                ArrayList itemset = section.getItemArraySortedForGrading();
                int seq = 1;
                Iterator itemsIter = itemset.iterator();
                while (itemsIter.hasNext()) {
                    HistogramQuestionScoresBean questionScores = new HistogramQuestionScoresBean();
                    questionScores.setNumberOfParts(parts.size());
                    questionScores.setRandomType(isRandompart);
                    questionScores.setPoolName(poolName);
                    ItemDataIfc item = (ItemDataIfc)itemsIter.next();
                    String type = this.getType(item.getTypeId().intValue());
                    if (item.getSequence() == null) {
                        item.setSequence(Integer.valueOf(seq++));
                    }
                    questionScores.setPartNumber(section.getSequence().toString());
                    if (questionScores.getRandomType() && poolName != null) {
                        if (questionScores.getNumberOfParts() > 1) {
                            questionScores.setQuestionLabelFormat(rb.getString("label_question_part_pool", null));
                        } else {
                            questionScores.setQuestionLabelFormat(rb.getString("label_question_pool", null));
                        }
                    } else if (questionScores.getNumberOfParts() > 1) {
                        questionScores.setQuestionLabelFormat(rb.getString("label_question_part", null));
                    } else {
                        questionScores.setQuestionLabelFormat(rb.getString("label_question", null));
                    }
                    questionScores.setQuestionNumber(item.getSequence().toString());
                    questionScores.setItemId(item.getItemId());
                    questionScores.setTitle(title + item.getSequence().toString() + " (" + type + ")");
                    questionScores.setQuestionText(item.getText());
                    questionScores.setQuestionType(item.getTypeId().toString());
                    this.determineResults((PublishedAssessmentIfc)pub, questionScores, (ArrayList)itemScores.get(item.getItemId()));
                    questionScores.setTotalScore(item.getScore().toString());
                    questionScores.setN("" + numSubmissions);
                    questionScores.setItemId(item.getItemId());
                    Set studentsWithAllCorrect = questionScores.getStudentsWithAllCorrect();
                    Set studentsResponded = questionScores.getStudentsResponded();
                    if (studentsWithAllCorrect == null || studentsResponded == null || studentsWithAllCorrect.isEmpty() || studentsResponded.isEmpty()) {
                        questionScores.setPercentCorrectFromUpperQuartileStudents("0");
                        questionScores.setPercentCorrectFromLowerQuartileStudents("0");
                        questionScores.setDiscrimination("0.0");
                    } else {
                        int percent27ForThisQuestion = percent27;
                        Set upperQuartileStudents = histogramScores.getUpperQuartileStudents().keySet();
                        Set lowerQuartileStudents = histogramScores.getLowerQuartileStudents().keySet();
                        if (isRandompart) {
                            upperQuartileStudents = new HashSet();
                            lowerQuartileStudents = new HashSet();
                            percent27ForThisQuestion = questionScores.getNumResponses() * 27 / 100;
                            if (percent27ForThisQuestion == 0) {
                                percent27ForThisQuestion = 1;
                            }
                            if (questionScores.getNumResponses() != 0) {
                                List filteredGradings = this.filterGradingData(submissionsSortedForDiscrim, questionScores.getItemId());
                                for (int i = 0; i < percent27ForThisQuestion; ++i) {
                                    lowerQuartileStudents.add(((AssessmentGradingData)filteredGradings.get(i)).getAgentId());
                                    upperQuartileStudents.add(((AssessmentGradingData)filteredGradings.get(questionScores.getNumResponses() - 1 - i)).getAgentId());
                                }
                            }
                        }
                        if (questionScores.getNumResponses() != 0) {
                            int numStudentsWithAllCorrectFromUpperQuartile = 0;
                            int numStudentsWithAllCorrectFromLowerQuartile = 0;
                            for (String agentId : studentsWithAllCorrect) {
                                if (upperQuartileStudents.contains(agentId)) {
                                    ++numStudentsWithAllCorrectFromUpperQuartile;
                                }
                                if (!lowerQuartileStudents.contains(agentId)) continue;
                                ++numStudentsWithAllCorrectFromLowerQuartile;
                            }
                            float percentCorrectFromUpperQuartileStudents = (float)numStudentsWithAllCorrectFromUpperQuartile / (float)percent27ForThisQuestion * 100.0f;
                            float percentCorrectFromLowerQuartileStudents = (float)numStudentsWithAllCorrectFromLowerQuartile / (float)percent27ForThisQuestion * 100.0f;
                            questionScores.setPercentCorrectFromUpperQuartileStudents(Integer.toString((int)percentCorrectFromUpperQuartileStudents));
                            questionScores.setPercentCorrectFromLowerQuartileStudents(Integer.toString((int)percentCorrectFromLowerQuartileStudents));
                            float discrimination = ((float)numStudentsWithAllCorrectFromUpperQuartile - (float)numStudentsWithAllCorrectFromLowerQuartile) / (float)percent27ForThisQuestion;
                            if (discrimination > 999999.0f || discrimination < -999999.0f) {
                                questionScores.setDiscrimination("NaN");
                            } else {
                                discrimination = (float)((int)(discrimination * 100.0f)) / 100.0f;
                                questionScores.setDiscrimination(Float.toString(discrimination));
                            }
                        } else {
                            questionScores.setPercentCorrectFromUpperQuartileStudents(rbEval.getString("na"));
                            questionScores.setPercentCorrectFromLowerQuartileStudents(rbEval.getString("na"));
                            questionScores.setDiscrimination(rbEval.getString("na"));
                        }
                    }
                    info.add(questionScores);
                }
                totalpossible = pub.getTotalScore().doubleValue();
            }
            histogramScores.setInfo(info);
            histogramScores.setRandomType(hasRandompart);
            int maxNumOfAnswers = 0;
            ArrayList<HistogramQuestionScoresBean> detailedStatistics = new ArrayList<HistogramQuestionScoresBean>();
            for (HistogramQuestionScoresBean questionScores : info) {
                if (!questionScores.getQuestionType().equals("1") && !questionScores.getQuestionType().equals("2") && !questionScores.getQuestionType().equals("3") && !questionScores.getQuestionType().equals("4")) continue;
                detailedStatistics.add(questionScores);
                if (questionScores.getHistogramBars() == null) continue;
                maxNumOfAnswers = questionScores.getHistogramBars().length > maxNumOfAnswers ? questionScores.getHistogramBars().length : maxNumOfAnswers;
            }
            histogramScores.setDetailedStatistics(detailedStatistics);
            histogramScores.setMaxNumberOfAnswers(maxNumOfAnswers);
            if (assessmentMap.isEmpty()) {
                histogramScores.setNumResponses(0);
            }
            try {
                BeanUtils.populate((Object)histogramScores, (Map)assessmentMap);
                histogramScores.setQ1((String)assessmentMap.get("q1"));
                histogramScores.setQ2((String)assessmentMap.get("q2"));
                histogramScores.setQ3((String)assessmentMap.get("q3"));
                histogramScores.setQ4((String)assessmentMap.get("q4"));
                histogramScores.setTotalScore((String)assessmentMap.get("totalScore"));
                histogramScores.setTotalPossibleScore(Double.toString(totalpossible));
                HistogramBarBean[] bars = new HistogramBarBean[histogramScores.getColumnHeight().length];
                for (int i = 0; i < histogramScores.getColumnHeight().length; ++i) {
                    bars[i] = new HistogramBarBean();
                    bars[i].setColumnHeight(Integer.toString(histogramScores.getColumnHeight()[i]));
                    bars[i].setNumStudents(histogramScores.getNumStudentCollection()[i]);
                    bars[i].setRangeInfo(histogramScores.getRangeCollection()[i]);
                }
                histogramScores.setHistogramBars(bars);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("IllegalAccessException:  unable to populate bean" + e));
            }
            catch (InvocationTargetException e) {
                log.warn((Object)("InvocationTargetException: unable to populate bean" + e));
            }
        } else {
            log.error((Object)("pub is null. publishedId = " + publishedId));
            return false;
        }
        histogramScores.setAssessmentName(assessmentName);
        return true;
    }

    private void determineResults(PublishedAssessmentIfc pub, HistogramQuestionScoresBean qbean, ArrayList<ItemGradingData> itemScores) {
        if (itemScores == null) {
            itemScores = new ArrayList();
        }
        int responses = 0;
        HashSet<Long> assessmentGradingIds = new HashSet<Long>();
        int numStudentsWithZeroAnswers = 0;
        for (ItemGradingData itemGradingData : itemScores) {
            if (assessmentGradingIds.contains(itemGradingData.getAssessmentGradingId())) continue;
            ++responses;
            assessmentGradingIds.add(itemGradingData.getAssessmentGradingId());
            if (itemGradingData.getSubmittedDate() != null) continue;
            ++numStudentsWithZeroAnswers;
        }
        qbean.setNumResponses(responses);
        qbean.setNumberOfStudentsWithZeroAnswers(numStudentsWithZeroAnswers);
        if (qbean.getQuestionType().equals("1") || qbean.getQuestionType().equals("2") || qbean.getQuestionType().equals("12") || qbean.getQuestionType().equals("3") || qbean.getQuestionType().equals("4") || qbean.getQuestionType().equals("9") || qbean.getQuestionType().equals("8") || qbean.getQuestionType().equals("11") || qbean.getQuestionType().equals("13")) {
            this.doAnswerStatistics(pub, qbean, itemScores);
        }
        if (qbean.getQuestionType().equals("5") || qbean.getQuestionType().equals("6") || qbean.getQuestionType().equals("7")) {
            this.doScoreStatistics(qbean, itemScores);
        }
    }

    private void doAnswerStatistics(PublishedAssessmentIfc pub, HistogramQuestionScoresBean qbean, ArrayList scores) {
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.EvaluationMessages");
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        HashMap publishedItemHash = pubService.preparePublishedItemHash(pub);
        HashMap publishedItemTextHash = pubService.preparePublishedItemTextHash(pub);
        HashMap publishedAnswerHash = pubService.preparePublishedAnswerHash(pub);
        ItemDataIfc item = (ItemDataIfc)publishedItemHash.get(qbean.getItemId());
        ArrayList text = item.getItemTextArraySorted();
        ArrayList answers = null;
        if (!qbean.getQuestionType().equals("9")) {
            ItemTextIfc firstText = (ItemTextIfc)publishedItemTextHash.get(((ItemTextIfc)text.toArray()[0]).getId());
            answers = firstText.getAnswerArraySorted();
        }
        if (qbean.getQuestionType().equals("1")) {
            this.getTFMCScores(publishedAnswerHash, scores, qbean, answers);
        } else if (qbean.getQuestionType().equals("2")) {
            this.getFIBMCMCScores(publishedItemHash, publishedAnswerHash, scores, qbean, answers);
        } else if (qbean.getQuestionType().equals("12")) {
            this.getTFMCScores(publishedAnswerHash, scores, qbean, answers);
        } else if (qbean.getQuestionType().equals("3")) {
            this.getTFMCScores(publishedAnswerHash, scores, qbean, answers);
        } else if (qbean.getQuestionType().equals("4")) {
            this.getTFMCScores(publishedAnswerHash, scores, qbean, answers);
        } else if (qbean.getQuestionType().equals("8") || qbean.getQuestionType().equals("11")) {
            this.getFIBMCMCScores(publishedItemHash, publishedAnswerHash, scores, qbean, answers);
        } else if (qbean.getQuestionType().equals("9")) {
            this.getMatchingScores(publishedItemTextHash, publishedAnswerHash, scores, qbean, text);
        } else if (qbean.getQuestionType().equals("13")) {
            this.getMatrixSurveyScores(publishedItemTextHash, publishedAnswerHash, scores, qbean, text);
        }
    }

    private void getFIBMCMCScores(HashMap publishedItemHash, HashMap publishedAnswerHash, ArrayList scores, HistogramQuestionScoresBean qbean, ArrayList answers) {
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.EvaluationMessages");
        HashMap<Long, AnswerIfc> texts = new HashMap<Long, AnswerIfc>();
        Iterator iter = answers.iterator();
        HashMap<Long, Integer> results = new HashMap<Long, Integer>();
        HashMap<Long, ArrayList<ItemGradingData>> numStudentRespondedMap = new HashMap<Long, ArrayList<ItemGradingData>>();
        HashMap<Long, Long> sequenceMap = new HashMap<Long, Long>();
        while (iter.hasNext()) {
            AnswerIfc answer = (AnswerIfc)iter.next();
            texts.put(answer.getId(), answer);
            results.put(answer.getId(), 0);
            sequenceMap.put(answer.getSequence(), answer.getId());
        }
        for (ItemGradingData data : scores) {
            ArrayList<ItemGradingData> studentResponseList;
            AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
            if (answer == null) continue;
            Integer num = null;
            try {
                num = (Integer)results.get(answer.getId());
            }
            catch (Exception e) {
                log.warn((Object)("No results for " + answer.getId()));
            }
            if (num == null) {
                num = 0;
            }
            if ((studentResponseList = (ArrayList<ItemGradingData>)numStudentRespondedMap.get(data.getAssessmentGradingId())) == null) {
                studentResponseList = new ArrayList<ItemGradingData>();
            }
            studentResponseList.add(data);
            numStudentRespondedMap.put(data.getAssessmentGradingId(), studentResponseList);
            if (qbean.getQuestionType().equals("8") || qbean.getQuestionType().equals("11")) {
                Float autoscore = data.getAutoScore();
                if (Float.valueOf(0.0f).equals(autoscore)) continue;
                results.put(answer.getId(), num + 1);
                continue;
            }
            results.put(answer.getId(), num + 1);
        }
        HistogramBarBean[] bars = new HistogramBarBean[results.keySet().size()];
        int[] numarray = new int[results.keySet().size()];
        ArrayList<Long> sequenceList = new ArrayList<Long>();
        for (AnswerIfc answer : answers) {
            sequenceList.add(answer.getSequence());
        }
        Collections.sort(sequenceList);
        iter = sequenceList.iterator();
        int i = 0;
        int correctresponses = 0;
        while (iter.hasNext()) {
            int num;
            Long sequenceId = (Long)iter.next();
            Long answerId = (Long)sequenceMap.get(sequenceId);
            AnswerIfc answer = (AnswerIfc)texts.get(answerId);
            numarray[i] = num = ((Integer)results.get(answerId)).intValue();
            bars[i] = new HistogramBarBean();
            if (answer != null) {
                bars[i].setLabel(answer.getText());
            }
            if (!qbean.getQuestionType().equals("8") && !qbean.getQuestionType().equals("11") && answer != null) {
                bars[i].setIsCorrect(answer.getIsCorrect());
            }
            if (num > 1 || num == 0) {
                bars[i].setNumStudentsText(num + " " + rb.getString("responses"));
            } else {
                bars[i].setNumStudentsText(num + " " + rb.getString("response"));
            }
            bars[i].setNumStudents(num);
            ++i;
        }
        for (Map.Entry entry : numStudentRespondedMap.entrySet()) {
            ArrayList resultsForOneStudent = (ArrayList)entry.getValue();
            boolean hasIncorrect = false;
            for (ItemGradingData item : resultsForOneStudent) {
                if (qbean.getQuestionType().equals("8") || qbean.getQuestionType().equals("11")) {
                    Float autoscore = item.getAutoScore();
                    if (!Float.valueOf(0.0f).equals(autoscore)) continue;
                    hasIncorrect = true;
                    break;
                }
                if (!qbean.getQuestionType().equals("2")) continue;
                try {
                    ArrayList itemTextArray = ((ItemDataIfc)publishedItemHash.get(item.getPublishedItemId())).getItemTextArraySorted();
                    ArrayList answerArray = ((ItemTextIfc)itemTextArray.get(0)).getAnswerArraySorted();
                    int corranswers = 0;
                    for (AnswerIfc answerchoice : answerArray) {
                        if (!answerchoice.getIsCorrect().booleanValue()) continue;
                        ++corranswers;
                    }
                    if (resultsForOneStudent.size() != corranswers) {
                        hasIncorrect = true;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("error calculating mcmc question.");
                }
                AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(item.getPublishedAnswerId());
                if (answer == null || answer.getIsCorrect() != null && answer.getIsCorrect().booleanValue()) continue;
                hasIncorrect = true;
                break;
            }
            if (!hasIncorrect) {
                ++correctresponses;
                qbean.addStudentWithAllCorrect(((ItemGradingData)resultsForOneStudent.get(0)).getAgentId());
            }
            qbean.addStudentResponded(((ItemGradingData)resultsForOneStudent.get(0)).getAgentId());
        }
        int[] heights = HistogramListener.calColumnHeight((int[])numarray, (int)qbean.getNumResponses());
        for (i = 0; i < bars.length; ++i) {
            try {
                bars[i].setColumnHeight(Integer.toString(heights[i]));
                continue;
            }
            catch (NullPointerException npe) {
                log.warn((Object)("bars[" + i + "] is null. " + npe));
            }
        }
        qbean.setHistogramBars(bars);
        if (qbean.getNumResponses() > 0) {
            qbean.setPercentCorrect(Integer.toString((int)((float)correctresponses / (float)qbean.getNumResponses() * 100.0f)));
        }
    }

    private void getTFMCScores(HashMap publishedAnswerHash, ArrayList scores, HistogramQuestionScoresBean qbean, ArrayList answers) {
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.EvaluationMessages");
        HashMap<Long, AnswerIfc> texts = new HashMap<Long, AnswerIfc>();
        Iterator iter = answers.iterator();
        HashMap<Long, Integer> results = new HashMap<Long, Integer>();
        HashMap<Long, Long> sequenceMap = new HashMap<Long, Long>();
        while (iter.hasNext()) {
            AnswerIfc answer = (AnswerIfc)iter.next();
            texts.put(answer.getId(), answer);
            results.put(answer.getId(), 0);
            sequenceMap.put(answer.getSequence(), answer.getId());
        }
        for (ItemGradingData data : scores) {
            AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
            if (answer == null) continue;
            Integer num = null;
            try {
                num = (Integer)results.get(answer.getId());
            }
            catch (Exception e) {
                log.warn((Object)("No results for " + answer.getId()));
                e.printStackTrace();
            }
            if (num == null) {
                num = 0;
            }
            results.put(answer.getId(), num + 1);
            if (answer.getIsCorrect() != null && answer.getIsCorrect().booleanValue()) {
                qbean.addStudentWithAllCorrect(data.getAgentId());
            }
            qbean.addStudentResponded(data.getAgentId());
        }
        HistogramBarBean[] bars = new HistogramBarBean[results.keySet().size()];
        int[] numarray = new int[results.keySet().size()];
        ArrayList<Long> sequenceList = new ArrayList<Long>();
        for (AnswerIfc answer : answers) {
            sequenceList.add(answer.getSequence());
        }
        Collections.sort(sequenceList);
        iter = sequenceList.iterator();
        int i = 0;
        int correctresponses = 0;
        while (iter.hasNext()) {
            Long sequenceId = (Long)iter.next();
            Long answerId = (Long)sequenceMap.get(sequenceId);
            AnswerIfc answer = (AnswerIfc)texts.get(answerId);
            int num = (Integer)results.get(answerId);
            i = answer.getSequence().intValue() - 1;
            numarray[i] = num;
            bars[i] = new HistogramBarBean();
            if (qbean.getQuestionType().equals("4")) {
                String origText = answer.getText();
                String text = "";
                text = "true".equals(origText) ? rb.getString("true_msg") : rb.getString("false_msg");
                bars[i].setLabel(text);
            } else {
                bars[i].setLabel(answer.getText());
            }
            bars[i].setIsCorrect(answer.getIsCorrect());
            if (num > 1 || num == 0) {
                bars[i].setNumStudentsText(num + " " + rb.getString("responses"));
            } else {
                bars[i].setNumStudentsText(num + " " + rb.getString("response"));
            }
            bars[i].setNumStudents(num);
            if (answer.getIsCorrect() == null || !answer.getIsCorrect().booleanValue()) continue;
            correctresponses += num;
        }
        int[] heights = HistogramListener.calColumnHeight((int[])numarray, (int)qbean.getNumResponses());
        for (i = 0; i < bars.length; ++i) {
            try {
                bars[i].setColumnHeight(Integer.toString(heights[i]));
                continue;
            }
            catch (NullPointerException npe) {
                log.warn((Object)("bars[" + i + "] is null. " + npe));
            }
        }
        qbean.setHistogramBars(bars);
        if (qbean.getNumResponses() > 0) {
            qbean.setPercentCorrect(Integer.toString((int)((float)correctresponses / (float)qbean.getNumResponses() * 100.0f)));
        }
    }

    private void getMatchingScores(HashMap publishedItemTextHash, HashMap publishedAnswerHash, ArrayList scores, HistogramQuestionScoresBean qbean, ArrayList labels) {
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.EvaluationMessages");
        ResourceLoader rc = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.CommonMessages");
        HashMap<Long, ItemTextIfc> texts = new HashMap<Long, ItemTextIfc>();
        Iterator iter = labels.iterator();
        HashMap<Long, Integer> results = new HashMap<Long, Integer>();
        HashMap<Long, ArrayList<ItemGradingData>> numStudentRespondedMap = new HashMap<Long, ArrayList<ItemGradingData>>();
        HashMap<Long, Long> sequenceMap = new HashMap<Long, Long>();
        while (iter.hasNext()) {
            ItemTextIfc label = (ItemTextIfc)iter.next();
            texts.put(label.getId(), label);
            results.put(label.getId(), 0);
            sequenceMap.put(label.getSequence(), label.getId());
        }
        for (ItemGradingData data : scores) {
            ArrayList<ItemGradingData> studentResponseList;
            ItemTextIfc text = (ItemTextIfc)publishedItemTextHash.get(data.getPublishedItemTextId());
            AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
            if (answer == null) continue;
            Integer num = (Integer)results.get(text.getId());
            if (num == null) {
                num = 0;
            }
            if ((studentResponseList = (ArrayList<ItemGradingData>)numStudentRespondedMap.get(data.getAssessmentGradingId())) == null) {
                studentResponseList = new ArrayList<ItemGradingData>();
            }
            studentResponseList.add(data);
            numStudentRespondedMap.put(data.getAssessmentGradingId(), studentResponseList);
            if (answer.getIsCorrect() == null || !answer.getIsCorrect().booleanValue()) continue;
            results.put(text.getId(), num + 1);
        }
        HistogramBarBean[] bars = new HistogramBarBean[results.keySet().size()];
        int[] numarray = new int[results.keySet().size()];
        ArrayList<Long> sequenceList = new ArrayList<Long>();
        for (ItemTextIfc label : labels) {
            sequenceList.add(label.getSequence());
        }
        Collections.sort(sequenceList);
        iter = sequenceList.iterator();
        int i = 0;
        int correctresponses = 0;
        while (iter.hasNext()) {
            int num;
            Long sequenceId = (Long)iter.next();
            Long textId = (Long)sequenceMap.get(sequenceId);
            ItemTextIfc text = (ItemTextIfc)texts.get(textId);
            numarray[i] = num = ((Integer)results.get(textId)).intValue();
            bars[i] = new HistogramBarBean();
            bars[i].setLabel(text.getText());
            bars[i].setNumStudents(num);
            if (num > 1 || num == 0) {
                bars[i].setNumStudentsText(num + " " + rb.getString("correct_responses"));
            } else {
                bars[i].setNumStudentsText(num + " " + rc.getString("correct_response"));
            }
            ++i;
        }
        for (Map.Entry entry : numStudentRespondedMap.entrySet()) {
            ArrayList resultsForOneStudent = (ArrayList)entry.getValue();
            boolean hasIncorrect = false;
            for (ItemGradingData item : resultsForOneStudent) {
                if (resultsForOneStudent.size() != labels.size()) {
                    hasIncorrect = true;
                    break;
                }
                AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(item.getPublishedAnswerId());
                if (answer.getIsCorrect() != null && answer.getIsCorrect().booleanValue()) continue;
                hasIncorrect = true;
                break;
            }
            if (!hasIncorrect) {
                ++correctresponses;
                qbean.addStudentWithAllCorrect(((ItemGradingData)resultsForOneStudent.get(0)).getAgentId());
            }
            qbean.addStudentResponded(((ItemGradingData)resultsForOneStudent.get(0)).getAgentId());
        }
        int[] heights = HistogramListener.calColumnHeight((int[])numarray, (int)qbean.getNumResponses());
        for (i = 0; i < bars.length; ++i) {
            try {
                bars[i].setColumnHeight(Integer.toString(heights[i]));
                continue;
            }
            catch (NullPointerException npe) {
                log.warn((Object)("bars[" + i + "] is null. " + npe));
            }
        }
        qbean.setHistogramBars(bars);
        if (qbean.getNumResponses() > 0) {
            qbean.setPercentCorrect(Integer.toString((int)((float)correctresponses / (float)qbean.getNumResponses() * 100.0f)));
        }
    }

    private void getMatrixSurveyScores(HashMap publishedItemTextHash, HashMap publishedAnswerHash, ArrayList scores, HistogramQuestionScoresBean qbean, ArrayList labels) {
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.EvaluationMessages");
        HashMap<Long, ItemTextIfc> texts = new HashMap<Long, ItemTextIfc>();
        HashMap<Long, Integer> rows = new HashMap<Long, Integer>();
        HashMap sequenceMap = new HashMap();
        HashMap<Long, Integer> answers = new HashMap<Long, Integer>();
        HashMap<Long, ArrayList<ItemGradingData>> numStudentRespondedMap = new HashMap<Long, ArrayList<ItemGradingData>>();
        for (ItemTextIfc label : labels) {
            texts.put(label.getId(), label);
            rows.put(label.getId(), 0);
        }
        for (ItemGradingData data : scores) {
            ArrayList<ItemGradingData> studentResponseList;
            AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
            if (answer != null) {
                Integer num = null;
                try {
                    num = (Integer)answers.get(answer.getId());
                }
                catch (Exception e) {
                    log.warn((Object)("No results for " + answer.getId()));
                    log.error((Object)e.getMessage());
                }
                if (num == null) {
                    num = 0;
                }
                answers.put(answer.getId(), num + 1);
                Long id = answer.getItemText().getId();
                Integer rCount = null;
                try {
                    rCount = (Integer)rows.get(id);
                }
                catch (Exception e) {
                    log.warn((Object)("No results for " + id));
                    log.error((Object)e.getMessage());
                }
                if (rCount != null) {
                    rows.put(id, rCount + 1);
                }
            }
            if ((studentResponseList = (ArrayList<ItemGradingData>)numStudentRespondedMap.get(data.getAssessmentGradingId())) == null) {
                studentResponseList = new ArrayList<ItemGradingData>();
            }
            studentResponseList.add(data);
            numStudentRespondedMap.put(data.getAssessmentGradingId(), studentResponseList);
            qbean.addStudentResponded(data.getAgentId());
        }
        ArrayList<String> answerTextList = new ArrayList<String>();
        Iterator<Object> iter = publishedAnswerHash.keySet().iterator();
        boolean isIn = false;
        while (iter.hasNext()) {
            Long id = (Long)iter.next();
            AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(id);
            for (int i = 0; i < answerTextList.size(); ++i) {
                if (!answer.getText().trim().equals(((String)answerTextList.get(i)).trim())) continue;
                isIn = true;
                break;
            }
            if (isIn) continue;
            String ansStr = new String(answer.getText().trim());
            answerTextList.add(ansStr);
        }
        ArrayList<HistogramBarBean> histogramBarList = new ArrayList<HistogramBarBean>();
        for (Long id : texts.keySet()) {
            HistogramBarBean gramBar = new HistogramBarBean();
            ItemTextIfc ifc = (ItemTextIfc)texts.get(id);
            Integer totalCount = (Integer)rows.get(id);
            gramBar.setLabel(ifc.getText());
            ArrayList<ItemBarBean> itemBars = new ArrayList<ItemBarBean>();
            for (int i = 0; i < answerTextList.size(); ++i) {
                ItemBarBean barBean = new ItemBarBean();
                int count = 0;
                for (Long id1 : publishedAnswerHash.keySet()) {
                    AnswerIfc answer1 = (AnswerIfc)publishedAnswerHash.get(id1);
                    if (!answer1.getText().equals((String)answerTextList.get(i)) || !answer1.getItemText().getText().equals(ifc.getText())) continue;
                    if (!answers.containsKey(answer1.getId())) break;
                    count = (Integer)answers.get(answer1.getId());
                    break;
                }
                if (count > 1) {
                    barBean.setNumStudentsText(count + " responses");
                } else {
                    barBean.setNumStudentsText(count + " response");
                }
                barBean.setItemText((String)answerTextList.get(i));
                int height = 0;
                if (totalCount != 0) {
                    height = 300 * count / totalCount;
                }
                barBean.setColumnHeight(Integer.toString(height));
                itemBars.add(barBean);
            }
            gramBar.setItemBars(itemBars);
            histogramBarList.add(gramBar);
        }
        qbean.setHistogramBars(histogramBarList.toArray(new HistogramBarBean[histogramBarList.size()]));
        qbean.setNumResponses(numStudentRespondedMap.size());
    }

    private void doScoreStatistics(HistogramQuestionScoresBean qbean, ArrayList scores) {
        Map assessmentMap = this.getAssessmentStatisticsMap(scores);
        if (assessmentMap.isEmpty()) {
            qbean.setNumResponses(0);
        }
        try {
            BeanUtils.populate((Object)qbean, (Map)assessmentMap);
            qbean.setQ1((String)assessmentMap.get("q1"));
            qbean.setQ2((String)assessmentMap.get("q2"));
            qbean.setQ3((String)assessmentMap.get("q3"));
            qbean.setQ4((String)assessmentMap.get("q4"));
            HistogramBarBean[] bars = new HistogramBarBean[qbean.getColumnHeight().length];
            if (scores.size() == 0) {
                bars = new HistogramBarBean[]{};
            } else {
                for (int i = 0; i < qbean.getColumnHeight().length; ++i) {
                    bars[i] = new HistogramBarBean();
                    bars[i].setColumnHeight(Integer.toString(qbean.getColumnHeight()[i]));
                    bars[i].setNumStudents(qbean.getNumStudentCollection()[i]);
                    if (qbean.getNumStudentCollection()[i] > 1) {
                        bars[i].setNumStudentsText(qbean.getNumStudentCollection()[i] + " Responses");
                    } else {
                        bars[i].setNumStudentsText(qbean.getNumStudentCollection()[i] + " Response");
                    }
                    bars[i].setRangeInfo(qbean.getRangeCollection()[i]);
                    bars[i].setLabel(qbean.getRangeCollection()[i]);
                }
            }
            qbean.setHistogramBars(bars);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Map getAssessmentStatisticsMap(ArrayList scoreList) {
        Iterator iter = scoreList.iterator();
        ArrayList<Float> floats = new ArrayList<Float>();
        while (iter.hasNext()) {
            Object data = iter.next();
            if (data instanceof AssessmentGradingData) {
                Float finalScore = ((AssessmentGradingData)data).getFinalScore();
                if (finalScore == null) {
                    finalScore = Float.valueOf("0");
                }
                floats.add(finalScore);
                continue;
            }
            float autoScore = 0.0f;
            if (((ItemGradingData)data).getAutoScore() != null) {
                autoScore = ((ItemGradingData)data).getAutoScore().floatValue();
            }
            float overrideScore = 0.0f;
            if (((ItemGradingData)data).getOverrideScore() != null) {
                overrideScore = ((ItemGradingData)data).getOverrideScore().floatValue();
            }
            floats.add(Float.valueOf(autoScore + overrideScore));
        }
        if (floats.isEmpty()) {
            floats.add(new Float(0.0));
        }
        Object[] array = floats.toArray();
        Arrays.sort(array);
        double[] scores = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            scores[i] = ((Float)array[i]).doubleValue();
        }
        HashMap<String, Object> statMap = new HashMap<String, Object>();
        double min = scores[0];
        double max = scores[scores.length - 1];
        double total = HistogramListener.calTotal((double[])scores);
        double mean = HistogramListener.calMean((double[])scores, (double)total);
        int interval = 0;
        interval = HistogramListener.calInterval((double[])scores, (double)min, (double)max);
        int[] numStudents = HistogramListener.calNumStudents((double[])scores, (double)min, (double)max, (int)interval);
        statMap.put("maxScore", this.castingNum(max, 2));
        statMap.put("interval", interval);
        statMap.put("numResponses", scoreList.size());
        statMap.put("totalScore", this.castingNum(total, 2));
        statMap.put("mean", this.castingNum(mean, 2));
        statMap.put("median", this.castingNum(HistogramListener.calMedian((double[])scores), 2));
        statMap.put("mode", this.castingNumForMode(HistogramListener.calMode((double[])scores)));
        statMap.put("numStudentCollection", numStudents);
        statMap.put("rangeCollection", HistogramListener.calRange((double[])scores, (int[])numStudents, (double)min, (double)max, (int)interval));
        statMap.put("standDev", this.castingNum(HistogramListener.calStandDev((double[])scores, (double)mean), 2));
        statMap.put("columnHeight", HistogramListener.calColumnHeight((int[])numStudents, (int)scoreList.size()));
        statMap.put("arrayLength", numStudents.length);
        statMap.put("range", this.castingNum(scores[0], 2) + " - " + this.castingNum(scores[scores.length - 1], 2));
        statMap.put("q1", this.castingNum(HistogramListener.calQuartiles((double[])scores, (double)0.25), 2));
        statMap.put("q2", this.castingNum(HistogramListener.calQuartiles((double[])scores, (double)0.5), 2));
        statMap.put("q3", this.castingNum(HistogramListener.calQuartiles((double[])scores, (double)0.75), 2));
        statMap.put("q4", this.castingNum(max, 2));
        return statMap;
    }

    private static double calTotal(double[] scores) {
        double total = 0.0;
        for (int i = 0; i < scores.length; ++i) {
            total += scores[i];
        }
        return total;
    }

    private static double calMean(double[] scores, double total) {
        return total / (double)scores.length;
    }

    private static double calMedian(double[] scores) {
        double median = scores.length % 2 == 0 ? (scores[scores.length / 2] + scores[scores.length / 2 - 1]) / 2.0 : scores[(scores.length - 1) / 2];
        return median;
    }

    private static String calMode(double[] scores) {
        Arrays.sort(scores);
        String maxString = "" + scores[0];
        int maxCount = 1;
        int currentCount = 1;
        for (int i = 1; i < scores.length; ++i) {
            if (!("" + scores[i]).equals("" + scores[i - 1])) {
                currentCount = 1;
                if (maxCount != currentCount) continue;
                maxString = maxString + ", " + scores[i];
                continue;
            }
            if (maxCount == ++currentCount) {
                maxString = maxString + ", " + scores[i];
            }
            if (maxCount >= currentCount) continue;
            maxString = "" + scores[i];
            maxCount = currentCount;
        }
        return maxString;
    }

    private static double calStandDev(double[] scores, double mean) {
        double total = 0.0;
        for (int i = 0; i < scores.length; ++i) {
            total += (scores[i] - mean) * (scores[i] - mean);
        }
        return Math.sqrt(total / (double)(scores.length - 1));
    }

    private static int calInterval(double[] scores, double min, double max) {
        int interval = max - min < 10.0 ? 1 : (int)Math.ceil((max - min) / 10.0);
        return interval;
    }

    private static int[] calNumStudents(double[] scores, double min, double max, int interval) {
        int[] numStudents;
        if (min > max) {
            max = min;
        }
        if ((numStudents = new int[(int)Math.ceil((max - min) / (double)interval)]).length == 0) {
            numStudents = new int[]{0};
        }
        block0: for (int i = 0; i < scores.length; ++i) {
            if (scores[i] <= min + (double)interval) {
                numStudents[0] = numStudents[0] + 1;
                continue;
            }
            for (int j = 1; j < numStudents.length; ++j) {
                if (!(scores[i] > min + (double)(j * interval)) || !(scores[i] <= min + (double)((j + 1) * interval))) continue;
                int n = j;
                numStudents[n] = numStudents[n] + 1;
                continue block0;
            }
        }
        return numStudents;
    }

    private static String[] calRange(double[] scores, int[] numStudents, double min, double max, int interval) {
        String[] ranges = new String[numStudents.length];
        ranges[0] = (int)min + " - " + (int)(min + (double)interval);
        for (int i = 1; i < ranges.length; ++i) {
            ranges[i] = (double)((i + 1) * interval) + min < max ? ">" + (int)((double)(i * interval) + min) + " - " + (int)((double)((i + 1) * interval) + min) : ">" + (int)((double)(i * interval) + min) + " - " + (int)max;
        }
        return ranges;
    }

    private static int[] calColumnHeight(int[] numStudents, int totalResponse) {
        int[] height = new int[numStudents.length];
        for (int index = 0; index < numStudents.length; ++index) {
            height[index] = totalResponse > 0 ? 600 * numStudents[index] / totalResponse : 0;
        }
        return height;
    }

    private static double calQuartiles(double[] scores, double r) {
        int k = (int)Math.floor(r * (double)(scores.length - 1) + 1.0);
        double f = r * (double)(scores.length - 1) - Math.floor(r * (double)(scores.length - 1));
        if (k < 2) {
            return scores[0];
        }
        return scores[k - 1] + f * (scores[k] - scores[k - 1]);
    }

    private String castingNum(double number, int decimal) {
        int indexOfDec = 0;
        if (Math.ceil(number) == Math.floor(number)) {
            return "" + (int)number;
        }
        String n = "" + number;
        indexOfDec = n.indexOf(".");
        int index = indexOfDec + decimal + 1;
        if (n.length() > index) {
            return n.substring(0, index);
        }
        return "" + number;
    }

    private String castingNumForMode(String oldmode) {
        String[] tokens = oldmode.split(",");
        String[] roundedtokens = new String[tokens.length];
        StringBuilder newModebuf = new StringBuilder();
        for (int j = 0; j < tokens.length; ++j) {
            roundedtokens[j] = this.castingNum(new Double(tokens[j]).doubleValue(), 2);
            newModebuf.append(", " + roundedtokens[j]);
        }
        String newMode = newModebuf.toString();
        newMode = newMode.substring(2, newMode.length());
        return newMode;
    }

    private String getType(int typeId) {
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.EvaluationMessages");
        ResourceLoader rc = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.CommonMessages");
        if (typeId == 1) {
            return rc.getString("multiple_choice_sin");
        }
        if (typeId == 2) {
            return rc.getString("multipl_mc_ms");
        }
        if (typeId == 12) {
            return rc.getString("multipl_mc_ss");
        }
        if (typeId == 3) {
            return rb.getString("q_mult_surv");
        }
        if (typeId == 4) {
            return rb.getString("q_tf");
        }
        if (typeId == 5) {
            return rb.getString("q_short_ess");
        }
        if (typeId == 6) {
            return rb.getString("q_fu");
        }
        if (typeId == 7) {
            return rb.getString("q_aud");
        }
        if (typeId == 8) {
            return rb.getString("q_fib");
        }
        if (typeId == 9) {
            return rb.getString("q_match");
        }
        if (typeId == 11) {
            return rb.getString("q_fin");
        }
        return "";
    }

    public List getDetailedStatisticsSpreadsheetData(String publishedId) throws AbortProcessingException {
        log.debug((Object)"HistogramAggregate Statistics LISTENER.");
        TotalScoresBean totalBean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        HistogramScoresBean bean = (HistogramScoresBean)ContextUtil.lookupBean((String)"histogramScores");
        totalBean.setPublishedId(publishedId);
        if (!this.histogramScores(bean, totalBean)) {
            throw new RuntimeException("failed to call histogramScores.");
        }
        ArrayList<Serializable> spreadsheetRows = new ArrayList<Serializable>();
        Collection detailedStatistics = bean.getDetailedStatistics();
        spreadsheetRows.add(Boolean.valueOf(bean.getShowPartAndTotalScoreSpreadsheetColumns()));
        if (totalBean.getFirstItem().equals("")) {
            boolean showDetailedStatisticsSheet = false;
            spreadsheetRows.add(Boolean.valueOf(showDetailedStatisticsSheet));
            return spreadsheetRows;
        }
        boolean showDetailedStatisticsSheet = true;
        spreadsheetRows.add(Boolean.valueOf(showDetailedStatisticsSheet));
        if (detailedStatistics == null || detailedStatistics.size() == 0) {
            return spreadsheetRows;
        }
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.EvaluationMessages");
        ArrayList<String> headerList = new ArrayList<String>();
        headerList = new ArrayList();
        headerList.add("<header/>");
        headerList.add(rb.getString("question"));
        if (bean.getRandomType()) {
            headerList.add("N(" + bean.getNumResponses() + ")");
        } else {
            headerList.add("N");
        }
        headerList.add(rb.getString("pct_correct_of"));
        if (bean.getShowDiscriminationColumn()) {
            headerList.add(rb.getString("pct_correct_of"));
            headerList.add(rb.getString("pct_correct_of"));
            headerList.add(rb.getString("discrim_abbrev"));
        }
        headerList.add(rb.getString("frequency"));
        spreadsheetRows.add(headerList);
        headerList = new ArrayList();
        headerList.add("<header/>");
        headerList.add("");
        headerList.add("");
        headerList.add(rb.getString("whole_group"));
        if (bean.getShowDiscriminationColumn()) {
            headerList.add(rb.getString("upper_pct"));
            headerList.add(rb.getString("lower_pct"));
            headerList.add("");
        }
        headerList.add(rb.getString("no_answer"));
        int aChar = 65;
        for (char colHeader = 'A'; colHeader < 65 + bean.getMaxNumberOfAnswers(); colHeader = (char)(colHeader + '\u0001')) {
            headerList.add(String.valueOf(colHeader));
        }
        spreadsheetRows.add(headerList);
        Iterator detailedStatsIter = detailedStatistics.iterator();
        ArrayList<Object> statsLine = null;
        while (detailedStatsIter.hasNext()) {
            Double dVal;
            HistogramQuestionScoresBean questionBean = (HistogramQuestionScoresBean)detailedStatsIter.next();
            statsLine = new ArrayList<Object>();
            statsLine.add(questionBean.getQuestionLabel());
            statsLine.add(questionBean.getNumResponses());
            try {
                if (questionBean.getShowPercentageCorrectAndDiscriminationFigures()) {
                    dVal = Double.parseDouble(questionBean.getPercentCorrect());
                    statsLine.add(dVal);
                } else {
                    statsLine.add(" ");
                }
            }
            catch (NumberFormatException ex) {
                statsLine.add(questionBean.getPercentCorrect());
            }
            if (bean.getShowDiscriminationColumn()) {
                try {
                    if (questionBean.getShowPercentageCorrectAndDiscriminationFigures()) {
                        dVal = Double.parseDouble(questionBean.getPercentCorrectFromUpperQuartileStudents());
                        statsLine.add(dVal);
                    } else {
                        statsLine.add(" ");
                    }
                }
                catch (NumberFormatException ex) {
                    statsLine.add(questionBean.getPercentCorrectFromUpperQuartileStudents());
                }
                try {
                    if (questionBean.getShowPercentageCorrectAndDiscriminationFigures()) {
                        dVal = Double.parseDouble(questionBean.getPercentCorrectFromLowerQuartileStudents());
                        statsLine.add(dVal);
                    } else {
                        statsLine.add(" ");
                    }
                }
                catch (NumberFormatException ex) {
                    statsLine.add(questionBean.getPercentCorrectFromLowerQuartileStudents());
                }
                try {
                    if (questionBean.getShowPercentageCorrectAndDiscriminationFigures()) {
                        dVal = Double.parseDouble(questionBean.getDiscrimination());
                        statsLine.add(dVal);
                    } else {
                        statsLine.add(" ");
                    }
                }
                catch (NumberFormatException ex) {
                    statsLine.add(questionBean.getDiscrimination());
                }
            }
            dVal = Double.parseDouble("" + questionBean.getNumberOfStudentsWithZeroAnswers());
            statsLine.add(dVal);
            for (int i = 0; i < questionBean.getHistogramBars().length; ++i) {
                try {
                    if (questionBean.getHistogramBars()[i].getIsCorrect().booleanValue()) {
                        statsLine.add("<format bold/>");
                    }
                    dVal = Double.parseDouble("" + questionBean.getHistogramBars()[i].getNumStudents());
                    statsLine.add(dVal);
                    continue;
                }
                catch (NullPointerException npe) {
                    log.warn((Object)("questionBean.getHistogramBars()[" + i + "] is null. " + npe));
                }
            }
            spreadsheetRows.add(statsLine);
        }
        return spreadsheetRows;
    }

    private List<AssessmentGradingData> filterGradingData(List<AssessmentGradingData> submissionsSortedForDiscrim, Long itemId) {
        ArrayList<AssessmentGradingData> submissionsForItemSortedForDiscrim = new ArrayList<AssessmentGradingData>();
        block0: for (AssessmentGradingData agd : submissionsSortedForDiscrim) {
            Set itemGradings = agd.getItemGradingSet();
            for (ItemGradingData igd : itemGradings) {
                if (!igd.getPublishedItemId().equals(itemId)) continue;
                submissionsForItemSortedForDiscrim.add(agd);
                continue block0;
            }
        }
        return submissionsForItemSortedForDiscrim;
    }
}

