/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.EvaluationModel;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAnswer;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.MediaIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.AgentResults;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.HistogramScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.PartData;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.QuestionScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.SubmissionStatusBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.TotalScoresBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.BeanSort;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.ResourceLoader;

public class QuestionScoreListener
implements ActionListener,
ValueChangeListener {
    private static Log log = LogFactory.getLog(QuestionScoreListener.class);
    private static BeanSort bs;
    private static final String noAnswer;

    public void processAction(ActionEvent event) throws AbortProcessingException {
        log.debug((Object)"QuestionScore LISTENER.");
        QuestionScoresBean bean = (QuestionScoresBean)ContextUtil.lookupBean((String)"questionScores");
        String defaultSearchString = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"search_default_student_search_string");
        bean.setSearchString(defaultSearchString);
        String publishedId = ContextUtil.lookupParam((String)"publishedId");
        if (!this.questionScores(publishedId, bean, false)) {
            throw new RuntimeException("failed to call questionScores.");
        }
    }

    public void processValueChange(ValueChangeEvent event) {
        log.debug((Object)"QuestionScore CHANGE LISTENER.");
        QuestionScoresBean bean = (QuestionScoresBean)ContextUtil.lookupBean((String)"questionScores");
        TotalScoresBean totalBean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        HistogramScoresBean histogramBean = (HistogramScoresBean)ContextUtil.lookupBean((String)"histogramScores");
        SubmissionStatusBean submissionbean = (SubmissionStatusBean)ContextUtil.lookupBean((String)"submissionStatus");
        String publishedId = ContextUtil.lookupParam((String)"publishedId");
        boolean toggleSubmissionSelection = false;
        String selectedvalue = (String)event.getNewValue();
        if (selectedvalue != null && !selectedvalue.equals("")) {
            if (event.getComponent().getId().indexOf("sectionpicker") > -1) {
                bean.setSelectedSectionFilterValue(selectedvalue);
                totalBean.setSelectedSectionFilterValue(selectedvalue);
                submissionbean.setSelectedSectionFilterValue(selectedvalue);
            } else if (event.getComponent().getId().indexOf("allSubmissions") > -1) {
                bean.setAllSubmissions(selectedvalue);
                totalBean.setAllSubmissions(selectedvalue);
                histogramBean.setAllSubmissions(selectedvalue);
                toggleSubmissionSelection = true;
            } else {
                bean.setSelectedSARationaleView(selectedvalue);
            }
        }
        if (!this.questionScores(publishedId, bean, toggleSubmissionSelection)) {
            throw new RuntimeException("failed to call questionScores.");
        }
    }

    public boolean questionScores(String publishedId, QuestionScoresBean bean, boolean isValueChange) {
        log.debug((Object)"questionScores()");
        try {
            Iterator iter2;
            String which;
            PublishedAssessmentService pubService = new PublishedAssessmentService();
            QuestionScoresBean questionBean = (QuestionScoresBean)ContextUtil.lookupBean((String)"questionScores");
            PublishedAssessmentIfc publishedAssessment = questionBean.getPublishedAssessment();
            if (publishedAssessment == null) {
                publishedAssessment = pubService.getPublishedAssessment(publishedId);
                questionBean.setPublishedAssessment(publishedAssessment);
            }
            HashMap publishedItemHash = pubService.preparePublishedItemHash(publishedAssessment);
            log.debug((Object)("questionScores(): publishedItemHash.size = " + publishedItemHash.size()));
            HashMap publishedItemTextHash = pubService.preparePublishedItemTextHash(publishedAssessment);
            log.debug((Object)("questionScores(): publishedItemTextHash.size = " + publishedItemTextHash.size()));
            HashMap publishedAnswerHash = pubService.preparePublishedAnswerHash(publishedAssessment);
            log.debug((Object)("questionScores(): publishedAnswerHash.size = " + publishedAnswerHash.size()));
            HashMap<Long, AgentResults> agentResultsByItemGradingIdMap = new HashMap<Long, AgentResults>();
            GradingService delegate = new GradingService();
            TotalScoresBean totalBean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
            if (ContextUtil.lookupParam((String)"sortBy") != null && !ContextUtil.lookupParam((String)"sortBy").trim().equals("")) {
                bean.setSortType(ContextUtil.lookupParam((String)"sortBy"));
            }
            String itemId = ContextUtil.lookupParam((String)"itemId");
            if (ContextUtil.lookupParam((String)"newItemId") != null && !ContextUtil.lookupParam((String)"newItemId").trim().equals("")) {
                itemId = ContextUtil.lookupParam((String)"newItemId");
            }
            if (ContextUtil.lookupParam((String)"sortAscending") != null && !ContextUtil.lookupParam((String)"sortAscending").trim().equals("")) {
                bean.setSortAscending(Boolean.valueOf(ContextUtil.lookupParam((String)"sortAscending")).booleanValue());
            }
            if ((which = bean.getAllSubmissions()) == null && totalBean.getAllSubmissions() != null) {
                which = totalBean.getAllSubmissions();
                bean.setAllSubmissions(which);
            }
            totalBean.setSelectedSectionFilterValue(bean.getSelectedSectionFilterValue());
            if (bean.getSelectedSARationaleView() == null) {
                bean.setSelectedSARationaleView("1");
            }
            if ("true".equalsIgnoreCase(totalBean.getAnonymous())) {
                boolean groupRelease = publishedAssessment.getAssessmentAccessControl().getReleaseTo().equals("Selected Groups");
                if (groupRelease) {
                    totalBean.setSelectedSectionFilterValue("-2");
                } else {
                    totalBean.setSelectedSectionFilterValue("-1");
                }
            }
            bean.setPublishedId(publishedId);
            Date dueDate = null;
            HashMap map = this.getItemScores(Long.valueOf(publishedId), Long.valueOf(itemId), which, isValueChange);
            log.debug((Object)("questionScores(): map .size = " + map.size()));
            ResourceLoader rb = null;
            ArrayList allscores = new ArrayList();
            Iterator keyiter = map.keySet().iterator();
            while (keyiter.hasNext()) {
                allscores.addAll((ArrayList)map.get(keyiter.next()));
            }
            log.debug((Object)("questionScores(): allscores.size = " + allscores.size()));
            ArrayList scores = new ArrayList();
            Map useridMap = totalBean.getUserIdMap(2);
            bean.setUserIdMap(useridMap);
            log.debug((Object)("questionScores(): useridMap.size = " + useridMap.size()));
            if (totalBean.getReleaseToAnonymous()) {
                scores.addAll(allscores);
            } else {
                for (ItemGradingData idata : allscores) {
                    String agentid = idata.getAgentId();
                    if (!useridMap.containsKey(agentid)) continue;
                    scores.add(idata);
                }
            }
            log.debug((Object)("questionScores(): scores.size = " + scores.size()));
            Iterator<Object> iter = scores.iterator();
            ArrayList agents = new ArrayList();
            log.debug((Object)"questionScores(): calling populateSections ");
            this.populateSections(publishedAssessment, bean, totalBean, scores, pubService);
            if (!iter.hasNext()) {
                log.debug((Object)"questionScores(): this section has no students");
                bean.setAgents(agents);
                bean.setAllAgents(agents);
                bean.setTotalPeople(Integer.toString(bean.getAgents().size()));
                bean.setAnonymous(totalBean.getAnonymous());
            }
            HashMap scoresByItem = new HashMap();
            while (iter.hasNext()) {
                ItemGradingData idata = (ItemGradingData)iter.next();
                ItemTextIfc pubItemText = (ItemTextIfc)publishedItemTextHash.get(idata.getPublishedItemTextId());
                AnswerIfc pubAnswer = (AnswerIfc)publishedAnswerHash.get(idata.getPublishedAnswerId());
                ArrayList temp = (ArrayList)scoresByItem.get(idata.getAssessmentGradingId() + ":" + idata.getPublishedItemId());
                if (temp == null) {
                    temp = new ArrayList();
                }
                iter2 = temp.iterator();
                ArrayList<ItemGradingData> newList = new ArrayList<ItemGradingData>();
                boolean added = false;
                while (iter2.hasNext()) {
                    ItemGradingData tmpData = (ItemGradingData)iter2.next();
                    ItemTextIfc tmpPublishedText = (ItemTextIfc)publishedItemTextHash.get(tmpData.getPublishedItemTextId());
                    AnswerIfc tmpAnswer = (AnswerIfc)publishedAnswerHash.get(tmpData.getPublishedAnswerId());
                    if (pubAnswer != null && tmpAnswer != null && !added && (pubItemText.getSequence().intValue() < tmpPublishedText.getSequence().intValue() || pubItemText.getSequence().intValue() == tmpPublishedText.getSequence().intValue() && pubAnswer.getSequence().intValue() < tmpAnswer.getSequence().intValue())) {
                        newList.add(idata);
                        added = true;
                    }
                    newList.add(tmpData);
                }
                if (!added) {
                    newList.add(idata);
                }
                scoresByItem.put(idata.getAssessmentGradingId() + ":" + idata.getPublishedItemId(), newList);
            }
            log.debug((Object)("questionScores(): scoresByItem.size = " + scoresByItem.size()));
            bean.setScoresByItem(scoresByItem);
            try {
                bean.setAnonymous(publishedAssessment.getEvaluationModel().getAnonymousGrading().equals(EvaluationModel.ANONYMOUS_GRADING) ? "true" : "false");
            }
            catch (RuntimeException e) {
                bean.setAnonymous("false");
            }
            try {
                bean.setLateHandling(publishedAssessment.getAssessmentAccessControl().getLateHandling().toString());
            }
            catch (Exception e) {
                bean.setLateHandling(AssessmentAccessControl.NOT_ACCEPT_LATE_SUBMISSION.toString());
            }
            try {
                bean.setDueDate(publishedAssessment.getAssessmentAccessControl().getDueDate().toString());
                dueDate = publishedAssessment.getAssessmentAccessControl().getDueDate();
            }
            catch (RuntimeException e) {
                bean.setDueDate(new Date().toString());
            }
            try {
                bean.setMaxScore(publishedAssessment.getEvaluationModel().getFixedTotalScore().toString());
            }
            catch (RuntimeException e) {
                float score = 0.0f;
                for (SectionDataIfc sdata : publishedAssessment.getSectionArraySorted()) {
                    for (ItemDataIfc idata : sdata.getItemArraySortedForGrading()) {
                        if (!idata.getItemId().equals(Long.valueOf(itemId))) continue;
                        score = idata.getScore().floatValue();
                    }
                }
                bean.setMaxScore(Float.toString(score));
            }
            ItemDataIfc item = (ItemDataIfc)publishedItemHash.get(Long.valueOf(itemId));
            if (item != null) {
                log.debug((Object)("item!=null steting type id = " + item.getTypeId().toString()));
                bean.setTypeId(item.getTypeId().toString());
                bean.setItemId(item.getItemId().toString());
                bean.setPartName(item.getSection().getSequence().toString());
                bean.setItemName(item.getSequence().toString());
                item.setHint("***");
                if (item.getTypeId().equals(5L)) {
                    for (PublishedAnswer publishedAnswer : publishedAnswerHash.values()) {
                        if (!publishedAnswer.getItem().getItemId().equals(item.getItemId())) continue;
                        if (publishedAnswer.getText() == null || publishedAnswer.getText().equals("")) {
                            bean.setHaveModelShortAnswer(false);
                        } else {
                            bean.setHaveModelShortAnswer(true);
                        }
                        break;
                    }
                }
            } else {
                log.debug((Object)"item==null ");
            }
            ArrayList<ItemDataIfc> deliveryItems = new ArrayList<ItemDataIfc>();
            if (item != null) {
                deliveryItems.add(item);
            }
            bean.setDeliveryItem(deliveryItems);
            if (ContextUtil.lookupParam((String)"roleSelection") != null) {
                bean.setRoleSelection(ContextUtil.lookupParam((String)"roleSelection"));
            }
            if (bean.getSortType() == null) {
                if (bean.getAnonymous().equals("true")) {
                    bean.setSortType("totalAutoScore");
                } else {
                    bean.setSortType("lastName");
                }
            }
            iter = scoresByItem.values().iterator();
            while (iter.hasNext()) {
                AgentResults results = new AgentResults();
                ArrayList answerList = (ArrayList)iter.next();
                results.setItemGradingArrayList(answerList);
                iter2 = answerList.iterator();
                ArrayList itemGradingAttachmentList = new ArrayList();
                while (iter2.hasNext()) {
                    ItemGradingData gdata = (ItemGradingData)iter2.next();
                    results.setItemGrading(gdata);
                    itemGradingAttachmentList.addAll(gdata.getItemGradingAttachmentList());
                    agentResultsByItemGradingIdMap.put(gdata.getItemGradingId(), results);
                    ItemTextIfc gdataPubItemText = (ItemTextIfc)publishedItemTextHash.get(gdata.getPublishedItemTextId());
                    AnswerIfc gdataAnswer = (AnswerIfc)publishedAnswerHash.get(gdata.getPublishedAnswerId());
                    String answerText = noAnswer;
                    String rationale = "";
                    String fullAnswerText = noAnswer;
                    if (bean.getTypeId().equals("1") || bean.getTypeId().equals("2") || bean.getTypeId().equals("12") || bean.getTypeId().equals("3") || bean.getTypeId().equals("4") || bean.getTypeId().equals("9") || bean.getTypeId().equals("13")) {
                        if (gdataAnswer != null) {
                            answerText = gdataAnswer.getText();
                        }
                    } else {
                        answerText = (bean.getTypeId().equals("8") || bean.getTypeId().equals("11")) && gdataAnswer == null ? "" : gdata.getAnswerText();
                    }
                    if ("4".equals(bean.getTypeId())) {
                        if (rb == null) {
                            rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.EvaluationMessages");
                        }
                        if ("true".equals(answerText)) {
                            answerText = rb.getString("true_msg");
                        } else if ("false".equals(answerText)) {
                            answerText = rb.getString("false_msg");
                        }
                    }
                    if (bean.getTypeId().equals("9")) {
                        answerText = gdataPubItemText == null ? "" : gdataPubItemText.getSequence() + ":" + answerText;
                    }
                    if (bean.getTypeId().equals("8") && gdataAnswer != null && gdataAnswer.getSequence() != null) {
                        answerText = gdataAnswer.getSequence() + ":" + answerText;
                    }
                    if (bean.getTypeId().equals("11") && gdataAnswer != null && gdataAnswer.getSequence() != null) {
                        answerText = gdataAnswer.getSequence() + ":" + answerText;
                    }
                    if (bean.getTypeId().equals("13")) {
                        if (gdataPubItemText == null) {
                            answerText = "";
                        } else {
                            int answerNo = gdataPubItemText.getSequence().intValue() + 1;
                            answerText = answerNo + ":" + answerText;
                        }
                    }
                    if (bean.getTypeId().equals("6")) {
                        gdata.setMediaArray(delegate.getMediaArray2(gdata.getItemGradingId().toString()));
                    }
                    if (bean.getTypeId().equals("7")) {
                        ArrayList mediaList = delegate.getMediaArray2(gdata.getItemGradingId().toString());
                        this.setDurationIsOver(item, mediaList);
                        gdata.setMediaArray(mediaList);
                    }
                    if (answerText == null) {
                        answerText = noAnswer;
                    } else if (gdata.getRationale() != null && !gdata.getRationale().trim().equals("")) {
                        rationale = "\nRationale: " + gdata.getRationale();
                    }
                    answerText = answerText.replaceAll("(\r\n|\r)", "<br/>");
                    rationale = rationale.replaceAll("<.*?>", "");
                    rationale = rationale.replaceAll("(\r\n|\r)", "<br/>");
                    fullAnswerText = answerText;
                    if (answerText.length() > 35) {
                        String noHTMLAnswerText = answerText.replaceAll("<((..?)|([^iI][^mM][^gG].*?))>", "");
                        int index = noHTMLAnswerText.toLowerCase().indexOf("<img");
                        answerText = index != -1 ? noHTMLAnswerText : (noHTMLAnswerText.length() > 35 ? noHTMLAnswerText.substring(0, 35) + "..." : noHTMLAnswerText);
                    }
                    if (gdataAnswer != null) {
                        if (bean.getTypeId().equals("8") || bean.getTypeId().equals("11")) {
                            if (gdataAnswer.getScore().floatValue() > 0.0f) {
                                Float autoscore = gdata.getAutoScore();
                                if (!Float.valueOf(0.0f).equals(autoscore)) {
                                    answerText = "<img src='/samigo-app/images/delivery/checkmark.gif'>" + answerText;
                                } else if (Float.valueOf(0.0f).equals(autoscore)) {
                                    answerText = "<img src='/samigo-app/images/crossmark.gif'>" + answerText;
                                }
                            }
                        } else if (!bean.getTypeId().equals("3")) {
                            if (gdataAnswer.getIsCorrect() != null && gdataAnswer.getIsCorrect().booleanValue() || gdataAnswer.getPartialCredit() != null && gdataAnswer.getPartialCredit().floatValue() > 0.0f) {
                                answerText = "<img src='/samigo-app/images/delivery/checkmark.gif'>" + answerText;
                            } else if (gdataAnswer.getIsCorrect() != null && !gdataAnswer.getIsCorrect().booleanValue()) {
                                answerText = "<img src='/samigo-app/images/crossmark.gif'>" + answerText;
                            }
                        }
                    }
                    if (!answerList.get(0).equals(gdata)) {
                        results.setAnswer(results.getAnswer() + "<br/>" + answerText);
                        if (gdata.getAutoScore() != null) {
                            results.setTotalAutoScore(Float.toString(Float.valueOf(results.getExactTotalAutoScore()).floatValue() + gdata.getAutoScore().floatValue()));
                        } else {
                            results.setTotalAutoScore(Float.toString(Float.valueOf(results.getExactTotalAutoScore()).floatValue()));
                        }
                        results.setItemGradingAttachmentList(itemGradingAttachmentList);
                        continue;
                    }
                    results.setItemGradingId(gdata.getItemGradingId());
                    results.setAssessmentGradingId(gdata.getAssessmentGradingId());
                    if (gdata.getAutoScore() != null) {
                        results.setTotalAutoScore(gdata.getAutoScore().toString());
                    } else {
                        results.setTotalAutoScore(Float.toString(0.0f));
                    }
                    results.setComments(FormattedText.convertFormattedTextToPlaintext((String)gdata.getComments()));
                    results.setAnswer(answerText);
                    results.setFullAnswer(fullAnswerText);
                    results.setRationale(rationale);
                    results.setSubmittedDate(gdata.getSubmittedDate());
                    AgentFacade agent = new AgentFacade(gdata.getAgentId());
                    results.setLastName(agent.getLastName());
                    results.setFirstName(agent.getFirstName());
                    results.setEmail(agent.getEmail());
                    if (results.getLastName() != null && results.getLastName().length() > 0) {
                        results.setLastInitial(results.getLastName().substring(0, 1));
                    } else if (results.getFirstName() != null && results.getFirstName().length() > 0) {
                        results.setLastInitial(results.getFirstName().substring(0, 1));
                    } else {
                        results.setLastInitial("Anonymous");
                    }
                    results.setIdString(agent.getIdString());
                    results.setAgentEid(agent.getEidString());
                    log.debug((Object)("testing agent getEid agent.getFirstname= " + agent.getFirstName()));
                    log.debug((Object)("testing agent getEid agent.getid= " + agent.getIdString()));
                    log.debug((Object)("testing agent getEid agent.geteid = " + agent.getEidString()));
                    results.setRole(agent.getRole());
                    results.setItemGradingAttachmentList(itemGradingAttachmentList);
                    agents.add(results);
                }
            }
            bs = new BeanSort(agents, bean.getSortType());
            if (bean.getSortType().equals("assessmentGradingId") || bean.getSortType().equals("totalAutoScore") || bean.getSortType().equals("totalOverrideScore") || bean.getSortType().equals("finalScore")) {
                bs.toNumericSort();
            } else {
                bs.toStringSort();
            }
            if (bean.isSortAscending()) {
                log.debug((Object)"sortAscending");
                agents = (ArrayList)bs.sort();
            } else {
                log.debug((Object)"!sortAscending");
                agents = (ArrayList)bs.sortDesc();
            }
            bean.setAgents((Collection)agents);
            bean.setAllAgents(agents);
            bean.setTotalPeople(Integer.valueOf(bean.getAgents().size()).toString());
            bean.setAgentResultsByItemGradingId(agentResultsByItemGradingIdMap);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private HashMap getItemScores(Long publishedId, Long itemId, String which, boolean isValueChange) {
        log.debug((Object)"getItemScores");
        GradingService delegate = new GradingService();
        QuestionScoresBean questionScoresBean = (QuestionScoresBean)ContextUtil.lookupBean((String)"questionScores");
        HashMap<Long, HashMap> itemScoresMap = questionScoresBean.getItemScoresMap();
        log.debug((Object)("getItemScores: itemScoresMap ==null ?" + itemScoresMap));
        log.debug((Object)("getItemScores: isValueChange ?" + isValueChange));
        if (itemScoresMap == null || isValueChange || questionScoresBean.getIsAnyItemGradingAttachmentListModified()) {
            log.debug((Object)"getItemScores: itemScoresMap == null or isValueChange == true ");
            log.debug((Object)("getItemScores: isValueChange = " + isValueChange));
            itemScoresMap = new HashMap<Long, HashMap>();
            questionScoresBean.setItemScoresMap(itemScoresMap);
            questionScoresBean.setIsAnyItemGradingAttachmentListModified(false);
        }
        log.debug((Object)("getItemScores: itemScoresMap.size() " + itemScoresMap.size()));
        HashMap map = (HashMap)itemScoresMap.get(itemId);
        if (map == null) {
            log.debug((Object)"getItemScores: map == null ");
            map = delegate.getItemScores(publishedId, itemId, which);
            log.debug((Object)("getItemScores: map size " + map.size()));
            itemScoresMap.put(itemId, map);
        }
        return map;
    }

    private void setDurationIsOver(ItemDataIfc item, ArrayList mediaList) {
        try {
            int maxDurationAllowed = item.getDuration();
            for (int i = 0; i < mediaList.size(); ++i) {
                MediaIfc m = (MediaIfc)mediaList.get(i);
                float duration = Float.valueOf(m.getDuration()).floatValue();
                if (duration > (float)maxDurationAllowed) {
                    m.setDurationIsOver(true);
                    m.setTimeAllowed(String.valueOf(maxDurationAllowed));
                    continue;
                }
                m.setDurationIsOver(false);
            }
        }
        catch (Exception e) {
            log.warn((Object)("**duration recorded is not an integer value=" + e.getMessage()));
        }
    }

    private void populateSections(PublishedAssessmentIfc publishedAssessment, QuestionScoresBean bean, TotalScoresBean totalBean, ArrayList scores, PublishedAssessmentService pubService) {
        ArrayList<PartData> sections = new ArrayList<PartData>();
        log.debug((Object)("questionScores(): populate sctions publishedAssessment.getSectionArraySorted size = " + publishedAssessment.getSectionArraySorted().size()));
        Iterator iter = publishedAssessment.getSectionArraySorted().iterator();
        int i = 1;
        while (iter.hasNext()) {
            HashSet itemSet;
            SectionDataIfc section = (SectionDataIfc)iter.next();
            ArrayList<PartData> items = new ArrayList<PartData>();
            PartData part = new PartData();
            boolean isRandomDrawPart = pubService.isRandomDrawPart(publishedAssessment.getPublishedAssessmentId(), section.getSectionId());
            part.setIsRandomDrawPart(isRandomDrawPart);
            part.setPartNumber("" + i);
            part.setId(section.getSectionId().toString());
            if (isRandomDrawPart) {
                if (section.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN") != null) {
                    int numberToBeDrawn = Integer.parseInt(section.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN"));
                    part.setNumberQuestionsDraw(numberToBeDrawn);
                }
                PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
                itemSet = publishedAssessmentService.getPublishedItemSet(publishedAssessment.getPublishedAssessmentId(), section.getSectionId());
                section.setItemSet((Set)itemSet);
            } else {
                GradingService gradingService = new GradingService();
                itemSet = gradingService.getItemSet(publishedAssessment.getPublishedAssessmentId(), section.getSectionId());
                section.setItemSet((Set)itemSet);
            }
            Iterator iter2 = section.getItemArraySortedForGrading().iterator();
            int j = 1;
            while (iter2.hasNext()) {
                ItemDataIfc item = (ItemDataIfc)iter2.next();
                PartData partitem = new PartData();
                partitem.setPartNumber("" + j);
                partitem.setId(item.getItemId().toString());
                log.debug((Object)("*   item.getId = " + item.getItemId()));
                partitem.setLinked(true);
                items.add(partitem);
                ++j;
            }
            log.debug((Object)("questionScores(): items size = " + items.size()));
            part.setQuestionNumberList(items);
            sections.add(part);
            ++i;
        }
        log.debug((Object)("questionScores(): sections size = " + sections.size()));
        bean.setSections(sections);
    }

    static {
        noAnswer = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"no_answer");
    }
}

