/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.services.GradebookServiceException;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.AgentResults;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.QuestionScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.TotalScoresBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.TextFormat;

public class QuestionScoreUpdateListener
implements ActionListener {
    private static Log log = LogFactory.getLog(QuestionScoreUpdateListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        log.debug((Object)"Question Score Update LISTENER.");
        QuestionScoresBean bean = (QuestionScoresBean)ContextUtil.lookupBean((String)"questionScores");
        TotalScoresBean tbean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        log.debug((Object)"Calling saveQuestionScores.");
        tbean.setAssessmentGradingHash(tbean.getPublishedAssessment().getPublishedAssessmentId());
        try {
            if (!this.saveQuestionScores(bean, tbean)) {
                throw new RuntimeException("failed to call saveQuestionScores.");
            }
        }
        catch (GradebookServiceException ge) {
            FacesContext context = FacesContext.getCurrentInstance();
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"gradebook_exception_error");
            context.addMessage(null, new FacesMessage(err));
        }
    }

    public boolean saveQuestionScores(QuestionScoresBean bean, TotalScoresBean tbean) {
        try {
            GradingService delegate = new GradingService();
            String itemId = ContextUtil.lookupParam((String)"itemId");
            String which = ContextUtil.lookupParam((String)"allSubmissions");
            if (which == null) {
                which = "false";
            }
            Collection agents = bean.getAgents();
            for (AgentResults ar : agents) {
                ArrayList datas = (ArrayList)bean.getScoresByItem().get(ar.getAssessmentGradingId() + ":" + itemId);
                if (datas == null) {
                    datas = new ArrayList();
                }
                for (Object obj : datas) {
                    String oldComments;
                    ItemGradingData data = (ItemGradingData)obj;
                    float newAutoScore = Float.valueOf(ar.getTotalAutoScore()).floatValue() / (float)datas.size();
                    String newComments = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)ar.getComments());
                    ar.setComments(newComments);
                    newComments = newComments != null ? newComments.trim() : "";
                    float oldAutoScore = 0.0f;
                    if (data.getAutoScore() != null) {
                        oldAutoScore = data.getAutoScore().floatValue();
                    }
                    oldComments = (oldComments = data.getComments()) != null ? oldComments.trim() : "";
                    StringBuffer logString = new StringBuffer();
                    logString.append("gradedBy=");
                    logString.append(AgentFacade.getAgentString());
                    logString.append(", itemGradingId=");
                    logString.append(data.getItemGradingId());
                    if (newAutoScore != oldAutoScore) {
                        data.setAutoScore(Float.valueOf(newAutoScore));
                        logString.append(", newAutoScore=");
                        logString.append(newAutoScore);
                        logString.append(", oldAutoScore=");
                        logString.append(oldAutoScore);
                    }
                    if (!newComments.equals(oldComments)) {
                        data.setComments(ar.getComments());
                        logString.append(", newComments=");
                        logString.append(newComments);
                        logString.append(", oldComments=");
                        logString.append(oldComments);
                    }
                    if (newAutoScore != oldAutoScore || !newComments.equals(oldComments)) {
                        data.setGradedBy(AgentFacade.getAgentString());
                        data.setGradedDate(new Date());
                        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.question.score.update", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", " + logString.toString()), (boolean)true));
                        delegate.updateItemScore(data, newAutoScore - oldAutoScore, (PublishedAssessmentIfc)tbean.getPublishedAssessment());
                    }
                    this.updateAttachment(data, ar, bean);
                }
            }
        }
        catch (GradebookServiceException ge) {
            FacesContext context = FacesContext.getCurrentInstance();
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"gradebook_exception_error");
            context.addMessage(null, new FacesMessage(err));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void updateAttachment(ItemGradingData itemGradingData, AgentResults agentResults, QuestionScoresBean bean) {
        List oldList = itemGradingData.getItemGradingAttachmentList();
        List newList = agentResults.getItemGradingAttachmentList();
        if (!(oldList != null && oldList.size() != 0 || newList != null && newList.size() != 0)) {
            return;
        }
        ArrayList<ItemGradingAttachmentIfc> attachmentList = new ArrayList<ItemGradingAttachmentIfc>();
        HashMap map = this.getAttachmentIdHash(oldList);
        for (int i = 0; i < newList.size(); ++i) {
            ItemGradingAttachmentIfc itemGradingAttachment = (ItemGradingAttachmentIfc)newList.get(i);
            if (map.get(itemGradingAttachment.getAttachmentId()) != null) {
                map.remove(itemGradingAttachment.getAttachmentId());
                continue;
            }
            itemGradingAttachment.setItemGrading((ItemGradingIfc)itemGradingData);
            attachmentList.add(itemGradingAttachment);
        }
        GradingService gradingService = new GradingService();
        if (attachmentList.size() > 0) {
            gradingService.saveOrUpdateAttachments(attachmentList);
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.student.score.update", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", Adding " + attachmentList.size() + " attachments for itemGradingData id = " + itemGradingData.getItemGradingId()), (boolean)true));
        }
        Set set = map.keySet();
        for (Long attachmentId : set) {
            gradingService.removeItemGradingAttachment(attachmentId.toString());
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.student.score.update", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", Removing attachmentId = " + attachmentId), (boolean)true));
        }
        bean.setIsAnyItemGradingAttachmentListModified(true);
    }

    private HashMap getAttachmentIdHash(List list) {
        HashMap<Long, ItemGradingAttachmentIfc> map = new HashMap<Long, ItemGradingAttachmentIfc>();
        for (int i = 0; i < list.size(); ++i) {
            ItemGradingAttachmentIfc a = (ItemGradingAttachmentIfc)list.get(i);
            map.put(a.getAttachmentId(), a);
        }
        return map;
    }
}

