/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.evaluation;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.AssessmentGradingIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.services.GradebookServiceException;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.ItemContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SectionContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.StudentScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.TotalScoresBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.TextFormat;

public class StudentScoreUpdateListener
implements ActionListener {
    private static Log log = LogFactory.getLog(StudentScoreUpdateListener.class);
    private static ContextUtil cu;

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        log.debug((Object)"Student Score Update LISTENER.");
        StudentScoresBean bean = (StudentScoresBean)ContextUtil.lookupBean((String)"studentScores");
        TotalScoresBean tbean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        tbean.setAssessmentGradingHash(tbean.getPublishedAssessment().getPublishedAssessmentId());
        DeliveryBean delivery = (DeliveryBean)ContextUtil.lookupBean((String)"delivery");
        log.debug((Object)"Calling saveStudentScores.");
        try {
            if (!this.saveStudentScores(bean, tbean, delivery)) {
                throw new RuntimeException("failed to call saveStudentScores.");
            }
        }
        catch (GradebookServiceException ge) {
            FacesContext context = FacesContext.getCurrentInstance();
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"gradebook_exception_error");
            context.addMessage(null, new FacesMessage(err));
        }
    }

    public boolean saveStudentScores(StudentScoresBean bean, TotalScoresBean tbean, DeliveryBean delivery) {
        GradingService delegate = new GradingService();
        HashSet<ItemGradingData> itemGradingSet = new HashSet<ItemGradingData>();
        AssessmentGradingData adata = null;
        try {
            ArrayList parts = delivery.getPageContents().getPartsContents();
            Iterator iter = parts.iterator();
            boolean updateFlag = false;
            while (iter.hasNext()) {
                ArrayList items = ((SectionContentsBean)iter.next()).getItemContents();
                for (ItemContentsBean question : items) {
                    ArrayList gradingarray = question.getItemGradingDataArray();
                    log.debug((Object)("****1. pub questionId = " + question.getItemData().getItemId()));
                    log.debug((Object)("****2. Gradingarray length = " + gradingarray.size()));
                    if (gradingarray.isEmpty() && (question.getExactPoints() > 0.0f || question.getGradingComment() != null && !question.getGradingComment().trim().equals(""))) {
                        question.setReview(false);
                        gradingarray = question.getItemGradingDataArray();
                    }
                    log.debug((Object)("****3a Gradingarray length2 = " + gradingarray.size()));
                    log.debug((Object)("****3b set points = " + question.getExactPoints() + ", comments to " + question.getGradingComment()));
                    for (ItemGradingData data : gradingarray) {
                        String newComments;
                        if (adata == null && data.getAssessmentGradingId() != null) {
                            adata = delegate.load(data.getAssessmentGradingId().toString());
                        }
                        if (data.getAgentId() == null) {
                            data.setSubmittedDate(null);
                            data.setAgentId(bean.getStudentId());
                        }
                        float newAutoScore = question.getExactPoints() / (float)gradingarray.size();
                        float oldAutoScore = 0.0f;
                        if (data.getAutoScore() != null) {
                            oldAutoScore = data.getAutoScore().floatValue();
                        }
                        newComments = (newComments = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)question.getGradingComment())) != null ? newComments.trim() : "";
                        String oldComments = data.getComments();
                        oldComments = oldComments != null ? oldComments.trim() : "";
                        boolean updateScore = newAutoScore != oldAutoScore;
                        boolean updateComments = !newComments.equals(oldComments);
                        StringBuffer logString = new StringBuffer();
                        logString.append("gradedBy=");
                        logString.append(AgentFacade.getAgentString());
                        logString.append(", itemGradingId=");
                        logString.append(data.getItemGradingId());
                        if (updateScore) {
                            data.setAutoScore(Float.valueOf(newAutoScore));
                            logString.append(", newAutoScore=");
                            logString.append(newAutoScore);
                            logString.append(", oldAutoScore=");
                            logString.append(oldAutoScore);
                        }
                        if (updateComments) {
                            data.setComments(newComments);
                            logString.append(", newComments=");
                            logString.append(newComments);
                            logString.append(", oldComments=");
                            logString.append(oldComments);
                        }
                        if (updateScore || updateComments) {
                            updateFlag = true;
                            data.setGradedBy(AgentFacade.getAgentString());
                            data.setGradedDate(new Date());
                            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.student.score.update", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", " + logString.toString()), (boolean)true));
                            log.debug((Object)("****4 itemGradingId=" + data.getItemGradingId()));
                            log.debug((Object)("****5 set points = " + data.getAutoScore() + ", comments to " + data.getComments()));
                        }
                        data.setAnswerText(ContextUtil.stringWYSIWYG((String)data.getAnswerText()));
                        itemGradingSet.add(data);
                    }
                }
                if (adata == null) {
                    String assessmentGradingId = ContextUtil.lookupParam((String)"gradingData");
                    adata = delegate.load(assessmentGradingId);
                }
                adata.setItemGradingSet(itemGradingSet);
            }
            if (adata == null) {
                return true;
            }
            String newComments = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)bean.getComments());
            newComments = newComments != null ? newComments.trim() : "";
            String oldComments = adata.getComments();
            if (!newComments.equals(oldComments = oldComments != null ? oldComments.trim() : "")) {
                updateFlag = true;
                adata.setComments(newComments);
                adata.setGradedBy(AgentFacade.getAgentString());
                adata.setGradedDate(new Date());
                StringBuffer logString = new StringBuffer();
                logString.append("gradedBy=");
                logString.append(AgentFacade.getAgentString());
                logString.append(", assessmentGradingId=");
                logString.append(adata.getAssessmentGradingId());
                logString.append(", newComments=");
                logString.append(newComments);
                logString.append(", oldComments=");
                logString.append(oldComments);
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.student.score.update", (String)logString.toString(), (boolean)true));
            }
            if (updateFlag) {
                delegate.updateAssessmentGradingScore((AssessmentGradingIfc)adata, (PublishedAssessmentIfc)tbean.getPublishedAssessment());
            }
            log.debug((Object)"Saved student scores.");
            this.updateAttachment(delivery);
        }
        catch (GradebookServiceException ge) {
            FacesContext context = FacesContext.getCurrentInstance();
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"gradebook_exception_error");
            context.addMessage(null, new FacesMessage(err));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void updateAttachment(DeliveryBean delivery) {
        ArrayList parts = delivery.getPageContents().getPartsContents();
        Iterator iter = parts.iterator();
        ArrayList<ItemGradingAttachmentIfc> attachmentList = new ArrayList<ItemGradingAttachmentIfc>();
        while (iter.hasNext()) {
            ArrayList items = ((SectionContentsBean)iter.next()).getItemContents();
            for (ItemContentsBean question : items) {
                ArrayList gradingarray = question.getItemGradingDataArray();
                log.debug((Object)("Gradingarray length2 = " + gradingarray.size()));
                for (ItemGradingData itemGradingData : gradingarray) {
                    List oldList = itemGradingData.getItemGradingAttachmentList();
                    List newList = question.getItemGradingAttachmentList();
                    if (!(oldList != null && oldList.size() != 0 || newList != null && newList.size() != 0)) continue;
                    HashMap map = this.getAttachmentIdHash(oldList);
                    for (int i = 0; i < newList.size(); ++i) {
                        ItemGradingAttachmentIfc itemGradingAttachment = (ItemGradingAttachmentIfc)newList.get(i);
                        if (map.get(itemGradingAttachment.getAttachmentId()) != null) {
                            map.remove(itemGradingAttachment.getAttachmentId());
                            continue;
                        }
                        itemGradingAttachment.setItemGrading((ItemGradingIfc)itemGradingData);
                        attachmentList.add(itemGradingAttachment);
                    }
                    GradingService gradingService = new GradingService();
                    if (attachmentList.size() > 0) {
                        gradingService.saveOrUpdateAttachments(attachmentList);
                        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.student.score.update", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", Adding " + attachmentList.size() + " attachments for itemGradingData id = " + itemGradingData.getItemGradingId()), (boolean)true));
                    }
                    Set set = map.keySet();
                    for (Long attachmentId : set) {
                        gradingService.removeItemGradingAttachment(attachmentId.toString());
                        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.student.score.update", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", Removing attachmentId = " + attachmentId), (boolean)true));
                    }
                }
            }
        }
    }

    private HashMap getAttachmentIdHash(List list) {
        HashMap<Long, ItemGradingAttachmentIfc> map = new HashMap<Long, ItemGradingAttachmentIfc>();
        for (int i = 0; i < list.size(); ++i) {
            ItemGradingAttachmentIfc a = (ItemGradingAttachmentIfc)list.get(i);
            map.put(a.getAttachmentId(), a);
        }
        return map;
    }
}

