/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.questionpool;

import java.util.ArrayList;
import java.util.Date;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.assessment.ui.bean.questionpool.QuestionPoolBean;
import org.sakaiproject.tool.assessment.ui.bean.questionpool.QuestionPoolDataBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.TextFormat;

public class PoolSaveListener
implements ActionListener {
    private static Log log = LogFactory.getLog(PoolSaveListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        QuestionPoolBean qpoolbean = (QuestionPoolBean)ContextUtil.lookupBean((String)"questionpool");
        String currentName = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)qpoolbean.getCurrentPool().getDisplayName());
        boolean isUnique = true;
        QuestionPoolService service = new QuestionPoolService();
        QuestionPoolDataBean bean = qpoolbean.getCurrentPool();
        Long currentId = new Long("0");
        FacesContext context = FacesContext.getCurrentInstance();
        if (bean.getId() != null) {
            currentId = bean.getId();
        }
        Long currentParentId = new Long("0");
        if (bean.getParentPoolId() != null) {
            currentParentId = bean.getParentPoolId();
        }
        if (currentName != null && currentName.trim().equals("")) {
            String err1 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.QuestionPoolMessages", (String)"poolName_empty");
            context.addMessage(null, new FacesMessage(err1));
            qpoolbean.setOutcomeEdit("editPool");
            qpoolbean.setOutcome("addPool");
            return;
        }
        try {
            isUnique = qpoolbean.getAddOrEdit().equals("add") ? service.poolIsUnique("0", currentName, "" + currentParentId, AgentFacade.getAgentString()) : service.poolIsUnique("" + currentId, currentName, "" + currentParentId, AgentFacade.getAgentString());
            if (!isUnique) {
                String error = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.QuestionPoolMessages", (String)"duplicateName_error");
                context.addMessage(null, new FacesMessage(error));
                qpoolbean.setOutcomeEdit("editPool");
                qpoolbean.setOutcome("addPool");
                return;
            }
            if (!this.savePool(qpoolbean)) {
                throw new RuntimeException("failed to populateItemBean.");
            }
            if (qpoolbean.getAddOrEdit().equals("edit") && !this.startRemoveItems(qpoolbean)) {
                throw new RuntimeException("failed to populateItemBean.");
            }
            qpoolbean.setAddOrEdit("edit");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean savePool(QuestionPoolBean qpbean) {
        QuestionPoolDataBean bean = qpbean.getCurrentPool();
        Long beanid = new Long("0");
        if (bean.getId() != null) {
            beanid = bean.getId();
        }
        Long parentid = new Long("0");
        if (bean.getParentPoolId() != null) {
            parentid = bean.getParentPoolId();
        }
        QuestionPoolFacade questionpool = new QuestionPoolFacade(beanid, parentid);
        questionpool.updateDisplayName(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)bean.getDisplayName()));
        questionpool.updateDescription(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)bean.getDescription()));
        questionpool.setOrganizationName(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)bean.getOrganizationName()));
        questionpool.setObjectives(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)bean.getObjectives()));
        questionpool.setKeywords(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)bean.getKeywords()));
        questionpool.setAccessTypeId(QuestionPoolFacade.ACCESS_DENIED);
        QuestionPoolService service = new QuestionPoolService();
        if (beanid.toString().equals("0")) {
            questionpool.setOwnerId(AgentFacade.getAgentString());
            questionpool.setDateCreated(new Date());
        } else {
            questionpool.setOwnerId(service.getPool(beanid, AgentFacade.getAgentString()).getOwnerId());
            questionpool.setDateCreated(bean.getDateCreated());
        }
        QuestionPoolService delegate = new QuestionPoolService();
        delegate.savePool(questionpool);
        qpbean.buildTree();
        if ("editpool".equals(qpbean.getAddPoolSource())) {
            qpbean.startEditPoolAgain(parentid.toString());
            QuestionPoolDataBean currentPool = qpbean.getCurrentPool();
            currentPool.setDisplayName(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)qpbean.getParentPool().getDisplayName()));
            currentPool.setOrganizationName(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)qpbean.getParentPool().getOrganizationName()));
            currentPool.setDescription(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)qpbean.getParentPool().getDescription()));
            currentPool.setObjectives(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)qpbean.getParentPool().getObjectives()));
            currentPool.setKeywords(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)qpbean.getParentPool().getKeywords()));
            ArrayList<Long> addedPools = qpbean.getAddedPools();
            if (addedPools == null) {
                addedPools = new ArrayList<Long>();
            }
            addedPools.add(questionpool.getQuestionPoolId());
            qpbean.setAddedPools(addedPools);
            qpbean.setOutcome("editPool");
            qpbean.setAddPoolSource("");
            qpbean.setSubQpDataModelByLevel();
        } else {
            qpbean.setOutcomeEdit("poolList");
            qpbean.setOutcome("poolList");
            qpbean.setQpDataModelByLevel();
        }
        return true;
    }

    public boolean startRemoveItems(QuestionPoolBean qpoolbean) {
        try {
            String itemId2 = "";
            ArrayList destItems = ContextUtil.paramArrayValueLike((String)"removeCheckbox");
            if (destItems.size() > 0) {
                ArrayList<ItemFacade> items = new ArrayList<ItemFacade>();
                for (String itemId2 : destItems) {
                    ItemService delegate = new ItemService();
                    ItemFacade itemfacade = delegate.getItem(new Long(itemId2), AgentFacade.getAgentString());
                    items.add(itemfacade);
                }
                qpoolbean.setItemsToDelete(items);
                qpoolbean.setOutcomeEdit("removeQuestionFromPool");
                qpoolbean.setOutcome("removeQuestionFromPool");
            } else {
                qpoolbean.setOutcome("poolList");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

