/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.samlite;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.sakaiproject.tool.assessment.facade.AssessmentTemplateFacade;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.authz.AuthorizationBean;
import org.sakaiproject.tool.assessment.ui.bean.samlite.SamLiteBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class NameListener
implements ActionListener {
    public void processAction(ActionEvent ae) {
        FacesContext context = FacesContext.getCurrentInstance();
        SamLiteBean samLiteBean = (SamLiteBean)ContextUtil.lookupBean((String)"samLiteBean");
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        author.setOutcome("samLiteEntry");
        if (!this.passAuthz(context)) {
            author.setOutcome("author");
            return;
        }
        String assessmentTitle = ContextUtil.lookupParam((String)"title");
        if (null == assessmentTitle || "".equals(assessmentTitle.trim())) {
            String err1 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"assessmentName_empty");
            context.addMessage(null, new FacesMessage(err1));
            author.setOutcome("author");
            return;
        }
        samLiteBean.setName(assessmentTitle);
        samLiteBean.setDescription(author.getAssessmentDescription());
        String templateId = ContextUtil.lookupParam((String)"assessmentTemplate");
        if (templateId == null) {
            templateId = AssessmentTemplateFacade.DEFAULTTEMPLATE.toString();
        }
        samLiteBean.setAssessmentTemplateId(templateId);
    }

    private boolean passAuthz(FacesContext context) {
        AuthorizationBean authzBean = (AuthorizationBean)ContextUtil.lookupBean((String)"authorization");
        boolean hasPrivilege = authzBean.getCreateAssessment();
        if (!hasPrivilege) {
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"denied_create_assessment_error");
            context.addMessage(null, new FacesMessage(err));
        }
        return hasPrivilege;
    }
}

