/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.api.SamigoApiFactory;
import org.sakaiproject.tool.assessment.data.dao.grading.StudentGradingSummaryData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentGradingFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.shared.api.assessment.SecureDeliveryServiceAPI;
import org.sakaiproject.tool.assessment.ui.bean.authz.AuthorizationBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBeanie;
import org.sakaiproject.tool.assessment.ui.bean.select.SelectAssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.shared.PersonBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.BeanSort;
import org.sakaiproject.util.ResourceLoader;

public class SelectActionListener
implements ActionListener {
    private static Log log = LogFactory.getLog(SelectActionListener.class);
    private static BeanSort bs;
    private static BeanSort bs2;

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        AuthorizationBean authzBean = (AuthorizationBean)ContextUtil.lookupBean((String)"authorization");
        PersonBean personBean = (PersonBean)ContextUtil.lookupBean((String)"person");
        DeliveryBean deliveryBean = (DeliveryBean)ContextUtil.lookupBean((String)"delivery");
        if (!deliveryBean.getAnonymousLogin() && !authzBean.getTakeAssessment()) {
            return;
        }
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        SelectAssessmentBean select = (SelectAssessmentBean)ContextUtil.lookupBean((String)"select");
        select.setHasHighestMultipleSubmission(false);
        select.setHasAnyAssessmentBeenModified(false);
        this.processSortInfo(select);
        HashMap h = publishedAssessmentService.getTotalSubmissionPerAssessment(AgentFacade.getAgentString(), AgentFacade.getCurrentSiteId());
        personBean.setTotalSubmissionPerAssessmentHash(h);
        ArrayList publishedAssessmentList = publishedAssessmentService.getBasicInfoOfAllPublishedAssessments(AgentFacade.getAgentString(), this.getTakeableOrderBy(select), select.isTakeableAscending(), AgentFacade.getCurrentSiteId());
        GradingService gradingService = new GradingService();
        List list = gradingService.getUpdatedAssessmentList(AgentFacade.getAgentString(), AgentFacade.getCurrentSiteId());
        List updatedAssessmentNeedResubmitList = new ArrayList();
        List updatedAssessmentList = new ArrayList();
        if (list != null && list.size() == 2) {
            updatedAssessmentNeedResubmitList = (List)list.get(0);
            updatedAssessmentList = (List)list.get(1);
        }
        ArrayList takeableList = this.getTakeableList(publishedAssessmentList, h, updatedAssessmentNeedResubmitList, updatedAssessmentList);
        ArrayList<DeliveryBeanie> takeablePublishedList = new ArrayList<DeliveryBeanie>();
        for (int i = 0; i < takeableList.size(); ++i) {
            PublishedAssessmentFacade f = (PublishedAssessmentFacade)takeableList.get(i);
            DeliveryBeanie delivery = new DeliveryBeanie();
            delivery.setAssessmentId(f.getPublishedAssessmentId().toString());
            delivery.setAssessmentTitle(f.getTitle());
            delivery.setDueDate(f.getDueDate());
            delivery.setTimeRunning(false);
            this.setTimedAssessment(delivery, f);
            if (f.getDueDate() != null && new Date().after(f.getDueDate())) {
                delivery.setPastDue(true);
            } else {
                delivery.setPastDue(false);
            }
            if (updatedAssessmentNeedResubmitList.contains(f.getPublishedAssessmentId())) {
                delivery.setAssessmentUpdatedNeedResubmit(true);
            } else {
                delivery.setAssessmentUpdatedNeedResubmit(false);
            }
            if (updatedAssessmentList.contains(f.getPublishedAssessmentId())) {
                delivery.setAssessmentUpdated(true);
            } else {
                delivery.setAssessmentUpdated(false);
            }
            takeablePublishedList.add(delivery);
        }
        this.processDisplayInfo(select);
        ArrayList recentSubmittedList = publishedAssessmentService.getBasicInfoOfLastOrHighestOrAverageSubmittedAssessmentsByScoringOption(AgentFacade.getAgentString(), AgentFacade.getCurrentSiteId(), "2".equals(select.getDisplayAllAssessments()));
        HashMap publishedAssessmentHash = this.getPublishedAssessmentHash(publishedAssessmentList);
        ArrayList<DeliveryBeanie> submittedAssessmentGradingList = new ArrayList<DeliveryBeanie>();
        boolean hasHighest = false;
        boolean hasMultipleSubmission = false;
        HashMap feedbackHash = publishedAssessmentService.getFeedbackHash();
        Object deliveryAnt = null;
        boolean isUnique = true;
        HashSet<Long> recentSubmittedIds = new HashSet<Long>();
        select.setHasAnyAssessmentRetractForEdit(false);
        for (int k = 0; k < recentSubmittedList.size(); ++k) {
            AssessmentGradingFacade g = (AssessmentGradingFacade)recentSubmittedList.get(k);
            recentSubmittedIds.add(g.getPublishedAssessmentId());
        }
        List containRandomPartAssessmentIds = publishedAssessmentService.getContainRandomPartAssessmentIds(recentSubmittedIds);
        for (int k = 0; k < recentSubmittedList.size(); ++k) {
            hasHighest = false;
            hasMultipleSubmission = false;
            AssessmentGradingFacade g = (AssessmentGradingFacade)recentSubmittedList.get(k);
            DeliveryBeanie delivery = new DeliveryBeanie();
            delivery.setAssessmentGradingId(g.getAssessmentGradingId());
            delivery.setAssessmentId(g.getPublishedAssessmentId().toString());
            Integer submissionAllowed = this.getSubmissionAllowed(g.getPublishedAssessmentId(), publishedAssessmentHash);
            if (submissionAllowed == -1) {
                log.debug((Object)"submissionAllowed == -1");
                continue;
            }
            if (submissionAllowed == 0) {
                delivery.setMultipleSubmissions(true);
                hasMultipleSubmission = true;
            } else if (submissionAllowed == 1) {
                delivery.setMultipleSubmissions(false);
                hasMultipleSubmission = false;
            } else if (submissionAllowed > 1) {
                delivery.setMultipleSubmissions(true);
                hasMultipleSubmission = true;
            }
            delivery.setScoringOption(this.getScoringType(g.getPublishedAssessmentId(), publishedAssessmentHash));
            if (EvaluationModelIfc.HIGHEST_SCORE.toString().equals(delivery.getScoringOption())) {
                hasHighest = true;
            }
            if (hasHighest && hasMultipleSubmission) {
                select.setHasHighestMultipleSubmission(true);
            }
            if (hasMultipleSubmission && EvaluationModelIfc.AVERAGE_SCORE.toString().equals(delivery.getScoringOption())) {
                select.setHasAverageMultipleSubmissions(true);
            }
            delivery.setAssessmentTitle(g.getPublishedAssessmentTitle());
            delivery.setFeedbackDelivery(this.getFeedbackDelivery(g.getPublishedAssessmentId(), publishedAssessmentHash));
            delivery.setFeedbackComponentOption(this.getFeedbackComponentOption(g.getPublishedAssessmentId(), publishedAssessmentHash));
            delivery.setFeedbackDate(this.getFeedbackDate(g.getPublishedAssessmentId(), publishedAssessmentHash));
            if (g.getFinalScore() != null) {
                delivery.setFinalScore(g.getFinalScore().toString());
                delivery.setGrade(g.getFinalScore().toString());
                delivery.setRawScore(g.getFinalScore().toString());
                delivery.setRaw(g.getFinalScore().longValue());
            }
            delivery.setTimeElapse(this.getTimeElapsed(g.getTimeElapsed()));
            delivery.setSubmissionDate(g.getSubmittedDate());
            delivery.setHasAssessmentBeenModified(this.getHasAssessmentBeenModified(select, g, publishedAssessmentHash));
            delivery.setSubmitted(true);
            PublishedAssessmentFacade p = (PublishedAssessmentFacade)publishedAssessmentHash.get(g.getPublishedAssessmentId());
            String hasFeedback = this.hasFeedback(p);
            delivery.setFeedback(hasFeedback);
            boolean isAssessmentRetractForEdit = this.isAssessmentRetractForEdit(p);
            delivery.setIsAssessmentRetractForEdit(isAssessmentRetractForEdit);
            if (isAssessmentRetractForEdit) {
                select.setHasAnyAssessmentRetractForEdit(true);
            }
            if (containRandomPartAssessmentIds.contains(g.getPublishedAssessmentId())) {
                delivery.setHasRandomDrawPart(true);
            } else {
                delivery.setHasRandomDrawPart(false);
            }
            delivery.setShowScore(this.showScore(g, hasFeedback, feedbackHash));
            String hasStats = this.hasStats(g, feedbackHash);
            delivery.setStatistics(hasStats);
            delivery.setIsRecordedAssessment(g.getIsRecorded());
            submittedAssessmentGradingList.add(delivery);
        }
        BeanSort bs = new BeanSort(submittedAssessmentGradingList, "assessmentTitle");
        bs.toStringSort();
        bs.sort();
        Iterator iter = submittedAssessmentGradingList.iterator();
        ArrayList<DeliveryBeanie> averageScoreAssessmentGradingList = new ArrayList<DeliveryBeanie>();
        while (iter.hasNext()) {
            DeliveryBeanie db = (DeliveryBeanie)iter.next();
            if (!db.getScoringOption().equals(EvaluationModelIfc.AVERAGE_SCORE.toString())) continue;
            averageScoreAssessmentGradingList.add(db);
        }
        String lastPublishedAssessmentId = "";
        HashMap<String, Float> averageScoreMap = new HashMap<String, Float>();
        float totalScores = 0.0f;
        int totalSubmissions = 0;
        float averageScore = 0.0f;
        for (int i = 0; i < averageScoreAssessmentGradingList.size(); ++i) {
            DeliveryBeanie db = (DeliveryBeanie)averageScoreAssessmentGradingList.get(i);
            if (lastPublishedAssessmentId != null && lastPublishedAssessmentId.equals(db.getAssessmentId()) || averageScoreAssessmentGradingList.size() == 1) {
                totalScores += Float.parseFloat(db.getFinalScore());
                ++totalSubmissions;
                if (i != averageScoreAssessmentGradingList.size() - 1) continue;
                averageScore = totalScores / (float)totalSubmissions;
                averageScoreMap.put(db.getAssessmentId(), Float.valueOf(averageScore));
                continue;
            }
            if (i > 0) {
                averageScore = totalScores / (float)totalSubmissions;
                averageScoreMap.put(lastPublishedAssessmentId, Float.valueOf(averageScore));
            }
            lastPublishedAssessmentId = db.getAssessmentId();
            totalScores = Float.parseFloat(db.getFinalScore());
            totalSubmissions = 1;
            if (i != averageScoreAssessmentGradingList.size() - 1) continue;
            averageScore = totalScores / (float)totalSubmissions;
            averageScoreMap.put(db.getAssessmentId(), Float.valueOf(averageScore));
        }
        GradingService service = new GradingService();
        ArrayList<DeliveryBeanie> reviewableList = new ArrayList<DeliveryBeanie>();
        ArrayList<DeliveryBeanie> recordedList = new ArrayList<DeliveryBeanie>();
        Iterator it = submittedAssessmentGradingList.iterator();
        String assessmentIdNew = "";
        while (it.hasNext()) {
            DeliveryBeanie recorded;
            DeliveryBeanie beanie = (DeliveryBeanie)it.next();
            String assessmentIdOld = beanie.getAssessmentId();
            if (beanie.getScoringOption().equals(EvaluationModelIfc.AVERAGE_SCORE.toString()) && !assessmentIdNew.equals(assessmentIdOld)) {
                assessmentIdNew = beanie.getAssessmentId();
                beanie.setIsRecordedAssessment(false);
                recorded = new DeliveryBeanie();
                recorded.setStatistics(beanie.getStatistics());
                recorded.setHasRandomDrawPart(beanie.getHasRandomDrawPart());
                recorded.setDueDate(beanie.getDueDate());
                recorded.setHasAssessmentBeenModified(beanie.getHasAssessmentBeenModified());
                recorded.setIsAssessmentRetractForEdit(beanie.getIsAssessmentRetractForEdit());
                recorded.setPastDue(beanie.getPastDue());
                recorded.setShowScore(beanie.getShowScore());
                recorded.setSubTime(beanie.getSubTime());
                recorded.setAssessmentGradingId(beanie.getAssessmentGradingId());
                recorded.setAssessmentTitle(beanie.getAssessmentTitle());
                recorded.setAssessmentId(beanie.getAssessmentId());
                recorded.setFeedback(beanie.getFeedback());
                recorded.setFeedbackDate(beanie.getFeedbackDate());
                recorded.setFeedbackDelivery(beanie.getFeedbackDelivery());
                recorded.setFeedbackComponentOption(beanie.getFeedbackComponentOption());
                recorded.setFinalScore(averageScoreMap.get(assessmentIdNew).toString());
                recorded.setGrade(averageScoreMap.get(assessmentIdNew).toString());
                recorded.setRawScore(averageScoreMap.get(assessmentIdNew).toString());
                recorded.setMultipleSubmissions(beanie.isMultipleSubmissions());
                recorded.setIsRecordedAssessment(true);
                recorded.setScoringOption(beanie.getScoringOption());
                recordedList.add(recorded);
                reviewableList.add(recorded);
                reviewableList.add(beanie);
                continue;
            }
            if ((beanie.getScoringOption().equals(EvaluationModelIfc.HIGHEST_SCORE.toString()) || beanie.getScoringOption().equals(EvaluationModelIfc.LAST_SCORE.toString())) && beanie.getIsRecordedAssessment()) {
                beanie.setIsRecordedAssessment(false);
                recorded = new DeliveryBeanie();
                recorded.setStatistics(beanie.getStatistics());
                recorded.setHasRandomDrawPart(beanie.getHasRandomDrawPart());
                recorded.setDueDate(beanie.getDueDate());
                recorded.setHasAssessmentBeenModified(beanie.getHasAssessmentBeenModified());
                recorded.setIsAssessmentRetractForEdit(beanie.getIsAssessmentRetractForEdit());
                recorded.setPastDue(beanie.getPastDue());
                recorded.setShowScore(beanie.getShowScore());
                recorded.setSubTime(beanie.getSubTime());
                recorded.setAssessmentGradingId(beanie.getAssessmentGradingId());
                recorded.setAssessmentTitle(beanie.getAssessmentTitle());
                recorded.setAssessmentId(beanie.getAssessmentId());
                recorded.setFeedback(beanie.getFeedback());
                recorded.setFeedbackDate(beanie.getFeedbackDate());
                recorded.setFeedbackDelivery(beanie.getFeedbackDelivery());
                recorded.setFeedbackComponentOption(beanie.getFeedbackComponentOption());
                recorded.setFinalScore(beanie.getFinalScore());
                recorded.setGrade(beanie.getGrade());
                recorded.setRawScore(beanie.getRawScore());
                recorded.setMultipleSubmissions(beanie.isMultipleSubmissions());
                recorded.setIsRecordedAssessment(true);
                recorded.setScoringOption(beanie.getScoringOption());
                recordedList.add(recorded);
                reviewableList.add(recorded);
                reviewableList.add(beanie);
                continue;
            }
            if (!"2".equals(select.getDisplayAllAssessments())) continue;
            reviewableList.add(beanie);
        }
        submittedAssessmentGradingList = "2".equals(select.getDisplayAllAssessments()) ? reviewableList : recordedList;
        if (!select.isReviewableAscending()) {
            Collections.reverse(submittedAssessmentGradingList);
        }
        select.setTakeableAssessments(takeablePublishedList);
        select.setReviewableAssessments(submittedAssessmentGradingList);
        select.setSecureDeliveryHTMLFragments("");
        SecureDeliveryServiceAPI secureDelivery = SamigoApiFactory.getInstance().getSecureDeliveryServiceAPI();
        if (secureDelivery.isSecureDeliveryAvaliable()) {
            HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
            select.setSecureDeliveryHTMLFragments(secureDelivery.getInitialHTMLFragments(request, new ResourceLoader().getLocale()));
        }
    }

    private String getTakeableOrderBy(SelectAssessmentBean select) {
        String sort = select.getTakeableSortOrder();
        String returnType = "title";
        if (sort != null && sort.equals("due")) {
            returnType = "dueDate";
        }
        return returnType;
    }

    private String getSubmittedOrderBy(SelectAssessmentBean select) {
        String sort = select.getReviewableSortOrder();
        String returnType = "assessmentTitle";
        if (sort != null) {
            if ("raw".equals(sort)) {
                returnType = "raw";
            } else if ("grade".equals(sort)) {
                returnType = "grade";
            } else if ("time".equals(sort)) {
                returnType = "subTime";
            } else if ("submitted".equals(sort)) {
                returnType = "submissionDate";
            } else if ("feedbackDate".equals(sort)) {
                returnType = "feedbackDate";
            }
        }
        return returnType;
    }

    private void processDisplayInfo(SelectAssessmentBean bean) {
        String displaySubmissions = ContextUtil.lookupParam((String)"selectSubmissions");
        if (displaySubmissions != null && displaySubmissions.equalsIgnoreCase("1")) {
            bean.setDisplayAllAssessments("1");
        } else {
            bean.setDisplayAllAssessments("2");
        }
    }

    private void processSortInfo(SelectAssessmentBean bean) {
        String takeOrder = ContextUtil.lookupParam((String)"takeableSortType");
        String reviewOrder = ContextUtil.lookupParam((String)"reviewableSortType");
        String reviewAscending = ContextUtil.lookupParam((String)"reviewableAscending");
        String takeAscending = ContextUtil.lookupParam((String)"takeAscending");
        if (takeOrder != null && !takeOrder.trim().equals("")) {
            bean.setTakeableSortOrder(takeOrder);
        }
        if (reviewOrder != null && !reviewOrder.trim().equals("")) {
            bean.setReviewableSortOrder(reviewOrder);
        }
        if (takeAscending != null && !takeAscending.trim().equals("")) {
            try {
                bean.setTakeableAscending(Boolean.valueOf(takeAscending).booleanValue());
            }
            catch (Exception ex) {
                log.warn((Object)ex.getMessage());
            }
        } else {
            bean.setTakeableAscending(true);
        }
        if (reviewAscending != null && !reviewAscending.trim().equals("")) {
            try {
                bean.setReviewableAscending(Boolean.valueOf(reviewAscending).booleanValue());
            }
            catch (Exception ex) {
                log.warn((Object)ex.getMessage());
            }
        } else {
            bean.setReviewableAscending(true);
        }
    }

    private ArrayList getTakeableList(ArrayList assessmentList, HashMap h, List updatedAssessmentNeedResubmitList, List updatedAssessmentList) {
        ArrayList<PublishedAssessmentFacade> takeableList = new ArrayList<PublishedAssessmentFacade>();
        GradingService gradingService = new GradingService();
        HashMap numberRetakeHash = gradingService.getNumberRetakeHash(AgentFacade.getAgentString());
        HashMap actualNumberRetake = gradingService.getActualNumberRetakeHash(AgentFacade.getAgentString());
        for (int i = 0; i < assessmentList.size(); ++i) {
            PublishedAssessmentFacade f = (PublishedAssessmentFacade)assessmentList.get(i);
            if (f.getReleaseTo() == null || "".equals(f.getReleaseTo()) || f.getReleaseTo().indexOf("Anonymous Users") != -1 || !this.isAvailable(f, h, numberRetakeHash, actualNumberRetake, updatedAssessmentNeedResubmitList, updatedAssessmentList)) continue;
            takeableList.add(f);
        }
        return takeableList;
    }

    public boolean isAvailable(PublishedAssessmentFacade f, HashMap h, HashMap numberRetakeHash, HashMap actualNumberRetakeHash, List updatedAssessmentNeedResubmitList, List updatedAssessmentList) {
        boolean returnValue = false;
        Integer status = f.getStatus();
        Date currentDate = new Date();
        Date startDate = f.getStartDate();
        Date retractDate = f.getRetractDate();
        Date dueDate = f.getDueDate();
        if (!Integer.valueOf(1).equals(status)) {
            return false;
        }
        if (startDate != null && startDate.after(currentDate)) {
            return false;
        }
        if (retractDate != null && retractDate.before(currentDate)) {
            return false;
        }
        if (updatedAssessmentNeedResubmitList.contains(f.getPublishedAssessmentId()) || updatedAssessmentList.contains(f.getPublishedAssessmentId())) {
            return true;
        }
        boolean acceptLateSubmission = AssessmentAccessControlIfc.ACCEPT_LATE_SUBMISSION.equals(f.getLateHandling());
        int maxSubmissionsAllowed = 9999;
        if (Boolean.FALSE.equals(f.getUnlimitedSubmissions())) {
            maxSubmissionsAllowed = f.getSubmissionsAllowed();
        }
        int numberRetake = 0;
        if (numberRetakeHash.get(f.getPublishedAssessmentId()) != null) {
            numberRetake = ((StudentGradingSummaryData)numberRetakeHash.get(f.getPublishedAssessmentId())).getNumberRetake();
        }
        int totalSubmitted = 0;
        if (h.get(f.getPublishedAssessmentId()) != null) {
            totalSubmitted = (Integer)h.get(f.getPublishedAssessmentId());
        }
        if (retractDate == null || retractDate.after(currentDate)) {
            if (startDate == null || startDate.before(currentDate)) {
                if (dueDate != null && dueDate.before(currentDate)) {
                    if (acceptLateSubmission && totalSubmitted == 0) {
                        return true;
                    }
                    int actualNumberRetake = 0;
                    if (actualNumberRetakeHash.get(f.getPublishedAssessmentId()) != null) {
                        actualNumberRetake = (Integer)actualNumberRetakeHash.get(f.getPublishedAssessmentId());
                    }
                    if (actualNumberRetake < numberRetake) {
                        returnValue = true;
                    }
                } else if (totalSubmitted < maxSubmissionsAllowed + numberRetake) {
                    returnValue = true;
                }
            }
        } else if (totalSubmitted < maxSubmissionsAllowed + numberRetake) {
            returnValue = true;
        }
        return returnValue;
    }

    private String hasFeedback(PublishedAssessmentFacade p) {
        String hasFeedback = "na";
        Date currentDate = new Date();
        if (p == null) {
            return hasFeedback;
        }
        if (AssessmentFeedbackIfc.IMMEDIATE_FEEDBACK.equals(p.getFeedbackDelivery()) || AssessmentFeedbackIfc.FEEDBACK_ON_SUBMISSION.equals(p.getFeedbackDelivery()) || AssessmentFeedbackIfc.FEEDBACK_BY_DATE.equals(p.getFeedbackDelivery()) && p.getFeedbackDate() != null && currentDate.after(p.getFeedbackDate())) {
            hasFeedback = "show";
        }
        if (AssessmentFeedbackIfc.FEEDBACK_BY_DATE.equals(p.getFeedbackDelivery()) && p.getFeedbackDate() != null && currentDate.before(p.getFeedbackDate())) {
            hasFeedback = "blank";
        }
        return hasFeedback;
    }

    private boolean isAssessmentRetractForEdit(PublishedAssessmentFacade p) {
        if (p == null) {
            return false;
        }
        return AssessmentIfc.RETRACT_FOR_EDIT_STATUS.equals(p.getStatus());
    }

    private String hasStats(AssessmentGradingFacade a, HashMap feedbackHash) {
        String hasStats = "false";
        AssessmentFeedbackIfc f = (AssessmentFeedbackIfc)feedbackHash.get(a.getPublishedAssessmentId());
        if (f != null && Boolean.TRUE.equals(f.getShowStatistics())) {
            hasStats = "true";
        }
        return hasStats;
    }

    private String showScore(AssessmentGradingFacade a, String hasFeedback, HashMap feedbackHash) {
        String showScore = "na";
        AssessmentFeedbackIfc f = (AssessmentFeedbackIfc)feedbackHash.get(a.getPublishedAssessmentId());
        if (f != null) {
            boolean showScorecore;
            boolean bl = showScorecore = Boolean.TRUE.equals(f.getShowStudentScore()) || Integer.valueOf(1).equals(f.getFeedbackComponentOption());
            if (showScorecore && "show".equals(hasFeedback)) {
                showScore = "show";
            }
            if (showScorecore && "blank".equals(hasFeedback)) {
                showScore = "blank";
            }
        }
        return showScore;
    }

    private String getScoringType(Long publishedAssessmentId, HashMap publishedAssessmentHash) {
        PublishedAssessmentFacade p = (PublishedAssessmentFacade)publishedAssessmentHash.get(publishedAssessmentId);
        if (p != null && p.getScoringType() != null) {
            return p.getScoringType().toString();
        }
        return null;
    }

    private Integer getSubmissionAllowed(Long publishedAssessmentId, HashMap publishedAssessmentHash) {
        PublishedAssessmentFacade p = (PublishedAssessmentFacade)publishedAssessmentHash.get(publishedAssessmentId);
        if (p != null) {
            return p.getSubmissionsAllowed();
        }
        log.debug((Object)"The published assessment is not valid");
        return -1;
    }

    private Date getFeedbackDate(Long publishedAssessmentId, HashMap publishedAssessmentHash) {
        PublishedAssessmentFacade p = (PublishedAssessmentFacade)publishedAssessmentHash.get(publishedAssessmentId);
        if (p != null) {
            return p.getFeedbackDate();
        }
        return null;
    }

    private String getFeedbackDelivery(Long publishedAssessmentId, HashMap publishedAssessmentHash) {
        PublishedAssessmentFacade p = (PublishedAssessmentFacade)publishedAssessmentHash.get(publishedAssessmentId);
        if (p != null) {
            return p.getFeedbackDelivery().toString();
        }
        return null;
    }

    private String getFeedbackComponentOption(Long publishedAssessmentId, HashMap publishedAssessmentHash) {
        PublishedAssessmentFacade p = (PublishedAssessmentFacade)publishedAssessmentHash.get(publishedAssessmentId);
        if (p != null) {
            Integer option = p.getFeedbackComponentOption();
            if (option == null) {
                return null;
            }
            return option.toString();
        }
        return null;
    }

    private boolean getHasAssessmentBeenModified(SelectAssessmentBean select, AssessmentGradingFacade g, HashMap publishedAssessmentHash) {
        PublishedAssessmentFacade p = (PublishedAssessmentFacade)publishedAssessmentHash.get(g.getPublishedAssessmentId());
        if (p != null && !Integer.valueOf(AssessmentIfc.RETRACT_FOR_EDIT_STATUS).equals(p.getStatus()) && g.getSubmittedDate() != null && p.getLastModifiedDate().after(g.getSubmittedDate())) {
            log.debug((Object)("AssessmentGradingId = " + g.getAssessmentGradingId()));
            log.debug((Object)("LastModifiedDate = " + p.getLastModifiedDate()));
            log.debug((Object)("SubmittedDate = " + g.getSubmittedDate()));
            select.setHasAnyAssessmentBeenModified(true);
            return true;
        }
        return false;
    }

    private String getTimeElapsed(Integer s) {
        String timeElapsedInString = "n/a";
        if (s != null && s > 0) {
            int totalSec = s;
            int hr = totalSec / 3600;
            int min = totalSec % 3600 / 60;
            int sec = totalSec % 3600 % 60;
            timeElapsedInString = "";
            if (hr > 0) {
                timeElapsedInString = hr + " hr ";
            }
            if (min > 0) {
                timeElapsedInString = timeElapsedInString + min + " min ";
            }
            if (sec > 0) {
                timeElapsedInString = timeElapsedInString + sec + " sec ";
            }
        }
        return timeElapsedInString;
    }

    public HashMap getPublishedAssessmentHash(ArrayList publishedAssessmentList) {
        HashMap<Long, PublishedAssessmentFacade> h = new HashMap<Long, PublishedAssessmentFacade>();
        for (int i = 0; i < publishedAssessmentList.size(); ++i) {
            PublishedAssessmentFacade p = (PublishedAssessmentFacade)publishedAssessmentList.get(i);
            h.put(p.getPublishedAssessmentId(), p);
        }
        return h;
    }

    private void setTimedAssessment(DeliveryBeanie delivery, PublishedAssessmentFacade pubAssessment) {
        if (pubAssessment.getTimeLimit() != null) {
            int seconds = pubAssessment.getTimeLimit();
            int hour = 0;
            int minute = 0;
            if (seconds >= 3600) {
                hour = Math.abs(seconds / 3600);
                minute = Math.abs((seconds - hour * 3600) / 60);
            } else {
                minute = Math.abs(seconds / 60);
            }
            delivery.setTimeLimit_hour(hour);
            delivery.setTimeLimit_minute(minute);
        } else {
            delivery.setTimeLimit_hour(0);
            delivery.setTimeLimit_minute(0);
        }
    }
}

