/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.queue.delivery;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.event.cover.NotificationService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.AssessmentGradingIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.model.delivery.TimedAssessmentGradingModel;
import org.sakaiproject.tool.assessment.ui.queue.delivery.TimedAssessmentQueue;
import org.sakaiproject.tool.cover.SessionManager;

public class SubmitTimedAssessmentThread
extends TimerTask {
    private static Log log = LogFactory.getLog(SubmitTimedAssessmentThread.class);

    public void run() {
        log.debug((Object)"run!!");
        ArrayList<TimedAssessmentGradingModel> removeTimedAGList = new ArrayList<TimedAssessmentGradingModel>();
        TimedAssessmentQueue queue = TimedAssessmentQueue.getInstance();
        for (TimedAssessmentGradingModel timedAG : queue) {
            log.debug((Object)("****** going through timedAG in queue, timedAG" + timedAG));
            boolean submitted = timedAG.getSubmittedForGrade();
            long bufferedExpirationTime = timedAG.getBufferedExpirationDate().getTime();
            long currentTime = new Date().getTime();
            log.debug((Object)("****** submitted=" + submitted));
            log.debug((Object)("****** currentTime=" + currentTime));
            log.debug((Object)("****** bufferedExpirationTime=" + bufferedExpirationTime));
            log.debug((Object)("****** expired=" + (currentTime > bufferedExpirationTime)));
            if (!submitted) {
                if (currentTime <= bufferedExpirationTime) continue;
                timedAG.setSubmittedForGrade(true);
                GradingService service = new GradingService();
                AssessmentGradingData ag = service.load(timedAG.getAssessmentGradingId().toString());
                if (ag.getForGrade().booleanValue()) continue;
                ag.setForGrade(Boolean.TRUE);
                ag.setTimeElapsed(Integer.valueOf(timedAG.getTimeLimit()));
                ag.setStatus(AssessmentGradingIfc.SUBMITTED);
                ag.setIsLate(this.islate(ag.getPublishedAssessmentId()));
                ag.setSubmittedDate(new Date());
                if (ag.getFinalScore() == null) {
                    ag.setFinalScore(Float.valueOf("0"));
                }
                if (ag.getTotalAutoScore() == null) {
                    ag.setTotalAutoScore(Float.valueOf("0"));
                }
                service.completeItemGradingData(ag);
                service.saveOrUpdateAssessmentGrading((AssessmentGradingIfc)ag);
                PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
                String siteId = publishedAssessmentService.getPublishedAssessmentOwner(ag.getPublishedAssessmentId());
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.thread_submit", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", submissionId=" + ag.getAssessmentGradingId()), (String)siteId, (boolean)true, (int)NotificationService.NOTI_REQUIRED));
                this.notifyGradebookByScoringType((AssessmentGradingIfc)ag, timedAG.getPublishedAssessment());
                log.debug((Object)"**** 4a. time's up, timeLeft+latency buffer reached, saved to DB");
                continue;
            }
            if (currentTime <= bufferedExpirationTime + (long)timedAG.getTransactionBuffer() * 1000L) continue;
            removeTimedAGList.add(timedAG);
            log.debug((Object)"**** 4b. transaction buffer reached");
        }
        Iterator i = removeTimedAGList.iterator();
        while (i.hasNext()) {
            log.debug((Object)"removing from queue");
            queue.remove((TimedAssessmentGradingModel)i.next());
        }
    }

    private Boolean islate(Long publishedId) {
        PublishedAssessmentService service = new PublishedAssessmentService();
        PublishedAssessmentData pub = service.getBasicInfoOfPublishedAssessment(publishedId.toString());
        if (pub.getDueDate() != null && pub.getDueDate().before(new Date())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void notifyGradebookByScoringType(AssessmentGradingIfc ag, PublishedAssessmentFacade publishedAssessment) {
        if (publishedAssessment == null || publishedAssessment.getEvaluationModel() == null) {
            log.debug((Object)"publishedAssessment is null or publishedAssessment.getEvaluationModel() is null");
            return;
        }
        if (publishedAssessment.getEvaluationModel().getToGradeBook().equals(EvaluationModelIfc.TO_DEFAULT_GRADEBOOK.toString())) {
            Session s;
            AssessmentGradingIfc assessmentGrading = ag;
            GradingService g = new GradingService();
            if (publishedAssessment.getEvaluationModel().getScoringType().equals(EvaluationModelIfc.HIGHEST_SCORE)) {
                assessmentGrading = g.getHighestSubmittedAssessmentGrading(publishedAssessment.getPublishedAssessmentId().toString(), ag.getAgentId());
            }
            if ((s = SessionManager.getCurrentSession()) != null) {
                s.setUserId(assessmentGrading.getAgentId());
                g.notifyGradebook(assessmentGrading, (PublishedAssessmentIfc)publishedAssessment);
            }
        }
    }
}

