/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.servlet.delivery;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.MediaIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.integration.helper.integrated.AgentHelperImpl;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.shared.impl.assessment.PublishedAssessmentServiceImpl;
import org.sakaiproject.tool.assessment.ui.bean.authz.AuthorizationBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.QuestionScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.shared.PersonBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class DownloadAllMediaServlet
extends HttpServlet {
    private static final long serialVersionUID = 1465451058167004991L;
    private static Log log = LogFactory.getLog(DownloadAllMediaServlet.class);
    private GradingService gradingService = new GradingService();

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String assessmentCreatedBy;
        String publishedItemId = req.getParameter("publishedItemId");
        log.debug((Object)("publishedItemId = " + publishedItemId));
        boolean accessDenied = true;
        String agentIdString = this.getAgentString(req, res);
        String currentSiteId = "";
        String assessmentName = "";
        PublishedAssessmentIfc pub = this.gradingService.getPublishedAssessmentByPublishedItemId(publishedItemId);
        if (pub != null) {
            assessmentName = pub.getTitle();
            PublishedAssessmentService service = new PublishedAssessmentService();
            log.debug((Object)("pub.getPublishedAssessmentId() = " + pub.getPublishedAssessmentId()));
            currentSiteId = service.getPublishedAssessmentOwner(pub.getPublishedAssessmentId());
        }
        if (this.canGrade(req, res, agentIdString, currentSiteId, assessmentCreatedBy = req.getParameter("createdBy"))) {
            accessDenied = false;
        }
        if (accessDenied) {
            String path = "/jsf/delivery/mediaAccessDenied.faces";
            RequestDispatcher dispatcher = req.getRequestDispatcher(path);
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        } else {
            res.setContentType("application/x-zip-compressed");
            StringBuilder zipFilename = new StringBuilder();
            zipFilename.append(assessmentName);
            String partAndQues = this.getPartNumAndQuestionNum(publishedItemId);
            log.debug((Object)("partAndQues = " + partAndQues));
            zipFilename.append(partAndQues);
            zipFilename.append(".zip");
            log.debug((Object)("zipFilename = " + zipFilename));
            res.setHeader("Content-Disposition", "attachment;filename=\"" + zipFilename + "\";");
            String anonymous = req.getParameter("anonymous");
            if ("true".equals(anonymous)) {
                this.processAnonymous(req, res);
            } else {
                this.processNonAnonymous(req, res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processAnonymous(HttpServletRequest req, HttpServletResponse res) {
        String publishedId = req.getParameter("publishedId");
        String publishedItemId = req.getParameter("publishedItemId");
        String scoringType = req.getParameter("scoringType");
        log.debug((Object)("publishedId = " + publishedId));
        log.debug((Object)("publishedItemId = " + publishedItemId));
        log.debug((Object)("scoringType = " + scoringType));
        GradingService gradingService = new GradingService();
        List mediaList = gradingService.getMediaArray(publishedId, publishedItemId, scoringType);
        log.debug((Object)("mediaList.size() = " + mediaList.size()));
        ZipOutputStream zos = null;
        ServletOutputStream outputStream = res.getOutputStream();
        zos = new ZipOutputStream((OutputStream)outputStream);
        for (int i = 0; i < mediaList.size(); ++i) {
            MediaIfc mediaData = (MediaIfc)mediaList.get(i);
            this.processOneMediaData(zos, mediaData, true, -1);
        }
        Object var13_13 = null;
        if (zos == null) return;
        try {
            zos.close();
            return;
        }
        catch (IOException e2) {
            log.error((Object)e2.getMessage());
        }
        return;
        {
            catch (IOException e) {
                log.error((Object)e.getMessage());
                e.printStackTrace();
                Object var13_14 = null;
                if (zos == null) return;
                try {
                    zos.close();
                    return;
                }
                catch (IOException e2) {
                    log.error((Object)e2.getMessage());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (zos == null) throw throwable;
            try {
                zos.close();
                throw throwable;
            }
            catch (IOException e2) {
                log.error((Object)e2.getMessage());
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processNonAnonymous(HttpServletRequest req, HttpServletResponse res) {
        MediaIfc mediaData;
        String publishedId = req.getParameter("publishedId");
        String publishedItemId = req.getParameter("publishedItemId");
        String scoringType = req.getParameter("scoringType");
        log.debug((Object)("publishedId = " + publishedId));
        log.debug((Object)("publishedItemId = " + publishedItemId));
        log.debug((Object)("scoringType = " + scoringType));
        HashMap hashByAgentId = new HashMap();
        List mediaList = this.gradingService.getMediaArray(publishedId, publishedItemId, scoringType);
        log.debug((Object)("mediaList.size() = " + mediaList.size()));
        QuestionScoresBean questionScoresBean = (QuestionScoresBean)ContextUtil.lookupBeanFromExternalServlet((String)"questionScores", (HttpServletRequest)req, (HttpServletResponse)res);
        Map userIdMap = questionScoresBean.getUserIdMap();
        for (int i = 0; i < mediaList.size(); ++i) {
            ArrayList list;
            HashMap<Long, ArrayList> subHashByAssessmentGradingId;
            mediaData = (MediaIfc)mediaList.get(i);
            ItemGradingData itemGradingData = (ItemGradingData)mediaData.getItemGradingData();
            String agentId = itemGradingData.getAgentId();
            Long assessmentGradingId = itemGradingData.getAssessmentGradingId();
            log.debug((Object)("agentId = " + agentId));
            log.debug((Object)("assessmentGradingId = " + assessmentGradingId));
            if (!userIdMap.containsKey(agentId)) {
                log.debug((Object)("Do not download files from this user - agentId = " + agentId));
                continue;
            }
            if (hashByAgentId.containsKey(agentId)) {
                log.debug((Object)"same agentId");
                subHashByAssessmentGradingId = (HashMap<Long, ArrayList>)hashByAgentId.get(agentId);
                if (subHashByAssessmentGradingId.containsKey(assessmentGradingId)) {
                    log.debug((Object)"same assessmentGradingId");
                    list = (ArrayList)subHashByAssessmentGradingId.get(assessmentGradingId);
                    list.add(mediaData);
                    continue;
                }
                log.debug((Object)"different assessmentGradingId");
                list = new ArrayList();
                list.add(mediaData);
                subHashByAssessmentGradingId.put(assessmentGradingId, list);
                continue;
            }
            log.debug((Object)"different agentId");
            list = new ArrayList();
            list.add(mediaData);
            subHashByAssessmentGradingId = new HashMap<Long, ArrayList>();
            subHashByAssessmentGradingId.put(assessmentGradingId, list);
            hashByAgentId.put(agentId, subHashByAssessmentGradingId);
        }
        log.debug((Object)"HashMap built successfully");
        ZipOutputStream zos = null;
        ServletOutputStream outputStream = res.getOutputStream();
        zos = new ZipOutputStream((OutputStream)outputStream);
        for (HashMap hashMap : hashByAgentId.values()) {
            int numberSubmission = hashMap.size();
            log.debug((Object)("numberSubmission = " + numberSubmission));
            Iterator subIter = hashMap.keySet().iterator();
            if (numberSubmission > 1) {
                ArrayList<Long> keyList = new ArrayList<Long>();
                while (subIter.hasNext()) {
                    Long key = (Long)subIter.next();
                    log.debug((Object)("key = " + key));
                    keyList.add(key);
                    Collections.sort(keyList);
                }
                for (int i = 0; i < keyList.size(); ++i) {
                    Long sortedKey = (Long)keyList.get(i);
                    ArrayList valueList = (ArrayList)hashMap.get(sortedKey);
                    for (int j = 0; j < valueList.size(); ++j) {
                        log.debug((Object)("j = " + j));
                        mediaData = (MediaIfc)valueList.get(j);
                        this.processOneMediaData(zos, mediaData, false, i + 1);
                    }
                }
                continue;
            }
            if (numberSubmission != 1) continue;
            while (subIter.hasNext()) {
                ArrayList valueList = (ArrayList)hashMap.get(subIter.next());
                log.debug((Object)("valueList.size() = " + valueList.size()));
                for (int i = 0; i < valueList.size(); ++i) {
                    log.debug((Object)("i = " + i));
                    mediaData = (MediaIfc)valueList.get(i);
                    this.processOneMediaData(zos, mediaData, false, -1);
                }
            }
        }
        Object var29_31 = null;
        if (zos == null) return;
        try {
            zos.close();
            return;
        }
        catch (IOException e2) {
            log.error((Object)e2.getMessage());
        }
        return;
        {
            catch (IOException e) {
                log.error((Object)e.getMessage());
                e.printStackTrace();
                Object var29_32 = null;
                if (zos == null) return;
                try {
                    zos.close();
                    return;
                }
                catch (IOException e2) {
                    log.error((Object)e2.getMessage());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var29_33 = null;
            if (zos == null) throw throwable;
            try {
                zos.close();
                throw throwable;
            }
            catch (IOException e2) {
                log.error((Object)e2.getMessage());
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    private void processOneMediaData(ZipOutputStream zos, MediaIfc mediaData, boolean anonymous, int numberSubmission) throws IOException {
        block17: {
            IOException e22;
            BufferedInputStream bufInputStream;
            block16: {
                int BUFFER_SIZE = 2048;
                byte[] data = new byte[BUFFER_SIZE];
                int count = 0;
                bufInputStream = null;
                ZipEntry ze = null;
                String mediaLocation = mediaData.getLocation();
                log.debug((Object)("mediaLocation = " + mediaLocation));
                String filename = this.getFilename(mediaData, anonymous, numberSubmission);
                if (mediaLocation == null || mediaLocation.trim().equals("")) {
                    byte[] media = mediaData.getMedia();
                    log.debug((Object)("media.length = " + media.length));
                    bufInputStream = new BufferedInputStream(new ByteArrayInputStream(media));
                } else {
                    bufInputStream = new BufferedInputStream(this.getFileStream(mediaLocation));
                }
                ze = new ZipEntry(filename);
                zos.putNextEntry(ze);
                while ((count = bufInputStream.read(data, 0, BUFFER_SIZE)) != -1) {
                    zos.write(data, 0, count);
                }
                Object var14_14 = null;
                if (bufInputStream == null) break block16;
                try {
                    bufInputStream.close();
                }
                catch (IOException e22) {
                    log.error((Object)e22.getMessage());
                }
            }
            if (zos != null) {
                try {
                    zos.closeEntry();
                }
                catch (IOException e22) {
                    log.error((Object)e22.getMessage());
                }
            }
            break block17;
            {
                catch (IOException e3) {
                    log.error((Object)e3.getMessage());
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var14_15 = null;
                if (bufInputStream != null) {
                    try {
                        bufInputStream.close();
                    }
                    catch (IOException e22) {
                        log.error((Object)e22.getMessage());
                    }
                }
                if (zos != null) {
                    try {
                        zos.closeEntry();
                    }
                    catch (IOException e22) {
                        log.error((Object)e22.getMessage());
                    }
                }
                throw throwable;
            }
        }
    }

    private FileInputStream getFileStream(String mediaLocation) {
        FileInputStream inputStream = null;
        try {
            File media = new File(mediaLocation);
            inputStream = new FileInputStream(media);
        }
        catch (FileNotFoundException ex) {
            log.warn((Object)("file not found=" + ex.getMessage()));
        }
        return inputStream;
    }

    public String getAgentString(HttpServletRequest req, HttpServletResponse res) {
        String agentIdString = AgentFacade.getAgentString();
        if (agentIdString == null || agentIdString.equals("")) {
            PersonBean person = (PersonBean)ContextUtil.lookupBeanFromExternalServlet((String)"person", (HttpServletRequest)req, (HttpServletResponse)res);
            agentIdString = person.getAnonymousId();
        }
        return agentIdString;
    }

    public boolean canGrade(HttpServletRequest req, HttpServletResponse res, String agentId, String currentSiteId, String assessmentCreatedBy) {
        AuthorizationBean authzBean = (AuthorizationBean)ContextUtil.lookupBeanFromExternalServlet((String)"authorization", (HttpServletRequest)req, (HttpServletResponse)res);
        log.debug((Object)("agentId=" + agentId));
        log.debug((Object)("currentSiteId=" + currentSiteId));
        log.debug((Object)("assessmentCreatedBy=" + assessmentCreatedBy));
        boolean hasPrivilege_any = authzBean.getGradeAnyAssessment(req, currentSiteId);
        boolean hasPrivilege_own0 = authzBean.getGradeOwnAssessment(req, currentSiteId);
        boolean hasPrivilege_own = hasPrivilege_own0 && this.isOwner(agentId, assessmentCreatedBy);
        boolean hasPrivilege = hasPrivilege_any || hasPrivilege_own;
        log.debug((Object)("hasPrivilege_any=" + hasPrivilege_any));
        log.debug((Object)("hasPrivilege_own0=" + hasPrivilege_own0));
        log.debug((Object)("hasPrivilege_own=" + hasPrivilege_own));
        log.debug((Object)("hasPrivilege=" + hasPrivilege));
        return hasPrivilege;
    }

    public boolean isOwner(String agentId, String ownerId) {
        boolean isOwner = false;
        isOwner = agentId.equals(ownerId);
        log.debug((Object)("isOwner=" + isOwner));
        return isOwner;
    }

    private String getPartNumAndQuestionNum(String itemId) {
        log.debug((Object)("itemId = " + itemId));
        PublishedAssessmentServiceImpl pubAssessmentServiceImpl = new PublishedAssessmentServiceImpl();
        ItemDataIfc item = pubAssessmentServiceImpl.loadPublishedItem(itemId);
        Integer partNum = item.getSection().getSequence();
        log.debug((Object)("partNum = " + partNum));
        Integer questionNum = item.getSequence();
        log.debug((Object)("questionNum=" + questionNum));
        StringBuilder partAndQues = new StringBuilder("_Part");
        partAndQues.append(partNum);
        partAndQues.append("_Ques");
        partAndQues.append(questionNum);
        log.debug((Object)("partAndQues = " + partAndQues));
        return partAndQues.toString();
    }

    private String getFilename(MediaIfc mediaData, boolean anonymous, int numberSubmission) {
        log.debug((Object)("numberSubmission = " + numberSubmission));
        StringBuilder filename = new StringBuilder();
        ItemGradingData itemGradingData = (ItemGradingData)mediaData.getItemGradingData();
        if (anonymous) {
            Long assessmentGradingId = itemGradingData.getAssessmentGradingId();
            log.debug((Object)("submissionId(assessmentGradingId) = " + assessmentGradingId));
            filename.append(assessmentGradingId);
            filename.append("_");
            filename.append(mediaData.getFilename());
            log.debug((Object)("filename = " + filename));
        } else {
            AgentHelperImpl helper = new AgentHelperImpl();
            String agentId = itemGradingData.getAgentId();
            String lastName = helper.getLastName(agentId);
            String firstName = helper.getFirstName(agentId);
            String eid = helper.getEidById(agentId);
            filename.append(lastName);
            filename.append("_");
            filename.append(firstName);
            filename.append("_");
            filename.append(eid);
            filename.append("_");
            log.debug((Object)("filename = " + filename));
            if (numberSubmission == -1) {
                filename.append(mediaData.getFilename());
                log.debug((Object)("filename = " + filename));
            } else {
                filename.append("sub");
                filename.append(numberSubmission);
                filename.append("_");
                filename.append(mediaData.getFilename());
                log.debug((Object)("filename = " + filename));
            }
        }
        return filename.toString();
    }
}

