/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.servlet.delivery;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemText;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.MediaData;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingIfc;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;

public class UploadAudioMediaServlet
extends HttpServlet {
    private static final long serialVersionUID = 8389831837152012411L;
    private static Log log = LogFactory.getLog(UploadAudioMediaServlet.class);

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean mediaIsValid = true;
        ServletContext context = super.getServletContext();
        String repositoryPath = (String)context.getAttribute("FILEUPLOAD_REPOSITORY_PATH");
        String saveToDb = (String)context.getAttribute("FILEUPLOAD_SAVE_MEDIA_TO_DB");
        log.debug((Object)("req content length =" + req.getContentLength()));
        log.debug((Object)("req content type =" + req.getContentType()));
        String suffix = req.getParameter("suffix");
        if (suffix == null || "".equals(suffix)) {
            suffix = "au";
        }
        String mediaLocation = req.getParameter("media") + "." + suffix;
        log.debug((Object)("****media location=" + mediaLocation));
        String response = "empty";
        if (mediaLocation != null && !mediaLocation.trim().equals("")) {
            mediaLocation = repositoryPath + "/" + mediaLocation;
            File mediaFile = new File(mediaLocation);
            File mediaDir = mediaFile.getParentFile();
            if (!mediaDir.exists()) {
                mediaDir.mkdirs();
            }
            mediaIsValid = this.writeToFile(req, mediaLocation);
        }
        if (mediaIsValid) {
            try {
                response = this.submitMediaAsAnswer(req, mediaLocation, saveToDb);
                log.info((Object)"Audio has been saved and submitted as answer to the question. Any old recordings have been removed from the system.");
            }
            catch (Exception ex) {
                log.info((Object)ex.getMessage());
            }
        }
        res.setContentType("text/plain");
        res.setContentLength(response.length());
        PrintWriter out = res.getWriter();
        out.println(response);
        out.close();
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean writeToFile(HttpServletRequest req, String mediaLocation) {
        String status;
        boolean mediaIsValid;
        block40: {
            IOException e222222;
            FilterOutputStream bufOutputStream;
            BufferedInputStream bufInputStream;
            FileOutputStream fileOutputStream;
            ServletInputStream inputStream;
            block34: {
                block33: {
                    mediaIsValid = false;
                    status = "Upload failure: empty media location.";
                    inputStream = null;
                    fileOutputStream = null;
                    bufInputStream = null;
                    bufOutputStream = null;
                    int count = 0;
                    inputStream = req.getInputStream();
                    fileOutputStream = this.getFileOutputStream(mediaLocation);
                    bufInputStream = new BufferedInputStream((InputStream)inputStream);
                    bufOutputStream = new BufferedOutputStream(fileOutputStream);
                    int i = 0;
                    count = 0;
                    if (bufInputStream != null) {
                        while ((i = bufInputStream.read()) != -1) {
                            ((BufferedOutputStream)bufOutputStream).write(i);
                            ++count;
                        }
                    }
                    ((BufferedOutputStream)bufOutputStream).flush();
                    status = "Acknowleged: " + mediaLocation + "-> " + count + " bytes.";
                    if (count <= 0) break block33;
                    mediaIsValid = true;
                }
                Object var12_12 = null;
                if (bufOutputStream == null) break block34;
                try {
                    bufOutputStream.close();
                }
                catch (IOException e222222) {
                    log.error((Object)e222222.getMessage());
                }
            }
            if (bufInputStream != null) {
                try {
                    bufInputStream.close();
                }
                catch (IOException e222222) {
                    log.error((Object)e222222.getMessage());
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e222222) {
                    log.error((Object)e222222.getMessage());
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e222222) {
                    log.error((Object)e222222.getMessage());
                }
            }
            break block40;
            {
                catch (Exception ex) {
                    IOException e222222;
                    log.info((Object)ex.getMessage());
                    status = "Upload failure: " + mediaLocation;
                    Object var12_13 = null;
                    if (bufOutputStream != null) {
                        try {
                            bufOutputStream.close();
                        }
                        catch (IOException e222222) {
                            log.error((Object)e222222.getMessage());
                        }
                    }
                    if (bufInputStream != null) {
                        try {
                            bufInputStream.close();
                        }
                        catch (IOException e222222) {
                            log.error((Object)e222222.getMessage());
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e222222) {
                            log.error((Object)e222222.getMessage());
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException e222222) {
                            log.error((Object)e222222.getMessage());
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e222222;
                Object var12_14 = null;
                if (bufOutputStream != null) {
                    try {
                        bufOutputStream.close();
                    }
                    catch (IOException e222222) {
                        log.error((Object)e222222.getMessage());
                    }
                }
                if (bufInputStream != null) {
                    try {
                        bufInputStream.close();
                    }
                    catch (IOException e222222) {
                        log.error((Object)e222222.getMessage());
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e222222) {
                        log.error((Object)e222222.getMessage());
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e222222) {
                        log.error((Object)e222222.getMessage());
                    }
                }
                throw throwable;
            }
        }
        log.info((Object)status);
        return mediaIsValid;
    }

    private FileOutputStream getFileOutputStream(String mediaLocation) {
        FileOutputStream outputStream = null;
        try {
            File media = new File(mediaLocation);
            outputStream = new FileOutputStream(media);
        }
        catch (FileNotFoundException ex) {
            log.warn((Object)("file not found=" + ex.getMessage()));
        }
        return outputStream;
    }

    private String submitMediaAsAnswer(HttpServletRequest req, String mediaLocation, String saveToDb) throws Exception {
        String mimeType = req.getContentType();
        String duration = req.getParameter("lastDuration");
        String agentId = req.getParameter("agent");
        int attemptsRemaining = Integer.parseInt(req.getParameter("attempts"));
        GradingService gradingService = new GradingService();
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        int assessmentIndex = mediaLocation.indexOf("assessment");
        int questionIndex = mediaLocation.indexOf("question");
        int agentIndex = mediaLocation.indexOf("/", questionIndex + 8);
        String pubAssessmentId = mediaLocation.substring(assessmentIndex + 10, questionIndex - 1);
        String questionId = mediaLocation.substring(questionIndex + 8, agentIndex);
        PublishedItemData item = pubService.loadPublishedItem(questionId);
        PublishedItemText itemText = (PublishedItemText)item.getItemTextSet().iterator().next();
        log.debug((Object)("****agentId=" + agentId));
        log.debug((Object)("****pubAssId=" + pubAssessmentId));
        AssessmentGradingData adata = gradingService.getLastSavedAssessmentGradingByAgentId(pubAssessmentId, agentId);
        if (adata == null) {
            throw new Exception("This page must have been reached by mistake.");
        }
        ItemGradingData itemGrading = gradingService.getItemGradingData(adata.getAssessmentGradingId().toString(), questionId);
        ArrayList mediaList = new ArrayList();
        if (itemGrading != null) {
            GradingService service = new GradingService();
            if (itemGrading.getItemGradingId() != null) {
                mediaList = service.getMediaArray(itemGrading.getItemGradingId().toString());
            }
            if (mediaList.size() > 0) {
                log.debug((Object)"*** delete old audio");
                gradingService.deleteAll((Collection)mediaList);
            }
            if (itemGrading.getAttemptsRemaining() == null) {
                if (item.getTriesAllowed() >= 9999) {
                    attemptsRemaining = 9999;
                }
            } else if (item.getTriesAllowed() >= 9999) {
                attemptsRemaining = 9999;
            } else if (itemGrading.getAttemptsRemaining() <= 0) {
                throw new Exception("This page must have been reached by mistake. Our record shows that no more attempt for this question is allowed.");
            }
        } else {
            if (item.getTriesAllowed() >= 9999) {
                attemptsRemaining = 9999;
            }
            itemGrading = new ItemGradingData();
            itemGrading.setAssessmentGradingId(adata.getAssessmentGradingId());
            itemGrading.setPublishedItemId(item.getItemId());
            itemGrading.setPublishedItemTextId(itemText.getId());
            itemGrading.setAgentId(agentId);
            itemGrading.setOverrideScore(Float.valueOf(0.0f));
            itemGrading.setSubmittedDate(new Date());
            itemGrading.setAttemptsRemaining(Integer.valueOf(attemptsRemaining));
            itemGrading.setLastDuration(duration);
            gradingService.saveItemGrading((ItemGradingIfc)itemGrading);
        }
        log.debug((Object)("****1. assessmentGradingId=" + adata.getAssessmentGradingId()));
        log.debug((Object)("****2. attemptsRemaining=" + attemptsRemaining));
        log.debug((Object)("****3. itemGradingDataId=" + itemGrading.getItemGradingId()));
        return this.saveMedia(attemptsRemaining, mimeType, agentId, mediaLocation, itemGrading, saveToDb, duration);
    }

    private String saveMedia(int attemptsRemaining, String mimeType, String agent, String mediaLocation, ItemGradingData itemGrading, String saveToDb, String duration) {
        boolean SAVETODB = false;
        if ("true".equals(saveToDb)) {
            SAVETODB = true;
        }
        log.debug((Object)("****4. saveMedia, saveToDB" + SAVETODB));
        log.debug((Object)("****5. saveMedia, mediaLocation" + mediaLocation));
        GradingService gradingService = new GradingService();
        File media = new File(mediaLocation);
        byte[] mediaByte = this.getMediaStream(mediaLocation);
        log.debug((Object)("**** SAVETODB=" + SAVETODB));
        MediaData mediaData = null;
        mediaData = SAVETODB ? new MediaData((ItemGradingIfc)itemGrading, mediaByte, Long.valueOf(mediaByte.length + ""), mimeType, "description", null, media.getName(), false, false, Integer.valueOf(1), agent, new Date(), agent, new Date(), duration) : new MediaData((ItemGradingIfc)itemGrading, null, Long.valueOf(mediaByte.length + ""), mimeType, "description", mediaLocation, media.getName(), false, false, Integer.valueOf(1), agent, new Date(), agent, new Date(), duration);
        Long mediaId = gradingService.saveMedia(mediaData);
        log.debug((Object)("mediaId=" + mediaId));
        itemGrading.setAttemptsRemaining(Integer.valueOf(attemptsRemaining));
        itemGrading.setSubmittedDate(new Date());
        itemGrading.setAnswerText(mediaId + "");
        itemGrading.setAutoScore(Float.valueOf(0.0f));
        gradingService.saveItemGrading((ItemGradingIfc)itemGrading);
        try {
            boolean success;
            if (SAVETODB && !(success = media.delete())) {
                log.error((Object)("Delete Failed for media. mediaid = " + mediaId));
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
        return mediaId.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] getMediaStream(String mediaLocation) {
        byte[] mediaByte;
        block27: {
            IOException ex12222;
            FileInputStream mediaStream2;
            FileInputStream mediaStream;
            block25: {
                block24: {
                    mediaStream = null;
                    mediaStream2 = null;
                    mediaByte = new byte[]{};
                    int size = 0;
                    mediaStream = new FileInputStream(mediaLocation);
                    if (mediaStream != null) {
                        while (mediaStream.read() != -1) {
                            ++size;
                        }
                    }
                    mediaStream2 = new FileInputStream(mediaLocation);
                    mediaByte = new byte[size];
                    if (mediaStream2 == null) break block24;
                    mediaStream2.read(mediaByte, 0, size);
                }
                Object var7_8 = null;
                if (mediaStream == null) break block25;
                try {
                    mediaStream.close();
                }
                catch (IOException ex12222) {
                    log.warn((Object)ex12222.getMessage());
                }
            }
            if (mediaStream2 != null) {
                try {
                    mediaStream2.close();
                }
                catch (IOException ex12222) {
                    log.warn((Object)ex12222.getMessage());
                }
            }
            break block27;
            {
                catch (FileNotFoundException ex) {
                    IOException ex12222;
                    log.debug((Object)("file not found=" + ex.getMessage()));
                    Object var7_9 = null;
                    if (mediaStream != null) {
                        try {
                            mediaStream.close();
                        }
                        catch (IOException ex12222) {
                            log.warn((Object)ex12222.getMessage());
                        }
                    }
                    if (mediaStream2 != null) {
                        try {
                            mediaStream2.close();
                        }
                        catch (IOException ex12222) {
                            log.warn((Object)ex12222.getMessage());
                        }
                    }
                    break block27;
                }
                catch (IOException ex) {
                    IOException ex12222;
                    log.debug((Object)("io exception=" + ex.getMessage()));
                    Object var7_10 = null;
                    if (mediaStream != null) {
                        try {
                            mediaStream.close();
                        }
                        catch (IOException ex12222) {
                            log.warn((Object)ex12222.getMessage());
                        }
                    }
                    if (mediaStream2 != null) {
                        try {
                            mediaStream2.close();
                        }
                        catch (IOException ex12222) {
                            log.warn((Object)ex12222.getMessage());
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                IOException ex12222;
                Object var7_11 = null;
                if (mediaStream != null) {
                    try {
                        mediaStream.close();
                    }
                    catch (IOException ex12222) {
                        log.warn((Object)ex12222.getMessage());
                    }
                }
                if (mediaStream2 != null) {
                    try {
                        mediaStream2.close();
                    }
                    catch (IOException ex12222) {
                        log.warn((Object)ex12222.getMessage());
                    }
                }
                throw throwable;
            }
        }
        return mediaByte;
    }
}

