/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.cover.ContentHostingService;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingIfc;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.cover.SessionManager;

public class AttachmentUtil {
    private static Log log = LogFactory.getLog(AttachmentUtil.class);

    private HashMap getResourceIdHash(Set attachmentSet) {
        HashMap<String, ItemGradingAttachmentIfc> map = new HashMap<String, ItemGradingAttachmentIfc>();
        if (attachmentSet != null) {
            for (ItemGradingAttachmentIfc attach : attachmentSet) {
                map.put(attach.getResourceId(), attach);
            }
        }
        return map;
    }

    public List prepareAssessmentAttachment(ItemGradingData itemGradingData, Set itemGradingAttachmentSet) {
        ToolSession session = SessionManager.getCurrentToolSession();
        if (session.getAttribute("sakaiproject.filepicker.attachments") != null) {
            GradingService gradingService = new GradingService();
            HashMap map = this.getResourceIdHash(itemGradingAttachmentSet);
            ArrayList<ItemGradingAttachmentIfc> newAttachmentList = new ArrayList<ItemGradingAttachmentIfc>();
            String protocol = ContextUtil.getProtocol();
            List refs = (List)session.getAttribute("sakaiproject.filepicker.attachments");
            if (refs != null && refs.size() > 0) {
                for (int i = 0; i < refs.size(); ++i) {
                    Reference ref = (Reference)refs.get(i);
                    String resourceId = ref.getId();
                    if (map.get(resourceId) == null) {
                        log.debug((Object)("**** ref.Id=" + ref.getId()));
                        log.debug((Object)("**** ref.name=" + ref.getProperties().getProperty(ref.getProperties().getNamePropDisplayName())));
                        ItemGradingAttachmentIfc newAttach = gradingService.createItemGradingAttachment((ItemGradingIfc)itemGradingData, ref.getId(), ref.getProperties().getProperty(ref.getProperties().getNamePropDisplayName()), protocol);
                        newAttachmentList.add(newAttach);
                        continue;
                    }
                    newAttachmentList.add((ItemGradingAttachmentIfc)map.get(resourceId));
                    map.remove(resourceId);
                }
            }
            session.removeAttribute("sakaiproject.filepicker.attachments");
            session.removeAttribute("sakaiproject.filepicker.cancel");
            return newAttachmentList;
        }
        return new ArrayList();
    }

    public List prepareReferenceList(List attachmentList) {
        ArrayList<Reference> list = new ArrayList<Reference>();
        for (int i = 0; i < attachmentList.size(); ++i) {
            Reference ref;
            ContentResource cr = null;
            AttachmentIfc attach = (AttachmentIfc)attachmentList.get(i);
            try {
                cr = ContentHostingService.getResource((String)attach.getResourceId());
            }
            catch (PermissionException e) {
                log.warn((Object)("PermissionException from ContentHostingService:" + e.getMessage()));
            }
            catch (IdUnusedException e) {
                log.warn((Object)("IdUnusedException from ContentHostingService:" + e.getMessage()));
                GradingService gradingService = new GradingService();
                gradingService.removeItemGradingAttachment(attach.getAttachmentId().toString());
            }
            catch (TypeException e) {
                log.warn((Object)("TypeException from ContentHostingService:" + e.getMessage()));
            }
            if (cr == null || (ref = EntityManager.newReference((String)cr.getReference())) == null) continue;
            list.add(ref);
        }
        return list;
    }
}

