/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.sakaiproject.tool.assessment.util.BeanSortComparator;

public class BeanDateComparator
extends BeanSortComparator {
    private String propertyName;

    public BeanDateComparator(String propertyName) {
        this.propertyName = propertyName;
    }

    protected BeanDateComparator() {
    }

    public int compare(Object o1, Object o2) {
        Map m1 = this.describeBean(o1);
        Map m2 = this.describeBean(o2);
        String s1 = (String)m1.get(this.propertyName);
        String s2 = (String)m2.get(this.propertyName);
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
        Date i1 = null;
        Date i2 = null;
        boolean firstDateValid = true;
        boolean secondDateValid = true;
        try {
            i1 = dateFormat.parse(s1);
        }
        catch (ParseException e) {
            firstDateValid = false;
        }
        try {
            i2 = dateFormat.parse(s2);
        }
        catch (ParseException e) {
            secondDateValid = false;
        }
        int returnValue = 0;
        if (firstDateValid && secondDateValid && i1 != null) {
            returnValue = i1.compareTo(i2);
        }
        if (firstDateValid && !secondDateValid) {
            returnValue = 1;
        }
        if (!firstDateValid && secondDateValid) {
            returnValue = -1;
        }
        if (!firstDateValid && !secondDateValid) {
            returnValue = 0;
        }
        return returnValue;
    }
}

