/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.util.Map;
import org.sakaiproject.tool.assessment.util.BeanSortComparator;

public class BeanFloatComparator
extends BeanSortComparator {
    private String propertyName;

    public BeanFloatComparator(String propertyName) {
        this.propertyName = propertyName;
    }

    protected BeanFloatComparator() {
    }

    public int compare(Object o1, Object o2) {
        Map m1 = this.describeBean(o1);
        Map m2 = this.describeBean(o2);
        String s1 = (String)m1.get(this.propertyName);
        String s2 = (String)m2.get(this.propertyName);
        Float i1 = null;
        Float i2 = null;
        boolean firstFloatValid = true;
        boolean secondFloatValid = true;
        try {
            i1 = new Float(s1);
        }
        catch (NumberFormatException e) {
            firstFloatValid = false;
        }
        try {
            i2 = new Float(s2);
        }
        catch (NumberFormatException e) {
            secondFloatValid = false;
        }
        int returnValue = 0;
        if (firstFloatValid && secondFloatValid && i1 != null) {
            returnValue = i1.compareTo(i2);
        }
        if (firstFloatValid && !secondFloatValid) {
            returnValue = 1;
        }
        if (!firstFloatValid && secondFloatValid) {
            returnValue = -1;
        }
        if (!firstFloatValid && !secondFloatValid) {
            returnValue = 0;
        }
        return returnValue;
    }
}

