/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.util.Map;
import org.sakaiproject.tool.assessment.util.BeanSortComparator;

public class BeanIntegerComparator
extends BeanSortComparator {
    private String propertyName;

    public BeanIntegerComparator(String propertyName) {
        this.propertyName = propertyName;
    }

    protected BeanIntegerComparator() {
    }

    public int compare(Object o1, Object o2) {
        Map m1 = this.describeBean(o1);
        Map m2 = this.describeBean(o2);
        String s1 = (String)m1.get(this.propertyName);
        String s2 = (String)m2.get(this.propertyName);
        Integer i1 = null;
        Integer i2 = null;
        boolean firstIntegerValid = true;
        boolean secondIntegerValid = true;
        try {
            i1 = Integer.valueOf(s1);
        }
        catch (NumberFormatException e) {
            firstIntegerValid = false;
        }
        try {
            i2 = Integer.valueOf(s2);
        }
        catch (NumberFormatException e) {
            secondIntegerValid = false;
        }
        int returnValue = 0;
        if (firstIntegerValid && secondIntegerValid && i1 != null) {
            returnValue = i1.compareTo(i2);
        }
        if (firstIntegerValid && !secondIntegerValid) {
            returnValue = 1;
        }
        if (!firstIntegerValid && secondIntegerValid) {
            returnValue = -1;
        }
        if (!firstIntegerValid && !secondIntegerValid) {
            returnValue = 0;
        }
        return returnValue;
    }
}

