/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.util.Arrays;
import java.util.Collection;
import org.sakaiproject.tool.assessment.util.BeanDateComparator;
import org.sakaiproject.tool.assessment.util.BeanFloatComparator;
import org.sakaiproject.tool.assessment.util.BeanIntegerComparator;
import org.sakaiproject.tool.assessment.util.BeanSortComparator;

public class BeanSort {
    private Collection collection;
    private String property;
    private boolean string = true;
    private boolean numeric = false;
    private boolean date = false;

    public BeanSort(Collection c, String onProperty) {
        this.collection = c;
        this.property = onProperty;
    }

    private BeanSort() {
    }

    public Object[] arraySort() {
        Object[] array = this.collection.toArray();
        Arrays.sort(array, this.getBeanSortComparator(this.property));
        return array;
    }

    public Collection sort() {
        Object[] array = this.arraySort();
        this.collection.clear();
        for (int i = 0; i < array.length; ++i) {
            this.collection.add(array[i]);
        }
        return this.collection;
    }

    public Collection sortDesc() {
        Object[] array = this.arraySort();
        this.collection.clear();
        for (int i = array.length - 1; i >= 0; --i) {
            this.collection.add(array[i]);
        }
        return this.collection;
    }

    private BeanSortComparator getBeanSortComparator(String property) {
        Object bsc = null;
        if (this.string) {
            bsc = new BeanSortComparator(property);
        } else if (this.numeric) {
            bsc = "timeElapsed".equals(property) ? new BeanIntegerComparator(property) : new BeanFloatComparator(property);
        } else if (this.date) {
            bsc = new BeanDateComparator(property);
        }
        return bsc;
    }

    public void toStringSort() {
        this.string = true;
        this.numeric = false;
        this.date = false;
    }

    public void toNumericSort() {
        this.string = false;
        this.numeric = true;
        this.date = false;
    }

    public void toDateSort() {
        this.string = false;
        this.numeric = false;
        this.date = true;
    }
}

