/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanSortComparator
implements Comparator {
    private static Log log = LogFactory.getLog(BeanSortComparator.class);
    private String propertyName;

    public BeanSortComparator(String propertyName) {
        this.propertyName = propertyName;
    }

    protected BeanSortComparator() {
    }

    public int compare(Object o1, Object o2) {
        String s2;
        int result = 0;
        Map m1 = this.describeBean(o1);
        Map m2 = this.describeBean(o2);
        String s1 = (String)m1.get(this.propertyName);
        result = this.subCompare(s1, s2 = (String)m2.get(this.propertyName));
        if (result == 0 && "lastName".equals(this.propertyName)) {
            String firstName1 = (String)m1.get("firstName");
            String firstName2 = (String)m2.get("firstName");
            result = this.subCompare(firstName1, firstName2);
        }
        return result;
    }

    private int subCompare(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        if (s1.toLowerCase().startsWith("n/a") && !s2.toLowerCase().startsWith("n/a")) {
            return 1;
        }
        if (s2.toLowerCase().startsWith("n/a") && !s1.toLowerCase().startsWith("n/a")) {
            return -1;
        }
        String finalS1 = s1.replaceAll("<.*?>", "");
        String finalS2 = s2.replaceAll("<.*?>", "");
        int result = finalS1.toLowerCase().compareTo(finalS2.toLowerCase());
        return result;
    }

    protected Map describeBean(Object o) {
        Map m = null;
        try {
            m = BeanUtils.describe((Object)((Serializable)o));
        }
        catch (Throwable t) {
            log.debug((Object)("Caught error in BeanUtils.describe(): " + t.getMessage()));
            t.printStackTrace();
            throw new UnsupportedOperationException("Invalid describeBean. Objects may not be Java Beans.  " + t);
        }
        return m;
    }
}

