/*
 * Decompiled with CFR 0.152.
 */
package test.org.sakaiproject.tool.assessment.ui.listener;

import java.util.Date;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentFeedback;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.cms.CourseManagementBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.FeedbackComponent;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SettingsDeliveryBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class FakeBeginDeliveryActionListener
implements ActionListener {
    private static Log log = LogFactory.getLog(FakeBeginDeliveryActionListener.class);
    private static String ID_TO_TEST = "3";

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        DeliveryBean delivery = (DeliveryBean)ContextUtil.lookupBean((String)"delivery");
        PublishedAssessmentFacade pub = null;
        pub = this.lookupPublishedAssessment(ID_TO_TEST, publishedAssessmentService);
        log.info((Object)("** FakeBeginDeliveryActionListener, pub = " + pub));
        log.info((Object)("** FakeBeginDeliveryActionListener, pub title = " + pub.getTitle()));
        this.populateBeanFromPub(delivery, pub);
        CourseManagementBean course = (CourseManagementBean)ContextUtil.lookupBean((String)"course");
        this.populateBeanFromCourse(delivery, course);
    }

    private PublishedAssessmentFacade lookupPublishedAssessment(String id, PublishedAssessmentService publishedAssessmentService) {
        PublishedAssessmentService assessmentService = new PublishedAssessmentService();
        PublishedAssessmentFacade pub = assessmentService.getPublishedAssessment("3");
        AssessmentFeedback feed = new AssessmentFeedback();
        feed.setShowCorrectResponse(Boolean.TRUE);
        feed.setShowGraderComments(Boolean.TRUE);
        feed.setShowQuestionLevelFeedback(Boolean.TRUE);
        feed.setShowQuestionText(Boolean.TRUE);
        feed.setShowSelectionLevelFeedback(Boolean.TRUE);
        feed.setShowStatistics(Boolean.TRUE);
        feed.setShowStudentScore(Boolean.TRUE);
        feed.setShowStudentQuestionScore(Boolean.TRUE);
        feed.setFeedbackDelivery(AssessmentFeedbackIfc.FEEDBACK_BY_DATE);
        feed.setFeedbackAuthoring(AssessmentFeedbackIfc.QUESTIONLEVEL_FEEDBACK);
        pub.setAssessmentFeedback((AssessmentFeedbackIfc)feed);
        return pub;
    }

    private void populateBeanFromPub(DeliveryBean delivery, PublishedAssessmentFacade pubAssessment) {
        log.info((Object)("** 1. FakeBeginDeliveryActionListener, deliveryBean = " + delivery));
        log.info((Object)("** 2. FakeBeginDeliveryActionListener, pubAssessment = " + pubAssessment));
        log.info((Object)("** 3. FakeBeginDeliveryActionListener, id= " + pubAssessment.getAssessmentId()));
        log.info((Object)("** 4. FakeBeginDeliveryActionListener, pubId= " + pubAssessment.getPublishedAssessmentId()));
        delivery.setAssessmentId(pubAssessment.getPublishedAssessmentId().toString());
        delivery.setAssessmentTitle(pubAssessment.getTitle());
        delivery.setInstructorMessage(pubAssessment.getDescription());
        delivery.setCreatorName(pubAssessment.getCreatedBy());
        delivery.setSubmitted(false);
        delivery.setGraded(false);
        delivery.setFeedbackOnDate(false);
        delivery.setItemIndex(0);
        delivery.setSectionIndex(0);
        FeedbackComponent feedback = new FeedbackComponent();
        this.populateFeedbackComponent(feedback, (PublishedAssessmentIfc)pubAssessment);
        delivery.setFeedbackComponent(feedback);
        AssessmentAccessControlIfc control = pubAssessment.getAssessmentAccessControl();
        Date currentDate = new Date();
        if (feedback.getShowDateFeedback() && control.getFeedbackDate() != null && currentDate.after(control.getFeedbackDate())) {
            delivery.setFeedbackOnDate(true);
        }
        SettingsDeliveryBean settings = new SettingsDeliveryBean();
        this.populateSettings(settings, (PublishedAssessmentIfc)pubAssessment);
        delivery.setSettings(settings);
    }

    private void populateBeanFromCourse(DeliveryBean delivery, CourseManagementBean course) {
        delivery.setCourseName(course.getCourseName());
        delivery.setInstructorName(course.getInstructor());
    }

    private void populateFeedbackComponent(FeedbackComponent feedback, PublishedAssessmentIfc pubAssessment) {
        AssessmentFeedback info = (AssessmentFeedback)pubAssessment.getAssessmentFeedback();
        feedback.setShowCorrectResponse(info.getShowCorrectResponse().booleanValue());
        feedback.setShowGraderComment(info.getShowGraderComments().booleanValue());
        feedback.setShowItemLevel(info.getShowQuestionLevelFeedback().booleanValue());
        feedback.setShowQuestion(info.getShowQuestionText().booleanValue());
        feedback.setShowResponse(info.getShowCorrectResponse().booleanValue());
        feedback.setShowSelectionLevel(info.getShowSelectionLevelFeedback().booleanValue());
        feedback.setShowStats(info.getShowStatistics().booleanValue());
        feedback.setShowStudentScore(info.getShowStudentScore().booleanValue());
        feedback.setShowStudentQuestionScore(info.getShowStudentQuestionScore().booleanValue());
        Integer feedbackDelivery = info.getFeedbackDelivery();
        feedback.setShowDateFeedback(AssessmentFeedbackIfc.FEEDBACK_BY_DATE.equals(feedbackDelivery));
        feedback.setShowImmediate(AssessmentFeedbackIfc.IMMEDIATE_FEEDBACK.equals(feedbackDelivery));
        feedback.setShowNoFeedback(AssessmentFeedbackIfc.NO_FEEDBACK.equals(feedbackDelivery));
    }

    private void populateSettings(SettingsDeliveryBean settings, PublishedAssessmentIfc pubAssessment) {
        AssessmentAccessControlIfc control = pubAssessment.getAssessmentAccessControl();
        if (control != null) {
            this.constructControlSettings(settings, control);
        }
    }

    private void constructControlSettings(SettingsDeliveryBean settings, AssessmentAccessControlIfc control) {
        settings.setAutoSubmit(AssessmentAccessControlIfc.AUTO_SUBMIT.equals(control.getAutoSubmit()));
        settings.setAutoSave(AssessmentAccessControlIfc.AUTO_SAVE.equals(control.getSubmissionsSaved()));
        settings.setDueDate(control.getDueDate());
        settings.setMaxAttempts(control.getRetryAllowed().intValue());
        settings.setSubmissionMessage(control.getSubmissionMessage());
        settings.setUnlimitedAttempts(AssessmentAccessControlIfc.UNLIMITED_SUBMISSIONS_ALLOWED.equals(control.getSubmissionsAllowed()));
        settings.setFeedbackDate(control.getFeedbackDate());
        Integer format = control.getAssessmentFormat();
        settings.setFormatByAssessment(AssessmentAccessControlIfc.BY_ASSESSMENT.equals(format));
        settings.setFormatByPart(AssessmentAccessControlIfc.BY_PART.equals(format));
        settings.setFormatByQuestion(AssessmentAccessControlIfc.BY_QUESTION.equals(format));
        settings.setUsername(control.getUsername());
        settings.setPassword(control.getPassword());
    }
}

