<%-- $Id: deliverShortAnswer.jsp 98973 2011-10-05 05:52:39Z ktsao@stanford.edu $
include file for delivering short answer essay questions
should be included in file importing DeliveryMessages
--%>
<!--
* $Id: deliverShortAnswer.jsp 98973 2011-10-05 05:52:39Z ktsao@stanford.edu $
<%--
***********************************************************************************
*
* Copyright (c) 2004, 2005, 2006 The Sakai Foundation.
*
* Licensed under the Educational Community License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.osedu.org/licenses/ECL-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License. 
*
**********************************************************************************/
--%>
-->
<h:outputText value="#{question.text}"  escape="false"/>

<!-- ATTACHMENTS -->
<%@ include file="/jsf/delivery/item/attachment.jsp" %>

<h:panelGrid rendered="#{!(delivery.actionString=='reviewAssessment' || delivery.actionString=='gradeAssessment')}">
<f:verbatim><br/></f:verbatim>
<h:outputText value="#{deliveryMessages.maxSAText}"/>

<h:panelGroup>
  <h:commandButton id="getAaCharCount" value="#{deliveryMessages.count_characters}" styleClass="active" onclick="clickSaCharCountLink(this);" onmousedown="clickSaCharCountLink(this);"/>
  <f:verbatim>&nbsp;&nbsp;</f:verbatim>
  <h:inputText value="#{question.saCharCount}" size="8" readonly="true" style="text-align:right;"/>
</h:panelGroup>
</h:panelGrid>

<h:commandLink id="hiddenlink" action="takeAssessment" value="">
  <f:actionListener
           type="org.sakaiproject.tool.assessment.ui.listener.delivery.SaCharCountListener" />
  <f:param name="itemId" value="#{question.itemData.itemId}"/>
</h:commandLink>

<h:outputText value="#{deliveryMessages.sa_invalid_length_error} " escape="false" rendered="#{question.isInvalidSALengthInput}" styleClass="messageSamigo3"/>

<%-- If studentRichText is true, show the rich text answer option --%>
<h:panelGrid rendered="#{delivery.actionString!='reviewAssessment'
            && delivery.actionString!='gradeAssessment' && delivery.studentRichText}">
	<samigo:wysiwyg rows="240" columns="629" value="#{question.responseText}" hasToggle="yes">
	</samigo:wysiwyg>
</h:panelGrid>

<%-- Otherwise, show old-style non-rich text answer input --%>

<h:inputTextarea rows="20" cols="80" value="#{question.responseText}" 
   rendered="#{delivery.actionString!='reviewAssessment'
            && delivery.actionString!='gradeAssessment' && !delivery.studentRichText}">
<f:validateLength maximum="60000"/>
</h:inputTextarea>
<h:outputText value="#{question.responseTextForDisplay}" 
   rendered="#{delivery.actionString=='reviewAssessment'
            || delivery.actionString=='gradeAssessment'}" escape="false"/>

<f:verbatim><br /></f:verbatim>
<h:panelGroup rendered="#{(delivery.actionString=='previewAssessment'
                || delivery.actionString=='takeAssessment' 
                || delivery.actionString=='takeAssessmentViaUrl')
             && delivery.navigation ne '1' && delivery.displayMardForReview }">
<h:selectBooleanCheckbox value="#{question.review}" id="mark_for_review" />
	<h:outputLabel for="mark_for_review" value="#{deliveryMessages.mark}" />
	<h:outputLink title="#{assessmentSettingsMessages.whats_this_link}" value="#" onclick="javascript:window.open('../author/markForReviewPopUp.faces','MarkForReview','width=300,height=220,scrollbars=yes, resizable=yes');" >
		<h:outputText  value=" #{assessmentSettingsMessages.whats_this_link}"/>
	</h:outputLink>
</h:panelGroup>

<f:verbatim><br /></f:verbatim>

<h:panelGroup rendered="#{delivery.feedback eq 'true'}">
  <h:panelGrid rendered="#{delivery.feedbackComponent.showCorrectResponse && !delivery.noFeedback=='true'&& question.modelAnswerIsNotEmpty}" >
    <h:panelGroup> 
      <h:outputLabel for="answerKeyMC" styleClass="answerkeyFeedbackCommentLabel" value="#{deliveryMessages.model} " />
      <h:outputText  value="#{question.key}" escape="false"/>
    </h:panelGroup> 
    <h:outputText value=" "/>
  </h:panelGrid>
  
  <h:panelGrid rendered="#{delivery.feedbackComponent.showItemLevel && !delivery.noFeedback=='true' && question.feedbackIsNotEmpty}">
    <h:panelGroup> 
      <h:outputLabel for="feedSC" styleClass="answerkeyFeedbackCommentLabel" value="#{commonMessages.feedback}#{deliveryMessages.column} " />
      <h:outputText id="feedSC" value="#{question.feedback}" escape="false" />
    </h:panelGroup> 
    <h:outputText value=" "/>
  </h:panelGrid>
  
  <h:panelGrid rendered="#{delivery.actionString !='gradeAssessment' && delivery.feedbackComponent.showGraderComment && !delivery.noFeedback=='true' && (question.gradingCommentIsNotEmpty || question.hasItemGradingAttachment)}" columns="1" border="0">
    <h:panelGroup>  
      <h:outputLabel for="commentSC" styleClass="answerkeyFeedbackCommentLabel" value="#{deliveryMessages.comment}#{deliveryMessages.column} " />
	  <h:outputText id="commentSC" value="#{question.gradingComment}" escape="false" rendered="#{question.gradingCommentIsNotEmpty}"/>
    </h:panelGroup>
    
	<h:panelGroup rendered="#{question.hasItemGradingAttachment}">
      <h:dataTable value="#{question.itemGradingAttachmentList}" var="attach">
        <h:column>
          <%@ include file="/jsf/shared/mimeicon.jsp" %>
        </h:column>
        <h:column>
          <f:verbatim>&nbsp;&nbsp;&nbsp;&nbsp;</f:verbatim>
          <h:outputLink value="#{attach.location}" target="new_window">
            <h:outputText escape="false" value="#{attach.filename}" />
          </h:outputLink>
        </h:column>
        <h:column>
          <f:verbatim>&nbsp;&nbsp;&nbsp;&nbsp;</f:verbatim>
          <h:outputText escape="false" value="(#{attach.fileSize} #{generalMessages.kb})" rendered="#{!attach.isLink}"/>
        </h:column>
      </h:dataTable>
    </h:panelGroup>
  </h:panelGrid>
</h:panelGroup>
