/*
 * Decompiled with CFR 0.152.
 */
package com.corejsf;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadRenderer
extends Renderer {
    private static Log log = LogFactory.getLog(UploadRenderer.class);
    private static final String UPLOAD = ".upload";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        ExternalContext external = context.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)external.getRequest();
        String clientId = component.getClientId(context);
        log.debug((Object)("** encodeBegin, clientId =" + clientId));
        this.encodeUploadField(writer, clientId, component);
    }

    public void encodeUploadField(ResponseWriter writer, String clientId, UIComponent component) throws IOException {
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"file", "type");
        writer.writeAttribute("name", (Object)(clientId + UPLOAD), "clientId");
        writer.writeAttribute("size", (Object)"50", null);
        writer.endElement("input");
        writer.flush();
    }

    public void decode(FacesContext context, UIComponent component) {
        log.debug((Object)"**** decode =");
        ExternalContext external = context.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)external.getRequest();
        String clientId = component.getClientId(context);
        FileItem item = (FileItem)request.getAttribute(clientId + UPLOAD);
        log.debug((Object)("clientId =" + clientId));
        log.debug((Object)("fileItem =" + item));
        Long maxSize = (Long)((ServletContext)external.getContext()).getAttribute("FILEUPLOAD_SIZE_MAX");
        if (item != null && item.getSize() / 1000L > (long)maxSize.intValue()) {
            ((ServletContext)external.getContext()).setAttribute("TEMP_FILEUPLOAD_SIZE", (Object)new Long(item.getSize() / 1000L));
            ((EditableValueHolder)component).setSubmittedValue((Object)("SizeTooBig:" + item.getName()));
            return;
        }
        ValueBinding binding = component.getValueBinding("target");
        Object target = binding != null ? binding.getValue(context) : component.getAttributes().get("target");
        String repositoryPath = (String)((ServletContext)external.getContext()).getAttribute("FILEUPLOAD_REPOSITORY_PATH");
        log.debug((Object)("****" + repositoryPath));
        if (target != null) {
            File dir = new File(repositoryPath + target.toString());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (item != null && !"".equals(item.getName())) {
                String fullname = item.getName();
                fullname = fullname.replace('\\', '/');
                fullname = fullname.substring(fullname.lastIndexOf("/") + 1);
                int dot_index = fullname.lastIndexOf(".");
                String filename = "";
                filename = dot_index < 0 ? fullname + "_" + new Date().getTime() : fullname.substring(0, dot_index) + "_" + new Date().getTime() + fullname.substring(dot_index);
                File file = new File(dir.getPath() + "/" + filename);
                log.debug((Object)("**1. filename=" + file.getPath()));
                try {
                    item.write(file);
                    ((EditableValueHolder)component).setSubmittedValue((Object)file.getPath());
                }
                catch (Exception ex) {
                    throw new FacesException((Throwable)ex);
                }
            }
        }
    }
}

