/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.jsf.util;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.jsf.util.JsfTool;
import org.sakaiproject.tool.api.ActiveTool;
import org.sakaiproject.tool.api.ToolException;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemAuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishedAssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.bean.author.SectionBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.ItemContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.QuestionScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.util.EmailBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.cover.ActiveToolManager;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.util.Web;

public class SamigoJsfTool
extends JsfTool {
    private static final String HELPER_EXT = ".helper";
    private static final String HELPER_SESSION_PREFIX = "session.";
    private static final String HELPER_RETURN_NOTIFICATION = "/returnToCaller";
    private static final String RESET_ASSESSMENT_BEAN = "/resetAssessmentBean";
    private static Log log = LogFactory.getLog(SamigoJsfTool.class);

    protected boolean isResourceRequest(String path) {
        log.debug((Object)("****0. inside isResourceRequest, path=" + path));
        if (path == null || path.length() == 0) {
            return false;
        }
        int pos = path.lastIndexOf(".");
        if (pos == -1) {
            return false;
        }
        String ext = path.substring(pos);
        log.debug((Object)("****1. inside isResourceRequest, ext=" + ext));
        if (ext.indexOf("/") != -1) {
            return false;
        }
        if (ext.equals(".jsf")) {
            return false;
        }
        if (ext.equals(".faces")) {
            return false;
        }
        if (path.startsWith("/faces/")) {
            return false;
        }
        return path.indexOf(HELPER_EXT) <= -1;
    }

    protected void dispatch(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ItemAuthorBean bean;
        RequestDispatcher resourceDispatcher;
        ToolSession session;
        String target = req.getPathInfo();
        log.debug((Object)("***0. dispatch, target =" + target));
        if (target != null && target.startsWith(RESET_ASSESSMENT_BEAN)) {
            AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBeanFromExternalServlet((String)"assessmentBean", (HttpServletRequest)req, (HttpServletResponse)res);
            if (assessmentBean != null && assessmentBean.getAssessmentId() != null) {
                AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
                Object assessmentService = author.getIsEditPendingAssessmentFlow() ? new AssessmentService() : new PublishedAssessmentService();
                AssessmentIfc assessment = assessmentService.getAssessment(Long.valueOf(assessmentBean.getAssessmentId()));
                assessmentBean.setAssessment(assessment);
            }
            target = target.replaceFirst(RESET_ASSESSMENT_BEAN, "");
        }
        if (HELPER_RETURN_NOTIFICATION.equals(target) && (target = (String)(session = SessionManager.getCurrentToolSession()).getAttribute(ToolManager.getCurrentTool().getId() + "sakai.tool.helper.done.url")) != null) {
            session.removeAttribute(ToolManager.getCurrentTool().getId() + "sakai.tool.helper.done.url");
            res.sendRedirect(target);
            return;
        }
        boolean sendToHelper = this.sendToHelper(req, res);
        boolean isResourceRequest = this.isResourceRequest(target);
        log.debug((Object)("***1. dispatch, send to helper =" + sendToHelper));
        log.debug((Object)("***2. dispatch, isResourceRequest =" + isResourceRequest));
        if (sendToHelper) {
            return;
        }
        if (isResourceRequest && (resourceDispatcher = this.getServletContext().getRequestDispatcher(target)) != null) {
            resourceDispatcher.forward((ServletRequest)req, (ServletResponse)res);
            return;
        }
        if (target == null || "/".equals(target)) {
            target = this.computeDefaultTarget();
            if (!target.startsWith("/")) {
                target = "/" + target;
            }
            res.sendRedirect(Web.returnUrl((HttpServletRequest)req, (String)target));
            return;
        }
        String newTarget = this.redirectRequestedTarget(target);
        if (!newTarget.startsWith("/")) {
            newTarget = "/" + newTarget;
        }
        if (!newTarget.equals(target)) {
            res.sendRedirect(Web.returnUrl((HttpServletRequest)req, (String)newTarget));
            return;
        }
        target = newTarget;
        ToolSession toolSession = SessionManager.getCurrentToolSession();
        if (toolSession != null) {
            toolSession.setAttribute("sakai.jsf.tool.last.view.visited", (Object)target);
        }
        log.debug((Object)("3a. dispatch: toolSession=" + toolSession));
        log.debug((Object)("3b. dispatch: target=" + target));
        log.debug((Object)("3c. dispatch: lastview?" + this.m_defaultToLastView));
        target = this.m_path + target;
        int lastSlash = target.lastIndexOf("/");
        int lastDot = target.lastIndexOf(".");
        if (lastDot < 0 || lastDot < lastSlash) {
            target = target + ".jsf";
        }
        req.setAttribute("sakai.jsf.tool.URL.path", (Object)this.m_path);
        req.setAttribute("sakai.jsf.tool.URL.ext", (Object)".jsp");
        req.setAttribute("sakai.request.native.url", (Object)"sakai.request.native.url");
        res.setContentType("text/html; charset=UTF-8");
        res.addDateHeader("Expires", System.currentTimeMillis() - 31536000000L);
        res.addDateHeader("Last-Modified", System.currentTimeMillis());
        res.addHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0, post-check=0, pre-check=0");
        res.addHeader("Pragma", "no-cache");
        log.debug((Object)("***4. dispatch, dispatching path: " + req.getPathInfo() + " to: " + target + " context: " + this.getServletContext().getServletContextName()));
        if (target.indexOf("/jsf/author/item/") > -1 && "true".equals(toolSession.getAttribute("SENT_TO_FILEPICKER_HELPER"))) {
            bean = (ItemAuthorBean)ContextUtil.lookupBeanFromExternalServlet((String)"itemauthor", (HttpServletRequest)req, (HttpServletResponse)res);
            bean.setItemAttachment();
            toolSession.removeAttribute("SENT_TO_FILEPICKER_HELPER");
        } else if (target.indexOf("/jsf/author/editPart") > -1 && "true".equals(toolSession.getAttribute("SENT_TO_FILEPICKER_HELPER"))) {
            bean = (SectionBean)ContextUtil.lookupBeanFromExternalServlet((String)"sectionBean", (HttpServletRequest)req, (HttpServletResponse)res);
            bean.setPartAttachment();
            toolSession.removeAttribute("SENT_TO_FILEPICKER_HELPER");
        } else if (target.indexOf("/jsf/author/authorSettings") > -1 && "true".equals(toolSession.getAttribute("SENT_TO_FILEPICKER_HELPER"))) {
            bean = (AssessmentSettingsBean)ContextUtil.lookupBeanFromExternalServlet((String)"assessmentSettings", (HttpServletRequest)req, (HttpServletResponse)res);
            bean.setAssessmentAttachment();
            toolSession.removeAttribute("SENT_TO_FILEPICKER_HELPER");
        } else if (target.indexOf("/jsf/author/publishedSettings") > -1 && "true".equals(toolSession.getAttribute("SENT_TO_FILEPICKER_HELPER"))) {
            bean = (PublishedAssessmentSettingsBean)ContextUtil.lookupBeanFromExternalServlet((String)"publishedSettings", (HttpServletRequest)req, (HttpServletResponse)res);
            bean.setAssessmentAttachment();
            toolSession.removeAttribute("SENT_TO_FILEPICKER_HELPER");
        } else if (target.indexOf("/jsf/evaluation/createNewEmail") > -1 && "true".equals(toolSession.getAttribute("SENT_TO_FILEPICKER_HELPER"))) {
            bean = (EmailBean)ContextUtil.lookupBeanFromExternalServlet((String)"email", (HttpServletRequest)req, (HttpServletResponse)res);
            bean.prepareAttachment();
            toolSession.removeAttribute("SENT_TO_FILEPICKER_HELPER");
        } else if (target.indexOf("/jsf/evaluation/questionScore") > -1 && "true".equals(toolSession.getAttribute("SENT_TO_FILEPICKER_HELPER"))) {
            bean = (QuestionScoresBean)ContextUtil.lookupBeanFromExternalServlet((String)"questionScores", (HttpServletRequest)req, (HttpServletResponse)res);
            bean.setAttachment((Long)toolSession.getAttribute("itemGradingId"));
            toolSession.removeAttribute("SENT_TO_FILEPICKER_HELPER");
        } else if (target.indexOf("/jsf/evaluation/gradeStudentResult") > -1 && "true".equals(toolSession.getAttribute("SENT_TO_FILEPICKER_HELPER"))) {
            bean = (ItemContentsBean)ContextUtil.lookupBeanFromExternalServlet((String)"itemContents", (HttpServletRequest)req, (HttpServletResponse)res);
            bean.setAttachment((Long)toolSession.getAttribute("itemGradingId"));
            toolSession.removeAttribute("SENT_TO_FILEPICKER_HELPER");
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(target);
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        req.removeAttribute("sakai.request.native.url");
        req.removeAttribute("sakai.jsf.tool.URL.path");
        req.removeAttribute("sakai.jsf.tool.URL.ext");
    }

    protected boolean sendToHelper(HttpServletRequest req, HttpServletResponse res) throws ToolException {
        String path = req.getPathInfo();
        if (path == null) {
            path = "/";
        }
        String[] parts = path.split("/");
        log.debug((Object)("***a. sendToHelper.partLength=" + parts.length));
        String helperPath = null;
        String toolPath = null;
        if (parts.length > 2) {
            log.debug((Object)("***b. sendToHelper.partLength=" + parts.length));
            helperPath = parts[parts.length - 2];
            toolPath = parts[parts.length - 1];
        } else if (parts.length == 2) {
            log.debug((Object)("***c. sendToHelper.partLength=" + parts.length));
            helperPath = parts[1];
        } else {
            return false;
        }
        if (!helperPath.endsWith(HELPER_EXT)) {
            return false;
        }
        log.debug((Object)("****d. sendToHelper, part #1=" + helperPath));
        log.debug((Object)("****e. sendToHelper, part #2=" + toolPath));
        ToolSession toolSession = SessionManager.getCurrentToolSession();
        toolSession.setAttribute("SENT_TO_FILEPICKER_HELPER", (Object)"true");
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            if (!paramName.startsWith(HELPER_SESSION_PREFIX)) continue;
            String attributeName = paramName.substring(HELPER_SESSION_PREFIX.length());
            toolSession.setAttribute(attributeName, (Object)req.getParameter(paramName));
        }
        int posEnd = helperPath.lastIndexOf(".");
        String helperId = helperPath.substring(0, posEnd);
        log.debug((Object)("****f. sendToHelper, helperId=" + helperId));
        ActiveTool helperTool = ActiveToolManager.getActiveTool((String)helperId);
        String url = req.getContextPath() + req.getServletPath();
        if (toolSession.getAttribute(helperTool.getId() + "sakai.tool.helper.done.url") == null) {
            toolSession.setAttribute(helperTool.getId() + "sakai.tool.helper.done.url", (Object)(url + RESET_ASSESSMENT_BEAN + this.computeDefaultTarget(true)));
        }
        log.debug((Object)("****g. sendToHelper, url=" + url));
        String context = url + "/" + helperPath;
        log.debug((Object)("****h. sendToHelper, context=" + context));
        if (toolPath != null) {
            helperTool.help(req, res, context, "/" + toolPath);
        } else {
            helperTool.help(req, res, context, "");
        }
        return true;
    }

    protected String computeDefaultTarget(boolean lastVisited) {
        String last;
        ToolSession session = SessionManager.getCurrentToolSession();
        String target = "/" + this.m_default;
        if (lastVisited && (last = (String)session.getAttribute("sakai.jsf.tool.last.view.visited")) != null) {
            target = last;
        }
        session.removeAttribute("sakai.jsf.tool.last.view.visited");
        log.debug((Object)("***3. computeDefaultTarget()=" + target));
        return target;
    }
}

