/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.jsf.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class PagerButtonRenderer
extends Renderer {
    private static final String[] numberValues = new String[]{"10", "20", "30", "50", "100"};
    private static final String DISABLED_ATTRIB = " disabled=\"disabled\"";
    private static final String OF = "of";
    private static final String VIEWING = "Viewing";
    private static final String SHOW = "Show";
    private static final String ITEMS = "items";
    private static final String ITEMS_PER = "items per page";

    public boolean supportsComponentType(UIComponent component) {
        return component instanceof UIOutput;
    }

    public void decode(FacesContext context, UIComponent component) {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String formId = (String)component.getAttributes().get("formId");
        String firstItem = (String)component.getAttributes().get("firstItem");
        String lastItem = (String)component.getAttributes().get("lastItem");
        String dataTableId = (String)component.getAttributes().get("dataTableId");
        String prevText = (String)component.getAttributes().get("prevText");
        String nextText = (String)component.getAttributes().get("nextText");
        String numItems = (String)component.getAttributes().get("numItems");
        String totalItems = (String)component.getAttributes().get("totalItems");
        String prevDisabled = (String)component.getAttributes().get("prevDisabled");
        String nextDisabled = (String)component.getAttributes().get("nextDisabled");
        String prevDisabledAttr = "";
        String nextDisabledAttr = "";
        if ("true".equals(prevDisabled)) {
            prevDisabledAttr = DISABLED_ATTRIB;
        }
        if ("true".equals(nextDisabled)) {
            nextDisabledAttr = DISABLED_ATTRIB;
        }
        writer.write("  <span class=\"instruction\">Viewing " + firstItem + " - " + lastItem + " " + OF + " " + totalItems + " " + ITEMS + "</span>");
        writer.write("  <br />");
        writer.write("  <input type=\"submit\"");
        writer.write("    name=\"" + dataTableId + "_" + formId + "__pager_button_control_prev_btn\"");
        writer.write("    onclick=\"javascript:document.forms['" + formId + "'].submit(); return false;\"");
        writer.write("    value=\"&lt; " + prevText + " " + numItems + "\"");
        writer.write("    " + prevDisabledAttr + "/>");
        String select = dataTableId + "_" + formId + "__pager_button_control_select";
        this.writeSelectList(writer, numItems, select, formId);
        writer.write("  <input type=\"submit\"");
        writer.write("    name=\"" + dataTableId + "_" + formId + "__pager_button_control_next_btn\"");
        writer.write("    onclick=\"javascript:document.forms['" + formId + "'].submit(); return false;\"");
        writer.write("    value=\"" + nextText + " " + numItems + " &gt;\"");
        writer.write("\t\t" + nextDisabledAttr + "/>");
        writer.write("  <br />");
    }

    private void writeSelectList(ResponseWriter writer, String numItems, String selectId, String formId) throws IOException {
        writer.write("  <select ");
        writer.write("    onchange=\"javascript:document.forms['" + formId + "'].submit(); return false;\"");
        writer.write("    name=\"" + selectId + "\">");
        for (int i = 0; i < numberValues.length; ++i) {
            String currentVal = numberValues[i];
            writer.write("    <option ");
            writer.write(" value=\"" + currentVal + "\"");
            if (currentVal.equals(numItems)) {
                writer.write(" selected=\"selected\" ");
            }
            writer.write(">Show " + currentVal + " " + ITEMS_PER + "</option>");
        }
        writer.write("  </select>");
    }
}

