/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.pdf;

import com.lowagie.text.DocListener;
import com.lowagie.text.html.simpleparser.StyleSheet;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.cover.ContentHostingService;

public class HTMLWorker
extends org.sakaiproject.tool.assessment.pdf.itext.HTMLWorker {
    private static String ACCESSBASE = ServerConfigurationService.getAccessUrl() + ContentHostingService.REFERENCE_ROOT;
    private String RELATIVEBASE = ACCESSBASE.replace(ServerConfigurationService.getServerUrl(), "");
    private ArrayList tempFiles = new ArrayList();

    public HTMLWorker(DocListener doc) {
        super(doc);
    }

    public static ArrayList parseToList(Reader reader, StyleSheet style, HashMap interfaceProps) throws IOException {
        HTMLWorker worker = new HTMLWorker(null);
        if (style != null) {
            worker.setStyleSheet(style);
        }
        worker.document = worker;
        worker.setInterfaceProps(interfaceProps);
        worker.objectList = new ArrayList();
        worker.parse(reader);
        return worker.objectList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startElement(String tag, HashMap h) {
        if (tag.equals("img")) {
            String src = (String)h.get("src");
            if (src == null) {
                return;
            }
            String imgId = "";
            if (src.startsWith(ACCESSBASE) || src.startsWith(this.RELATIVEBASE) || src.startsWith("/samigo/")) {
                FileOutputStream fos = null;
                FilterOutputStream dos = null;
                if (src.startsWith(ACCESSBASE) || src.startsWith(this.RELATIVEBASE)) {
                    imgId = src.replaceFirst(ACCESSBASE, "").replaceFirst(this.RELATIVEBASE, "");
                } else if (src.startsWith("/samigo/")) {
                    imgId = src.replaceFirst("/samigo", "");
                }
                try {
                    imgId = URLDecoder.decode(imgId);
                    ContentResource img = ContentHostingService.getResource((String)imgId);
                    String ext = imgId.substring(imgId.lastIndexOf("."));
                    File temp = File.createTempFile("temp" + img.hashCode(), ext);
                    fos = new FileOutputStream(temp);
                    dos = new DataOutputStream(fos);
                    ((DataOutputStream)dos).write(img.getContent(), 0, (int)img.getContentLength());
                    dos.close();
                    fos.close();
                    this.tempFiles.add(temp);
                    h.put("src", temp.getCanonicalPath());
                    HashMap props = this.getInterfaceProps();
                    HashMap tempProps = new HashMap();
                    this.setInterfaceProps(tempProps);
                    super.startElement(tag, h);
                    this.setInterfaceProps(props);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (dos != null) {
                        try {
                            dos.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                super.startElement(tag, h);
            }
            for (int i = 0; i < this.tempFiles.size(); ++i) {
                File trash = (File)this.tempFiles.get(i);
                trash.deleteOnExit();
            }
        } else {
            super.startElement(tag, h);
        }
    }
}

