/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.pdf.itext;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.FontFactoryImp;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.html.simpleparser.ALink;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import com.lowagie.text.html.simpleparser.FactoryProperties;
import com.lowagie.text.html.simpleparser.Img;
import com.lowagie.text.html.simpleparser.IncCell;
import com.lowagie.text.html.simpleparser.IncTable;
import com.lowagie.text.html.simpleparser.StyleSheet;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.xml.simpleparser.SimpleXMLDocHandler;
import com.lowagie.text.xml.simpleparser.SimpleXMLParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.cover.ContentHostingService;

/*
 * Exception performing whole class analysis ignored.
 */
public class HTMLWorker
implements SimpleXMLDocHandler,
DocListener {
    protected ArrayList objectList;
    protected DocListener document;
    private Paragraph currentParagraph;
    private ChainedProperties cprops = new ChainedProperties();
    private Stack stack = new Stack();
    private boolean pendingTR = false;
    private boolean pendingTD = false;
    private boolean pendingLI = false;
    private StyleSheet style = new StyleSheet();
    private boolean isPRE = false;
    private boolean inBLOCK = false;
    private Stack tableState = new Stack();
    private boolean skipText = false;
    private HashMap interfaceProps;
    private FactoryProperties factoryProperties = new FactoryProperties();
    private int maxWidth = 450;
    public static final String tagsSupportedString = "ol ul li a pre font span br p div body table td th tr i b u sub sup em strong h1 h2 h3 h4 h5 h6 img hr blockquote";
    public static final HashMap tagsSupported = new HashMap();

    public HTMLWorker(DocListener document) {
        this.document = document;
    }

    public void setStyleSheet(StyleSheet style) {
        this.style = style;
    }

    public StyleSheet getStyleSheet() {
        return this.style;
    }

    public void setInterfaceProps(HashMap interfaceProps) {
        this.interfaceProps = interfaceProps;
        FontFactoryImp ff = null;
        if (interfaceProps != null) {
            ff = (FontFactoryImp)interfaceProps.get("font_factory");
        }
        if (ff != null) {
            this.factoryProperties.setFontImp(ff);
        }
    }

    public HashMap getInterfaceProps() {
        return this.interfaceProps;
    }

    public void parse(Reader reader) throws IOException {
        SimpleXMLParser.parse((SimpleXMLDocHandler)this, null, (Reader)reader, (boolean)true);
    }

    public static ArrayList parseToList(Reader reader, StyleSheet style) throws IOException {
        return HTMLWorker.parseToList((Reader)reader, (StyleSheet)style, null);
    }

    public static ArrayList parseToList(Reader reader, StyleSheet style, HashMap interfaceProps) throws IOException {
        HTMLWorker worker = new HTMLWorker(null);
        if (style != null) {
            worker.style = style;
        }
        worker.document = worker;
        worker.setInterfaceProps(interfaceProps);
        worker.objectList = new ArrayList();
        worker.parse(reader);
        return worker.objectList;
    }

    public void endDocument() {
        try {
            for (int k = 0; k < this.stack.size(); ++k) {
                this.document.add((Element)this.stack.elementAt(k));
            }
            if (this.currentParagraph != null) {
                this.document.add((Element)this.currentParagraph);
            }
            this.currentParagraph = null;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void startDocument() {
        HashMap h = new HashMap();
        this.style.applyStyle("body", h);
        this.cprops.addToChain("body", h);
    }

    public void startElement(String tag, HashMap h) {
        if (!tagsSupported.containsKey(tag)) {
            return;
        }
        try {
            this.style.applyStyle(tag, h);
            String follow = (String)FactoryProperties.followTags.get(tag);
            if (follow != null) {
                HashMap<String, Object> prop = new HashMap<String, Object>();
                prop.put(follow, null);
                this.cprops.addToChain(follow, prop);
                return;
            }
            FactoryProperties.insertStyle((HashMap)h);
            if (tag.equals("a")) {
                this.cprops.addToChain(tag, h);
                if (this.currentParagraph == null) {
                    this.currentParagraph = new Paragraph();
                }
                this.stack.push(this.currentParagraph);
                this.endElement("p");
                this.currentParagraph = new Paragraph();
                return;
            }
            if (tag.equals("br")) {
                if (this.currentParagraph == null) {
                    this.currentParagraph = new Paragraph();
                }
                this.currentParagraph.add((Object)this.factoryProperties.createChunk("\n", this.cprops));
                return;
            }
            if (tag.equals("hr")) {
                PdfPTable hr = new PdfPTable(1);
                hr.setHorizontalAlignment(1);
                hr.setWidthPercentage(100.0f);
                hr.setSpacingAfter(0.0f);
                hr.setSpacingBefore(0.0f);
                PdfPCell cell = new PdfPCell();
                cell.setUseVariableBorders(true);
                cell.setVerticalAlignment(5);
                cell.setHorizontalAlignment(1);
                cell.setBorder(2);
                cell.setBorderWidth(1.0f);
                cell.setPadding(0.0f);
                cell.addElement((Element)this.factoryProperties.createChunk("\n", this.cprops));
                hr.addCell(cell);
                this.document.add((Element)hr);
                return;
            }
            if (tag.equals("font") || tag.equals("span")) {
                this.cprops.addToChain(tag, h);
                return;
            }
            if (tag.equals("img")) {
                String src = (String)h.get("src");
                if (src == null) {
                    return;
                }
                this.cprops.addToChain(tag, h);
                Image img = null;
                if (this.interfaceProps != null) {
                    String baseurl;
                    HashMap images = (HashMap)this.interfaceProps.get("img_static");
                    if (images != null) {
                        Image tim = (Image)images.get(src);
                        if (tim != null) {
                            img = Image.getInstance((Image)tim);
                        }
                    } else if (!src.startsWith("http") && (baseurl = (String)this.interfaceProps.get("img_baseurl")) != null) {
                        src = baseurl + src;
                        img = Image.getInstance((String)src);
                    }
                }
                if (img == null) {
                    if (!src.startsWith("http")) {
                        String path = this.cprops.getProperty("image_path");
                        if (path == null) {
                            path = "";
                        }
                        src = new File(path, src).getPath();
                        img = Image.getInstance((String)src);
                    } else {
                        String srcResource = src.substring(src.indexOf("/content", 0)).replaceAll("/content", "");
                        byte[] buffer = this.getImageStream(URLDecoder.decode(srcResource));
                        img = Image.getInstance((byte[])buffer);
                    }
                }
                String align = (String)h.get("align");
                String width = (String)h.get("width");
                String height = (String)h.get("height");
                String border = (String)h.get("border");
                String hspace = (String)h.get("hspace");
                String vspace = (String)h.get("vspace");
                String before = this.cprops.getProperty("before");
                String after = this.cprops.getProperty("after");
                float wp = 0.0f;
                float lp = 0.0f;
                if (this.maxWidth > 0 && (width != null && Integer.parseInt(width) > this.maxWidth || width == null && (int)img.width() > this.maxWidth)) {
                    lp = wp = HTMLWorker.lengthParse((String)String.valueOf(this.maxWidth), (int)((int)img.width()));
                } else {
                    wp = HTMLWorker.lengthParse((String)width, (int)((int)img.width()));
                    lp = HTMLWorker.lengthParse((String)height, (int)((int)img.height()));
                }
                if (wp > 0.0f && lp > 0.0f) {
                    img.scalePercent(wp, lp);
                } else if (wp > 0.0f) {
                    img.scalePercent(wp);
                } else if (lp > 0.0f) {
                    img.scalePercent(lp);
                }
                img.setWidthPercentage(0.0f);
                if (border != null && !"".equals(border)) {
                    try {
                        img.setBorderWidth((float)Integer.parseInt(border));
                        img.setBorder(15);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (hspace != null && !"".equals(hspace)) {
                    try {
                        img.setSpacingAfter(Float.parseFloat(hspace));
                        img.setSpacingBefore(Float.parseFloat(hspace));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (align != null && (align.equalsIgnoreCase("left") || align.equalsIgnoreCase("right"))) {
                    this.endElement("p");
                    int ralign = 0;
                    if (align.equalsIgnoreCase("right")) {
                        ralign = 2;
                    }
                    img.setAlignment(ralign | 4);
                    Img i = null;
                    boolean skip = false;
                    if (this.interfaceProps != null && (i = (Img)this.interfaceProps.get("img_interface")) != null) {
                        skip = i.process(img, h, this.cprops, this.document);
                    }
                    if (!skip) {
                        this.document.add((Element)img);
                    }
                    this.cprops.removeChain(tag);
                } else {
                    img.setAlignment(4);
                    float bottom = 0.0f;
                    float top = img.top();
                    float prevHeight = 0.0f;
                    float prevRise = 0.0f;
                    if (this.currentParagraph != null) {
                        ArrayList chunks = this.currentParagraph.getChunks();
                        Chunk sibling = null;
                        for (int k = chunks.size() - 1; k >= 0; --k) {
                            if (chunks.get(k) == null) continue;
                            sibling = (Chunk)chunks.get(k);
                        }
                        if (sibling != null) {
                            if (sibling.hasAttributes()) {
                                prevRise = sibling.getTextRise();
                            }
                            prevHeight = 0.0f;
                            if (sibling.font() != null) {
                                prevHeight = sibling.font().getCalculatedSize();
                            }
                        }
                    }
                    if ("absMiddle".equalsIgnoreCase(align)) {
                        if (prevHeight > 0.0f) {
                            bottom += img.scaledHeight() / 2.0f - prevHeight / 2.0f;
                        } else if (img.scaledHeight() > 0.0f) {
                            bottom += img.scaledHeight() / 2.0f;
                        }
                    } else if ("middle".equalsIgnoreCase(align)) {
                        if (img.scaledHeight() > 0.0f) {
                            bottom += img.scaledHeight() / 2.0f;
                        }
                    } else if (!("bottom".equalsIgnoreCase(align) || "baseline".equalsIgnoreCase(align) || "absbottom".equalsIgnoreCase(align))) {
                        if ("top".equalsIgnoreCase(align)) {
                            bottom += img.scaledHeight() - prevHeight;
                        } else if ("texttop".equalsIgnoreCase(align)) {
                            bottom += img.scaledHeight() - (prevHeight - prevRise);
                        }
                    }
                    this.cprops.removeChain(tag);
                    if (this.currentParagraph == null) {
                        this.currentParagraph = FactoryProperties.createParagraph((ChainedProperties)this.cprops);
                        bottom = 0.0f;
                    } else if (this.currentParagraph.isEmpty()) {
                        bottom = 0.0f;
                    }
                    this.currentParagraph.setLeading(2.0f + bottom, 1.0f);
                    this.currentParagraph.add((Object)new Chunk(img, 0.0f, 0.0f - bottom));
                }
                return;
            }
            if (tag.equals("blockquote")) {
                this.cprops.addToChain(tag, h);
                this.inBLOCK = true;
                if (this.currentParagraph != null) {
                    this.endElement("p");
                }
                this.currentParagraph = FactoryProperties.createParagraph((HashMap)h);
                this.currentParagraph.add((Object)this.factoryProperties.createChunk("\n", this.cprops));
                return;
            }
            this.endElement("p");
            if (tag.equals("h1") || tag.equals("h2") || tag.equals("h3") || tag.equals("h4") || tag.equals("h5") || tag.equals("h6")) {
                if (!h.containsKey("size")) {
                    int v = 8 - Integer.parseInt(tag.substring(1));
                    h.put("size", Integer.toString(v));
                }
                this.cprops.addToChain(tag, h);
                return;
            }
            if (tag.equals("ul")) {
                if (this.pendingLI) {
                    this.endElement("li");
                }
                this.skipText = true;
                this.cprops.addToChain(tag, h);
                List list = new List(false, 10.0f);
                list.setListSymbol("\u2022");
                this.stack.push(list);
                return;
            }
            if (tag.equals("ol")) {
                if (this.pendingLI) {
                    this.endElement("li");
                }
                this.skipText = true;
                this.cprops.addToChain(tag, h);
                List list = new List(true, 10.0f);
                this.stack.push(list);
                return;
            }
            if (tag.equals("li")) {
                if (this.pendingLI) {
                    this.endElement("li");
                }
                this.skipText = false;
                this.pendingLI = true;
                this.cprops.addToChain(tag, h);
                this.stack.push(FactoryProperties.createListItem((ChainedProperties)this.cprops));
                return;
            }
            if (tag.equals("div") || tag.equals("body")) {
                this.cprops.addToChain(tag, h);
                return;
            }
            if (tag.equals("pre")) {
                if (!h.containsKey("face")) {
                    h.put("face", "Courier");
                }
                this.cprops.addToChain(tag, h);
                this.isPRE = true;
                return;
            }
            if (tag.equals("p")) {
                this.cprops.addToChain(tag, h);
                this.currentParagraph = FactoryProperties.createParagraph((HashMap)h);
                if (this.inBLOCK) {
                    this.currentParagraph.setIndentationLeft(this.currentParagraph.indentationLeft() + 40.0f);
                }
                return;
            }
            if (tag.equals("tr")) {
                if (this.pendingTR) {
                    this.endElement("tr");
                }
                this.skipText = true;
                this.pendingTR = true;
                this.cprops.addToChain("tr", h);
                return;
            }
            if (tag.equals("td") || tag.equals("th")) {
                if (this.pendingTD) {
                    this.endElement(tag);
                }
                this.skipText = false;
                this.pendingTD = true;
                this.cprops.addToChain("td", h);
                this.stack.push(new IncCell(tag, this.cprops));
                return;
            }
            if (tag.equals("table")) {
                this.cprops.addToChain("table", h);
                IncTable table = new IncTable(h);
                this.stack.push(table);
                this.tableState.push(new boolean[]{this.pendingTR, this.pendingTD});
                this.pendingTD = false;
                this.pendingTR = false;
                this.skipText = true;
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void endElement(String tag) {
        if (!tagsSupported.containsKey(tag)) {
            return;
        }
        try {
            Object obj;
            String follow = (String)FactoryProperties.followTags.get(tag);
            if (follow != null) {
                this.cprops.removeChain(follow);
                return;
            }
            if (tag.equals("font") || tag.equals("span")) {
                this.cprops.removeChain(tag);
                return;
            }
            if (tag.equals("a")) {
                String href;
                if (this.currentParagraph == null) {
                    this.currentParagraph = new Paragraph();
                }
                ALink i = null;
                boolean skip = false;
                if (this.interfaceProps != null && (i = (ALink)this.interfaceProps.get("alink_interface")) != null) {
                    skip = i.process(this.currentParagraph, this.cprops);
                }
                if (!skip && (href = this.cprops.getProperty("href")) != null) {
                    ArrayList chunks = this.currentParagraph.getChunks();
                    for (int k = 0; k < chunks.size(); ++k) {
                        Chunk ck = (Chunk)chunks.get(k);
                        ck.setAnchor(href);
                    }
                }
                Paragraph tmp = (Paragraph)this.stack.pop();
                Phrase tmp2 = new Phrase();
                tmp2.add((Object)this.currentParagraph);
                tmp.add((Object)tmp2);
                this.currentParagraph = tmp;
                this.cprops.removeChain("a");
                return;
            }
            if (tag.equals("blockquote")) {
                this.cprops.removeChain(tag);
                this.currentParagraph = new Paragraph();
                this.currentParagraph.add((Object)this.factoryProperties.createChunk("\n", this.cprops));
                this.inBLOCK = false;
                return;
            }
            if (tag.equals("br")) {
                return;
            }
            if (tag.equals("hr")) {
                return;
            }
            if (this.currentParagraph != null) {
                if (this.stack.empty()) {
                    this.document.add((Element)this.currentParagraph);
                } else {
                    obj = this.stack.pop();
                    if (obj instanceof TextElementArray) {
                        TextElementArray current = (TextElementArray)obj;
                        current.add((Object)this.currentParagraph);
                    }
                    this.stack.push(obj);
                }
            }
            this.currentParagraph = null;
            if (tag.equals("ul") || tag.equals("ol")) {
                if (this.pendingLI) {
                    this.endElement("li");
                }
                this.skipText = false;
                this.cprops.removeChain(tag);
                if (this.stack.empty()) {
                    return;
                }
                obj = this.stack.pop();
                if (!(obj instanceof List)) {
                    this.stack.push(obj);
                    return;
                }
                if (this.stack.empty()) {
                    this.document.add((Element)obj);
                } else {
                    ((TextElementArray)this.stack.peek()).add(obj);
                }
                return;
            }
            if (tag.equals("li")) {
                this.pendingLI = false;
                this.skipText = true;
                this.cprops.removeChain(tag);
                if (this.stack.empty()) {
                    return;
                }
                obj = this.stack.pop();
                if (!(obj instanceof ListItem)) {
                    this.stack.push(obj);
                    return;
                }
                if (this.stack.empty()) {
                    this.document.add((Element)obj);
                    return;
                }
                Object list = this.stack.pop();
                if (!(list instanceof List)) {
                    this.stack.push(list);
                    return;
                }
                ListItem item = (ListItem)obj;
                ((List)list).add((Object)item);
                ArrayList cks = item.getChunks();
                if (!cks.isEmpty()) {
                    item.listSymbol().setFont(((Chunk)cks.get(0)).font());
                }
                this.stack.push(list);
                return;
            }
            if (tag.equals("div") || tag.equals("body")) {
                this.cprops.removeChain(tag);
                return;
            }
            if (tag.equals("pre")) {
                this.cprops.removeChain(tag);
                this.isPRE = false;
                return;
            }
            if (tag.equals("p")) {
                this.cprops.removeChain(tag);
                return;
            }
            if (tag.equals("h1") || tag.equals("h2") || tag.equals("h3") || tag.equals("h4") || tag.equals("h5") || tag.equals("h6")) {
                this.cprops.removeChain(tag);
                return;
            }
            if (tag.equals("table")) {
                if (this.pendingTR) {
                    this.endElement("tr");
                }
                this.cprops.removeChain("table");
                IncTable table = (IncTable)this.stack.pop();
                if (table.getRows() == null || table.getRows().isEmpty()) {
                    return;
                }
                PdfPTable tb = table.buildTable();
                tb.setSplitRows(true);
                if (this.stack.empty()) {
                    this.document.add((Element)tb);
                } else {
                    ((TextElementArray)this.stack.peek()).add((Object)tb);
                }
                boolean[] state = (boolean[])this.tableState.pop();
                this.pendingTR = state[0];
                this.pendingTD = state[1];
                this.skipText = false;
                return;
            }
            if (tag.equals("tr")) {
                Object obj2;
                if (this.pendingTD) {
                    this.endElement("td");
                }
                this.pendingTR = false;
                this.cprops.removeChain("tr");
                ArrayList<PdfPCell> cells = new ArrayList<PdfPCell>();
                IncTable table = null;
                do {
                    if (!((obj2 = this.stack.pop()) instanceof IncCell)) continue;
                    cells.add(((IncCell)obj2).getCell());
                } while (!(obj2 instanceof IncTable));
                table = (IncTable)obj2;
                if (cells.size() > 0) {
                    table.addCols(cells);
                    table.endRow();
                }
                this.stack.push(table);
                this.skipText = true;
                return;
            }
            if (tag.equals("td") || tag.equals("th")) {
                this.pendingTD = false;
                this.cprops.removeChain("td");
                this.skipText = true;
                return;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void text(String str) {
        if (this.skipText) {
            return;
        }
        String content = str;
        if (this.isPRE) {
            if (this.currentParagraph == null) {
                this.currentParagraph = new Paragraph();
            }
            this.currentParagraph.add((Object)this.factoryProperties.createChunk(content, this.cprops));
            return;
        }
        if (content.trim().length() == 0 && content.indexOf(32) < 0) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        int len = content.length();
        boolean newline = false;
        block6: for (int i = 0; i < len; ++i) {
            char character = content.charAt(i);
            switch (character) {
                case ' ': {
                    if (newline) continue block6;
                    buf.append(character);
                    continue block6;
                }
                case '\n': {
                    if (i <= 0) continue block6;
                    newline = true;
                    buf.append(' ');
                    continue block6;
                }
                case '\r': {
                    continue block6;
                }
                case '\t': {
                    continue block6;
                }
                default: {
                    newline = false;
                    buf.append(character);
                }
            }
        }
        if (this.currentParagraph == null) {
            this.currentParagraph = FactoryProperties.createParagraph((ChainedProperties)this.cprops);
        }
        this.currentParagraph.add((Object)this.factoryProperties.createChunk(buf.toString(), this.cprops));
    }

    public boolean add(Element element) throws DocumentException {
        this.objectList.add(element);
        return true;
    }

    public void clearTextWrap() throws DocumentException {
    }

    public void close() {
    }

    public boolean newPage() {
        return true;
    }

    public void open() {
    }

    public void resetFooter() {
    }

    public void resetHeader() {
    }

    public void resetPageCount() {
    }

    public void setFooter(HeaderFooter footer) {
    }

    public void setHeader(HeaderFooter header) {
    }

    public boolean setMarginMirroring(boolean marginMirroring) {
        return true;
    }

    public boolean setMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        return true;
    }

    public void setPageCount(int pageN) {
    }

    public boolean setPageSize(Rectangle pageSize) {
        return true;
    }

    private static float lengthParse(String txt, int c) {
        if (txt == null) {
            return -1.0f;
        }
        if (txt.endsWith("%")) {
            float vf = Float.parseFloat(txt.substring(0, txt.length() - 1));
            return vf;
        }
        int v = Integer.parseInt(txt);
        return (float)v / (float)c * 100.0f;
    }

    public void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    private byte[] getImageStream(String src) throws Exception {
        InputStream input = null;
        try {
            ContentResource resource = ContentHostingService.getResource((String)src);
            byte[] buffer = new byte[(int)resource.getContentLength()];
            input = resource.streamContent();
            input.read(buffer, 0, buffer.length);
            byte[] byArray = buffer;
            return byArray;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception fe) {}
            }
        }
    }

    static {
        StringTokenizer tok = new StringTokenizer("ol ul li a pre font span br p div body table td th tr i b u sub sup em strong h1 h2 h3 h4 h5 h6 img hr blockquote");
        while (tok.hasMoreTokens()) {
            tagsSupported.put(tok.nextToken(), null);
        }
    }
}

