/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.rsf.producers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.rsf.params.BeginAssessmentViewParameters;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.shared.PersonBean;
import org.sakaiproject.tool.assessment.ui.listener.delivery.BeginDeliveryActionListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import uk.org.ponder.messageutil.MessageLocator;
import uk.org.ponder.rsf.components.UIBranchContainer;
import uk.org.ponder.rsf.components.UICommand;
import uk.org.ponder.rsf.components.UIContainer;
import uk.org.ponder.rsf.components.UIForm;
import uk.org.ponder.rsf.components.UIOutput;
import uk.org.ponder.rsf.components.decorators.UIDecorator;
import uk.org.ponder.rsf.components.decorators.UIFreeAttributeDecorator;
import uk.org.ponder.rsf.components.decorators.UITooltipDecorator;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCase;
import uk.org.ponder.rsf.flow.jsfnav.NavigationCaseReporter;
import uk.org.ponder.rsf.view.ComponentChecker;
import uk.org.ponder.rsf.view.DefaultView;
import uk.org.ponder.rsf.view.ViewComponentProducer;
import uk.org.ponder.rsf.viewstate.AnyViewParameters;
import uk.org.ponder.rsf.viewstate.SimpleViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParameters;
import uk.org.ponder.rsf.viewstate.ViewParamsReporter;

public class BeginAssessmentProducer
implements ViewComponentProducer,
NavigationCaseReporter,
DefaultView,
ViewParamsReporter {
    public HttpServletRequest httpServletRequest;
    public HttpServletResponse httpServletResponse;
    public MessageLocator messageLocator;
    private static Log log = LogFactory.getLog(BeginAssessmentProducer.class);
    public static final String VIEW_ID = "BeginTakingAssessment";

    public String getViewID() {
        return VIEW_ID;
    }

    public void fillComponents(UIContainer tofill, ViewParameters viewparams, ComponentChecker checker) {
        BeginAssessmentViewParameters params = null;
        String alias = "";
        if (viewparams != null) {
            params = (BeginAssessmentViewParameters)viewparams;
            alias = params.pubReference;
        } else {
            log.warn((Object)"Something bad... we have no viewparams");
        }
        HttpSession httpSession = this.httpServletRequest.getSession(true);
        httpSession.setMaxInactiveInterval(3600);
        PersonBean person = (PersonBean)ContextUtil.lookupBeanFromExternalServlet((String)"person", (HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse);
        DeliveryBean delivery = (DeliveryBean)ContextUtil.lookupBeanFromExternalServlet((String)"delivery", (HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse);
        delivery.setAssessmentGrading(null);
        delivery.setActionString("takeAssessmentViaUrl");
        delivery.setTimeElapse("0");
        delivery.setLastTimer(0L);
        delivery.setTimeLimit("0");
        delivery.setBeginAssessment(true);
        delivery.setContextPath(this.httpServletRequest.getContextPath());
        PublishedAssessmentService service = new PublishedAssessmentService();
        PublishedAssessmentFacade pub = service.getPublishedAssessment(alias);
        delivery.setAssessmentId(pub.getPublishedAssessmentId().toString());
        delivery.setAssessmentTitle(pub.getTitle());
        delivery.setPublishedAssessment(pub);
        String path = null;
        String agentIdString = "";
        boolean isAuthorized = false;
        boolean isAuthenticated = false;
        String releaseTo = pub.getAssessmentAccessControl().getReleaseTo();
        if (releaseTo != null && releaseTo.indexOf("Anonymous Users") > -1) {
            agentIdString = AgentFacade.createAnonymous();
            isAuthenticated = true;
            isAuthorized = true;
            delivery.setAnonymousLogin(true);
            person.setAnonymousId(agentIdString);
        } else {
            agentIdString = this.httpServletRequest.getRemoteUser();
            boolean bl = isAuthenticated = agentIdString != null && !"".equals(agentIdString);
            if (isAuthenticated) {
                isAuthorized = this.checkMembership(pub);
                agentIdString = AgentFacade.getAgentString();
            }
        }
        log.debug((Object)("*** agentIdString: " + agentIdString));
        boolean assessmentIsAvailable = this.assessmentIsAvailable(service, agentIdString, pub, delivery);
        if (isAuthorized) {
            if (!assessmentIsAvailable) {
                UIBranchContainer.make((UIContainer)tofill, (String)"assessmentNotAvailable:");
            } else {
                BeginDeliveryActionListener listener = new BeginDeliveryActionListener();
                listener.processAction(null);
                UIForm form = UIForm.make((UIContainer)tofill, (String)"takeAssessmentForm:");
                String url = "/samigo-app/servlet/Login?id=" + pub.getAssessmentMetaDataByLabel("ALIAS") + "&fromDirect=true";
                UICommand.make((UIContainer)form, (String)"takeAssessment", (String)this.messageLocator.getMessage("begin_assessment_"), null).decorate((UIDecorator)new UITooltipDecorator(this.messageLocator.getMessage("begin_assessment_"))).decorate((UIDecorator)new UIFreeAttributeDecorator("onclick", "window.location.href='" + url + "'"));
                UIOutput.make((UIContainer)form, (String)"assessmentTitle", (String)delivery.getAssessmentTitle());
                UIOutput.make((UIContainer)form, (String)"courseName", (String)delivery.getCourseName());
                UIOutput.make((UIContainer)form, (String)"creatorName", (String)delivery.getCreatorName());
                if (delivery.getHasTimeLimit()) {
                    UIBranchContainer timeLimit = UIBranchContainer.make((UIContainer)form, (String)"timeLimit:");
                    UIOutput.make((UIContainer)timeLimit, (String)"timeLimit", (String)delivery.getTimeLimit());
                    UIOutput.make((UIContainer)timeLimit, (String)"timeLimitHour", (String)(delivery.getTimeLimit_hour() + ""));
                    UIOutput.make((UIContainer)timeLimit, (String)"timeLimitMin", (String)(delivery.getTimeLimit_minute() + ""));
                } else {
                    UIBranchContainer noTimeLimit = UIBranchContainer.make((UIContainer)form, (String)"noTimeLimit:");
                    UIOutput.make((UIContainer)noTimeLimit, (String)"timeLimit", (String)delivery.getTimeLimit());
                }
                if (!delivery.getAnonymousLogin() && !delivery.getSettings().isUnlimitedAttempts()) {
                    UIBranchContainer limited = UIBranchContainer.make((UIContainer)tofill, (String)"limited:");
                    UIOutput.make((UIContainer)limited, (String)"maxAttempts", (String)(delivery.getSettings().getMaxAttempts() + ""));
                    UIOutput.make((UIContainer)limited, (String)"remaining", (String)(delivery.getSubmissionsRemaining() + ""));
                } else if (!delivery.getAnonymousLogin() && delivery.getSettings().isUnlimitedAttempts()) {
                    UIBranchContainer.make((UIContainer)tofill, (String)"unlimited:");
                }
                if (delivery.getFeedbackComponent().getShowImmediate()) {
                    UIBranchContainer.make((UIContainer)tofill, (String)"immediate:");
                } else if (delivery.getFeedbackComponent().getShowNoFeedback()) {
                    UIBranchContainer.make((UIContainer)tofill, (String)"nofeedback:");
                } else if (delivery.getFeedbackComponent().getShowDateFeedback()) {
                    UIBranchContainer feedback = UIBranchContainer.make((UIContainer)tofill, (String)"feedback:");
                    UIOutput.make((UIContainer)feedback, (String)"feedBackDate", (String)delivery.getSettings().getFeedbackDate().toString());
                }
                if (delivery.getDueDate() != null) {
                    UIBranchContainer duedate = UIBranchContainer.make((UIContainer)tofill, (String)"duedate:");
                    UIOutput.make((UIContainer)duedate, (String)"duedate", (String)delivery.getDueDateString());
                }
            }
        } else if (!isAuthenticated) {
            if (AgentFacade.isStandaloneEnvironment()) {
                delivery.setActionString(null);
                path = delivery.getPortal();
            } else {
                delivery.setActionString(null);
                try {
                    path = "/authn/login?url=" + URLEncoder.encode(this.httpServletRequest.getRequestURL().toString() + "?pubId=" + alias, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            log.info((Object)("** servlet path=" + this.httpServletRequest.getRequestURL().toString()));
            String url = this.httpServletRequest.getRequestURL().toString();
            String context = this.httpServletRequest.getContextPath();
            String finalUrl = url.substring(0, url.lastIndexOf(context)) + path;
            log.info((Object)("**** finalUrl = " + finalUrl));
            try {
                this.httpServletResponse.sendRedirect(finalUrl);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            UIBranchContainer.make((UIContainer)tofill, (String)"accessDenied:");
        }
    }

    private boolean checkMembership(PublishedAssessmentFacade pub) {
        boolean isMember = false;
        List l = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("VIEW_PUBLISHED_ASSESSMENT", pub.getPublishedAssessmentId().toString());
        for (int i = 0; i < l.size(); ++i) {
            String siteId = ((AuthorizationData)l.get(i)).getAgentIdString();
            isMember = PersistenceService.getInstance().getAuthzQueriesFacade().checkMembership(siteId);
            if (isMember) break;
        }
        return isMember;
    }

    public boolean assessmentIsAvailable(PublishedAssessmentService service, String agentIdString, PublishedAssessmentFacade pub, DeliveryBean delivery) {
        boolean assessmentIsAvailable = false;
        String nextAction = delivery.checkBeforeProceed();
        log.debug((Object)("nextAction=" + nextAction));
        if ("safeToProceed".equals(nextAction)) {
            assessmentIsAvailable = true;
        }
        return assessmentIsAvailable;
    }

    public ViewParameters getViewParameters() {
        return new BeginAssessmentViewParameters();
    }

    public List reportNavigationCases() {
        ArrayList<NavigationCase> togo = new ArrayList<NavigationCase>();
        togo.add(new NavigationCase(null, (AnyViewParameters)new SimpleViewParameters(VIEW_ID)));
        return togo;
    }

    public void setMessageLocator(MessageLocator messageLocator) {
        this.messageLocator = messageLocator;
    }
}

