/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.author;

import java.io.Serializable;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.sakaiproject.tool.assessment.jsf.convert.AnswerSurveyConverter;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.ResourceLoader;

public class AnswerBean
implements Serializable {
    private static final long serialVersionUID = 7526471155622776147L;
    private String text;
    private Long sequence;
    private String label;
    private String feedback;
    private Boolean isCorrect;
    private String partialCredit = "0";
    private static ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorMessages");
    public static final String choiceLabels = rb.getString("choice_labels");

    public AnswerBean() {
    }

    public AnswerBean(String ptext, Long pseq, String plabel, String pfdbk, Boolean pcorr, String pgrade, Float pscore) {
        this.text = ptext;
        this.sequence = pseq;
        this.label = plabel;
        this.feedback = pfdbk;
        this.isCorrect = pcorr;
    }

    public String getText() {
        AnswerSurveyConverter conv = new AnswerSurveyConverter();
        return conv.getAsString(null, null, (Object)this.text);
    }

    public void setText(String text) {
        this.text = text;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public void setSequence(Long sequence) {
        this.sequence = sequence;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getFeedback() {
        return this.feedback;
    }

    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }

    public Boolean getIsCorrect() {
        return this.isCorrect;
    }

    public void setIsCorrect(Boolean isCorrect) {
        this.isCorrect = isCorrect;
    }

    public static String[] getChoiceLabels() {
        String[] lables = choiceLabels.split(":");
        return lables;
    }

    public AnswerBean(String ptext, Long pseq, String plabel, String pfdbk, Boolean pcorr, String pgrade, Float pscore, String pCredit) {
        this.text = ptext;
        this.sequence = pseq;
        this.label = plabel;
        this.feedback = pfdbk;
        this.isCorrect = pcorr;
        this.partialCredit = pCredit;
    }

    public String getPartialCredit() {
        return this.partialCredit;
    }

    public void setPartialCredit(String pCredit) {
        this.partialCredit = pCredit;
    }

    public void validatePartialCredit(FacesContext context, UIComponent toValidate, Object value) {
        Integer pCredit = null;
        boolean isValid = true;
        if ("0.0".equals(value.toString())) {
            pCredit = 0;
        } else {
            try {
                pCredit = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException e) {
                isValid = false;
            }
        }
        if (isValid && (pCredit == null || pCredit < 0 || pCredit > 99)) {
            isValid = false;
        }
        if (!isValid) {
            ((UIInput)toValidate).setValid(false);
            FacesMessage message = new FacesMessage();
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            String summary = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"partial_credit_limit_summary");
            String detail = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"partial_credit_limit_detail");
            message.setSummary(summary);
            message.setDetail(detail);
            context.addMessage(toValidate.getClientId(context), message);
        }
    }
}

