/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.author;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.shared.TypeService;
import org.sakaiproject.tool.assessment.ui.bean.delivery.ItemContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SectionContentsBean;

public class AssessmentBean
implements Serializable {
    private static Log log = LogFactory.getLog(AssessmentBean.class);
    private static final long serialVersionUID = -630950053380808339L;
    private AssessmentIfc assessment;
    private String assessmentId;
    private String title;
    private ArrayList sections = new ArrayList();
    private ArrayList sectionList = new ArrayList();
    private ArrayList otherSectionList = new ArrayList();
    private ArrayList partNumbers = new ArrayList();
    private int questionSize = 0;
    private float totalScore = 0.0f;
    private String newQuestionTypeId;
    private String firstSectionId;
    private boolean hasRandomDrawPart;
    private boolean showPrintLink;
    private boolean hasGradingData = false;
    private boolean hasSubmission = false;
    private boolean showPrintAssessment;

    public AssessmentIfc getAssessment() {
        return this.assessment;
    }

    public void setAssessment(AssessmentIfc assessment) {
        try {
            this.assessment = assessment;
            if (assessment instanceof AssessmentFacade) {
                this.assessmentId = assessment.getAssessmentId().toString();
            } else if (assessment instanceof PublishedAssessmentFacade) {
                this.assessmentId = ((PublishedAssessmentFacade)assessment).getPublishedAssessmentId().toString();
            }
            this.title = assessment.getTitle();
            this.sections = new ArrayList();
            ArrayList sectionArray = assessment.getSectionArraySorted();
            for (int i = 0; i < sectionArray.size(); ++i) {
                SectionDataIfc section = (SectionDataIfc)sectionArray.get(i);
                SectionContentsBean sectionBean = new SectionContentsBean(section);
                this.sections.add(sectionBean);
            }
            this.setPartNumbers();
            this.setQuestionSizeAndTotalScore();
            this.setSectionList(sectionArray);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getAssessmentId() {
        return this.assessmentId;
    }

    public void setAssessmentId(String assessmentId) {
        this.assessmentId = assessmentId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ArrayList getSections() {
        return this.sections;
    }

    public void setSections(ArrayList sections) {
        this.sections = sections;
    }

    public ArrayList getPartNumbers() {
        return this.partNumbers;
    }

    public void setPartNumbers() {
        this.partNumbers = new ArrayList();
        for (int i = 1; i <= this.sections.size(); ++i) {
            this.partNumbers.add(new SelectItem((Object)(i + "")));
        }
    }

    public int getQuestionSize() {
        return this.questionSize;
    }

    public void setQuestionSizeAndTotalScore() {
        this.questionSize = 0;
        this.totalScore = 0.0f;
        int randomPartCount = 0;
        for (int i = 0; i < this.sections.size(); ++i) {
            SectionContentsBean sectionBean = (SectionContentsBean)this.sections.get(i);
            ArrayList items = sectionBean.getItemContents();
            int itemsInThisSection = 0;
            if (sectionBean.getSectionAuthorType().equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL)) {
                ++randomPartCount;
                itemsInThisSection = sectionBean.getNumberToBeDrawn();
            } else {
                itemsInThisSection = items.size();
            }
            this.questionSize += itemsInThisSection;
            for (int j = 0; j < itemsInThisSection; ++j) {
                ItemContentsBean item = (ItemContentsBean)items.get(j);
                if (item.getItemData().getScore() == null) continue;
                this.totalScore += item.getItemData().getScore().floatValue();
            }
        }
        if (randomPartCount > 0) {
            this.setHasRandomDrawPart(true);
        } else {
            this.setHasRandomDrawPart(false);
        }
    }

    public int updateRandomPoolQuestions(String sectionId) {
        for (int i = 0; i < this.sections.size(); ++i) {
            SectionContentsBean sectionBean = (SectionContentsBean)this.sections.get(i);
            if (!sectionBean.getSectionId().equals(sectionId)) continue;
            AssessmentService assessmentService = new AssessmentService();
            int success = assessmentService.updateRandomPoolQuestions(assessmentService.getSection(sectionId));
            if (success == 0) {
                this.sections.set(i, new SectionContentsBean((SectionDataIfc)assessmentService.getSection(sectionBean.getSectionId())));
                continue;
            }
            return success;
        }
        return 0;
    }

    public float getTotalScore() {
        return this.totalScore;
    }

    public void setTotalScore(float totalScore) {
        this.totalScore = totalScore;
    }

    public String getNewQuestionTypeId() {
        return this.newQuestionTypeId;
    }

    public void setNewQuestionTypeId(String newQuestionTypeId) {
        this.newQuestionTypeId = newQuestionTypeId;
    }

    public SelectItem[] getItemTypes() {
        TypeService service = new TypeService();
        List list = service.getFacadeItemTypes();
        SelectItem[] itemTypes = new SelectItem[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            TypeIfc t = (TypeIfc)list.get(i);
            itemTypes[i] = new SelectItem((Object)t.getTypeId().toString(), t.getKeyword());
        }
        return itemTypes;
    }

    public void setSectionList(ArrayList list) {
        this.sectionList = new ArrayList();
        try {
            for (int i = 0; i < list.size(); ++i) {
                SectionDataIfc f = (SectionDataIfc)list.get(i);
                this.sectionList.add(new SelectItem((Object)f.getSectionId().toString(), f.getTitle()));
                if (i != 0) continue;
                this.firstSectionId = f.getSectionId().toString();
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
    }

    public ArrayList getSectionList() {
        return this.sectionList;
    }

    public String getFirstSectionId() {
        return this.firstSectionId;
    }

    public void setFirstSectionId(String firstSectionId) {
        this.firstSectionId = firstSectionId;
    }

    public ArrayList getOtherSectionList() {
        return this.otherSectionList;
    }

    public void setOtherSectionList(ArrayList list) {
        this.otherSectionList = list;
    }

    public boolean getHasRandomDrawPart() {
        return this.hasRandomDrawPart;
    }

    public void setHasRandomDrawPart(boolean param) {
        this.hasRandomDrawPart = param;
    }

    public boolean getShowPrintLink() {
        return this.showPrintLink;
    }

    public void setShowPrintLink(boolean showPrintLink) {
        this.showPrintLink = showPrintLink;
    }

    public boolean getHasGradingData() {
        return this.hasGradingData;
    }

    public void setHasGradingData(boolean hasGradingData) {
        this.hasGradingData = hasGradingData;
    }

    public boolean getHasSubmission() {
        return this.hasSubmission;
    }

    public void setHasSubmission(boolean hasSubmission) {
        this.hasSubmission = hasSubmission;
    }

    public boolean getShowPrintAssessment() {
        String printAssessment = ServerConfigurationService.getString((String)"samigo.printAssessment");
        return Boolean.parseBoolean(printAssessment);
    }

    public void setShowPrintAssessment(boolean showPrintAssessment) {
        this.showPrintAssessment = showPrintAssessment;
    }
}

