/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.author;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.facade.AssessmentTemplateFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.TemplateBean;
import org.sakaiproject.tool.assessment.util.BeanSort;

public class IndexBean
implements Serializable {
    private static BeanSort bs;
    private Collection templateList;
    private ArrayList sortTemplateList;
    private static final long serialVersionUID = 7919219404875270127L;
    private Collection templateNames;
    private Collection templateIds;
    private String assessmentTypeChoice;
    private String course_id;
    private String agent_id;
    private String templateOrderBy = "templateName";
    private boolean templateAscending = true;
    private boolean automaticSubmissionEnabled = false;
    private static Log log;
    private String outcome;

    public Collection getTemplateList() {
        try {
            AssessmentService delegate = new AssessmentService();
            ArrayList list = delegate.getBasicInfoOfAllActiveAssessmentTemplates("title");
            ArrayList<TemplateBean> templates = new ArrayList<TemplateBean>();
            for (AssessmentTemplateFacade facade : list) {
                TemplateBean bean = new TemplateBean();
                bean.setTemplateName(facade.getTitle());
                bean.setIdString(facade.getAssessmentBaseId().toString());
                bean.setLastModified(facade.getLastModifiedDate().toString());
                templates.add(bean);
            }
            this.templateList = templates;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.templateList = new ArrayList();
        }
        return this.templateList;
    }

    public void setTemplateList(Collection templateList) {
        this.templateList = templateList;
    }

    public ArrayList getSortTemplateList() {
        return this.sortTemplateList;
    }

    public void setSortTemplateList(ArrayList sortTemplateList) {
        this.sortTemplateList = sortTemplateList;
    }

    public Collection getTemplateNames() {
        if (this.templateNames == null) {
            this.getTemplateList();
        }
        return this.templateNames;
    }

    public void setTemplateNames(Collection names) {
        this.templateNames = names;
    }

    public Collection getTemplateIds() {
        if (this.templateIds == null) {
            this.getTemplateList();
        }
        return this.templateIds;
    }

    public void setTemplateIds(Collection ids) {
        this.templateIds = ids;
    }

    public String getAssessmentTypeChoice() {
        return this.assessmentTypeChoice;
    }

    public void setAssessmentTypeChoice(String typeChoice) {
        this.assessmentTypeChoice = typeChoice;
    }

    public String getCourseId() {
        return this.course_id;
    }

    public void setCourseId(String id) {
        log.debug((Object)("Setting course id to " + id));
        this.course_id = id;
    }

    public String getAgentId() {
        return this.agent_id;
    }

    public void setAgentId(String id) {
        log.debug((Object)("Setting agent id to " + id));
        this.agent_id = id;
    }

    public String getTemplateOrderBy() {
        return this.templateOrderBy;
    }

    public void setTemplateOrderBy(String templateOrderBy) {
        this.templateOrderBy = templateOrderBy;
    }

    public boolean isTemplateAscending() {
        return this.templateAscending;
    }

    public void setTemplateAscending(boolean templateAscending) {
        this.templateAscending = templateAscending;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public void setAutomaticSubmissionEnabled(boolean automaticSubmissionEnabled) {
        this.automaticSubmissionEnabled = automaticSubmissionEnabled;
    }

    public boolean getAutomaticSubmissionEnabled() {
        return this.automaticSubmissionEnabled;
    }

    static {
        log = LogFactory.getLog(IndexBean.class);
    }
}

