/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.author;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PublishedItemService;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AnswerBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemAuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SectionContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.questionpool.QuestionPoolBean;
import org.sakaiproject.tool.assessment.ui.listener.author.ItemAddListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.ResourceLoader;

public class ItemAuthorBean
implements Serializable {
    private static Log log = LogFactory.getLog(ItemAuthorBean.class);
    private static final long serialVersionUID = 8266438770394956874L;
    public static final String FROM_QUESTIONPOOL = "questionpool";
    public static final String FROM_ASSESSMENT = "assessment";
    private String assessTitle;
    private String sectionIdent;
    private ArrayList assessmentSectionIdents;
    private String insertPosition;
    private String insertToSection;
    private String insertType;
    private String assessmentID;
    private String currentSection;
    private String itemId;
    private String itemNo;
    private String itemType;
    private String itemTypeString;
    private String showMetadata;
    private String showOverallFeedback;
    private String showQuestionLevelFeedback;
    private String showSelectionLevelFeedback;
    private String showFeedbackAuthoring;
    private ArrayList trueFalseAnswerSelectList;
    private ItemDataIfc item;
    private ItemBean currentItem;
    private ItemFacade itemToDelete;
    private ItemFacade itemToPreview;
    private List attachmentList;
    private String qpoolId;
    private String target;
    private ArrayList poolListSelectItems;
    private boolean[] choiceCorrectArray;
    private String maxRecordingTime;
    private String maxNumberRecordings;
    private String scaleName;
    private String[] matches;
    private String[] matchAnswers;
    private String[] matchFeedbackList;
    private String[] answerFeedbackList;
    private String outcome;
    private HashMap resourceHash = new HashMap();

    public void setItem(ItemDataIfc item) {
        this.item = item;
        this.attachmentList = item.getItemAttachmentList();
    }

    public ItemDataIfc getItem() {
        return this.item;
    }

    public void setCurrentItem(ItemBean item) {
        this.currentItem = item;
    }

    public ItemBean getCurrentItem() {
        return this.currentItem;
    }

    public String getAssessTitle() {
        return this.assessTitle;
    }

    public void setAssessTitle(String string) {
        this.assessTitle = string;
    }

    public String getSectionIdent() {
        return this.sectionIdent;
    }

    public void setSectionIdent(String string) {
        this.sectionIdent = string;
    }

    public ArrayList getAssessmentSectionIdents() {
        return this.assessmentSectionIdents;
    }

    public void setAssessmentSectionIdents(ArrayList list) {
        this.assessmentSectionIdents = list;
    }

    public String getInsertPosition() {
        return this.insertPosition;
    }

    public void setInsertPosition(String string) {
        this.insertPosition = string;
    }

    public String getInsertToSection() {
        return this.insertToSection;
    }

    public void setInsertToSection(String string) {
        this.insertToSection = string;
    }

    public String getInsertType() {
        return this.insertType;
    }

    public void setInsertType(String string) {
        this.insertType = string;
    }

    public String getAssessmentID() {
        return this.assessmentID;
    }

    public void setAssessmentID(String string) {
        this.assessmentID = string;
    }

    public String getCurrentSection() {
        return this.currentSection;
    }

    public void setCurrentSection(String string) {
        this.currentSection = string;
    }

    public String getItemNo() {
        return this.itemNo;
    }

    public void setItemNo(String string) {
        this.itemNo = string;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String string) {
        this.itemId = string;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String string) {
        this.itemType = string;
    }

    public String getItemTypeString() {
        return this.itemTypeString;
    }

    public void setItemTypeString(String string) {
        this.itemTypeString = string;
    }

    public String getShowMetadata() {
        return this.showMetadata;
    }

    public void setShowMetadata(String string) {
        this.showMetadata = string;
    }

    public String getShowOverallFeedback() {
        return this.showOverallFeedback;
    }

    public String getShowQuestionLevelFeedback() {
        return this.showQuestionLevelFeedback;
    }

    public String getShowSelectionLevelFeedback() {
        return this.showSelectionLevelFeedback;
    }

    public void setShowOverallFeedback(String string) {
        this.showOverallFeedback = string;
    }

    public void setShowQuestionLevelFeedback(String string) {
        this.showQuestionLevelFeedback = string;
    }

    public void setShowSelectionLevelFeedback(String string) {
        this.showSelectionLevelFeedback = string;
    }

    public void setQpoolId(String string) {
        this.qpoolId = string;
    }

    public String getQpoolId() {
        return this.qpoolId;
    }

    public void setItemToDelete(ItemFacade param) {
        this.itemToDelete = param;
    }

    public ItemFacade getItemToDelete() {
        return this.itemToDelete;
    }

    public void setItemToPreview(ItemFacade param) {
        this.itemToPreview = param;
    }

    public ItemFacade getItemToPreview() {
        return this.itemToPreview;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean[] getChoiceCorrectArray() {
        return this.choiceCorrectArray;
    }

    public void setChoiceCorrectArray(boolean[] choiceCorrectArray) {
        this.choiceCorrectArray = choiceCorrectArray;
    }

    public boolean isCorrectChoice(int n) {
        return this.choiceCorrectArray[n];
    }

    public void setCorrectChoice(int n, boolean correctChoice) {
        this.choiceCorrectArray[n] = correctChoice;
    }

    public String getMaxRecordingTime() {
        return this.maxRecordingTime;
    }

    public void setMaxRecordingTime(String maxRecordingTime) {
        this.maxRecordingTime = maxRecordingTime;
    }

    public String getMaxNumberRecordings() {
        return this.maxNumberRecordings;
    }

    public void setMaxNumberRecordings(String maxNumberRecordings) {
        this.maxNumberRecordings = maxNumberRecordings;
    }

    public String getScaleName() {
        return this.scaleName;
    }

    public void setScaleName(String scaleName) {
        this.scaleName = scaleName;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String param) {
        this.outcome = param;
    }

    public String[] getMatches() {
        return this.matches;
    }

    public void setMatches(String[] matches) {
        this.matches = matches;
    }

    public String getMatch(int n) {
        return this.matches[n];
    }

    public void setMatch(int n, String match) {
        this.matches[n] = match;
    }

    public int[] getMatchCounter() {
        int n = this.matches.length;
        int[] count = new int[n];
        for (int i = 0; i < n; ++i) {
            count[i] = i;
        }
        return count;
    }

    public ArrayList getTrueFalseAnswerSelectList() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        String trueprop = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"true_msg");
        String falseprop = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"false_msg");
        String[] answerValues = new String[]{"true", "false"};
        String[] answerLabelText = new String[]{trueprop, falseprop};
        this.currentItem.setAnswers(answerValues);
        this.currentItem.setAnswerLabels(answerLabelText);
        for (int i = 0; i < answerValues.length; ++i) {
            SelectItem selection = new SelectItem();
            selection.setLabel(answerLabelText[i]);
            selection.setValue((Object)answerValues[i]);
            list.add(selection);
        }
        return list;
    }

    public ArrayList getSectionSelectList() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorMessages");
        AssessmentBean assessbean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        ArrayList sectionSet = assessbean.getSections();
        Iterator iter = sectionSet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ++i;
            SectionContentsBean part = (SectionContentsBean)iter.next();
            SelectItem selection = new SelectItem();
            if (part.getSectionAuthorType().equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL)) continue;
            if ("".equals(part.getTitle())) {
                selection.setLabel(rb.getString("p") + " " + i);
            } else {
                selection.setLabel(rb.getString("p") + " " + i + " - " + FormattedText.convertFormattedTextToPlaintext((String)part.getTitle()));
            }
            selection.setValue((Object)part.getSectionId());
            list.add(selection);
        }
        Collections.reverse(list);
        if (list.size() < 1) {
            SelectItem temppart = new SelectItem();
            temppart.setLabel(rb.getString("p") + " " + ++i);
            temppart.setValue((Object)"-1");
            list.add(temppart);
        }
        return list;
    }

    public ArrayList getSelectRelativeWidthList() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorMessages");
        String[] widthLists = new String[]{rb.getString("matrix_width_list_default"), rb.getString("matrix_width_list_1"), rb.getString("matrix_width_list_2"), rb.getString("matrix_width_list_3"), rb.getString("matrix_width_list_4"), rb.getString("matrix_width_list_5"), rb.getString("matrix_width_list_6"), rb.getString("matrix_width_list_7"), rb.getString("matrix_width_list_8"), rb.getString("matrix_width_list_9")};
        for (int i = 0; i < widthLists.length; ++i) {
            SelectItem selectItem = new SelectItem();
            selectItem.setLabel(widthLists[i]);
            selectItem.setValue((Object)Integer.toString(i));
            list.add(selectItem);
        }
        return list;
    }

    public Map getSectionList() {
        Hashtable<String, String> items = new Hashtable<String, String>();
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorMessages");
        AssessmentBean assessbean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        ArrayList sectionSet = assessbean.getSections();
        Iterator iter = sectionSet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ++i;
            SectionContentsBean part = (SectionContentsBean)iter.next();
            if (part.getSectionAuthorType().equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL)) continue;
            if ("".equals(part.getTitle())) {
                items.put(rb.getString("p") + " " + i, part.getSectionId());
                continue;
            }
            items.put(rb.getString("p") + " " + i + " - " + part.getTitle(), part.getSectionId());
        }
        if (items.size() < 1) {
            items.put(rb.getString("p") + " " + ++i, "-1");
        }
        return items;
    }

    public ArrayList getPoolSelectList() {
        this.poolListSelectItems = new ArrayList();
        QuestionPoolService delegate = new QuestionPoolService();
        ArrayList qplist = delegate.getBasicInfoOfAllPools(AgentFacade.getAgentString());
        Iterator iter = qplist.iterator();
        try {
            while (iter.hasNext()) {
                QuestionPoolFacade pool = (QuestionPoolFacade)iter.next();
                this.poolListSelectItems.add(new SelectItem((Object)pool.getQuestionPoolId().toString(), FormattedText.convertFormattedTextToPlaintext((String)pool.getDisplayName())));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Collections.sort(this.poolListSelectItems, new ItemComparator(this));
        return this.poolListSelectItems;
    }

    public String[] getMatchAnswers() {
        return this.matchAnswers;
    }

    public void setMatchAnswers(String[] matchAnswers) {
        this.matchAnswers = matchAnswers;
    }

    public String getMatchAnswer(int n) {
        return this.matchAnswers[n];
    }

    public void setMatchAnswer(int n, String matchAnswer) {
        this.matchAnswers[n] = matchAnswer;
    }

    public String getMatchFeedback(int n) {
        return this.matchFeedbackList[n];
    }

    public void setMatchFeedback(int n, String matchFeedback) {
        this.matchFeedbackList[n] = matchFeedback;
    }

    public String[] getMatchFeedbackList() {
        return this.matchFeedbackList;
    }

    public void setMatchFeedbackList(String[] matchFeedbackList) {
        this.matchFeedbackList = matchFeedbackList;
    }

    public String[] getAnswerFeedbackList() {
        return this.answerFeedbackList;
    }

    public void setAnswerFeedbackList(String[] answerFeedbackList) {
        this.answerFeedbackList = answerFeedbackList;
    }

    public String doit() {
        if ("searchQuestionBank".equals(this.outcome)) {
            try {
                ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
                context.redirect("sakai.questionbank.client.helper/authorIndex");
            }
            catch (Exception e) {
                log.error((Object)("fail to redirect to question bank: " + e.getMessage()));
            }
        }
        return this.outcome;
    }

    public String print() {
        try {
            AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
            ToolSession currentToolSession = SessionManager.getCurrentToolSession();
            currentToolSession.setAttribute("QB_assessemnt_id", (Object)assessmentBean.getAssessmentId());
            ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
            context.redirect("sakai.questionbank.printout.helper/printAssessment?assessmentId=" + assessmentBean.getAssessmentId() + "&actionString=previewAssessment");
        }
        catch (Exception e) {
            log.error((Object)("fail to redirect to assessment print out: " + e.getMessage()));
        }
        return this.outcome;
    }

    public String deleteItem() {
        ItemService delegate = new ItemService();
        Long deleteId = this.getItemToDelete().getItemId();
        ItemFacade itemf = delegate.getItem(deleteId, AgentFacade.getAgentString());
        SectionFacade currSection = (SectionFacade)itemf.getSection();
        Integer currSeq = itemf.getSequence();
        QuestionPoolService qpdelegate = new QuestionPoolService();
        if (qpdelegate.getPoolIdsByItem(deleteId.toString()) == null || qpdelegate.getPoolIdsByItem(deleteId.toString()).isEmpty()) {
            delegate.deleteItem(deleteId, AgentFacade.getAgentString());
        } else {
            if (currSection == null) {
                QuestionPoolBean qpoolbean = (QuestionPoolBean)ContextUtil.lookupBean((String)FROM_QUESTIONPOOL);
                ItemFacade itemfacade = delegate.getItem(deleteId, AgentFacade.getAgentString());
                ArrayList<ItemFacade> items = new ArrayList<ItemFacade>();
                items.add(itemfacade);
                qpoolbean.setItemsToDelete(items);
                qpoolbean.removeQuestionsFromPool();
                return "editPool";
            }
            itemf.setSection(null);
            delegate.saveItem(itemf);
        }
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.item.delete", (String)("/sam/" + AgentFacade.getCurrentSiteId() + "/removed itemId=" + deleteId), (boolean)true));
        AssessmentService assessdelegate = new AssessmentService();
        SectionFacade sectfacade = assessdelegate.getSection(currSection.getSectionId().toString());
        Set itemset = sectfacade.getItemFacadeSet();
        for (ItemFacade itemfacade : itemset) {
            Integer itemfacadeseq = itemfacade.getSequence();
            if (itemfacadeseq.compareTo(currSeq) <= 0) continue;
            itemfacade.setSequence(Integer.valueOf(itemfacadeseq - 1));
            delegate.saveItem(itemfacade);
        }
        AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        AssessmentFacade assessment = assessdelegate.getAssessment(assessmentBean.getAssessmentId());
        assessmentBean.setAssessment((AssessmentIfc)assessment);
        assessdelegate.updateAssessmentLastModifiedInfo((AssessmentIfc)assessment);
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.asessment.revise", (String)("/sam/" + AgentFacade.getCurrentSiteId() + "/removed itemId=" + deleteId + "from assessmentId=" + assessmentBean.getAssessmentId()), (boolean)true));
        return "editAssessment";
    }

    public String confirmDeleteItem() {
        ItemService delegate = new ItemService();
        String itemId = ContextUtil.lookupParam((String)"itemid");
        ItemFacade itemf = delegate.getItem(Long.valueOf(itemId), AgentFacade.getAgentString());
        this.setItemToDelete(itemf);
        return "removeQuestion";
    }

    public void selectItemType(ValueChangeEvent event) {
        String type = (String)event.getNewValue();
        this.setItemType(type);
    }

    public String getShowFeedbackAuthoring() {
        return this.showFeedbackAuthoring;
    }

    public void setShowFeedbackAuthoring(String string) {
        this.showFeedbackAuthoring = string;
    }

    public List getAttachmentList() {
        return this.attachmentList;
    }

    public void setAttachmentList(List attachmentList) {
        this.attachmentList = attachmentList;
    }

    public boolean getHasAttachment() {
        return this.attachmentList != null && this.attachmentList.size() > 0;
    }

    public String addAttachmentsRedirect() {
        try {
            this.prepareMCcorrAnswers();
            List filePickerList = this.prepareReferenceList(this.attachmentList);
            ToolSession currentToolSession = SessionManager.getCurrentToolSession();
            currentToolSession.setAttribute("sakaiproject.filepicker.attachments", (Object)filePickerList);
            ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
            context.redirect("sakai.filepicker.helper/tool");
        }
        catch (Exception e) {
            log.error((Object)("fail to redirect to attachment page: " + e.getMessage()));
        }
        return this.getOutcome();
    }

    public void setItemAttachment() {
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        boolean isEditPendingAssessmentFlow = author.getIsEditPendingAssessmentFlow();
        Object service = null;
        service = isEditPendingAssessmentFlow ? new ItemService() : new PublishedItemService();
        ItemFacade itemData = null;
        if (this.itemId != null) {
            try {
                itemData = service.getItem(this.itemId);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
        }
        List list = this.prepareItemAttachment(itemData, isEditPendingAssessmentFlow);
        this.setAttachmentList(list);
    }

    private List prepareReferenceList(List attachmentList) {
        ArrayList<Reference> list = new ArrayList<Reference>();
        if (attachmentList == null) {
            return list;
        }
        for (int i = 0; i < attachmentList.size(); ++i) {
            ContentResource cr = null;
            AttachmentIfc attach = (AttachmentIfc)attachmentList.get(i);
            try {
                log.debug((Object)("*** resourceId=" + attach.getResourceId()));
                cr = AssessmentService.getContentHostingService().getResource(attach.getResourceId());
            }
            catch (PermissionException e) {
                log.warn((Object)("ContentHostingService.getResource() throws PermissionException=" + e.getMessage()));
            }
            catch (IdUnusedException e) {
                log.warn((Object)("ContentHostingService.getResource() throws IdUnusedException=" + e.getMessage()));
                AssessmentService assessmentService = new AssessmentService();
                assessmentService.removeItemAttachment(attach.getAttachmentId().toString());
            }
            catch (TypeException e) {
                log.warn((Object)("ContentHostingService.getResource() throws TypeException=" + e.getMessage()));
            }
            if (cr == null) continue;
            Reference ref = EntityManager.newReference((String)cr.getReference());
            log.debug((Object)("*** ref=" + ref));
            if (ref == null) continue;
            list.add(ref);
        }
        return list;
    }

    private List prepareItemAttachment(ItemDataIfc item, boolean isEditPendingAssessmentFlow) {
        ToolSession session = SessionManager.getCurrentToolSession();
        if (session.getAttribute("sakaiproject.filepicker.attachments") != null) {
            Set attachmentSet = new HashSet();
            if (item != null) {
                attachmentSet = item.getItemAttachmentSet();
            }
            HashMap map = this.getResourceIdHash(attachmentSet);
            ArrayList<ItemAttachmentIfc> newAttachmentList = new ArrayList<ItemAttachmentIfc>();
            AssessmentService assessmentService = new AssessmentService();
            String protocol = ContextUtil.getProtocol();
            List refs = (List)session.getAttribute("sakaiproject.filepicker.attachments");
            if (refs != null && refs.size() > 0) {
                for (int i = 0; i < refs.size(); ++i) {
                    Reference ref = (Reference)refs.get(i);
                    String resourceId = ref.getId();
                    if (map.get(resourceId) == null) {
                        log.debug((Object)("**** ref.Id=" + ref.getId()));
                        log.debug((Object)("**** ref.name=" + ref.getProperties().getProperty(ref.getProperties().getNamePropDisplayName())));
                        ItemAttachmentIfc newAttach = assessmentService.createItemAttachment(item, ref.getId(), ref.getProperties().getProperty(ref.getProperties().getNamePropDisplayName()), protocol, isEditPendingAssessmentFlow);
                        newAttachmentList.add(newAttach);
                        continue;
                    }
                    newAttachmentList.add((ItemAttachmentIfc)map.get(resourceId));
                    map.remove(resourceId);
                }
            }
            session.removeAttribute("sakaiproject.filepicker.attachments");
            session.removeAttribute("sakaiproject.filepicker.cancel");
            return newAttachmentList;
        }
        if (item == null) {
            return new ArrayList();
        }
        return item.getItemAttachmentList();
    }

    private HashMap getResourceIdHash(Set attachmentSet) {
        HashMap<String, ItemAttachmentIfc> map = new HashMap<String, ItemAttachmentIfc>();
        if (attachmentSet != null) {
            for (ItemAttachmentIfc attach : attachmentSet) {
                map.put(attach.getResourceId(), attach);
            }
        }
        return map;
    }

    public HashMap getResourceHash() {
        return this.resourceHash;
    }

    public void setResourceHash(HashMap resourceHash) {
        this.resourceHash = resourceHash;
    }

    private void prepareMCcorrAnswers() {
        if (Long.valueOf(this.currentItem.getItemType()).equals(TypeFacade.MULTIPLE_CORRECT) || Long.valueOf(this.currentItem.getItemType()).equals(TypeFacade.MULTIPLE_CORRECT_SINGLE_SELECTION)) {
            ArrayList multipleChoiceAnswers = this.currentItem.getMultipleChoiceAnswers();
            if (multipleChoiceAnswers == null) {
                return;
            }
            int corrsize = multipleChoiceAnswers.size();
            String[] corrChoices = new String[corrsize];
            int counter = 0;
            boolean isCorrectChoice = false;
            String label = "";
            ItemAddListener itemAddListener = new ItemAddListener();
            for (int i = 0; i < corrsize; ++i) {
                AnswerBean answerbean = (AnswerBean)multipleChoiceAnswers.get(i);
                label = answerbean.getLabel();
                isCorrectChoice = itemAddListener.isCorrectChoice(this.currentItem, label);
                if (!isCorrectChoice) continue;
                corrChoices[counter] = label;
                ++counter;
            }
            this.currentItem.setCorrAnswers(corrChoices);
        }
    }
}

