/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.author;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.assessment.data.dao.assessment.FavoriteColChoices;
import org.sakaiproject.tool.assessment.data.dao.assessment.FavoriteColChoicesItem;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AnswerBean;
import org.sakaiproject.tool.assessment.ui.bean.author.MatchItemBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.ResourceLoader;

public class ItemBean
implements Serializable {
    private static final String answerNumbers = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static boolean partialCreditEnabledChecked = false;
    private static boolean partialCreditEnabled = false;
    private static final long serialVersionUID = 8266438770394956874L;
    private String itemText;
    private String itemId;
    private String itemType;
    private String itemScore = "0";
    private String itemDiscount = "0";
    private String partialCreditFlag = "Defualt";
    private String[] answers;
    private String[] answerLabels;
    private String[] corrAnswers;
    private String corrAnswer;
    private ArrayList multipleChoiceAnswers;
    private String additionalChoices = "0";
    private int totalMCAsnwers;
    private boolean[] choiceCorrectArray;
    private String maxRecordingTime;
    private String maxNumberRecordings;
    private String scaleName;
    private boolean multipleCorrect = false;
    private String multipleCorrectString;
    private String randomized = "false";
    private String rationale = "false";
    private String instruction;
    private ArrayList matchItemBeanList;
    private MatchItemBean currentMatchPair;
    private String[] matches;
    private String[] matchAnswers;
    private String[] matchFeedbackList;
    private String corrFeedback = "";
    private String incorrFeedback = "";
    private String generalFeedback = "";
    private String objective;
    private String keyword;
    private String rubric;
    private String timeAllowed;
    private String numAttempts;
    private String outcome;
    private String poolOutcome;
    private String selectedPool;
    private String origPool;
    private String origSection;
    private String selectedSection = "0";
    private boolean caseSensitiveForFib = false;
    private boolean mutuallyExclusiveForFib = false;
    private boolean caseSensitiveForFin = false;
    private boolean mutuallyExclusiveForFin = false;
    private boolean showMutuallyExclusiveForFibCheckbox = false;
    private boolean showMutuallyExclusiveForFinCheckbox = false;
    private String rowChoices;
    private String columnChoices;
    private boolean newFavoriteChoice = false;
    private boolean addToFavorite = false;
    private boolean addComment = false;
    private boolean forceRanking = false;
    private int relativeWidth = 0;
    private boolean newAddToFavorite = false;
    private String favoriteName = "30 character limit";
    private boolean fromFavoriteSelectOneMenu = false;
    private String commentField = "200 character limit";
    private String currentFavorite = "1";
    private boolean hasFavoriteList = false;
    private ArrayList currentFavoriteList;

    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public String getPoolOutcome() {
        return this.poolOutcome;
    }

    public void setPoolOutcome(String poolOutcome) {
        this.poolOutcome = poolOutcome;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String string) {
        this.itemId = string;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String param) {
        this.itemType = param;
    }

    public String getItemText() {
        return this.itemText;
    }

    public void setItemText(String itemText) {
        this.itemText = itemText;
    }

    public String getItemScore() {
        return this.itemScore;
    }

    public void setItemScore(String score) {
        this.itemScore = score;
    }

    public String getItemDiscount() {
        return this.itemDiscount;
    }

    public void setItemDiscount(String discount) {
        this.itemDiscount = discount.startsWith("-") ? discount.substring(1) : discount;
    }

    public String getAdditionalChoices() {
        return this.additionalChoices;
    }

    public void setAdditionalChoices(String size) {
        this.additionalChoices = size;
    }

    public String[] getAnswerLabels() {
        return this.answerLabels;
    }

    public void setAnswerLabels(String[] answers) {
        this.answerLabels = answers;
    }

    public String[] getAnswers() {
        return this.answers;
    }

    public void setAnswers(String[] answers) {
        this.answers = answers;
    }

    public String getCorrAnswer() {
        return this.corrAnswer;
    }

    public void setCorrAnswer(String answer) {
        this.corrAnswer = answer;
    }

    public String[] getCorrAnswers() {
        return this.corrAnswers;
    }

    public void setCorrAnswers(String[] answers) {
        this.corrAnswers = answers;
    }

    public int[] getAnswerCounter() {
        int n = this.answers.length;
        int[] count = new int[n];
        for (int i = 0; i < n; ++i) {
            count[i] = i;
        }
        return count;
    }

    public String getAnswer(int n) {
        return this.answers[n];
    }

    public void setAnswer(int n, String answer) {
        this.answers[n] = answer;
    }

    public String getAnswerNumber(int n) {
        StringBuilder anumbuf = new StringBuilder();
        while (n > 25) {
            anumbuf.append("X");
            n -= 25;
        }
        anumbuf.append(answerNumbers.substring(n));
        String anum = anumbuf.toString();
        return anum;
    }

    public boolean[] getChoiceCorrectArray() {
        return this.choiceCorrectArray;
    }

    public void setChoiceCorrectArray(boolean[] choiceCorrectArray) {
        this.choiceCorrectArray = choiceCorrectArray;
    }

    public boolean isCorrectChoice(String label) {
        boolean returnVal = false;
        ArrayList corranswersList = ContextUtil.paramArrayValueLike((String)"mccheckboxes");
        for (String currentcorrect : corranswersList) {
            if (currentcorrect.trim().equals(label)) {
                returnVal = true;
                break;
            }
            returnVal = false;
        }
        return returnVal;
    }

    public boolean isCorrectChoice(int n) {
        return this.choiceCorrectArray[n];
    }

    public void setCorrectChoice(int n, boolean correctChoice) {
        this.choiceCorrectArray[n] = correctChoice;
    }

    public String getMaxRecordingTime() {
        return this.maxRecordingTime;
    }

    public void setMaxRecordingTime(String maxRecordingTime) {
        this.maxRecordingTime = maxRecordingTime;
    }

    public String getMaxNumberRecordings() {
        return this.maxNumberRecordings;
    }

    public void setMaxNumberRecordings(String maxNumberRecordings) {
        this.maxNumberRecordings = maxNumberRecordings;
    }

    public String getScaleName() {
        return this.scaleName;
    }

    public void setScaleName(String scaleName) {
        this.scaleName = scaleName;
    }

    public String getIncorrFeedback() {
        return this.incorrFeedback;
    }

    public void setIncorrFeedback(String param) {
        this.incorrFeedback = param;
    }

    public String getCorrFeedback() {
        return this.corrFeedback;
    }

    public void setCorrFeedback(String param) {
        this.corrFeedback = param;
    }

    public String getGeneralFeedback() {
        return this.generalFeedback;
    }

    public void setGeneralFeedback(String param) {
        this.generalFeedback = param;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String param) {
        this.keyword = param;
    }

    public String getObjective() {
        return this.objective;
    }

    public void setObjective(String param) {
        this.objective = param;
    }

    public String getRubric() {
        return this.rubric;
    }

    public void setRubric(String param) {
        this.rubric = param;
    }

    public String getTimeAllowed() {
        return this.timeAllowed;
    }

    public void setTimeAllowed(String param) {
        this.timeAllowed = param;
    }

    public String getNumAttempts() {
        return this.numAttempts;
    }

    public void setNumAttempts(String param) {
        this.numAttempts = param;
    }

    public String getMultipleCorrectString() {
        return this.multipleCorrectString;
    }

    public void setMultipleCorrectString(String multipleCorrect) {
        this.multipleCorrectString = multipleCorrect;
    }

    public void setMultipleChoiceAnswers(ArrayList list) {
        this.multipleChoiceAnswers = list;
    }

    public void setMatchItemBeanList(ArrayList list) {
        this.matchItemBeanList = list;
    }

    public ArrayList getMatchItemBeanList() {
        return this.matchItemBeanList;
    }

    public void setCurrentMatchPair(MatchItemBean param) {
        this.currentMatchPair = param;
    }

    public MatchItemBean getCurrentMatchPair() {
        return this.currentMatchPair;
    }

    public boolean getMultipleCorrect() {
        return this.multipleCorrect;
    }

    public void setMultipleCorrect(boolean multipleCorrect) {
        this.multipleCorrect = multipleCorrect;
    }

    public String getRandomized() {
        return this.randomized;
    }

    public void setRandomized(String randomized) {
        this.randomized = randomized;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public void setInstruction(String param) {
        this.instruction = param;
    }

    public String getRationale() {
        return this.rationale;
    }

    public void setRationale(String param) {
        this.rationale = param;
    }

    public String[] getMatches() {
        return this.matches;
    }

    public void setMatches(String[] matches) {
        this.matches = matches;
    }

    public String getMatch(int n) {
        return this.matches[n];
    }

    public void setMatch(int n, String match) {
        this.matches[n] = match;
    }

    public int[] getMatchCounter() {
        int n = this.matches.length;
        int[] count = new int[n];
        for (int i = 0; i < n; ++i) {
            count[i] = i;
        }
        return count;
    }

    public String[] getMatchAnswers() {
        return this.matchAnswers;
    }

    public void setMatchAnswers(String[] matchAnswers) {
        this.matchAnswers = matchAnswers;
    }

    public String getMatchAnswer(int n) {
        return this.matchAnswers[n];
    }

    public void setMatchAnswer(int n, String matchAnswer) {
        this.matchAnswers[n] = matchAnswer;
    }

    public String getMatchFeedback(int n) {
        return this.matchFeedbackList[n];
    }

    public void setMatchFeedback(int n, String matchFeedback) {
        this.matchFeedbackList[n] = matchFeedback;
    }

    public String[] getMatchFeedbackList() {
        return this.matchFeedbackList;
    }

    public void setMatchFeedbackList(String[] matchFeedbackList) {
        this.matchFeedbackList = matchFeedbackList;
    }

    public String getSelectedSection() {
        return this.selectedSection;
    }

    public void setSelectedSection(String selectedSection) {
        this.selectedSection = selectedSection;
    }

    public String getSelectedPool() {
        return this.selectedPool;
    }

    public void setSelectedPool(String selectedPool) {
        this.selectedPool = selectedPool;
    }

    public String getOrigPool() {
        return this.origPool;
    }

    public void setOrigPool(String param) {
        this.origPool = param;
    }

    public String getOrigSection() {
        return this.origSection;
    }

    public void setOrigSection(String param) {
        this.origSection = param;
    }

    public ArrayList getMultipleChoiceAnswers() {
        ArrayList<AnswerBean> list = new ArrayList<AnswerBean>();
        if (this.multipleChoiceAnswers != null) {
            return this.multipleChoiceAnswers;
        }
        int defaultlength = 4;
        for (int i = 0; i < defaultlength; ++i) {
            AnswerBean answerbean = new AnswerBean();
            answerbean.setSequence(Long.valueOf(i + 1));
            answerbean.setLabel(AnswerBean.getChoiceLabels()[i]);
            list.add(answerbean);
        }
        this.setMultipleChoiceAnswers(list);
        return list;
    }

    public void toggleChoiceTypes(ValueChangeEvent event) {
        String type = (String)event.getNewValue();
        if (type == null || type.equals(TypeFacade.MULTIPLE_CHOICE.toString())) {
            this.setItemType(TypeFacade.MULTIPLE_CHOICE.toString());
        } else if (type.equals(TypeFacade.MULTIPLE_CORRECT_SINGLE_SELECTION.toString())) {
            this.setItemType(TypeFacade.MULTIPLE_CORRECT_SINGLE_SELECTION.toString());
        } else {
            this.setItemType(TypeFacade.MULTIPLE_CORRECT.toString());
        }
    }

    public String addChoicesAction() {
        String newvalue = this.getAdditionalChoices();
        ArrayList list = this.getMultipleChoiceAnswers();
        if (list != null) {
            int currentsize = list.size();
            int newlength = currentsize + new Integer(newvalue);
            if (newlength <= 26) {
                for (int i = currentsize; i < newlength; ++i) {
                    AnswerBean answerbean = new AnswerBean();
                    answerbean.setSequence(Long.valueOf(i + 1));
                    answerbean.setLabel(AnswerBean.getChoiceLabels()[i]);
                    list.add(answerbean);
                }
                this.setMultipleChoiceAnswers(list);
                this.setAdditionalChoices("0");
                if (TypeFacade.MULTIPLE_CORRECT.toString().equals(this.itemType) || TypeFacade.MULTIPLE_CORRECT_SINGLE_SELECTION.toString().equals(this.itemType)) {
                    ArrayList corranswersList = ContextUtil.paramArrayValueLike((String)"mccheckboxes");
                    int corrsize = corranswersList.size();
                    int counter = 0;
                    String[] corrchoices = new String[corrsize];
                    Iterator iter = corranswersList.iterator();
                    while (iter.hasNext()) {
                        String currentcorrect;
                        corrchoices[counter] = currentcorrect = (String)iter.next();
                        ++counter;
                    }
                    this.setCorrAnswers(corrchoices);
                }
            } else {
                FacesContext context = FacesContext.getCurrentInstance();
                ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorMessages");
                context.addMessage(null, new FacesMessage(rb.getString("MCanswer_outofbound_error")));
            }
        }
        return "multipleChoiceItem";
    }

    public String removeChoices() {
        String labelToRemove = ContextUtil.lookupParam((String)"answerid");
        ArrayList corranswersList = ContextUtil.paramArrayValueLike((String)"mccheckboxes");
        Object[] objArray = corranswersList.toArray();
        String[] corrAnswers = new String[objArray.length];
        ArrayList list = this.getMultipleChoiceAnswers();
        if (list == null) {
            return null;
        }
        Iterator iter = list.iterator();
        int currentindex = 0;
        int correctIndex = 0;
        boolean delete = false;
        while (iter.hasNext()) {
            AnswerBean answerbean = (AnswerBean)iter.next();
            if (answerbean.getLabel().equals(labelToRemove)) {
                iter.remove();
                delete = true;
            } else {
                answerbean.setSequence(Long.valueOf(++currentindex));
                answerbean.setLabel(AnswerBean.getChoiceLabels()[currentindex - 1]);
            }
            for (int i = 0; i < objArray.length; ++i) {
                if (labelToRemove.equals(objArray[i]) || (!delete || !AnswerBean.getChoiceLabels()[currentindex].equals(objArray[i])) && (delete || !AnswerBean.getChoiceLabels()[currentindex - 1].equals(objArray[i]))) continue;
                corrAnswers[correctIndex++] = AnswerBean.getChoiceLabels()[currentindex - 1];
            }
        }
        this.setCorrAnswers(corrAnswers);
        return null;
    }

    public String removeChoicesSingle() {
        String labelToRemove = ContextUtil.lookupParam((String)"answeridSingle");
        ArrayList corranswersList = ContextUtil.paramArrayValueLike((String)"mcradiobtn");
        Object[] objArray = corranswersList.toArray();
        String[] corrAnswers = new String[objArray.length];
        ArrayList list = this.getMultipleChoiceAnswers();
        if (list == null) {
            return null;
        }
        Iterator iter = list.iterator();
        int currentindex = 0;
        int correctIndex = 0;
        boolean delete = false;
        while (iter.hasNext()) {
            AnswerBean answerbean = (AnswerBean)iter.next();
            if (answerbean.getLabel().equals(labelToRemove)) {
                iter.remove();
                delete = true;
            } else {
                answerbean.setSequence(Long.valueOf(++currentindex));
                answerbean.setLabel(AnswerBean.getChoiceLabels()[currentindex - 1]);
            }
            for (int i = 0; i < objArray.length; ++i) {
                if (labelToRemove.equals(objArray[i]) || (!delete || !AnswerBean.getChoiceLabels()[currentindex].equals(objArray[i])) && (delete || !AnswerBean.getChoiceLabels()[currentindex - 1].equals(objArray[i]))) continue;
                corrAnswers[correctIndex++] = AnswerBean.getChoiceLabels()[currentindex - 1];
            }
        }
        this.setCorrAnswers(corrAnswers);
        if (corrAnswers.length == 0) {
            this.setCorrAnswer("");
        } else {
            this.setCorrAnswer(corrAnswers[0]);
        }
        return null;
    }

    public boolean isMatchError() {
        String choice = this.currentMatchPair.getChoice().replaceAll("<^[^(img)(IMG)]*?>", "").trim();
        String match = this.currentMatchPair.getMatch().replaceAll("<^[^(img)(IMG)]*?>", "").trim();
        if (choice == null || choice.equals("") || match == null || match.equals("")) {
            FacesContext context = FacesContext.getCurrentInstance();
            ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AuthorMessages");
            context.addMessage(null, new FacesMessage(rb.getString("match_error")));
            return true;
        }
        return false;
    }

    public String addMatchPair() {
        if (!this.isMatchError()) {
            ArrayList list = this.getMatchItemBeanList();
            MatchItemBean currpair = this.getCurrentMatchPair();
            if (!currpair.getSequence().equals(-1L)) {
                int seqno = currpair.getSequence().intValue() - 1;
                MatchItemBean newpair = (MatchItemBean)this.getMatchItemBeanList().get(seqno);
                newpair.setSequence(currpair.getSequence());
                newpair.setChoice(currpair.getChoice());
                newpair.setMatch(currpair.getMatch());
                newpair.setCorrMatchFeedback(currpair.getCorrMatchFeedback());
                newpair.setIncorrMatchFeedback(currpair.getIncorrMatchFeedback());
                newpair.setIsCorrect(Boolean.TRUE);
            } else {
                MatchItemBean newpair = new MatchItemBean();
                newpair.setChoice(currpair.getChoice());
                newpair.setMatch(currpair.getMatch());
                newpair.setCorrMatchFeedback(currpair.getCorrMatchFeedback());
                newpair.setIncorrMatchFeedback(currpair.getIncorrMatchFeedback());
                newpair.setIsCorrect(Boolean.TRUE);
                newpair.setSequence(Long.valueOf(list.size() + 1));
                list.add(newpair);
            }
            this.setMatchItemBeanList(list);
            MatchItemBean matchitem = new MatchItemBean();
            this.setCurrentMatchPair(matchitem);
        }
        return "matchingItem";
    }

    public String editMatchPair() {
        String seqnostr = ContextUtil.lookupParam((String)"sequence");
        int seqno = Integer.valueOf(seqnostr) - 1;
        MatchItemBean pairForEdit = (MatchItemBean)this.getMatchItemBeanList().get(seqno);
        this.setCurrentMatchPair(pairForEdit);
        return "matchingItem";
    }

    public String removeMatchPair() {
        String seqnostr = ContextUtil.lookupParam((String)"sequence");
        int seqno = Integer.valueOf(seqnostr) - 1;
        this.getMatchItemBeanList().remove(seqno);
        Iterator iter = this.getMatchItemBeanList().iterator();
        int i = 1;
        while (iter.hasNext()) {
            MatchItemBean apair = (MatchItemBean)iter.next();
            apair.setSequence(Long.valueOf(i));
            ++i;
        }
        MatchItemBean matchitem = new MatchItemBean();
        this.setCurrentMatchPair(matchitem);
        return "matchingItem";
    }

    public boolean getCaseSensitiveForFib() {
        return this.caseSensitiveForFib;
    }

    public void setCaseSensitiveForFib(boolean param) {
        this.caseSensitiveForFib = param;
    }

    public boolean getMutuallyExclusiveForFib() {
        return this.mutuallyExclusiveForFib;
    }

    public void setMutuallyExclusiveForFib(boolean param) {
        this.mutuallyExclusiveForFib = param;
    }

    public boolean getShowMutuallyExclusiveForFibCheckbox() {
        return this.showMutuallyExclusiveForFibCheckbox;
    }

    public void setShowMutuallyExclusiveForFibCheckbox(boolean param) {
        this.showMutuallyExclusiveForFibCheckbox = param;
    }

    public boolean getCaseSensitiveForFin() {
        return this.caseSensitiveForFin;
    }

    public void setCaseSensitiveForFin(boolean param) {
        this.caseSensitiveForFin = param;
    }

    public boolean getMutuallyExclusiveForFin() {
        return this.mutuallyExclusiveForFin;
    }

    public void setMutuallyExclusiveForFin(boolean param) {
        this.mutuallyExclusiveForFin = param;
    }

    public boolean getShowMutuallyExclusiveForFinCheckbox() {
        return this.showMutuallyExclusiveForFinCheckbox;
    }

    public void setShowMutuallyExclusiveForFinCheckbox(boolean param) {
        this.showMutuallyExclusiveForFinCheckbox = param;
    }

    public void setPartialCreditFlag(String partialCreditFlag) {
        this.partialCreditFlag = partialCreditFlag;
    }

    public String getPartialCreditFlag() {
        if (this.isPartialCreditEnabled()) {
            return this.partialCreditFlag;
        }
        return "false";
    }

    public boolean isPartialCreditEnabled() {
        if (partialCreditEnabledChecked) {
            return partialCreditEnabled;
        }
        partialCreditEnabledChecked = true;
        String partialCreditEnabledString = ServerConfigurationService.getString((String)"samigo.partialCreditEnabled");
        partialCreditEnabled = partialCreditEnabledString.equalsIgnoreCase("true");
        return partialCreditEnabled;
    }

    public void togglePartialCredit(ValueChangeEvent event) {
        String switchEvent = (String)event.getNewValue();
        if (Boolean.parseBoolean(switchEvent)) {
            this.setPartialCreditFlag("true");
            this.resetPartialCreditValues();
        } else if ("False".equalsIgnoreCase(switchEvent)) {
            this.setPartialCreditFlag("false");
        } else {
            this.setPartialCreditFlag("Default");
        }
    }

    public void resetPartialCreditValues() {
        ArrayList answersList = this.getMultipleChoiceAnswers();
        for (AnswerBean answerBean : answersList) {
            if (Integer.parseInt(answerBean.getPartialCredit()) < 100) {
                answerBean.setPartialCredit("0");
                continue;
            }
            answerBean.setPartialCredit("100");
        }
        this.setMultipleChoiceAnswers(answersList);
    }

    public String resetToDefaultGradingLogic() {
        this.partialCreditFlag = "Default";
        ArrayList answersList = this.getMultipleChoiceAnswers();
        for (AnswerBean answerBean : answersList) {
            answerBean.setPartialCredit("0");
        }
        this.setMultipleChoiceAnswers(answersList);
        return null;
    }

    public int gettotalMCAnswers() {
        return this.multipleChoiceAnswers.size();
    }

    public void settotalMCAnswers() {
        this.totalMCAsnwers = this.multipleChoiceAnswers.size();
    }

    public boolean getAddToFavorite() {
        return this.addToFavorite;
    }

    public void setAddToFavorite(boolean param) {
        if (this.newAddToFavorite) {
            this.newAddToFavorite = false;
            return;
        }
        this.addToFavorite = param;
    }

    public boolean getForceRanking() {
        return this.forceRanking;
    }

    public void setForceRanking(boolean param) {
        this.forceRanking = param;
    }

    public int getRelativeWidth() {
        return this.relativeWidth;
    }

    public void setRelativeWidth(int param) {
        this.relativeWidth = param;
    }

    public String getSelectedRelativeWidth() {
        return Integer.toString(this.relativeWidth / 10);
    }

    public void setSelectedRelativeWidth(String param) {
        this.relativeWidth = Integer.parseInt(param) * 10;
    }

    public boolean getAddComment() {
        return this.addComment;
    }

    public void setAddComment(boolean param) {
        this.addComment = param;
    }

    public String getRowChoices() {
        return this.rowChoices;
    }

    public void setRowChoices(String param) {
        StringBuilder r = new StringBuilder();
        StringTokenizer t = new StringTokenizer(param, "\n");
        while (t.hasMoreTokens()) {
            r.append(t.nextToken().trim()).append(System.getProperty("line.separator"));
        }
        this.rowChoices = r.toString();
    }

    public String getColumnChoices() {
        return this.columnChoices;
    }

    public void setColumnChoices(String param) {
        if (this.newFavoriteChoice) {
            this.newFavoriteChoice = false;
            return;
        }
        StringBuilder r = new StringBuilder();
        StringTokenizer t = new StringTokenizer(param, "\n");
        while (t.hasMoreTokens()) {
            r.append(t.nextToken().trim()).append(System.getProperty("line.separator"));
        }
        this.columnChoices = r.toString();
    }

    public String getFavoriteName() {
        return this.favoriteName;
    }

    public void setFavoriteName(String param) {
        if (this.fromFavoriteSelectOneMenu) {
            this.fromFavoriteSelectOneMenu = false;
            return;
        }
        this.favoriteName = param;
    }

    public boolean getFromFavoriteSelectOneMenu() {
        return false;
    }

    public void setFromFavoriteSelectOneMenu(boolean param) {
        this.fromFavoriteSelectOneMenu = param;
    }

    public boolean getNewFavoriteChoice() {
        return false;
    }

    public void setNewFavoriteChoice(boolean param) {
        this.newFavoriteChoice = param;
    }

    public boolean getNewAddToFavorite() {
        return false;
    }

    public void setNewAddToFavorite(boolean param) {
        this.newAddToFavorite = param;
    }

    public String getCommentField() {
        return this.commentField;
    }

    public void setCommentField(String param) {
        this.commentField = param;
    }

    public void toggleAddToFavorite(ValueChangeEvent event) {
        this.addToFavorite = (Boolean)event.getNewValue();
    }

    public void toggleAddComment(ValueChangeEvent event) {
        this.addComment = (Boolean)event.getNewValue();
    }

    public String getCurrentFavorite() {
        return this.currentFavorite;
    }

    public void setCurrentFavorite(String favorite) {
        this.currentFavorite = favorite;
    }

    public boolean getHasFavoriteList() {
        AssessmentService assessment = new AssessmentService();
        String agentId = AgentFacade.getAgentString();
        if (assessment.getFavoriteColChoicesbyAgent(agentId) != null && assessment.getFavoriteColChoicesbyAgent(agentId).size() > 0) {
            this.hasFavoriteList = true;
        }
        return this.hasFavoriteList;
    }

    public void setHasFavoriteList(boolean param) {
        this.hasFavoriteList = param;
    }

    public void setCurrentFavoriteList(String[] list) {
        if (!this.hasFavoriteList) {
            return;
        }
        if (list.length > 0) {
            this.hasFavoriteList = true;
            this.currentFavoriteList = new ArrayList();
            for (int i = 0; i < list.length; ++i) {
                this.currentFavoriteList.add(new SelectItem((Object)list[i]));
            }
        }
    }

    public ArrayList getCurrentFavoriteList() {
        AssessmentService assessment = new AssessmentService();
        String agentId = AgentFacade.getAgentString();
        List favorites = assessment.getFavoriteColChoicesbyAgent(agentId);
        if (favorites != null && favorites.size() > 0) {
            this.currentFavoriteList = new ArrayList();
            for (FavoriteColChoices choices : favorites) {
                SelectItem item = new SelectItem((Object)choices.getFavoriteName());
                this.currentFavoriteList.add(item);
            }
            return this.currentFavoriteList;
        }
        return null;
    }

    public void setColumnChoicesFromFavorite(String strFavorite) {
        StringBuffer strBuff = new StringBuffer();
        AssessmentService assessment = new AssessmentService();
        String agentId = AgentFacade.getAgentString();
        List favorites = assessment.getFavoriteColChoicesbyAgent(agentId);
        if (favorites != null && favorites.size() > 0) {
            for (FavoriteColChoices choice : favorites) {
                if (!choice.getFavoriteName().equals(strFavorite)) continue;
                Set choicesItem = new HashSet();
                choicesItem = choice.getFavoriteItems();
                FavoriteColChoicesItem[] itemArray = choicesItem.toArray(new FavoriteColChoicesItem[choicesItem.size()]);
                block1: for (int j = 0; j < itemArray.length; ++j) {
                    for (int i = 0; i < itemArray.length; ++i) {
                        FavoriteColChoicesItem item = itemArray[i];
                        if (item.getSequence() != j) continue;
                        strBuff.append(item.getChoiceText());
                        strBuff.append("\n");
                        continue block1;
                    }
                }
                this.setColumnChoices(strBuff.toString());
                this.setAddToFavorite(true);
                this.setFavoriteName(strFavorite);
                this.newFavoriteChoice = true;
                this.newAddToFavorite = true;
                this.fromFavoriteSelectOneMenu = true;
                return;
            }
        }
    }
}

