/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.authz;

import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class AuthorizationBean
implements Serializable {
    private static final long serialVersionUID = -2782949557257727817L;
    private static Log log = LogFactory.getLog(AuthorizationBean.class);
    private HashMap map = new HashMap();
    private boolean adminPrivilege = false;
    private boolean adminNewAssessmentPrivilege = false;
    private boolean adminCoreAssessmentPrivilege = false;
    private boolean adminPublishedAssessmentPrivilege = false;
    private boolean adminAssessmentPrivilege = false;
    private boolean adminTemplatePrivilege = false;
    private boolean adminQuestionPoolPrivilege = false;

    public HashMap getAuthzMap() {
        return this.map;
    }

    public boolean getAdminPrivilege() {
        return this.getPrivilege("admin_privilege");
    }

    public boolean getAdminNewAssessment() {
        return this.getPrivilege("admin_new_assessment");
    }

    public boolean getAdminCoreAssessment() {
        return this.getPrivilege("admin_core_assessment");
    }

    public boolean getAdminPublishedAssessment() {
        return this.getPrivilege("admin_published_assessment");
    }

    public boolean getAdminAssessment() {
        return this.getPrivilege("admin_assessment");
    }

    public boolean getAdminTemplate() {
        return this.getPrivilege("admin_template");
    }

    public boolean getAdminQuestionPool() {
        return this.getPrivilege("admin_questionpool");
    }

    public void addAllPrivilege(String siteId) {
        boolean p1 = this.canCreateAssessment(siteId);
        boolean p2 = this.canEditAnyAssessment(siteId);
        boolean p3 = this.canEditOwnAssessment(siteId);
        boolean p4 = this.canDeleteAnyAssessment(siteId);
        boolean p5 = this.canDeleteOwnAssessment(siteId);
        boolean p6 = this.canPublishAnyAssessment(siteId);
        boolean p7 = this.canPublishOwnAssessment(siteId);
        boolean p8 = this.canGradeAnyAssessment(siteId);
        boolean p9 = this.canGradeOwnAssessment(siteId);
        boolean p10 = this.canCreateQuestionPool(siteId);
        boolean p11 = this.canEditOwnQuestionPool(siteId);
        boolean p12 = this.canDeleteOwnQuestionPool(siteId);
        boolean p13 = this.canCopyOwnQuestionPool(siteId);
        boolean p14 = this.canCreateTemplate(siteId);
        boolean p15 = this.canEditOwnTemplate(siteId);
        boolean p16 = this.canDeleteOwnTemplate(siteId);
        this.canTakeAssessment(siteId);
        this.canSubmitAssessmentForGrade(siteId);
        this.adminNewAssessmentPrivilege = p1;
        this.addAdminPrivilege(this.adminNewAssessmentPrivilege, "admin_new_assessment", siteId);
        this.adminCoreAssessmentPrivilege = p2 || p3 || p4 || p5 || p6 || p7;
        this.addAdminPrivilege(this.adminCoreAssessmentPrivilege, "admin_core_assessment", siteId);
        this.adminPublishedAssessmentPrivilege = p8 || p9;
        this.addAdminPrivilege(this.adminPublishedAssessmentPrivilege, "admin_published_assessment", siteId);
        this.adminAssessmentPrivilege = p1 || p2 || p3 || p4 || p5 || p6 || p7 || p8 || p9;
        this.addAdminPrivilege(this.adminAssessmentPrivilege, "admin_assessment", siteId);
        this.adminQuestionPoolPrivilege = p10 || p11 || p12 || p13;
        this.addAdminPrivilege(this.adminQuestionPoolPrivilege, "admin_questionpool", siteId);
        this.adminTemplatePrivilege = p14 || p15 || p16;
        this.addAdminPrivilege(this.adminTemplatePrivilege, "admin_template", siteId);
        this.adminPrivilege = this.adminAssessmentPrivilege || this.adminQuestionPoolPrivilege || this.adminTemplatePrivilege;
        this.addAdminPrivilege(this.adminPrivilege, "admin_privilege", siteId);
    }

    public boolean canTakeAssessment(String siteId) {
        return this.addPrivilege("take_assessment", siteId);
    }

    public boolean canSubmitAssessmentForGrade(String siteId) {
        return this.addPrivilege("submit_assessment_for_grade", siteId);
    }

    public boolean canCreateAssessment(String siteId) {
        return this.addPrivilege("create_assessment", siteId);
    }

    public boolean canEditAnyAssessment(String siteId) {
        return this.addPrivilege("edit_any_assessment", siteId);
    }

    public boolean canEditOwnAssessment(String siteId) {
        return this.addPrivilege("edit_own_assessment", siteId);
    }

    public boolean canDeleteAnyAssessment(String siteId) {
        return this.addPrivilege("delete_any_assessment", siteId);
    }

    public boolean canDeleteOwnAssessment(String siteId) {
        return this.addPrivilege("delete_own_assessment", siteId);
    }

    public boolean canPublishAnyAssessment(String siteId) {
        return this.addPrivilege("publish_any_assessment", siteId);
    }

    public boolean canPublishOwnAssessment(String siteId) {
        return this.addPrivilege("publish_own_assessment", siteId);
    }

    public boolean canGradeAnyAssessment(String siteId) {
        return this.addPrivilege("grade_any_assessment", siteId);
    }

    public boolean canGradeOwnAssessment(String siteId) {
        return this.addPrivilege("grade_own_assessment", siteId);
    }

    public boolean canCreateQuestionPool(String siteId) {
        return this.addPrivilege("create_questionpool", siteId);
    }

    public boolean canEditOwnQuestionPool(String siteId) {
        return this.addPrivilege("edit_own_questionpool", siteId);
    }

    public boolean canDeleteOwnQuestionPool(String siteId) {
        return this.addPrivilege("delete_own_questionpool", siteId);
    }

    public boolean canCopyOwnQuestionPool(String siteId) {
        return this.addPrivilege("copy_own_questionpool", siteId);
    }

    public boolean canCreateTemplate(String siteId) {
        return this.addPrivilege("create_template", siteId);
    }

    public boolean canEditOwnTemplate(String siteId) {
        return this.addPrivilege("edit_own_template", siteId);
    }

    public boolean canDeleteOwnTemplate(String siteId) {
        return this.addPrivilege("delete_own_template", siteId);
    }

    public boolean addPrivilege(String functionKey, String siteId) {
        String functionName = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthzPermissions", (String)functionKey);
        boolean privilege = PersistenceService.getInstance().getAuthzQueriesFacade().hasPrivilege(functionName);
        this.map.put(functionName + "_" + siteId, privilege);
        return privilege;
    }

    public void addAdminPrivilege(boolean privilege, String functionKey, String siteId) {
        String functionName = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthzPermissions", (String)functionKey);
        this.map.put(functionName + "_" + siteId, privilege);
    }

    public boolean getTakeAssessment() {
        return this.getPrivilege("take_assessment");
    }

    public boolean getSubmitAssessmentForGrade() {
        return this.getPrivilege("submit_assessment_for_grade");
    }

    public boolean getCreateAssessment() {
        return this.getPrivilege("create_assessment");
    }

    public boolean getEditAnyAssessment() {
        return this.getPrivilege("edit_any_assessment");
    }

    public boolean getEditOwnAssessment() {
        return this.getPrivilege("edit_own_assessment");
    }

    public boolean getDeleteAnyAssessment() {
        return this.getPrivilege("delete_any_assessment");
    }

    public boolean getDeleteOwnAssessment() {
        return this.getPrivilege("delete_own_assessment");
    }

    public boolean getPublishAnyAssessment() {
        return this.getPrivilege("publish_any_assessment");
    }

    public boolean getPublishOwnAssessment() {
        return this.getPrivilege("publish_own_assessment");
    }

    public boolean getGradeAnyAssessment() {
        boolean priv = this.getPrivilege("grade_any_assessment");
        return priv;
    }

    public boolean getGradeOwnAssessment() {
        boolean priv = this.getPrivilege("grade_own_assessment");
        return priv;
    }

    public boolean getCreateQuestionPool() {
        return this.getPrivilege("create_questionpool");
    }

    public boolean getEditOwnQuestionPool() {
        return this.getPrivilege("edit_own_questionpool");
    }

    public boolean getDeleteOwnQuestionPool() {
        return this.getPrivilege("delete_own_questionpool");
    }

    public boolean getCopyOwnQuestionPool() {
        return this.getPrivilege("copy_own_questionpool");
    }

    public boolean getCreateTemplate() {
        return this.getPrivilege("create_template");
    }

    public boolean getEditOwnTemplate() {
        return this.getPrivilege("edit_own_template");
    }

    public boolean getDeleteOwnTemplate() {
        return this.getPrivilege("delete_own_template");
    }

    public boolean getPrivilege(String functionKey) {
        String siteId = AgentFacade.getCurrentSiteId();
        String functionName = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthzPermissions", (String)functionKey);
        boolean privilege = false;
        Object o = this.map.get(functionName + "_" + siteId);
        if (o != null) {
            privilege = (Boolean)o;
        }
        return privilege;
    }

    public boolean getGradeAnyAssessment(HttpServletRequest req, String siteId) {
        return this.getPrivilege(req, "grade_any_assessment", siteId);
    }

    public boolean getGradeOwnAssessment(HttpServletRequest req, String siteId) {
        return this.getPrivilege(req, "grade_own_assessment", siteId);
    }

    public boolean getPrivilege(HttpServletRequest req, String functionKey, String siteId) {
        String functionName = ContextUtil.getLocalizedString((HttpServletRequest)req, (String)"org.sakaiproject.tool.assessment.bundle.AuthzPermissions", (String)functionKey);
        boolean privilege = false;
        Object o = this.map.get(functionName + "_" + siteId);
        if (o != null) {
            privilege = (Boolean)o;
        }
        return privilege;
    }
}

