/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.delivery;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.event.cover.NotificationService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.assessment.api.SamigoApiFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemText;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSecuredIPAddress;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.MediaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.AssessmentGradingIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.FinFormatException;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.SaLengthException;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.shared.api.assessment.SecureDeliveryServiceAPI;
import org.sakaiproject.tool.assessment.ui.bean.delivery.ContentsDeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.FeedbackComponent;
import org.sakaiproject.tool.assessment.ui.bean.delivery.ItemContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SectionContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SelectionBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SettingsDeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.shared.PersonBean;
import org.sakaiproject.tool.assessment.ui.bean.util.Validator;
import org.sakaiproject.tool.assessment.ui.listener.delivery.BeginDeliveryActionListener;
import org.sakaiproject.tool.assessment.ui.listener.delivery.DeliveryActionListener;
import org.sakaiproject.tool.assessment.ui.listener.delivery.LinearAccessDeliveryActionListener;
import org.sakaiproject.tool.assessment.ui.listener.delivery.SubmitToGradingActionListener;
import org.sakaiproject.tool.assessment.ui.listener.select.SelectActionListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.ui.listener.util.TimeUtil;
import org.sakaiproject.tool.assessment.ui.model.delivery.TimedAssessmentGradingModel;
import org.sakaiproject.tool.assessment.ui.queue.delivery.TimedAssessmentQueue;
import org.sakaiproject.tool.assessment.ui.web.session.SessionUtil;
import org.sakaiproject.tool.assessment.util.MimeTypesLocator;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.util.ResourceLoader;

public class DeliveryBean
implements Serializable {
    private static Log log = LogFactory.getLog(DeliveryBean.class);
    private String assessmentId;
    private String assessmentTitle;
    private ArrayList markedForReview;
    private ArrayList blankItems;
    private ArrayList markedForReviewIdents;
    private ArrayList blankItemIdents;
    private boolean reviewMarked;
    private boolean reviewAll;
    private boolean reviewBlank;
    private boolean displayMardForReview;
    private int itemIndex;
    private int size;
    private String action;
    private Date beginTime;
    private String endTime;
    private String currentTime;
    private String multipleAttempts;
    private String timeOutSubmission;
    private String submissionTicket;
    private String timeElapse;
    private String username;
    private int sectionIndex;
    private boolean previous;
    private String duration;
    private String url;
    private String confirmation;
    private String outcome;
    private String questionLayout;
    private String navigation;
    private String numbering;
    private String feedback;
    private String noFeedback;
    private String statistics;
    private String creatorName;
    private FeedbackComponent feedbackComponent;
    private String feedbackComponentOption;
    private boolean feedbackOnDate;
    private String errorMessage;
    private SettingsDeliveryBean settings;
    private Date dueDate;
    private Date retractDate;
    private boolean statsAvailable;
    private boolean submitted;
    private boolean graded;
    private String graderComment;
    private String rawScore;
    private String grade;
    private Date submissionDate;
    private Date submissionTime;
    private String image;
    private boolean hasImage;
    private String instructorMessage;
    private String courseName;
    private String timeLimit;
    private int timeLimit_hour;
    private int timeLimit_minute;
    private ContentsDeliveryBean tableOfContents;
    private String submissionId;
    private String submissionMessage;
    private String instructorName;
    private ContentsDeliveryBean pageContents;
    private int submissionsRemaining;
    private int totalSubmissions;
    private boolean forGrade;
    private String password;
    private int numberRetake;
    private int actualNumberRetake;
    private HashMap itemContentsMap;
    private int partIndex;
    private int questionIndex;
    private boolean next_page;
    private boolean reload = true;
    private boolean notTakeable = true;
    private boolean pastDue;
    private long subTime;
    private long raw;
    private String takenHours;
    private String takenMinutes;
    private AssessmentGradingData adata;
    private PublishedAssessmentFacade publishedAssessment;
    private Date feedbackDate;
    private String feedbackDelivery;
    private String showScore;
    private boolean hasTimeLimit;
    private boolean isMoreThanOneQuestion;
    private Integer scoringType;
    private boolean anonymousLogin = false;
    private String contextPath;
    private boolean initAgentAccessString = false;
    private String timerId = null;
    private static final long serialVersionUID = -1090852048737428722L;
    private boolean showStudentScore;
    private boolean showStudentQuestionScore;
    private boolean timeRunning;
    private String javaScriptEnabledCheck;
    private String siteId;
    private boolean beginAssessment;
    private AgentFacade deliveryAgent;
    private String display_dayDateFormat = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"output_day_date_no_sec");
    private SimpleDateFormat dayDisplayFormat = new SimpleDateFormat(this.display_dayDateFormat, new ResourceLoader().getLocale());
    private String display_dateFormat = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"output_date_no_sec");
    private SimpleDateFormat displayFormat = new SimpleDateFormat(this.display_dateFormat, new ResourceLoader().getLocale());
    private boolean noQuestions = false;
    private Long assessmentGradingId;
    private boolean fromTableOfContents;
    private int fileUploadSizeMax;
    private boolean studentRichText;
    private boolean isAnyInvalidFinInput;
    private String redrawAnchorName;
    private boolean blockDelivery = false;
    private String secureDeliveryHTMLFragment;
    private boolean isFromPrint;
    public static final int TAKE_ASSESSMENT = 1;
    public static final int PREVIEW_ASSESSMENT = 2;
    public static final int REVIEW_ASSESSMENT = 3;
    public static final int GRADE_ASSESSMENT = 4;
    public static final int TAKE_ASSESSMENT_VIA_URL = 5;
    private int actionMode;
    private String actionString;
    private long time = 0L;
    private String timeElapseAfterFileUpload;
    private float timeElapseFloat = 0.0f;
    private float timeElapseAfterFileUploadFloat;
    private String protocol;
    private long timeStamp;
    private HashMap publishedItemHash = new HashMap();
    private HashMap publishedItemTextHash = new HashMap();
    private HashMap publishedAnswerHash = new HashMap();
    private List attachmentList;
    private boolean hasAttachment = false;

    public DeliveryBean() {
        this.deliveryAgent = new AgentFacade();
    }

    public int getItemIndex() {
        return this.itemIndex;
    }

    public void setItemIndex(int itemIndex) {
        this.itemIndex = itemIndex;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getAssessmentId() {
        return this.assessmentId;
    }

    public void setAssessmentId(String assessmentId) {
        this.assessmentId = assessmentId;
    }

    public ArrayList getMarkedForReview() {
        return this.markedForReview;
    }

    public void setMarkedForReview(ArrayList markedForReview) {
        this.markedForReview = markedForReview;
    }

    public boolean getReviewMarked() {
        return this.reviewMarked;
    }

    public void setReviewMarked(boolean reviewMarked) {
        this.reviewMarked = reviewMarked;
    }

    public boolean getReviewAll() {
        return this.reviewAll;
    }

    public void setReviewAll(boolean reviewAll) {
        this.reviewAll = reviewAll;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(String currentTime) {
        this.currentTime = currentTime;
    }

    public String getMultipleAttempts() {
        return this.multipleAttempts;
    }

    public void setMultipleAttempts(String multipleAttempts) {
        this.multipleAttempts = multipleAttempts;
    }

    public String getTimeOutSubmission() {
        return this.timeOutSubmission;
    }

    public void setTimeOutSubmission(String timeOutSubmission) {
        this.timeOutSubmission = timeOutSubmission;
    }

    public Date getSubmissionTime() {
        return this.submissionTime;
    }

    public void setSubmissionTime(Date submissionTime) {
        this.submissionTime = submissionTime;
    }

    public String getTimeElapse() {
        return this.timeElapse;
    }

    public void setTimeElapse(String timeElapse) {
        try {
            if (timeElapse != null && !"".equals(timeElapse) && this.getTimeLimit() != null && !"".equals(this.getTimeLimit())) {
                float elapsed;
                float limit = new Float(this.getTimeLimit()).floatValue();
                this.timeElapse = limit > (elapsed = new Float(timeElapse).floatValue()) ? timeElapse : this.getTimeLimit();
                this.setTimeElapseFloat(new Float(timeElapse).floatValue());
            }
        }
        catch (Exception e) {
            log.warn((Object)("setTimeElapse error:" + e.getMessage()));
        }
    }

    public String getSubmissionTicket() {
        return this.submissionTicket;
    }

    public void setSubmissionTicket(String submissionTicket) {
        this.submissionTicket = submissionTicket;
    }

    public int getDisplayIndex() {
        return this.itemIndex + 1;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getAssessmentTitle() {
        return this.assessmentTitle;
    }

    public void setAssessmentTitle(String assessmentTitle) {
        this.assessmentTitle = assessmentTitle;
    }

    public ArrayList getBlankItems() {
        return this.blankItems;
    }

    public void setBlankItems(ArrayList blankItems) {
        this.blankItems = blankItems;
    }

    public boolean getReviewBlank() {
        return this.reviewBlank;
    }

    public void setReviewBlank(boolean reviewBlank) {
        this.reviewBlank = reviewBlank;
    }

    public ArrayList getMarkedForReviewIdents() {
        return this.markedForReviewIdents;
    }

    public void setMarkedForReviewIdents(ArrayList markedForReviewIdents) {
        this.markedForReviewIdents = markedForReviewIdents;
    }

    public ArrayList getBlankItemIdents() {
        return this.blankItemIdents;
    }

    public void setBlankItemIdents(ArrayList blankItemIdents) {
        this.blankItemIdents = blankItemIdents;
    }

    public int getSectionIndex() {
        return this.sectionIndex;
    }

    public void setSectionIndex(int sectionIndex) {
        this.sectionIndex = sectionIndex;
    }

    public boolean getPrevious() {
        return this.previous;
    }

    public void setPrevious(boolean previous) {
        this.previous = previous;
    }

    public String getQuestionLayout() {
        return this.questionLayout;
    }

    public void setQuestionLayout(String questionLayout) {
        this.questionLayout = questionLayout;
    }

    public String getNavigation() {
        return this.navigation;
    }

    public void setNavigation(String navigation) {
        this.navigation = navigation;
    }

    public String getNumbering() {
        return this.numbering;
    }

    public void setNumbering(String numbering) {
        this.numbering = numbering;
    }

    public String getFeedback() {
        return this.feedback;
    }

    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }

    public String getNoFeedback() {
        return this.noFeedback;
    }

    public void setNoFeedback(String noFeedback) {
        this.noFeedback = noFeedback;
    }

    public String getStatistics() {
        return this.statistics;
    }

    public void setStatistics(String statistics) {
        this.statistics = statistics;
    }

    public FeedbackComponent getFeedbackComponent() {
        return this.feedbackComponent;
    }

    public void setFeedbackComponent(FeedbackComponent feedbackComponent) {
        this.feedbackComponent = feedbackComponent;
    }

    public String getFeedbackComponentOption() {
        return this.feedbackComponentOption;
    }

    public void setFeedbackComponentOption(String feedbackComponentOption) {
        this.feedbackComponentOption = feedbackComponentOption;
    }

    public SettingsDeliveryBean getSettings() {
        if (this.settings == null) {
            Session session = SessionManager.getCurrentSession();
            StringBuilder sb = new StringBuilder(400);
            sb.append("SAM-1438 - Delivery settings bean is null.\n");
            if (session != null) {
                sb.append("         - User EID  : ").append(session.getUserEid()).append("\n");
                sb.append("         - User ID   : ").append(session.getUserId()).append("\n");
                sb.append("         - Session ID: ").append(session.getId()).append("\n");
            } else {
                sb.append("         - Session is null. Cannot determine user.\n");
            }
            sb.append("         - Published Assessment ID: ");
            if (this.publishedAssessment == null) {
                sb.append("<null>\n");
            } else {
                sb.append(this.publishedAssessment.getPublishedAssessmentId()).append("\n");
                sb.append("         - Assessment Title       : ").append(this.publishedAssessment.getTitle()).append("\n");
                sb.append("         - Assessment Site ID     : ").append(this.publishedAssessment.getOwnerSiteId());
                BeginDeliveryActionListener listener = new BeginDeliveryActionListener();
                listener.populateBeanFromPub(this, this.publishedAssessment);
            }
            log.warn((Object)sb.toString());
        }
        return this.settings;
    }

    public void setSettings(SettingsDeliveryBean settings) {
        this.settings = settings;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String string) {
        this.duration = string;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String string) {
        this.creatorName = string;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public String getDueDateString() {
        String dateString = "";
        if (this.dueDate == null) {
            return dateString;
        }
        try {
            TimeUtil tu = new TimeUtil();
            dateString = tu.getDisplayDateTime(this.displayFormat, this.dueDate);
        }
        catch (Exception ex) {
            log.warn((Object)"Unable to format date.");
            ex.printStackTrace();
        }
        return dateString;
    }

    public String getDayDueDateString() {
        String dateString = "";
        if (this.dueDate == null) {
            return dateString;
        }
        try {
            TimeUtil tu = new TimeUtil();
            dateString = tu.getDisplayDateTime(this.dayDisplayFormat, this.dueDate);
        }
        catch (Exception ex) {
            log.warn((Object)"Unable to format date.");
            ex.printStackTrace();
        }
        return dateString;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getRetractDate() {
        return this.retractDate;
    }

    public void setRetractDate(Date retractDate) {
        this.retractDate = retractDate;
    }

    public boolean isStatsAvailable() {
        return this.statsAvailable;
    }

    public void setStatsAvailable(boolean statsAvailable) {
        this.statsAvailable = statsAvailable;
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(boolean submitted) {
        this.submitted = submitted;
    }

    public boolean isGraded() {
        return this.graded;
    }

    public void setGraded(boolean graded) {
        this.graded = graded;
    }

    public boolean getFeedbackOnDate() {
        return this.feedbackOnDate;
    }

    public void setFeedbackOnDate(boolean feedbackOnDate) {
        this.feedbackOnDate = feedbackOnDate;
    }

    public String getGraderComment() {
        if (this.graderComment == null) {
            return "";
        }
        return this.graderComment;
    }

    public void setGraderComment(String newComment) {
        this.graderComment = newComment;
    }

    public String getRawScore() {
        return this.rawScore;
    }

    public String getRoundedRawScore() {
        try {
            String newscore = ContextUtil.getRoundedValue((String)this.rawScore, (int)2);
            return Validator.check((String)newscore, (String)"N/A");
        }
        catch (Exception e) {
            return Validator.check((String)this.rawScore, (String)"0");
        }
    }

    public String getRoundedRawScoreViaURL() {
        this.rawScore = this.adata.getFinalScore() != null ? this.adata.getFinalScore().toString() : "0";
        try {
            String newscore = ContextUtil.getRoundedValue((String)this.rawScore, (int)2);
            return Validator.check((String)newscore, (String)"N/A");
        }
        catch (Exception e) {
            return Validator.check((String)this.rawScore, (String)"0");
        }
    }

    public void setRawScore(String rawScore) {
        this.rawScore = rawScore;
    }

    public long getRaw() {
        return this.raw;
    }

    public void setRaw(long raw) {
        this.raw = raw;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public Date getSubmissionDate() {
        return this.submissionDate;
    }

    public String getSubmissionDateString() {
        String dateString = "";
        if (this.submissionDate == null) {
            return dateString;
        }
        try {
            TimeUtil tu = new TimeUtil();
            dateString = tu.getDisplayDateTime(this.displayFormat, this.submissionDate);
        }
        catch (Exception ex) {
            log.warn((Object)"Unable to format date.");
            ex.printStackTrace();
        }
        return dateString;
    }

    public void setSubmissionDate(Date submissionDate) {
        this.submissionDate = submissionDate;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public boolean isHasImage() {
        return this.hasImage;
    }

    public void setHasImage(boolean hasImage) {
        this.hasImage = hasImage;
    }

    public String getInstructorMessage() {
        return this.instructorMessage;
    }

    public void setInstructorMessage(String instructorMessage) {
        this.instructorMessage = instructorMessage;
    }

    public String getCourseName() {
        return this.courseName;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
    }

    public String getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(String timeLimit) {
        this.timeLimit = timeLimit;
    }

    public int getTimeLimit_hour() {
        return this.timeLimit_hour;
    }

    public void setTimeLimit_hour(int timeLimit_hour) {
        this.timeLimit_hour = timeLimit_hour;
    }

    public int getTimeLimit_minute() {
        return this.timeLimit_minute;
    }

    public void setTimeLimit_minute(int timeLimit_minute) {
        this.timeLimit_minute = timeLimit_minute;
    }

    public ContentsDeliveryBean getTableOfContents() {
        return this.tableOfContents;
    }

    public void setTableOfContents(ContentsDeliveryBean tableOfContents) {
        this.tableOfContents = tableOfContents;
    }

    public ContentsDeliveryBean getPageContents() {
        return this.pageContents;
    }

    public void setPageContents(ContentsDeliveryBean pageContents) {
        this.pageContents = pageContents;
    }

    public String getSubmissionId() {
        return this.submissionId;
    }

    public void setSubmissionId(String submissionId) {
        this.submissionId = submissionId;
    }

    public String getSubmissionMessage() {
        return this.submissionMessage;
    }

    public void setSubmissionMessage(String submissionMessage) {
        this.submissionMessage = submissionMessage;
    }

    public int getSubmissionsRemaining() {
        return this.submissionsRemaining;
    }

    public void setSubmissionsRemaining(int submissionsRemaining) {
        this.submissionsRemaining = submissionsRemaining;
    }

    public int getTotalSubmissions() {
        return this.totalSubmissions;
    }

    public void setTotalSubmissions(int totalSubmissions) {
        this.totalSubmissions = totalSubmissions;
    }

    public String getInstructorName() {
        return this.instructorName;
    }

    public void setInstructorName(String instructorName) {
        this.instructorName = instructorName;
    }

    public boolean getForGrade() {
        return this.forGrade;
    }

    public void setForGrade(boolean newfor) {
        this.forGrade = newfor;
    }

    public String submitForGradeFromTimer() {
        return this.submitForGrade(true);
    }

    public String submitForGrade() {
        return this.submitForGrade(false);
    }

    private String submitForGrade(boolean isFromTimer) {
        String moduleId;
        String siteId;
        PublishedAssessmentService publishedAssessmentService;
        if (this.actionMode == 2) {
            return "editAssessment";
        }
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.submit.click_sub", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", submissionId=" + this.adata.getAssessmentGradingId()), (String)this.siteId, (boolean)true, (int)NotificationService.NOTI_REQUIRED));
        String nextAction = this.checkBeforeProceed(true, isFromTimer);
        log.debug((Object)("***** next Action=" + nextAction));
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.submit.checked", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", submissionId=" + this.adata.getAssessmentGradingId()), (String)this.siteId, (boolean)true, (int)NotificationService.NOTI_REQUIRED));
        if (!"safeToProceed".equals(nextAction)) {
            return nextAction;
        }
        this.setForGrade(true);
        SessionUtil.setSessionTimeout((FacesContext)FacesContext.getCurrentInstance(), (DeliveryBean)this, (boolean)false);
        this.syncTimeElapsedWithServer();
        SubmitToGradingActionListener listener = new SubmitToGradingActionListener();
        try {
            listener.processAction(null);
        }
        catch (FinFormatException e) {
            log.debug((Object)e.getMessage());
            return "takeAssessment";
        }
        catch (SaLengthException sae) {
            log.debug((Object)sae.getMessage());
            return "takeAssessment";
        }
        if (!"1".equals(this.navigation)) {
            GradingService gradingService = new GradingService();
            gradingService.completeItemGradingData(this.adata);
        }
        String returnValue = "submitAssessment";
        if (!isFromTimer) {
            if (this.actionMode == 5) {
                returnValue = "anonymousThankYou";
                publishedAssessmentService = new PublishedAssessmentService();
                siteId = publishedAssessmentService.getPublishedAssessmentOwner(this.adata.getPublishedAssessmentId());
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.submit.via_url", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", submissionId=" + this.adata.getAssessmentGradingId()), (String)siteId, (boolean)true, (int)NotificationService.NOTI_REQUIRED));
            } else {
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.submit", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", submissionId=" + this.adata.getAssessmentGradingId()), (boolean)true));
            }
        } else if (this.actionMode == 5) {
            returnValue = "anonymousThankYou";
            publishedAssessmentService = new PublishedAssessmentService();
            siteId = publishedAssessmentService.getPublishedAssessmentOwner(this.adata.getPublishedAssessmentId());
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.timer_submit.url", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", submissionId=" + this.adata.getAssessmentGradingId()), (String)siteId, (boolean)true, (int)NotificationService.NOTI_REQUIRED));
        } else {
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.timer_submit", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", submissionId=" + this.adata.getAssessmentGradingId()), (boolean)true));
        }
        this.forGrade = false;
        SelectActionListener l2 = new SelectActionListener();
        l2.processAction(null);
        this.reload = true;
        this.removeTimedAssessmentFromQueue();
        this.setSecureDeliveryHTMLFragment("");
        this.setBlockDelivery(false);
        SecureDeliveryServiceAPI secureDelivery = SamigoApiFactory.getInstance().getSecureDeliveryServiceAPI();
        if (secureDelivery.isSecureDeliveryAvaliable() && (moduleId = this.publishedAssessment.getAssessmentMetaDataByLabel("SECURE_DELIVERY_MODULE_KEY")) != null && !"SECURE_DELIVERY_NONE_ID".equals(moduleId)) {
            HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
            SecureDeliveryServiceAPI.PhaseStatus status = secureDelivery.validatePhase(moduleId, SecureDeliveryServiceAPI.Phase.ASSESSMENT_FINISH, (PublishedAssessmentIfc)this.publishedAssessment, request);
            this.setSecureDeliveryHTMLFragment(secureDelivery.getHTMLFragment(moduleId, (PublishedAssessmentIfc)this.publishedAssessment, request, SecureDeliveryServiceAPI.Phase.ASSESSMENT_FINISH, status, new ResourceLoader().getLocale()));
        }
        return returnValue;
    }

    public String confirmSubmit() {
        if (this.actionMode == 1 || this.actionMode == 5) {
            if (this.adata != null) {
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.submit.from_last_page", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", submissionId=" + this.adata.getAssessmentGradingId()), (String)this.siteId, (boolean)true, (int)NotificationService.NOTI_REQUIRED));
            } else {
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.submit.from_last_page", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", adata is null"), (String)this.siteId, (boolean)true, (int)NotificationService.NOTI_REQUIRED));
            }
        }
        String nextAction = this.checkBeforeProceed();
        log.debug((Object)("***** next Action=" + nextAction));
        if (!"safeToProceed".equals(nextAction)) {
            return nextAction;
        }
        this.setForGrade(false);
        if (this.actionMode == 1 || this.actionMode == 5) {
            this.syncTimeElapsedWithServer();
            SubmitToGradingActionListener listener = new SubmitToGradingActionListener();
            try {
                listener.processAction(null);
            }
            catch (FinFormatException fine) {
                log.debug((Object)fine.getMessage());
                return "takeAssessment";
            }
            catch (SaLengthException sae) {
                log.debug((Object)sae.getMessage());
                return "takeAssessment";
            }
        }
        DeliveryActionListener l2 = new DeliveryActionListener();
        l2.processAction(null);
        return "confirmsubmit";
    }

    public String confirmSubmitTOC() {
        if (this.actionMode == 1 || this.actionMode == 5) {
            if (this.adata != null) {
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.submit.from_toc", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", submissionId=" + this.adata.getAssessmentGradingId()), (String)this.siteId, (boolean)true, (int)NotificationService.NOTI_REQUIRED));
            } else {
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.submit.from_toc", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", adata is null"), (String)this.siteId, (boolean)true, (int)NotificationService.NOTI_REQUIRED));
            }
        }
        String nextAction = this.checkBeforeProceed();
        log.debug((Object)("***** next Action=" + nextAction));
        if (!"safeToProceed".equals(nextAction)) {
            return nextAction;
        }
        this.setForGrade(false);
        if (this.actionMode == 1 || this.actionMode == 5) {
            this.syncTimeElapsedWithServer();
            SubmitToGradingActionListener listener = new SubmitToGradingActionListener();
            try {
                listener.processAction(null);
            }
            catch (FinFormatException e) {
                log.debug((Object)e.getMessage());
                return "takeAssessment";
            }
            catch (SaLengthException sae) {
                log.debug((Object)sae.getMessage());
                return "takeAssessment";
            }
        }
        this.setFromTableOfContents(true);
        DeliveryActionListener l2 = new DeliveryActionListener();
        l2.processAction(null);
        this.setContinue(false);
        return "confirmsubmit";
    }

    public String saveAndExit() {
        String nextAction = this.checkBeforeProceed();
        log.debug((Object)("***** next Action=" + nextAction));
        if (!"safeToProceed".equals(nextAction)) {
            return nextAction;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        SessionUtil.setSessionTimeout((FacesContext)context, (DeliveryBean)this, (boolean)false);
        log.debug((Object)("***DeliverBean.saveAndEXit face context =" + context));
        this.forGrade = false;
        if (this.actionMode == 1 || this.actionMode == 5) {
            this.syncTimeElapsedWithServer();
            SubmitToGradingActionListener listener = new SubmitToGradingActionListener();
            try {
                listener.processAction(null);
            }
            catch (FinFormatException e) {
                log.debug((Object)e.getMessage());
                return "takeAssessment";
            }
            catch (SaLengthException sae) {
                log.debug((Object)sae.getMessage());
                return "takeAssessment";
            }
        }
        String returnValue = "saveForLaterWarning";
        if (this.actionMode == 5) {
            log.debug((Object)"**anonymous login, go to quit");
            returnValue = "anonymousQuit";
        }
        SelectActionListener l2 = new SelectActionListener();
        l2.processAction(null);
        this.reload = true;
        return returnValue;
    }

    public String next_page() {
        String nextAction = this.checkBeforeProceed();
        log.debug((Object)("***** next Action=" + nextAction));
        if (!"safeToProceed".equals(nextAction)) {
            return nextAction;
        }
        this.forGrade = false;
        if (this.actionMode == 1 || this.actionMode == 5) {
            this.syncTimeElapsedWithServer();
            SubmitToGradingActionListener listener = new SubmitToGradingActionListener();
            try {
                listener.processAction(null);
            }
            catch (FinFormatException e) {
                log.debug((Object)e.getMessage());
                return "takeAssessment";
            }
            catch (SaLengthException sae) {
                log.debug((Object)sae.getMessage());
                return "takeAssessment";
            }
        }
        if (this.getSettings().isFormatByPart()) {
            ++this.partIndex;
        }
        if (this.getSettings().isFormatByQuestion()) {
            ++this.questionIndex;
        }
        DeliveryActionListener l2 = new DeliveryActionListener();
        l2.processAction(null);
        if ("1".equals(this.navigation) && this.actionMode != 2) {
            LinearAccessDeliveryActionListener linearAccessDeliveryActionListener = new LinearAccessDeliveryActionListener();
            linearAccessDeliveryActionListener.saveLastVisitedPosition(this, this.partIndex, this.questionIndex);
        }
        this.reload = false;
        return "takeAssessment";
    }

    public String same_page() {
        String nextAction = this.checkBeforeProceed();
        log.debug((Object)("***** next Action=" + nextAction));
        if (!"safeToProceed".equals(nextAction)) {
            return nextAction;
        }
        this.forGrade = false;
        if (this.actionMode == 1 || this.actionMode == 5) {
            this.syncTimeElapsedWithServer();
            SubmitToGradingActionListener listener = new SubmitToGradingActionListener();
            try {
                listener.processAction(null);
            }
            catch (FinFormatException e) {
                log.debug((Object)e.getMessage());
                return "takeAssessment";
            }
            catch (SaLengthException sae) {
                log.debug((Object)sae.getMessage());
                return "takeAssessment";
            }
        }
        DeliveryActionListener l2 = new DeliveryActionListener();
        l2.processAction(null);
        this.reload = false;
        return "takeAssessment";
    }

    public String save_work() {
        String nextAction = this.checkBeforeProceed();
        log.debug((Object)("***** next Action=" + nextAction));
        if (!"safeToProceed".equals(nextAction)) {
            return nextAction;
        }
        this.forGrade = false;
        if (this.actionMode == 1 || this.actionMode == 5) {
            this.syncTimeElapsedWithServer();
            SubmitToGradingActionListener listener = new SubmitToGradingActionListener();
            try {
                listener.processAction(null);
            }
            catch (FinFormatException e) {
                log.debug((Object)e.getMessage());
                return "takeAssessment";
            }
            catch (SaLengthException sae) {
                log.debug((Object)sae.getMessage());
                return "takeAssessment";
            }
        }
        DeliveryActionListener l2 = new DeliveryActionListener();
        l2.processAction(null);
        this.reload = false;
        return "takeAssessment";
    }

    public String previous() {
        String nextAction = this.checkBeforeProceed();
        log.debug((Object)("***** next Action=" + nextAction));
        if (!"safeToProceed".equals(nextAction)) {
            return nextAction;
        }
        if (this.getSettings().isFormatByPart()) {
            --this.partIndex;
            this.questionIndex = 0;
        }
        if (this.getSettings().isFormatByQuestion()) {
            --this.questionIndex;
        }
        this.forGrade = false;
        if (this.actionMode == 1 || this.actionMode == 5) {
            this.syncTimeElapsedWithServer();
            SubmitToGradingActionListener listener = new SubmitToGradingActionListener();
            try {
                listener.processAction(null);
            }
            catch (FinFormatException e) {
                log.debug((Object)e.getMessage());
                return "takeAssessment";
            }
            catch (SaLengthException sae) {
                log.debug((Object)sae.getMessage());
                return "takeAssessment";
            }
        }
        DeliveryActionListener l2 = new DeliveryActionListener();
        l2.processAction(null);
        this.reload = false;
        return "takeAssessment";
    }

    public String confirmSubmitPrevious() {
        String nextAction = this.checkBeforeProceed();
        log.debug((Object)("***** next Action=" + nextAction));
        if (!"safeToProceed".equals(nextAction)) {
            return nextAction;
        }
        this.forGrade = false;
        this.syncTimeElapsedWithServer();
        DeliveryActionListener l2 = new DeliveryActionListener();
        l2.processAction(null);
        return "takeAssessment";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(String confirmation) {
        this.confirmation = confirmation;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String validatePassword() {
        log.debug((Object)("**** username=" + this.username));
        log.debug((Object)("**** password=" + this.password));
        log.debug((Object)("**** setting username=" + this.getSettings().getUsername()));
        log.debug((Object)("**** setting password=" + this.getSettings().getPassword()));
        if (this.password == null || this.username == null) {
            return "passwordAccessError";
        }
        if (this.password.equals(this.getSettings().getPassword()) && this.username.equals(this.getSettings().getUsername())) {
            return "takeAssessment";
        }
        return "passwordAccessError";
    }

    public String validateIP() {
        String thisIp = ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getRemoteAddr();
        Iterator addresses = this.getSettings().getIpAddresses().iterator();
        while (addresses.hasNext()) {
            String next = ((PublishedSecuredIPAddress)addresses.next()).getIpAddress();
            if (next != null && next.indexOf("*") > -1) {
                next = next.substring(0, next.indexOf("*"));
            }
            if (next != null && !next.trim().equals("") && !thisIp.trim().startsWith(next.trim())) continue;
            return "takeAssessment";
        }
        return "ipAccessError";
    }

    public String validate() {
        try {
            String results = "takeAssessment";
            if (!this.getSettings().getUsername().equals("")) {
                results = this.validatePassword();
                log.debug((Object)("*** checked password=" + results));
            }
            if (!results.equals("passwordAccessError") && this.getSettings().getIpAddresses() != null && !this.getSettings().getIpAddresses().isEmpty()) {
                results = this.validateIP();
                log.debug((Object)("*** checked password & IP=" + results));
            }
            if (!"takeAssessment".equals(results) && this.adata != null) {
                String agTimerId;
                TimedAssessmentQueue queue = TimedAssessmentQueue.getInstance();
                TimedAssessmentGradingModel timedAG = queue.get(this.adata.getAssessmentGradingId());
                if (timedAG != null && (agTimerId = timedAG.getTimerId()) != null && agTimerId.equals(this.timerId)) {
                    queue.remove(timedAG);
                    this.timeRunning = false;
                }
                return results;
            }
            String nextAction = this.checkBeforeProceed();
            log.debug((Object)("***** next Action=" + nextAction));
            if (!"safeToProceed".equals(nextAction)) {
                return nextAction;
            }
            this.setSecureDeliveryHTMLFragment("");
            this.setBlockDelivery(false);
            SecureDeliveryServiceAPI secureDelivery = SamigoApiFactory.getInstance().getSecureDeliveryServiceAPI();
            if (("takeAssessment".equals(results) || "".equals(results)) && secureDelivery.isSecureDeliveryAvaliable()) {
                String moduleId = this.publishedAssessment.getAssessmentMetaDataByLabel("SECURE_DELIVERY_MODULE_KEY");
                if (moduleId != null && !"SECURE_DELIVERY_NONE_ID".equals(moduleId)) {
                    HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
                    SecureDeliveryServiceAPI.PhaseStatus status = secureDelivery.validatePhase(moduleId, SecureDeliveryServiceAPI.Phase.ASSESSMENT_START, (PublishedAssessmentIfc)this.publishedAssessment, request);
                    this.setSecureDeliveryHTMLFragment(secureDelivery.getHTMLFragment(moduleId, (PublishedAssessmentIfc)this.publishedAssessment, request, SecureDeliveryServiceAPI.Phase.ASSESSMENT_START, status, new ResourceLoader().getLocale()));
                    this.setBlockDelivery(SecureDeliveryServiceAPI.PhaseStatus.FAILURE == status);
                    results = SecureDeliveryServiceAPI.PhaseStatus.SUCCESS == status ? "takeAssessment" : "secureDeliveryError";
                }
                return results;
            }
            if ("".equals(results)) {
                return "takeAssessment";
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "accessError";
        }
    }

    public String pvalidate() {
        return "takeAssessment";
    }

    public int getPartIndex() {
        return this.partIndex;
    }

    public void setPartIndex(int newindex) {
        this.partIndex = newindex;
    }

    public int getQuestionIndex() {
        return this.questionIndex;
    }

    public void setQuestionIndex(int newindex) {
        this.questionIndex = newindex;
    }

    public boolean getContinue() {
        return this.next_page;
    }

    public void setContinue(boolean docontinue) {
        this.next_page = docontinue;
    }

    public boolean getReload() {
        return this.reload;
    }

    public void setReload(boolean doreload) {
        this.reload = doreload;
    }

    public AssessmentGradingData getAssessmentGrading() {
        return this.adata;
    }

    public void setAssessmentGrading(AssessmentGradingData newdata) {
        this.adata = newdata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getMediaStream(String mediaLocation) {
        FileInputStream mediaStream = null;
        FileInputStream mediaStream2 = null;
        byte[] mediaByte = new byte[]{};
        try {
            int size = 0;
            mediaStream = new FileInputStream(mediaLocation);
            if (mediaStream != null) {
                int i;
                while ((i = mediaStream.read()) != -1) {
                    ++size;
                }
            }
            mediaStream2 = new FileInputStream(mediaLocation);
            mediaByte = new byte[size];
            if (mediaStream2 != null) {
                mediaStream2.read(mediaByte, 0, size);
            }
        }
        catch (FileNotFoundException ex) {
            log.error((Object)("file not found=" + ex.getMessage()));
        }
        catch (IOException ex) {
            log.error((Object)("io exception=" + ex.getMessage()));
        }
        finally {
            if (mediaStream != null) {
                try {
                    mediaStream.close();
                }
                catch (IOException ex1) {
                    log.warn((Object)ex1.getMessage());
                }
            }
            if (mediaStream2 != null) {
                try {
                    mediaStream2.close();
                }
                catch (IOException ex1) {
                    log.warn((Object)ex1.getMessage());
                }
            }
        }
        return mediaByte;
    }

    public void addMediaToItemGrading(ValueChangeEvent e) {
        if (this.isTimeRunning() && this.timeExpired()) {
            this.setOutcome("timeExpired");
        }
        String mediaLocation = (String)e.getNewValue();
        String action = this.addMediaToItemGrading(mediaLocation);
        this.syncTimeElapsedWithServer();
        log.debug((Object)("****time passed after fileupload before loading of next question" + this.getTimeElapse()));
        this.setTimeElapseAfterFileUpload(this.getTimeElapse());
        this.setOutcome(action);
    }

    public String addMediaToItemGrading(String mediaLocation) {
        log.debug((Object)("****" + mediaLocation + " " + new Date()));
        if (!this.mediaIsValid()) {
            this.reload = true;
            return "takeAssessment";
        }
        GradingService gradingService = new GradingService();
        HashMap itemHash = this.getPublishedItemHash();
        PersonBean person = (PersonBean)ContextUtil.lookupBean((String)"person");
        String agent = person.getId();
        int questionIndex = mediaLocation.indexOf("question");
        int agentIndex = mediaLocation.indexOf("/", questionIndex + 8);
        int myfileIndex = mediaLocation.lastIndexOf("/");
        if (agentIndex < 0) {
            agentIndex = mediaLocation.indexOf("\\", questionIndex + 8);
        }
        String questionId = mediaLocation.substring(questionIndex + 8, agentIndex);
        log.debug((Object)("***3a. addMediaToItemGrading, questionId =" + questionId));
        log.debug((Object)("***3b. addMediaToItemGrading, assessmentId =" + this.assessmentId));
        if (agent == null) {
            String agentId = mediaLocation.substring(agentIndex, myfileIndex - 1);
            log.debug((Object)("**** agentId=" + agentId));
            agent = agentId;
        }
        log.debug((Object)("***3c. addMediaToItemGrading, agent =" + agent));
        PublishedItemData item = (PublishedItemData)itemHash.get(new Long(questionId));
        log.debug((Object)("***4a. addMediaToItemGrading, itemText(0) =" + item.getItemTextArray().get(0)));
        PublishedItemText itemText = (PublishedItemText)item.getItemTextArraySorted().get(0);
        ItemGradingData itemGradingData = this.getItemGradingData(questionId);
        boolean newItemGradingData = false;
        if (itemGradingData == null) {
            newItemGradingData = true;
            itemGradingData = new ItemGradingData();
            itemGradingData.setAssessmentGradingId(this.adata.getAssessmentGradingId());
            itemGradingData.setPublishedItemId(item.getItemId());
            itemGradingData.setPublishedItemTextId(itemText.getId());
            itemGradingData.setSubmittedDate(new Date());
            itemGradingData.setAgentId(agent);
            itemGradingData.setOverrideScore(Float.valueOf(0.0f));
        }
        itemGradingData.setAutoScore(Float.valueOf(0.0f));
        this.setAssessmentGrading(this.adata);
        gradingService.saveItemGrading((ItemGradingIfc)itemGradingData);
        this.saveMedia(agent, mediaLocation, itemGradingData, gradingService);
        DeliveryActionListener dlistener = new DeliveryActionListener();
        dlistener.processAction(null, false);
        if (newItemGradingData) {
            this.attachToItemContentBean(itemGradingData, questionId);
        }
        this.reload = true;
        return "takeAssessment";
    }

    public void saveMedia(String agent, String mediaLocation, ItemGradingData itemGradingData, GradingService gradingService) {
        File media = new File(mediaLocation);
        byte[] mediaByte = this.getMediaStream(mediaLocation);
        String mimeType = MimeTypesLocator.getInstance().getContentType(media);
        boolean SAVETODB = this.getSaveToDb();
        log.debug((Object)("**** SAVETODB=" + SAVETODB));
        MediaData mediaData = null;
        log.debug((Object)("***6a. addMediaToItemGrading, itemGradinDataId=" + itemGradingData.getItemGradingId()));
        String fullname = media.getName().trim();
        int underscore_index = fullname.lastIndexOf("_");
        int dot_index = fullname.lastIndexOf(".");
        String filename = fullname.substring(0, underscore_index);
        if (dot_index >= 0) {
            filename = filename + fullname.substring(dot_index);
        }
        log.debug((Object)("**** filename=" + filename));
        String updatedFilename = gradingService.getFileName(itemGradingData.getItemGradingId(), agent, filename);
        log.debug((Object)("**** updatedFilename=" + updatedFilename));
        mediaData = SAVETODB ? new MediaData((ItemGradingIfc)itemGradingData, mediaByte, Long.valueOf(mediaByte.length + ""), mimeType, "description", null, updatedFilename, false, false, Integer.valueOf(1), agent, new Date(), agent, new Date(), null) : new MediaData((ItemGradingIfc)itemGradingData, null, Long.valueOf(mediaByte.length + ""), mimeType, "description", mediaLocation, updatedFilename, false, false, Integer.valueOf(1), agent, new Date(), agent, new Date(), null);
        Long mediaId = gradingService.saveMedia(mediaData);
        log.debug((Object)("mediaId=" + mediaId));
        log.debug((Object)("***6c. addMediaToItemGrading, media.itemGradinDataId=" + ((ItemGradingData)mediaData.getItemGradingData()).getItemGradingId()));
        log.debug((Object)("***6d. addMediaToItemGrading, mediaId=" + mediaData.getMediaId()));
        log.debug((Object)("***7. addMediaToItemGrading, adata=" + this.adata));
        itemGradingData.setAnswerText(mediaId + "");
        gradingService.saveItemGrading((ItemGradingIfc)itemGradingData);
        try {
            boolean success;
            if (SAVETODB && !(success = media.delete())) {
                log.warn((Object)("Error: media.delete() failed for mediaId =" + mediaId));
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
    }

    public boolean mediaIsValid() {
        boolean returnValue = true;
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext external = context.getExternalContext();
        Long fileSize = (Long)((ServletContext)external.getContext()).getAttribute("TEMP_FILEUPLOAD_SIZE");
        Long maxSize = (Long)((ServletContext)external.getContext()).getAttribute("FILEUPLOAD_SIZE_MAX");
        ((ServletContext)external.getContext()).removeAttribute("TEMP_FILEUPLOAD_SIZE");
        if (fileSize != null) {
            float fileSize_float = fileSize.floatValue() / 1024.0f;
            int tmp = Math.round(fileSize_float * 10.0f);
            fileSize_float = (float)tmp / 10.0f;
            float maxSize_float = maxSize.floatValue() / 1024.0f;
            int tmp0 = Math.round(maxSize_float * 10.0f);
            maxSize_float = (float)tmp0 / 10.0f;
            String err1 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.DeliveryMessages", (String)"file_upload_error");
            String err2 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.DeliveryMessages", (String)"file_uploaded");
            String err3 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.DeliveryMessages", (String)"max_size_allowed");
            String err4 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.DeliveryMessages", (String)"upload_again");
            String err = err2 + fileSize_float + err3 + maxSize_float + err4;
            context.addMessage("file_upload_error", new FacesMessage(err1));
            context.addMessage("file_upload_error", new FacesMessage(err));
            returnValue = false;
        }
        return returnValue;
    }

    public boolean getNotTakeable() {
        return this.notTakeable;
    }

    public void setNotTakeable(boolean notTakeable) {
        this.notTakeable = notTakeable;
    }

    public boolean getPastDue() {
        return this.pastDue;
    }

    public void setPastDue(boolean pastDue) {
        this.pastDue = pastDue;
    }

    public long getSubTime() {
        return this.subTime;
    }

    public void setSubTime(long newSubTime) {
        this.subTime = newSubTime;
    }

    public String getSubmissionHours() {
        return this.takenHours;
    }

    public void setSubmissionHours(String newHours) {
        this.takenHours = newHours;
    }

    public String getSubmissionMinutes() {
        return this.takenMinutes;
    }

    public void setSubmissionMinutes(String newMinutes) {
        this.takenMinutes = newMinutes;
    }

    public PublishedAssessmentFacade getPublishedAssessment() {
        return this.publishedAssessment;
    }

    public void setPublishedAssessment(PublishedAssessmentFacade publishedAssessment) {
        this.publishedAssessment = publishedAssessment;
    }

    public Date getFeedbackDate() {
        return this.feedbackDate;
    }

    public String getFeedbackDateString() {
        String dateString = "";
        if (this.feedbackDate == null) {
            return dateString;
        }
        try {
            TimeUtil tu = new TimeUtil();
            dateString = tu.getDisplayDateTime(this.displayFormat, this.feedbackDate);
        }
        catch (Exception ex) {
            log.warn((Object)"Unable to format date.");
            ex.printStackTrace();
        }
        return dateString;
    }

    public void setFeedbackDate(Date feedbackDate) {
        this.feedbackDate = feedbackDate;
    }

    public String getFeedbackDelivery() {
        return this.feedbackDelivery;
    }

    public void setFeedbackDelivery(String feedbackDelivery) {
        this.feedbackDelivery = feedbackDelivery;
    }

    public String getShowScore() {
        return this.showScore;
    }

    public void setShowScore(String showScore) {
        this.showScore = showScore;
    }

    public boolean getHasTimeLimit() {
        return this.hasTimeLimit;
    }

    public void setHasTimeLimit(boolean hasTimeLimit) {
        this.hasTimeLimit = hasTimeLimit;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public String doit() {
        return this.outcome;
    }

    public boolean getAnonymousLogin() {
        return this.anonymousLogin;
    }

    public void setAnonymousLogin(boolean anonymousLogin) {
        this.anonymousLogin = anonymousLogin;
    }

    public ItemGradingData getItemGradingData(String publishedItemId) {
        Set items;
        ItemGradingData selected = null;
        if (this.adata != null && (items = this.adata.getItemGradingSet()) != null) {
            for (ItemGradingData itemGradingData : items) {
                String itemPublishedId = itemGradingData.getPublishedItemId().toString();
                if (publishedItemId.equals(itemPublishedId)) {
                    log.debug((Object)"*** addMediaToItemGrading, same : found it");
                    selected = itemGradingData;
                    continue;
                }
                log.debug((Object)"*** addMediaToItemGrading, not the same");
            }
            log.debug((Object)("*** addMediaToItemGrading, publishedItemId =" + publishedItemId));
            if (selected != null) {
                log.debug((Object)("*** addMediaToItemGrading, itemGradingData.publishedItemId =" + selected.getPublishedItemId().toString()));
            }
        }
        return selected;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public boolean isShowStudentScore() {
        return this.showStudentScore;
    }

    public void setShowStudentScore(boolean showStudentScore) {
        this.showStudentScore = showStudentScore;
    }

    public boolean isShowStudentQuestionScore() {
        return this.showStudentQuestionScore;
    }

    public void setShowStudentQuestionScore(boolean param) {
        this.showStudentQuestionScore = param;
    }

    public boolean isTimeRunning() {
        return this.timeRunning;
    }

    public void setTimeRunning(boolean timeRunning) {
        this.timeRunning = timeRunning;
    }

    public String getJavaScriptEnabledCheck() {
        return this.javaScriptEnabledCheck;
    }

    public void setJavaScriptEnabledCheck(String javaScriptEnabledCheck) {
        this.javaScriptEnabledCheck = javaScriptEnabledCheck;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public String getSiteId() {
        this.siteId = null;
        Placement currentPlacement = ToolManager.getCurrentPlacement();
        if (currentPlacement != null) {
            this.siteId = currentPlacement.getContext();
        }
        return this.siteId;
    }

    public String getAgentAccessString() {
        return this.deliveryAgent.getAgentInstanceString();
    }

    public void setAgentAccessString(String agentString) {
        this.deliveryAgent.setAgentInstanceString(agentString);
    }

    public boolean getSaveToDb() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext external = context.getExternalContext();
        String saveToDb = (String)((ServletContext)external.getContext()).getAttribute("FILEUPLOAD_SAVE_MEDIA_TO_DB");
        return "true".equals(saveToDb);
    }

    public void attachToItemContentBean(ItemGradingData itemGradingData, String questionId) {
        ArrayList<ItemGradingData> list = new ArrayList<ItemGradingData>();
        list.add(itemGradingData);
        log.debug((Object)("**** attachToItemContentBean, questionId=" + questionId));
        PublishedItemData publishedItem = (PublishedItemData)this.getPublishedItemHash().get(new Long(questionId));
        PublishedSectionData publishedSection = (PublishedSectionData)publishedItem.getSection();
        String sectionId = publishedSection.getSectionId().toString();
        SectionContentsBean partSelected = null;
        ArrayList parts = this.getPageContents().getPartsContents();
        for (int i = 0; i < parts.size(); ++i) {
            SectionContentsBean part = (SectionContentsBean)parts.get(i);
            log.debug((Object)("**** question's sectionId" + sectionId));
            log.debug((Object)("**** partId" + part.getSectionId()));
            if (!sectionId.equals(part.getSectionId())) continue;
            partSelected = part;
            break;
        }
        ArrayList items = new ArrayList();
        if (partSelected != null) {
            items = partSelected.getItemContents();
        }
        for (int j = 0; j < items.size(); ++j) {
            ItemContentsBean item = (ItemContentsBean)items.get(j);
            if (!publishedItem.getItemId().equals(item.getItemData().getItemId())) continue;
            item.setItemGradingDataArray(list);
            break;
        }
    }

    public void setActionString(String actionString) {
        this.actionString = actionString;
        this.setFeedback("false");
        this.setNoFeedback("true");
        if ("previewAssessment".equals(actionString)) {
            this.setActionMode(2);
        } else if ("reviewAssessment".equals(actionString)) {
            this.setActionMode(3);
        } else if ("gradeAssessment".equals(actionString)) {
            this.setFeedback("true");
            this.setNoFeedback("false");
            this.setActionMode(4);
        } else if ("takeAssessment".equals(actionString)) {
            this.setActionMode(1);
        } else if ("takeAssessmentViaUrl".equals(actionString)) {
            this.setActionMode(5);
        }
    }

    public String getActionString() {
        return this.actionString;
    }

    private void setActionMode(int actionMode) {
        this.actionMode = actionMode;
    }

    public int getActionMode() {
        return this.actionMode;
    }

    public void setLastTimer(long time) {
        this.time = time;
    }

    public long getLastTimer() {
        return this.time;
    }

    public boolean getBeginAssessment() {
        return this.beginAssessment;
    }

    public void setBeginAssessment(boolean beginAssessment) {
        this.beginAssessment = beginAssessment;
    }

    public boolean timeExpired() {
        if (this.adata == null) {
            return false;
        }
        boolean timeExpired = false;
        TimedAssessmentQueue queue = TimedAssessmentQueue.getInstance();
        TimedAssessmentGradingModel timedAG = queue.get(this.adata.getAssessmentGradingId());
        if (timedAG != null) {
            if (timedAG.getSubmittedForGrade()) {
                timeExpired = true;
                queue.remove(timedAG);
            }
        } else {
            timeExpired = true;
        }
        return timeExpired;
    }

    private void removeTimedAssessmentFromQueue() {
        TimedAssessmentQueue queue = TimedAssessmentQueue.getInstance();
        TimedAssessmentGradingModel timedAG = queue.get(this.adata.getAssessmentGradingId());
        if (timedAG != null) {
            queue.remove(timedAG);
            this.timeRunning = false;
        }
    }

    public void syncTimeElapsedWithServer() {
        TimedAssessmentQueue queue;
        TimedAssessmentGradingModel timedAG;
        if (("takeAssessment".equals(this.actionString) || "takeAssessmentViaUrl".equals(this.actionString)) && (timedAG = (queue = TimedAssessmentQueue.getInstance()).get(this.adata.getAssessmentGradingId())) != null) {
            int timeElapsed = Math.round((float)(new Date().getTime() - this.adata.getAttemptDate().getTime()) / 1000.0f);
            log.debug((Object)("***setTimeElapsed=" + timeElapsed));
            this.adata.setTimeElapsed(Integer.valueOf(timeElapsed));
            GradingService gradingService = new GradingService();
            gradingService.saveOrUpdateAssessmentGrading((AssessmentGradingIfc)this.adata);
            this.setTimeElapse(this.adata.getTimeElapsed().toString());
        }
    }

    public void syncTimeElapsedWithServerLinear() {
        TimedAssessmentQueue queue;
        TimedAssessmentGradingModel timedAG;
        if (("takeAssessment".equals(this.actionString) || "takeAssessmentViaUrl".equals(this.actionString)) && (timedAG = (queue = TimedAssessmentQueue.getInstance()).get(this.adata.getAssessmentGradingId())) != null) {
            int timeElapsed = Math.round((float)(new Date().getTime() - this.adata.getAttemptDate().getTime()) / 1000.0f);
            this.adata.setTimeElapsed(Integer.valueOf(timeElapsed));
            GradingService gradingService = new GradingService();
            gradingService.saveOrUpdateAssessmentGradingOnly((AssessmentGradingIfc)this.adata);
            this.setTimeElapse(this.adata.getTimeElapsed().toString());
        }
    }

    public String getTimeElapseAfterFileUpload() {
        return this.timeElapseAfterFileUpload;
    }

    public void setTimeElapseAfterFileUpload(String timeElapseAfterFileUpload) {
        this.timeElapseAfterFileUpload = timeElapseAfterFileUpload;
        if (timeElapseAfterFileUpload != null && !"".equals(timeElapseAfterFileUpload)) {
            this.setTimeElapseAfterFileUploadFloat(Float.valueOf(timeElapseAfterFileUpload).floatValue());
        }
    }

    public float getTimeElapseFloat() {
        return this.timeElapseFloat;
    }

    public void setTimeElapseFloat(float timeElapseFloat) {
        this.timeElapseFloat = timeElapseFloat;
    }

    public float getTimeElapseAfterFileUploadFloat() {
        return this.timeElapseAfterFileUploadFloat;
    }

    public void setTimeElapseAfterFileUploadFloat(float timeElapseAfterFileUploadFloat) {
        this.timeElapseAfterFileUploadFloat = timeElapseAfterFileUploadFloat;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public HashMap getPublishedItemHash() {
        if (this.publishedItemHash.size() == 0) {
            PublishedAssessmentService pubService = new PublishedAssessmentService();
            this.publishedItemHash = pubService.preparePublishedItemHash((PublishedAssessmentIfc)this.getPublishedAssessment());
        }
        return this.publishedItemHash;
    }

    public void setPublishedItemHash(HashMap publishedItemHash) {
        this.publishedItemHash = publishedItemHash;
    }

    public HashMap getPublishedItemTextHash() {
        if (this.publishedItemTextHash.size() == 0) {
            PublishedAssessmentService pubService = new PublishedAssessmentService();
            this.publishedItemTextHash = pubService.preparePublishedItemTextHash((PublishedAssessmentIfc)this.getPublishedAssessment());
        }
        return this.publishedItemTextHash;
    }

    public void setPublishedItemTextHash(HashMap publishedItemTextHash) {
        this.publishedItemTextHash = publishedItemTextHash;
    }

    public HashMap getPublishedAnswerHash() {
        if (this.publishedAnswerHash.size() == 0) {
            PublishedAssessmentService pubService = new PublishedAssessmentService();
            this.publishedAnswerHash = pubService.preparePublishedAnswerHash((PublishedAssessmentIfc)this.getPublishedAssessment());
        }
        return this.publishedAnswerHash;
    }

    public void setPublishedAnswerHash(HashMap publishedAnswerHash) {
        this.publishedAnswerHash = publishedAnswerHash;
    }

    public boolean getIsMoreThanOneQuestion() {
        log.debug((Object)"getIsMoreThanOneQuestion() starts");
        ArrayList partsContents = this.pageContents.getPartsContents();
        if (partsContents.size() == 1) {
            String size = ((SectionContentsBean)partsContents.get(0)).getItemContentsSize();
            log.debug((Object)("ItemContentsSize = " + size));
            if ("1".equals(size)) {
                log.debug((Object)"isMoreThanOneQuestion set to false");
                this.isMoreThanOneQuestion = false;
            }
        } else {
            log.debug((Object)"isMoreThanOneQuestion set to true");
            this.isMoreThanOneQuestion = true;
        }
        return this.isMoreThanOneQuestion;
    }

    public List getAttachmentList() {
        return this.attachmentList;
    }

    public void setAttachmentList(List attachmentList) {
        this.attachmentList = attachmentList;
    }

    public boolean getHasAttachment() {
        boolean hasAttachment = false;
        if (this.attachmentList != null && this.attachmentList.size() > 0) {
            hasAttachment = true;
        }
        return hasAttachment;
    }

    public boolean getNoQuestions() {
        return this.noQuestions;
    }

    public void setNoQuestions(boolean noQuestions) {
        this.noQuestions = noQuestions;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String checkBeforeProceed(boolean isSubmitForGrade, boolean isFromTimer, boolean isViaUrlLogin) {
        block21: {
            if (this.getPublishedAssessment() == null) {
                return "error";
            }
            if (this.actionMode == 2) {
                return "safeToProceed";
            }
            GradingService service = new GradingService();
            AssessmentGradingData assessmentGrading = null;
            if (this.adata != null) {
                assessmentGrading = service.load(this.adata.getAssessmentGradingId().toString());
            }
            PublishedAssessmentService pubService = new PublishedAssessmentService();
            int totalSubmitted = pubService.getTotalSubmission(AgentFacade.getAgentString(), this.getPublishedAssessment().getPublishedAssessmentId().toString());
            log.debug((Object)("***totalSubmitted=" + totalSubmitted));
            if (this.isRemoved()) {
                return "isRemoved";
            }
            log.debug((Object)"check 1");
            if (!this.isAvailable()) {
                return "assessmentNotAvailable";
            }
            log.debug((Object)"check 2");
            if (!isFromTimer && this.isRetracted(isSubmitForGrade)) {
                return "isRetracted";
            }
            log.debug((Object)"check 3");
            if (this.isRetractedForEdit()) {
                return "isRetractedForEdit";
            }
            log.debug((Object)"check 4");
            if (assessmentGrading != null && !this.checkDataIntegrity(assessmentGrading)) {
                return "discrepancyInData";
            }
            log.debug((Object)"check 5");
            if (assessmentGrading != null && this.getAssessmentHasBeenSubmitted(assessmentGrading)) {
                return "assessmentHasBeenSubmitted";
            }
            log.debug((Object)"check 6");
            if (this.isNeedResubmit()) {
                return "safeToProceed";
            }
            GradingService gradingService = new GradingService();
            int numberRetake = gradingService.getNumberRetake(this.publishedAssessment.getPublishedAssessmentId(), AgentFacade.getAgentString());
            log.debug((Object)"check 7");
            if (!this.getHasSubmissionLeft(totalSubmitted, numberRetake)) {
                return "noSubmissionLeft";
            }
            log.debug((Object)"check 8");
            boolean acceptLateSubmission = AssessmentAccessControlIfc.ACCEPT_LATE_SUBMISSION.equals(this.publishedAssessment.getAssessmentAccessControl().getLateHandling());
            if (this.pastDueDate()) {
                if (acceptLateSubmission && totalSubmitted == 0) {
                    log.debug((Object)"Accept Late Submission && totalSubmitted == 0");
                } else {
                    log.debug((Object)("take from bean: actualNumberRetake =" + this.actualNumberRetake));
                    if (this.actualNumberRetake == numberRetake) {
                        if (isViaUrlLogin) {
                            return "noLateSubmission";
                        }
                        if (!acceptLateSubmission && this.isTimedAssessment()) {
                            log.debug((Object)"No Late Submission && timedAssessment");
                            break block21;
                        } else {
                            log.debug((Object)"noLateSubmission");
                            return "noLateSubmission";
                        }
                    }
                    if (this.actualNumberRetake == numberRetake - 1) {
                        log.debug((Object)"actualNumberRetake == numberRetake - 1: through Retake");
                    } else {
                        log.error((Object)"Should NOT come to here - wrong actualNumberRetake or numberRetake");
                    }
                }
            }
        }
        log.debug((Object)"check9");
        if (this.isTimeRunning() && this.timeExpired()) {
            return "timeExpired";
        }
        return "safeToProceed";
    }

    public String checkFromViaUrlLogin() {
        return this.checkBeforeProceed(false, false, true);
    }

    public String checkBeforeProceed() {
        return this.checkBeforeProceed(false, false);
    }

    public String checkBeforeProceed(boolean isSubmitForGrade, boolean isFromTimer) {
        return this.checkBeforeProceed(isSubmitForGrade, isFromTimer, false);
    }

    private boolean getHasSubmissionLeft(int totalSubmitted, int numberRetake) {
        boolean hasSubmissionLeft = false;
        int maxSubmissionsAllowed = 9999;
        if (Boolean.FALSE.equals(this.publishedAssessment.getAssessmentAccessControl().getUnlimitedSubmissions())) {
            maxSubmissionsAllowed = this.publishedAssessment.getAssessmentAccessControl().getSubmissionsAllowed();
            if ("takeAssessmentViaUrl".equals(this.actionString) && !this.anonymousLogin && this.settings == null) {
                SettingsDeliveryBean settingsDeliveryBean = new SettingsDeliveryBean();
                settingsDeliveryBean.setAssessmentAccessControl((PublishedAssessmentIfc)this.publishedAssessment);
                settingsDeliveryBean.setMaxAttempts(maxSubmissionsAllowed);
                this.settings = settingsDeliveryBean;
            }
        }
        if (totalSubmitted < maxSubmissionsAllowed + numberRetake) {
            hasSubmissionLeft = true;
        }
        return hasSubmissionLeft;
    }

    private boolean isAvailable() {
        boolean isAvailable = true;
        Date currentDate = new Date();
        Date startDate = this.publishedAssessment.getAssessmentAccessControl().getStartDate();
        if (startDate != null && startDate.after(currentDate)) {
            isAvailable = false;
        }
        return isAvailable;
    }

    private boolean pastDueDate() {
        boolean pastDue = true;
        Date currentDate = new Date();
        Date dueDate = this.publishedAssessment.getAssessmentAccessControl().getDueDate();
        if (dueDate == null || dueDate.after(currentDate)) {
            pastDue = false;
        }
        return pastDue;
    }

    private boolean isRetracted(boolean isSubmitForGrade) {
        boolean isRetracted = true;
        Date currentDate = new Date();
        Date retractDate = null;
        if (isSubmitForGrade) {
            PublishedAssessmentService pubService = new PublishedAssessmentService();
            PublishedAssessmentData publishedAssessmentData = pubService.getBasicInfoOfPublishedAssessment(this.getPublishedAssessment().getPublishedAssessmentId().toString());
            retractDate = publishedAssessmentData.getRetractDate();
        } else {
            retractDate = this.publishedAssessment.getAssessmentAccessControl().getRetractDate();
        }
        if (retractDate == null || retractDate.after(currentDate)) {
            isRetracted = false;
        }
        return isRetracted;
    }

    private boolean isRemoved() {
        Integer status = this.publishedAssessment.getStatus();
        return status.equals(AssessmentBaseIfc.DEAD_STATUS);
    }

    private boolean isRetractedForEdit() {
        Integer status = this.publishedAssessment.getStatus();
        return status.equals(AssessmentBaseIfc.RETRACT_FOR_EDIT_STATUS);
    }

    private boolean isNeedResubmit() {
        if (this.adata == null) {
            return false;
        }
        Integer status = this.adata.getStatus();
        return status.equals(AssessmentGradingIfc.ASSESSMENT_UPDATED_NEED_RESUBMIT);
    }

    private boolean checkDataIntegrity(AssessmentGradingData assessmentGrading) {
        if (assessmentGrading != null) {
            String browserDateString;
            long DBdate = 0L;
            if (assessmentGrading.getSubmittedDate() != null) {
                DBdate = assessmentGrading.getSubmittedDate().getTime();
            }
            if ((browserDateString = ContextUtil.lookupParam((String)"lastSubmittedDate1")) == null) {
                browserDateString = ContextUtil.lookupParam((String)"lastSubmittedDate2");
            }
            long browserDate = 0L;
            try {
                if (browserDateString == null) {
                    return true;
                }
                browserDate = Long.parseLong(browserDateString);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
            log.debug((Object)("last modified date in DB=" + DBdate));
            log.debug((Object)("last modified date in browser=" + browserDate));
            log.debug((Object)("date is equal=" + (DBdate == browserDate)));
            return DBdate == browserDate;
        }
        return true;
    }

    private boolean getAssessmentHasBeenSubmitted(AssessmentGradingData assessmentGrading) {
        if (assessmentGrading != null) {
            return assessmentGrading.getForGrade();
        }
        return false;
    }

    public String getPortal() {
        return ServerConfigurationService.getString((String)"portalPath");
    }

    public String getSelectURL() {
        Session session = SessionManager.getCurrentSession();
        String returnUrl = (String)session.getAttribute("LESSONBUILDER_RETURNURL_SAMIGO");
        if (returnUrl != null) {
            return returnUrl;
        }
        StringBuilder url = new StringBuilder(ServerConfigurationService.getString((String)"portalPath"));
        url.append("/site/");
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        String currentSiteId = publishedAssessmentService.getPublishedAssessmentSiteId(this.getAssessmentId());
        url.append(currentSiteId);
        url.append("/page/");
        url.append(this.getCurrentPageId(currentSiteId));
        return url.toString();
    }

    public String getTimerId() {
        return this.timerId;
    }

    public void setTimerId(String timerId) {
        this.timerId = timerId;
    }

    private Site getCurrentSite(String id) {
        Site site = null;
        try {
            site = SiteService.getSite((String)id);
        }
        catch (IdUnusedException e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return site;
    }

    private String getCurrentPageId(String id) {
        Site currentSite = this.getCurrentSite(id);
        if (currentSite == null) {
            return "";
        }
        SitePage page = null;
        String toolId = null;
        try {
            List pageList = currentSite.getPages();
            for (int i = 0; i < pageList.size(); ++i) {
                page = (SitePage)pageList.get(i);
                List pageToolList = page.getTools();
                if (pageToolList.get(0) == null && ((ToolConfiguration)pageToolList.get(0)).getTool() == null || !(toolId = ((ToolConfiguration)pageToolList.get(0)).getToolId()).equalsIgnoreCase("sakai.samigo")) continue;
                return page.getId();
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
        return "";
    }

    public Long getAssessmentGradingId() {
        return this.assessmentGradingId;
    }

    public void setFromTableOfContents(boolean fromTableOfContents) {
        this.fromTableOfContents = fromTableOfContents;
    }

    public boolean getFromTableOfContents() {
        return this.fromTableOfContents;
    }

    public void setAssessmentGradingId(Long assessmentGradingId) {
        this.assessmentGradingId = assessmentGradingId;
    }

    public String updateTimeLimit(String timeLimit) {
        boolean acceptLateSubmission = AssessmentAccessControlIfc.ACCEPT_LATE_SUBMISSION.equals(this.publishedAssessment.getAssessmentAccessControl().getLateHandling());
        GradingService gradingService = new GradingService();
        this.numberRetake = gradingService.getNumberRetake(this.publishedAssessment.getPublishedAssessmentId(), AgentFacade.getAgentString());
        log.debug((Object)("numberRetake = " + this.numberRetake));
        this.actualNumberRetake = gradingService.getActualNumberRetake(this.publishedAssessment.getPublishedAssessmentId(), AgentFacade.getAgentString());
        log.debug((Object)("actualNumberRetake =" + this.actualNumberRetake));
        if (!"previewAssessment".equals(this.actionString) && this.actualNumberRetake >= this.numberRetake && this.beginTime != null) {
            int timeBeforeRetract;
            int timeBeforeDue;
            if (this.dueDate != null && !acceptLateSubmission && (timeBeforeDue = Math.round((float)(this.dueDate.getTime() - this.beginTime.getTime()) / 1000.0f)) < Integer.parseInt(timeLimit)) {
                return String.valueOf(timeBeforeDue);
            }
            if (this.retractDate != null && (timeBeforeRetract = Math.round((float)(this.retractDate.getTime() - this.beginTime.getTime()) / 1000.0f)) < Integer.parseInt(timeLimit)) {
                return String.valueOf(timeBeforeRetract);
            }
        }
        return timeLimit;
    }

    private boolean isTimedAssessment() {
        return !this.getPublishedAssessment().getAssessmentAccessControl().getTimeLimit().equals(0);
    }

    public String cleanRadioButton() {
        String radioId = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("radioId");
        StringBuffer redrawAnchorName = new StringBuffer("p");
        String tmpAnchorName = "";
        ArrayList parts = this.pageContents.getPartsContents();
        for (int i = 0; i < parts.size(); ++i) {
            SectionContentsBean sectionContentsBean = (SectionContentsBean)parts.get(i);
            String partSeq = sectionContentsBean.getNumber();
            ArrayList items = sectionContentsBean.getItemContents();
            for (int j = 0; j < items.size(); ++j) {
                ItemContentsBean item = (ItemContentsBean)items.get(j);
                if (!item.getItemData().getItemId().toString().equals(radioId)) continue;
                String itemSeq = item.getItemData().getSequence().toString();
                redrawAnchorName.append(partSeq);
                redrawAnchorName.append("q");
                redrawAnchorName.append(itemSeq);
                if (tmpAnchorName.equals("") || tmpAnchorName.compareToIgnoreCase(redrawAnchorName.toString()) > 0) {
                    tmpAnchorName = redrawAnchorName.toString();
                }
                if (item.getItemData().getTypeId().longValue() == TypeIfc.MULTIPLE_CHOICE.longValue() || item.getItemData().getTypeId().longValue() == TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION.longValue() || item.getItemData().getTypeId().longValue() == TypeIfc.MULTIPLE_CHOICE_SURVEY.longValue()) {
                    item.setUnanswered(true);
                    for (int k = 0; k < item.getSelectionArray().size(); ++k) {
                        SelectionBean selection = (SelectionBean)item.getSelectionArray().get(k);
                        selection.setResponseFromCleanRadioButton();
                    }
                    ArrayList<ItemGradingData> itemGradingData = new ArrayList<ItemGradingData>();
                    for (ItemGradingData itemgrading : item.getItemGradingDataArray()) {
                        if (itemgrading.getItemGradingId() == null || itemgrading.getItemGradingId().intValue() <= 0) continue;
                        itemGradingData.add(itemgrading);
                        itemgrading.setPublishedAnswerId(null);
                    }
                    item.setItemGradingDataArray(itemGradingData);
                }
                if (item.getItemData().getTypeId().longValue() == TypeIfc.TRUE_FALSE.longValue()) {
                    item.setResponseId(null);
                    Iterator iter = item.getItemGradingDataArray().iterator();
                    if (iter.hasNext()) {
                        ItemGradingData data = (ItemGradingData)iter.next();
                        data.setPublishedAnswerId(null);
                    }
                }
                item.setReview(false);
                item.setRationale("");
            }
        }
        this.syncTimeElapsedWithServer();
        this.setRedrawAnchorName(tmpAnchorName.toString());
        return "takeAssessment";
    }

    public boolean getDisplayMardForReview() {
        return this.displayMardForReview;
    }

    public void setDisplayMardForReview(boolean displayMardForReview) {
        this.displayMardForReview = displayMardForReview;
    }

    public HashMap getItemContentsMap() {
        return this.itemContentsMap;
    }

    public void setItemContentsMap(HashMap itemContentsMap) {
        this.itemContentsMap = itemContentsMap;
    }

    public String getAutoSaveRepeatMilliseconds() {
        String s = ServerConfigurationService.getString((String)"samigo.autoSave.repeat.milliseconds");
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            s = "-1";
        }
        log.debug((Object)("auto save every " + s + " milliseconds"));
        return s;
    }

    public void setFileUploadSizeMax(int fileUploadSizeMax) {
        this.fileUploadSizeMax = fileUploadSizeMax;
    }

    public int getFileUploadSizeMax() {
        return this.fileUploadSizeMax;
    }

    public boolean getStudentRichText() {
        String studentRichText = ServerConfigurationService.getString((String)"samigo.studentRichText", (String)"true");
        return Boolean.parseBoolean(studentRichText);
    }

    public void setDisplayFormat() {
        this.display_dateFormat = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"output_date_no_sec");
        this.displayFormat = new SimpleDateFormat(this.display_dateFormat, new ResourceLoader().getLocale());
    }

    public Integer getScoringType() {
        return this.scoringType;
    }

    public void setScoringType(Integer scoringType) {
        this.scoringType = scoringType;
    }

    public String getSecureDeliveryHTMLFragment() {
        return this.secureDeliveryHTMLFragment;
    }

    public void setSecureDeliveryHTMLFragment(String secureDeliveryHTMLFragment) {
        this.secureDeliveryHTMLFragment = secureDeliveryHTMLFragment;
    }

    public boolean isBlockDelivery() {
        return this.blockDelivery;
    }

    public void setBlockDelivery(boolean blockDelivery) {
        this.blockDelivery = blockDelivery;
    }

    public boolean getIsFromPrint() {
        return this.isFromPrint;
    }

    public void setIsFromPrint(boolean isFromPrint) {
        this.isFromPrint = isFromPrint;
    }

    public boolean getIsAnyInvalidFinInput() {
        return this.isAnyInvalidFinInput;
    }

    public void setIsAnyInvalidFinInput(boolean isAnyInvalidFinInput) {
        this.isAnyInvalidFinInput = isAnyInvalidFinInput;
    }

    public String getRedrawAnchorName() {
        return this.redrawAnchorName;
    }

    public void setRedrawAnchorName(String redrawAnchorName) {
        this.redrawAnchorName = redrawAnchorName;
    }
}

