/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.delivery;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.assessment.ui.bean.delivery.ItemContentsBean;
import org.sakaiproject.util.ResourceLoader;

/*
 * Exception performing whole class analysis ignored.
 */
public class SectionContentsBean
implements Serializable {
    private static final long serialVersionUID = 5959692528847396966L;
    private static Log log = LogFactory.getLog(SectionContentsBean.class);
    private String text;
    private String nonDefaultText;
    private ArrayList itemContents;
    private String sectionId;
    private String number;
    private float maxPoints;
    private float points;
    private int questions;
    private int numbering;
    private String numParts;
    private String description;
    private int unansweredQuestions;
    private ArrayList questionNumbers = new ArrayList();
    private Integer sectionAuthorType;
    private Integer questionOrdering;
    private Integer numberToBeDrawn;
    private Long poolIdToBeDrawn;
    private String poolNameToBeDrawn;
    private String randomQuestionsDrawDate = "";
    private String randomQuestionsDrawTime = "";
    private List attachmentList;
    private boolean noQuestions;
    private String title;
    private String sequence;
    private boolean showStudentQuestionScore;
    private String pointsDisplayString;
    private boolean hasAttachment = false;

    public SectionContentsBean() {
    }

    public String getText() {
        return this.text;
    }

    public String getNonDefaultText() {
        if ("Default".equals(this.text) || "default".equals(this.text)) {
            return "";
        }
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public float getPoints() {
        return this.points;
    }

    public void setPoints(float points) {
        this.points = points;
    }

    public int getUnansweredQuestions() {
        Iterator i = this.itemContents.iterator();
        int num = 0;
        while (i.hasNext()) {
            ItemContentsBean next = (ItemContentsBean)i.next();
            if (!next.isUnanswered()) continue;
            ++num;
        }
        return num;
    }

    public void setUnansweredQuestions(int unansweredQuestions) {
        this.unansweredQuestions = unansweredQuestions;
    }

    public float getMaxPoints() {
        return this.maxPoints;
    }

    public float getRoundedMaxPoints() {
        return SectionContentsBean.roundTo2Decimals((float)this.maxPoints);
    }

    public void setMaxPoints(float maxPoints) {
        this.maxPoints = maxPoints;
    }

    public int getQuestions() {
        return this.questions;
    }

    public void setQuestions(int questions) {
        this.questions = questions;
    }

    public int getNumbering() {
        return this.numbering;
    }

    public void setNumbering(int newNumbering) {
        this.numbering = newNumbering;
    }

    public ArrayList getItemContents() {
        return this.itemContents;
    }

    public ArrayList getItemContentsForRandomDraw() {
        ArrayList randomsample = new ArrayList();
        long seed = AgentFacade.getAgentString().hashCode();
        Collections.shuffle(this.itemContents, new Random(seed));
        int samplesize = this.numberToBeDrawn;
        for (int i = 0; i < samplesize; ++i) {
            randomsample.add(this.itemContents.get(i));
        }
        return randomsample;
    }

    public ArrayList getItemContentsForRandomQuestionOrdering() {
        long seed = AgentFacade.getAgentString().hashCode();
        Collections.shuffle(this.itemContents, new Random(seed));
        return this.itemContents;
    }

    public void setItemContents(ArrayList itemContents) {
        this.itemContents = itemContents;
    }

    public String getItemContentsSize() {
        if (this.itemContents == null) {
            return "0";
        }
        return Integer.toString(this.itemContents.size());
    }

    public void setItemContentsSize(String dummy) {
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ArrayList getQuestionNumbers() {
        return this.questionNumbers;
    }

    public void setQuestionNumbers() {
        this.questionNumbers = new ArrayList();
        for (int i = 1; i <= this.itemContents.size(); ++i) {
            this.questionNumbers.add(new SelectItem((Object)i));
        }
    }

    public SectionContentsBean(SectionDataIfc section) {
        try {
            this.itemContents = new ArrayList();
            this.setSectionId(section.getSectionId().toString());
            this.setTitle(section.getTitle());
            this.setDescription(section.getDescription());
            Integer sequence = section.getSequence();
            if (sequence != null) {
                this.setNumber(sequence.toString());
            } else {
                this.setNumber("1");
            }
            this.setNumber(section.getSequence().toString());
            Set itemSet = section.getItemSet();
            if (itemSet != null) {
                this.setQuestions(itemSet.size());
                for (ItemDataIfc item : itemSet) {
                    ItemContentsBean itemBean = new ItemContentsBean(item);
                    this.itemContents.add(itemBean);
                }
            }
            this.setQuestionNumbers();
            this.setMetaData(section);
            this.attachmentList = section.getSectionAttachmentList();
            if (this.attachmentList != null && this.attachmentList.size() > 0) {
                this.hasAttachment = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void setMetaData(SectionDataIfc section) {
        if (section.getSectionMetaDataByLabel("AUTHOR_TYPE") != null) {
            Integer authortype = new Integer(section.getSectionMetaDataByLabel("AUTHOR_TYPE"));
            this.setSectionAuthorType(authortype);
            if (section.getSectionMetaDataByLabel("AUTHOR_TYPE").equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString())) {
                if (section.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN") != null) {
                    Integer numberdrawn = new Integer(section.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN"));
                    this.setNumberToBeDrawn(numberdrawn);
                }
                if (section.getSectionMetaDataByLabel("POOLID_FOR_RANDOM_DRAW") != null) {
                    Long poolid = new Long(section.getSectionMetaDataByLabel("POOLID_FOR_RANDOM_DRAW"));
                    this.setPoolIdToBeDrawn(poolid);
                }
                if (section.getSectionMetaDataByLabel("POOLNAME_FOR_RANDOM_DRAW") != null) {
                    String poolname = section.getSectionMetaDataByLabel("POOLNAME_FOR_RANDOM_DRAW");
                    this.setPoolNameToBeDrawn(poolname);
                    String randomDrawDate = section.getSectionMetaDataByLabel("QUESTIONS_RANDOM_DRAW_DATE");
                    if (randomDrawDate != null && !"".equals(randomDrawDate)) {
                        try {
                            DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
                            DateTime drawDate = fmt.parseDateTime(randomDrawDate);
                            Locale loc = new ResourceLoader().getLocale();
                            String drawDateString = DateTimeFormat.fullDate().withLocale(loc).print((ReadableInstant)drawDate);
                            String drawTimeString = DateTimeFormat.fullTime().withLocale(loc).print((ReadableInstant)drawDate);
                            this.setRandomQuestionsDrawDate(drawDateString);
                            this.setRandomQuestionsDrawTime(drawTimeString);
                        }
                        catch (Exception e) {
                            log.error((Object)("Unable to parse date text: " + randomDrawDate), (Throwable)e);
                        }
                    }
                }
            }
        } else {
            this.setSectionAuthorType(SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE);
        }
        if (section.getSectionMetaDataByLabel("QUESTIONS_ORDERING") != null) {
            Integer questionorder = new Integer(section.getSectionMetaDataByLabel("QUESTIONS_ORDERING"));
            this.setQuestionOrdering(questionorder);
        } else {
            this.setQuestionOrdering(SectionDataIfc.AS_LISTED_ON_ASSESSMENT_PAGE);
        }
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    public String getNumParts() {
        return this.numParts;
    }

    public void setNumParts(String newNum) {
        this.numParts = newNum;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDesc) {
        this.description = newDesc;
    }

    public Integer getSectionAuthorType() {
        return this.sectionAuthorType;
    }

    public String getSectionAuthorTypeString() {
        return this.sectionAuthorType.toString();
    }

    public void setSectionAuthorType(Integer param) {
        this.sectionAuthorType = param;
    }

    public Integer getQuestionOrdering() {
        return this.questionOrdering;
    }

    public String getQuestionOrderingString() {
        return this.questionOrdering.toString();
    }

    public void setQuestionOrdering(Integer param) {
        this.questionOrdering = param;
    }

    public Integer getNumberToBeDrawn() {
        return this.numberToBeDrawn;
    }

    public String getNumberToBeDrawnString() {
        return this.numberToBeDrawn.toString();
    }

    public void setNumberToBeDrawn(Integer param) {
        this.numberToBeDrawn = param;
    }

    public Long getPoolIdToBeDrawn() {
        return this.poolIdToBeDrawn;
    }

    public String getPoolIdToBeDrawnString() {
        return this.poolIdToBeDrawn.toString();
    }

    public void setPoolIdToBeDrawn(Long param) {
        this.poolIdToBeDrawn = param;
    }

    public void setPoolNameToBeDrawn(String param) {
        this.poolNameToBeDrawn = param;
    }

    public String getPoolNameToBeDrawn() {
        if (this.sectionAuthorType != null && this.sectionAuthorType.equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL)) {
            if ("".equals(this.poolNameToBeDrawn)) {
                QuestionPoolService qpservice = new QuestionPoolService();
                QuestionPoolFacade poolfacade = qpservice.getPool(this.poolIdToBeDrawn, AgentFacade.getAgentString());
                if (poolfacade != null) {
                    return poolfacade.getTitle();
                }
                return "";
            }
            return this.poolNameToBeDrawn;
        }
        return "";
    }

    public boolean isShowStudentQuestionScore() {
        return this.showStudentQuestionScore;
    }

    public void setShowStudentQuestionScore(boolean showStudentQuestionScore) {
        this.showStudentQuestionScore = showStudentQuestionScore;
    }

    public String getPointsDisplayString() {
        String pointsDisplayString = "";
        if (this.showStudentQuestionScore) {
            pointsDisplayString = SectionContentsBean.roundTo2Decimals((float)this.points) + "/";
        }
        return pointsDisplayString;
    }

    public static float roundTo2Decimals(float points) {
        int tmp = Math.round(points * 100.0f);
        points = (float)tmp / 100.0f;
        return points;
    }

    public List getAttachmentList() {
        return this.attachmentList;
    }

    public void setAttachmentList(List attachmentList) {
        this.attachmentList = attachmentList;
    }

    public boolean getHasAttachment() {
        boolean hasAttachment = false;
        if (this.attachmentList != null && this.attachmentList.size() > 0) {
            hasAttachment = true;
        }
        return hasAttachment;
    }

    public boolean getNoQuestions() {
        return this.noQuestions;
    }

    public void setNoQuestions(boolean noQuestions) {
        this.noQuestions = noQuestions;
    }

    public String getRandomQuestionsDrawDate() {
        return this.randomQuestionsDrawDate;
    }

    public void setRandomQuestionsDrawDate(String randomQuestionsDrawDate) {
        this.randomQuestionsDrawDate = randomQuestionsDrawDate;
    }

    public String getRandomQuestionsDrawTime() {
        return this.randomQuestionsDrawTime;
    }

    public void setRandomQuestionsDrawTime(String randomQuestionsDrawTime) {
        this.randomQuestionsDrawTime = randomQuestionsDrawTime;
    }
}

