/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.delivery;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;

public class SettingsDeliveryBean
implements Serializable {
    private static final long serialVersionUID = -1090852048737428722L;
    private String username;
    private String password;
    private Set ipAddresses;
    private boolean unlimitedAttempts;
    private Date dueDate;
    private Date feedbackDate;
    private boolean autoSave;
    private boolean autoSubmit;
    private boolean formatByPart;
    private boolean formatByQuestion;
    private boolean formatByAssessment;
    private int maxAttempts;
    private String submissionMessage;
    private String bgcolor;
    private String background;
    private String itemNumbering;

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public boolean getAutoSubmit() {
        return this.autoSubmit;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Date getFeedbackDate() {
        return this.feedbackDate;
    }

    public void setAutoSubmit(boolean autoSubmit) {
        this.autoSubmit = autoSubmit;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public void setFeedbackDate(Date feedbackDate) {
        this.feedbackDate = feedbackDate;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        if (this.username == null) {
            return "";
        }
        return this.username;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public Set getIpAddresses() {
        return this.ipAddresses;
    }

    public void setIpAddresses(Set set) {
        this.ipAddresses = set;
    }

    public boolean isUnlimitedAttempts() {
        return this.unlimitedAttempts;
    }

    public void setUnlimitedAttempts(boolean unlimitedAttempts) {
        this.unlimitedAttempts = unlimitedAttempts;
    }

    public boolean isFormatByPart() {
        return this.formatByPart;
    }

    public void setFormatByPart(boolean formatByPart) {
        this.formatByPart = formatByPart;
    }

    public boolean isFormatByQuestion() {
        return this.formatByQuestion;
    }

    public void setFormatByQuestion(boolean formatByQuestion) {
        this.formatByQuestion = formatByQuestion;
    }

    public boolean isFormatByAssessment() {
        return this.formatByAssessment;
    }

    public void setFormatByAssessment(boolean formatByAssessment) {
        this.formatByAssessment = formatByAssessment;
    }

    public String getSubmissionMessage() {
        return this.submissionMessage;
    }

    public void setSubmissionMessage(String submissionMessage) {
        this.submissionMessage = submissionMessage;
    }

    public String getBgcolor() {
        return this.checkColor(this.bgcolor, "bgcolor=transparent");
    }

    public void setBgcolor(String color) {
        this.bgcolor = "bgcolor=" + color;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String bg) {
        this.background = "background=" + bg;
    }

    public String getDivBgcolor() {
        return "background:" + this.getBgcolor().substring(8);
    }

    public String getDivBackground() {
        if (this.getBackground() != null && !this.getBackground().equals("")) {
            String divbg = "background-image:url(" + this.getBackground().substring(11) + ")";
            return divbg;
        }
        return "";
    }

    public String checkColor(String color, String defaultcolor) {
        if (color == null || color.equals("")) {
            return defaultcolor;
        }
        return color;
    }

    public String getItemNumbering() {
        return this.itemNumbering;
    }

    public void setItemNumbering(String numbering) {
        this.itemNumbering = numbering;
    }

    public void setAssessmentAccessControl(PublishedAssessmentIfc pubAssessment) {
        AssessmentAccessControlIfc control = pubAssessment.getAssessmentAccessControl();
        this.setAutoSubmit(AssessmentAccessControlIfc.AUTO_SUBMIT.equals(control.getAutoSubmit()));
        this.setAutoSave(AssessmentAccessControlIfc.AUTO_SAVE.equals(control.getSubmissionsSaved()));
        this.setDueDate(control.getDueDate());
        if (Boolean.TRUE.equals(control.getUnlimitedSubmissions())) {
            this.setUnlimitedAttempts(true);
        } else {
            this.setUnlimitedAttempts(false);
            if (control.getSubmissionsAllowed() != null) {
                this.setMaxAttempts(control.getSubmissionsAllowed().intValue());
            }
        }
        this.setSubmissionMessage(control.getSubmissionMessage());
        this.setFeedbackDate(control.getFeedbackDate());
        Integer format = control.getAssessmentFormat();
        if (format == null) {
            format = 1;
        }
        this.setFormatByAssessment(AssessmentAccessControlIfc.BY_ASSESSMENT.equals(format));
        this.setFormatByPart(AssessmentAccessControlIfc.BY_PART.equals(format));
        this.setFormatByQuestion(AssessmentAccessControlIfc.BY_QUESTION.equals(format));
        this.setUsername(control.getUsername());
        this.setPassword(control.getPassword());
        this.setItemNumbering(control.getItemNumbering().toString());
        this.setIpAddresses(pubAssessment.getSecuredIPAddressSet());
        Set set = pubAssessment.getAssessmentMetaDataSet();
        for (AssessmentMetaDataIfc data : set) {
            if (data.getLabel().equals("ASSESSMENT_BGCOLOR")) {
                this.setBgcolor(data.getEntry());
                continue;
            }
            if (!data.getLabel().equals("ASSESSMENT_BGIMAGE")) continue;
            this.setBackground(data.getEntry());
        }
    }
}

