/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.evaluation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.ui.bean.util.Validator;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.AttachmentUtil;
import org.sakaiproject.tool.cover.SessionManager;

public class AgentResults
implements Serializable {
    private static final long serialVersionUID = 2820488402465439395L;
    private static Log log = LogFactory.getLog(AgentResults.class);
    private Long assessmentGradingId;
    private Long itemGradingId;
    private String agentId;
    private String agentEid;
    private String firstName;
    private String lastName;
    private String lastInitial;
    private String email;
    private String idString;
    private String role;
    private PublishedAssessmentIfc publishedAssessment;
    private Date submittedDate;
    private Date attemptDate;
    private Boolean isLate;
    private Boolean forGrade;
    private String totalAutoScore;
    private String totalOverrideScore;
    private String finalScore;
    private String answer;
    private String fullAnswer = "";
    private String comments;
    private Integer status;
    private String gradedBy;
    private Date gradedDate;
    private Set itemGradingSet;
    private ArrayList itemGradingArrayList;
    private String rationale = "";
    private boolean retakeAllowed;
    private boolean isAutoSubmitted;
    private boolean isAttemptDateAfterDueDate;
    private ItemGradingData itemGrading;
    private List itemGradingAttachmentList;
    private Integer timeElapsed;
    private int submissionCount = 0;
    private Float scoreSummation = new Float("0");
    private Float averageScore = new Float("0");
    private boolean hasItemGradingAttachment = false;

    public Float getScoreSummation() {
        return this.scoreSummation;
    }

    public void setScoreSummation(Float scoreSummation) {
        this.scoreSummation = scoreSummation;
    }

    public int getSubmissionCount() {
        return this.submissionCount;
    }

    public void setSubmissionCount(int submissionCount) {
        this.submissionCount = submissionCount;
    }

    public Long getAssessmentGradingId() {
        return this.assessmentGradingId;
    }

    public void setAssessmentGradingId(Long assessmentGradingId) {
        this.assessmentGradingId = assessmentGradingId;
    }

    public Long getItemGradingId() {
        return this.itemGradingId;
    }

    public void setItemGradingId(Long itemGradingId) {
        this.itemGradingId = itemGradingId;
    }

    public PublishedAssessmentIfc getPublishedAssessment() {
        return this.publishedAssessment;
    }

    public void setPublishedAssessment(PublishedAssessmentIfc publishedAssessment) {
        this.publishedAssessment = publishedAssessment;
    }

    public String getAgentId() {
        return Validator.check((String)this.agentId, (String)"N/A");
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getAgentEid() {
        return Validator.check((String)this.agentEid, (String)"N/A");
    }

    public void setAgentEid(String agentEid) {
        this.agentEid = agentEid;
    }

    public String getFirstName() {
        return Validator.check((String)this.firstName, (String)"");
    }

    public void setFirstName(String name) {
        this.firstName = name;
    }

    public String getLastName() {
        return Validator.check((String)this.lastName, (String)"");
    }

    public void setLastName(String name) {
        this.lastName = name;
    }

    public String getLastInitial() {
        return Validator.check((String)this.lastInitial, (String)"A");
    }

    public void setLastInitial(String init) {
        this.lastInitial = init;
    }

    public String getEmail() {
        return Validator.check((String)this.email, (String)"");
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getIdString() {
        String escapedIdString = ContextUtil.escapeApostrophe((String)this.idString);
        return Validator.check((String)escapedIdString, (String)"N/A");
    }

    public void setIdString(String id) {
        this.idString = id;
    }

    public String getRole() {
        return Validator.check((String)this.role, (String)"N/A");
    }

    public void setRole(String newrole) {
        this.role = newrole;
    }

    public Date getSubmittedDate() {
        return this.submittedDate;
    }

    public void setSubmittedDate(Date submittedDate) {
        this.submittedDate = submittedDate;
    }

    public Date getAttemptDate() {
        return this.attemptDate;
    }

    public void setAttemptDate(Date attemptDate) {
        this.attemptDate = attemptDate;
    }

    public Boolean getIsLate() {
        return Validator.bcheck((Boolean)this.isLate, (boolean)false);
    }

    public void setIsLate(Boolean isLate) {
        this.isLate = isLate;
    }

    public Boolean getForGrade() {
        return Validator.bcheck((Boolean)this.forGrade, (boolean)true);
    }

    public void setForGrade(Boolean forGrade) {
        this.forGrade = forGrade;
    }

    public String getTotalAutoScore() {
        return this.getRoundedTotalAutoScore();
    }

    public String getExactTotalAutoScore() {
        return Validator.check((String)this.totalAutoScore, (String)"0").replace(',', '.');
    }

    public String getRoundedTotalAutoScore() {
        if (this.totalAutoScore != null) {
            try {
                String newscore = ContextUtil.getRoundedValue((String)this.totalAutoScore.replace(',', '.'), (int)2);
                return Validator.check((String)newscore, (String)"N/A").replace(',', '.');
            }
            catch (Exception e) {
                return Validator.check((String)this.totalAutoScore, (String)"0").replace(',', '.');
            }
        }
        return Validator.check((String)this.totalAutoScore, (String)"0").replace(',', '.');
    }

    public void setTotalAutoScore(String totalAutoScore) {
        this.totalAutoScore = totalAutoScore != null ? totalAutoScore.replace(',', '.') : null;
    }

    public String getTotalOverrideScore() {
        return Validator.check((String)this.totalOverrideScore, (String)"0").replace(',', '.');
    }

    public String getRoundedTotalOverrideScore() {
        if (this.totalOverrideScore != null) {
            try {
                String newscore = ContextUtil.getRoundedValue((String)this.totalOverrideScore.replace(',', '.'), (int)2);
                return Validator.check((String)newscore, (String)"N/A").replace(',', '.');
            }
            catch (Exception e) {
                return Validator.check((String)this.totalOverrideScore, (String)"0").replace(',', '.');
            }
        }
        return Validator.check((String)this.totalOverrideScore, (String)"0").replace(',', '.');
    }

    public void setTotalOverrideScore(String totalOverrideScore) {
        this.totalOverrideScore = totalOverrideScore != null ? totalOverrideScore.replace(',', '.') : null;
    }

    public String getFinalScore() {
        return Validator.check((String)this.finalScore, (String)"0").replace(',', '.');
    }

    public String getRoundedFinalScore() {
        if (this.finalScore != null) {
            try {
                String newscore = ContextUtil.getRoundedValue((String)this.finalScore.replace(',', '.'), (int)2);
                return Validator.check((String)newscore, (String)"N/A").replace(',', '.');
            }
            catch (Exception e) {
                return Validator.check((String)this.finalScore, (String)"0").replace(',', '.');
            }
        }
        return Validator.check((String)this.finalScore, (String)"0").replace(',', '.');
    }

    public void setFinalScore(String finalScore) {
        this.finalScore = finalScore != null ? finalScore.replace(',', '.') : null;
    }

    public String getAnswer() {
        return Validator.check((String)this.answer, (String)"");
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public String getComments() {
        return Validator.check((String)this.comments, (String)"");
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getGradedBy() {
        return Validator.check((String)this.gradedBy, (String)"");
    }

    public void setGradedBy(String gradedBy) {
        this.gradedBy = gradedBy;
    }

    public Date getGradedDate() {
        return this.gradedDate;
    }

    public void setGradedDate(Date gradedDate) {
        this.gradedDate = gradedDate;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Set getItemGradingSet() {
        return this.itemGradingSet;
    }

    public void setItemGradingSet(Set itemGradingSet) {
        this.itemGradingSet = itemGradingSet;
    }

    public ArrayList getItemGradingArrayList() {
        return this.itemGradingArrayList;
    }

    public void setItemGradingArrayList(ArrayList itemGradingArrayList) {
        this.itemGradingArrayList = itemGradingArrayList;
    }

    public String getFullAnswer() {
        return Validator.check((String)this.fullAnswer, (String)"");
    }

    public void setFullAnswer(String answer) {
        this.fullAnswer = answer;
    }

    public String getRationale() {
        return Validator.check((String)this.rationale, (String)"");
    }

    public void setRationale(String param) {
        this.rationale = param;
    }

    public boolean getRetakeAllowed() {
        return this.retakeAllowed;
    }

    public void setRetakeAllowed(boolean retakeAllowed) {
        this.retakeAllowed = retakeAllowed;
    }

    public boolean getIsAutoSubmitted() {
        return this.isAutoSubmitted;
    }

    public void setIsAutoSubmitted(boolean isAutoSubmitted) {
        this.isAutoSubmitted = isAutoSubmitted;
    }

    public boolean getIsAttemptDateAfterDueDate() {
        return this.isAttemptDateAfterDueDate;
    }

    public void setIsAttemptDateAfterDueDate(boolean isAttemptDateAfterDueDate) {
        this.isAttemptDateAfterDueDate = isAttemptDateAfterDueDate;
    }

    public ItemGradingData getItemGrading() {
        return this.itemGrading;
    }

    public void setItemGrading(ItemGradingData itemGrading) {
        this.itemGrading = itemGrading;
    }

    public List getItemGradingAttachmentList() {
        return this.itemGradingAttachmentList;
    }

    public void setItemGradingAttachmentList(List attachmentList) {
        this.itemGradingAttachmentList = attachmentList;
    }

    public boolean getHasItemGradingAttachment() {
        if (this.itemGradingAttachmentList != null && this.itemGradingAttachmentList.size() > 0) {
            this.hasItemGradingAttachment = true;
        }
        return this.hasItemGradingAttachment;
    }

    public String addAttachmentsRedirect() {
        try {
            List filePickerList = new ArrayList();
            if (this.itemGradingAttachmentList != null) {
                AttachmentUtil attachmentUtil = new AttachmentUtil();
                filePickerList = attachmentUtil.prepareReferenceList(this.itemGradingAttachmentList);
            }
            ToolSession currentToolSession = SessionManager.getCurrentToolSession();
            currentToolSession.setAttribute("sakaiproject.filepicker.attachments", filePickerList);
            currentToolSession.setAttribute("itemGradingId", (Object)this.itemGradingId);
            ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
            context.redirect("sakai.filepicker.helper/tool");
        }
        catch (Exception e) {
            log.error((Object)("fail to redirect to attachment page: " + e.getMessage()));
        }
        return "studentScores";
    }

    public Integer getTimeElapsed() {
        return this.timeElapsed;
    }

    public void setTimeElapsed(Integer timeElapsed) {
        this.timeElapsed = timeElapsed;
    }

    public String getFormatedTimeElapsed() {
        String timeElapsedInString = "n/a";
        if (this.timeElapsed != null && this.timeElapsed > 0) {
            int totalSec = this.timeElapsed;
            int hr = totalSec / 3600;
            int min = totalSec % 3600 / 60;
            int sec = totalSec % 3600 % 60;
            timeElapsedInString = "";
            if (hr > 0) {
                timeElapsedInString = hr + " hr ";
            }
            if (min > 0) {
                timeElapsedInString = timeElapsedInString + min + " min ";
            }
            if (sec > 0) {
                timeElapsedInString = timeElapsedInString + sec + " sec ";
            }
        }
        return timeElapsedInString;
    }
}

