/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.evaluation;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.sakaiproject.jsf.model.PhaseAware;
import org.sakaiproject.tool.assessment.jsf.convert.AnswerSurveyConverter;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.TotalScoresBean;
import org.sakaiproject.tool.assessment.ui.listener.evaluation.HistogramListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.Validator;

public class ExportResponsesBean
implements Serializable,
PhaseAware {
    private static final long serialVersionUID = 2854656853283125977L;
    public static final String NEW_SHEET_MARKER = "<sheet/>";
    public static final String HEADER_MARKER = "<header/>";
    public static final String FORMAT = "<format ";
    public static final String FORMAT_BOLD = "<format bold/>";
    private String assessmentId;
    private String assessmentName;
    private boolean anonymous;
    private static Log log = LogFactory.getLog(ExportResponsesBean.class);

    public ExportResponsesBean() {
        log.debug((Object)"Creating a new ExportResponsesBean");
    }

    public String getAssessmentId() {
        return org.sakaiproject.tool.assessment.ui.bean.util.Validator.check((String)this.assessmentId, (String)"0");
    }

    public void setAssessmentId(String assessmentId) {
        this.assessmentId = assessmentId;
    }

    public String getAssessmentName() {
        return org.sakaiproject.tool.assessment.ui.bean.util.Validator.check((String)this.assessmentName, (String)"N/A");
    }

    public void setAssessmentName(String assessmentName) {
        this.assessmentName = assessmentName;
    }

    public boolean getAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void endProcessValidators() {
        log.debug((Object)"endProcessValidators");
    }

    public void endProcessUpdates() {
        log.debug((Object)"endProcessUpdates");
    }

    public void startRenderResponse() {
        log.debug((Object)"startRenderResponse");
    }

    public void exportExcel(ActionEvent event) {
        log.debug((Object)("exporting as Excel: assessment id =  " + this.getAssessmentId()));
        FacesContext faces = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)faces.getExternalContext().getResponse();
        response.reset();
        response.setHeader("Pragma", "public");
        response.setHeader("Cache-Control", "public, must-revalidate, post-check=0, pre-check=0, max-age=0");
        this.writeDataToResponse(this.getSpreadsheetData(), this.getDownloadFileName(), response);
        faces.responseComplete();
    }

    private List<List<Object>> getSpreadsheetData() {
        TotalScoresBean totalScores = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        Map useridMap = totalScores.getUserIdMap(6);
        HistogramListener histogramListener = new HistogramListener();
        Iterator detailedStats = histogramListener.getDetailedStatisticsSpreadsheetData(this.assessmentId).iterator();
        detailedStats.next();
        boolean showPartAndTotalScoreSpreadsheetColumns = true;
        boolean showDetailedStatisticsSheet = (Boolean)detailedStats.next();
        String audioMessage = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"audio_message");
        String fileUploadMessage = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"file_upload_message");
        String noSubmissionMessage = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"export_no_submission");
        GradingService gradingService = new GradingService();
        String poolString = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"pool");
        String partString = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"part");
        String questionString = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"question");
        String responseString = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"response");
        String rationaleString = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"rationale");
        String itemGradingCommentsString = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"grader_comments");
        List exportResponsesDataList = gradingService.getExportResponsesData(this.assessmentId, this.anonymous, audioMessage, fileUploadMessage, noSubmissionMessage, showPartAndTotalScoreSpreadsheetColumns, poolString, partString, questionString, responseString, rationaleString, itemGradingCommentsString, useridMap);
        List<List<Object>> list = new ArrayList();
        if (exportResponsesDataList != null) {
            list = (List)exportResponsesDataList.get(0);
        }
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(HEADER_MARKER);
        if (this.anonymous) {
            headerList.add(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"sub_id"));
        } else {
            headerList.add(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"last_name"));
            headerList.add(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"first_name"));
            headerList.add(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"user_name"));
            headerList.add(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"num_submission"));
        }
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        if (showPartAndTotalScoreSpreadsheetColumns) {
            int numberOfSections = pubService.getPublishedSectionCount(Long.valueOf(this.assessmentId));
            if (numberOfSections > 1) {
                for (int i = 1; i <= numberOfSections; ++i) {
                    headerList.add(partString + " " + i + " " + ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"score"));
                }
            }
            headerList.add(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"tot"));
            headerList.add(itemGradingCommentsString);
        }
        if (exportResponsesDataList != null) {
            headerList.addAll((ArrayList)exportResponsesDataList.get(1));
        }
        list.add(0, headerList);
        ArrayList<String> newSheetList = new ArrayList<String>();
        newSheetList.add(NEW_SHEET_MARKER);
        newSheetList.add(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"responses"));
        list.add(0, newSheetList);
        if (showDetailedStatisticsSheet) {
            newSheetList = new ArrayList();
            newSheetList.add(NEW_SHEET_MARKER);
            newSheetList.add(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"item_analysis"));
            list.add(newSheetList);
            while (detailedStats.hasNext()) {
                list.add((List)detailedStats.next());
            }
        }
        return list;
    }

    public String getDownloadFileName() {
        Date now = new Date();
        String dateFormat = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"export_filename_date_format");
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, new ResourceLoader().getLocale());
        StringBuilder fileName = new StringBuilder(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"assessment"));
        if (StringUtils.trimToNull((String)this.assessmentName) != null) {
            this.assessmentName = this.assessmentName.replaceAll("\\s", "_");
            fileName.append("-");
            fileName.append(this.assessmentName);
        }
        fileName.append("-");
        fileName.append(df.format(now));
        return fileName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDataToResponse(List<List<Object>> spreadsheetData, String fileName, HttpServletResponse response) {
        String mimetype = "application/vnd.ms-excel;charset=UTF-8";
        String extension = ".xls";
        int columns = this.findColumnSize(spreadsheetData);
        if (columns >= 255) {
            mimetype = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            extension = ".xlsx";
            log.info((Object)("Samigo export (" + columns + " columns): Using xlsx mimetype: " + mimetype));
        }
        response.setContentType(mimetype);
        String escapedFilename = Validator.escapeUrl((String)fileName);
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String userAgent = request.getHeader("User-Agent");
        response.setHeader("Content-disposition", "attachment; filename=" + escapedFilename + extension + "; filename*=UTF-8''" + escapedFilename + extension);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            this.getAsWorkbook(spreadsheetData).write((OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
        }
        finally {
            block15: {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block15;
                    log.error((Object)e);
                }
            }
        }
    }

    protected Workbook getAsWorkbookTest(List<List<Object>> spreadsheetData) {
        HSSFWorkbook wb = new HSSFWorkbook();
        Sheet sheet = wb.createSheet();
        Iterator<List<Object>> dataIter = spreadsheetData.iterator();
        Row headerRow = sheet.createRow(0);
        List<Object> headerList = dataIter.next();
        for (short i = 0; i < headerList.size(); i = (short)(i + 1)) {
            this.createCell(headerRow, i, null).setCellValue(headerList.get(i).toString());
        }
        int rowPos = 1;
        while (dataIter.hasNext()) {
            List<Object> rowData = dataIter.next();
            int n = rowPos;
            rowPos = (short)(rowPos + 1);
            Row row = sheet.createRow(n);
            for (short i = 0; i < rowData.size(); i = (short)(i + 1)) {
                Cell cell = this.createCell(row, i, null);
                Object data = rowData.get(i);
                if (data == null) continue;
                if (data instanceof Double) {
                    cell.setCellValue(((Double)data).doubleValue());
                    continue;
                }
                cell.setCellValue(data.toString());
            }
        }
        return wb;
    }

    public Workbook getAsWorkbook(List<List<Object>> spreadsheetData) {
        HSSFWorkbook wb;
        int columns = this.findColumnSize(spreadsheetData);
        if (columns < 255) {
            log.info((Object)("Samigo export (" + columns + " columns): Using xsl format"));
            wb = new HSSFWorkbook();
        } else {
            log.info((Object)("Samigo export (" + columns + " columns): Using xslx format"));
            wb = new XSSFWorkbook();
        }
        CellStyle boldStyle = wb.createCellStyle();
        Font font = wb.createFont();
        font.setBoldweight((short)700);
        boldStyle.setFont(font);
        CellStyle headerStyle = boldStyle;
        Sheet sheet = null;
        Iterator<List<Object>> dataIter = spreadsheetData.iterator();
        int rowPos = 0;
        while (dataIter.hasNext()) {
            List<Object> rowData = dataIter.next();
            if (rowData.get(0).toString().equals(NEW_SHEET_MARKER)) {
                sheet = wb.createSheet(rowData.get(1).toString());
                rowPos = 0;
                continue;
            }
            if (rowData.get(0).toString().equals(HEADER_MARKER)) {
                if (sheet == null) {
                    sheet = wb.createSheet("responses");
                }
                int n = rowPos;
                rowPos = (short)(rowPos + 1);
                Row headerRow = sheet.createRow(n);
                for (short i = 0; i < rowData.size() - 1; i = (short)(i + 1)) {
                    this.createCell(headerRow, i, headerStyle).setCellValue(rowData.get(i + 1).toString());
                }
                continue;
            }
            if (sheet == null) {
                sheet = wb.createSheet("responses");
            }
            int n = rowPos;
            rowPos = (short)(rowPos + 1);
            Row row = sheet.createRow(n);
            short colPos = 0;
            Iterator<Object> colIter = rowData.iterator();
            while (colIter.hasNext()) {
                Cell cell = null;
                Object data = colIter.next();
                if (data == null) continue;
                if (data.toString().startsWith(FORMAT)) {
                    if (data.equals(FORMAT_BOLD)) {
                        short s = colPos;
                        colPos = (short)(colPos + 1);
                        cell = this.createCell(row, s, boldStyle);
                    }
                    data = colIter.next();
                } else {
                    short s = colPos;
                    colPos = (short)(colPos + 1);
                    cell = this.createCell(row, s, null);
                }
                if (data == null) continue;
                if (data instanceof Double) {
                    cell.setCellValue(((Double)data).doubleValue());
                    continue;
                }
                AnswerSurveyConverter converter = new AnswerSurveyConverter();
                String datac = converter.getAsString(null, null, (Object)data.toString());
                cell.setCellValue(FormattedText.convertFormattedTextToPlaintext((String)datac));
            }
        }
        return wb;
    }

    private int findColumnSize(List<List<Object>> spreadsheetData) {
        int columns = 0;
        for (List<Object> list : spreadsheetData) {
            if (list == null || list.size() <= columns) continue;
            columns = list.size();
        }
        return columns;
    }

    private Cell createCell(Row row, short column, CellStyle cellStyle) {
        Cell cell = row.createCell((int)column);
        if (cellStyle != null) {
            cell.setCellStyle(cellStyle);
        }
        return cell;
    }
}

