/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.evaluation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.HistogramBarBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.HistogramQuestionScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.util.Validator;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class HistogramScoresBean
implements Serializable {
    private String assessmentName;
    private static final long serialVersionUID = 3465442692662950563L;
    private String assessmentId;
    private String publishedId;
    private String itemId;
    private String agent;
    private String hasNav;
    private String groupName;
    private String maxScore;
    private String totalScore;
    private String totalPossibleScore;
    private String adjustedScore;
    private String questionNumber;
    private String allSubmissions;
    private String partNumber;
    private Integer parts;
    private String mean;
    private String median;
    private String mode;
    private String highestRange;
    private String standDev;
    private String lowerQuartile;
    private String upperQuartile;
    private int interval;
    private Collection<HistogramQuestionScoresBean> info;
    private Collection<HistogramQuestionScoresBean> partInfo;
    private int[] numStudentCollection = new int[0];
    private String[] rangeCollection = new String[0];
    private int[] columnHeight = new int[0];
    private int arrayLength;
    private String range;
    private int numResponses;
    private String q1;
    private String q2;
    private String q3;
    private String q4;
    private HistogramBarBean[] histogramBars;
    private HistogramQuestionScoresBean[] histogramQuestions;
    private boolean randomType;
    private List<PublishedSectionData> assesmentParts = new ArrayList();
    private List<SelectItem> selectItemParts = new ArrayList();
    private static Log log = LogFactory.getLog(HistogramScoresBean.class);
    private Map upperQuartileStudents;
    private Map lowerQuartileStudents;
    private int maxNumberOfAnswers = 0;
    private Collection detailedStatistics;

    public void setAgent(String pagent) {
        this.agent = pagent;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getAssessmentName() {
        return this.assessmentName;
    }

    public void setAssessmentName(String passessmentName) {
        this.assessmentName = passessmentName;
    }

    public HistogramQuestionScoresBean[] getHistogramQuestions() {
        return this.histogramQuestions;
    }

    public void setHistogramQuestions(HistogramQuestionScoresBean[] phistogramQuestions) {
        this.histogramQuestions = phistogramQuestions;
    }

    public String getAssessmentId() {
        return this.assessmentId;
    }

    public void setAssessmentId(String passessmentId) {
        this.assessmentId = passessmentId;
    }

    public String getPublishedId() {
        return this.publishedId;
    }

    public void setPublishedId(String ppublishedId) {
        this.publishedId = ppublishedId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String newId) {
        this.itemId = newId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String pgroupName) {
        this.groupName = pgroupName;
    }

    public String getHasNav() {
        return this.hasNav;
    }

    public void setHasNav(String phasNav) {
        this.hasNav = phasNav;
    }

    public boolean getRandomType() {
        return this.randomType;
    }

    public void setRandomType(boolean param) {
        this.randomType = param;
    }

    public String getAllSubmissions() {
        return this.allSubmissions;
    }

    public void setAllSubmissions(String pallSubmissions) {
        this.allSubmissions = pallSubmissions;
    }

    public String[] getRangeCollection() {
        return this.rangeCollection;
    }

    public void setRangeCollection(String[] prange) {
        this.rangeCollection = prange;
    }

    public int[] getNumStudentCollection() {
        return this.numStudentCollection;
    }

    public void setNumStudentCollection(int[] pnumStudent) {
        this.numStudentCollection = pnumStudent;
    }

    public int[] getColumnHeight() {
        return this.columnHeight;
    }

    public void setColumnHeight(int[] pcolumnHeight) {
        this.columnHeight = pcolumnHeight;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    public void setArrayLength(int parrayLength) {
        this.arrayLength = parrayLength;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int pinterval) {
        this.interval = pinterval;
    }

    public Collection<HistogramQuestionScoresBean> getInfo() {
        return this.info;
    }

    public void setInfo(Collection<HistogramQuestionScoresBean> pinfo) {
        this.info = pinfo;
        this.filterInfo();
    }

    public Collection<HistogramQuestionScoresBean> getPartInfo() {
        return this.partInfo;
    }

    public String getMaxScore() {
        return this.maxScore;
    }

    public void setMaxScore(String pmaxScore) {
        this.maxScore = pmaxScore;
    }

    public String getTotalScore() {
        return this.totalScore;
    }

    public void setTotalScore(String ptotalScore) {
        this.totalScore = ptotalScore;
    }

    public String getTotalPossibleScore() {
        return this.totalPossibleScore;
    }

    public String getRoundedTotalPossibleScore() {
        try {
            String newscore = ContextUtil.getRoundedValue((String)this.totalPossibleScore, (int)2);
            return Validator.check((String)newscore, (String)"N/A");
        }
        catch (Exception e) {
            return Validator.check((String)this.totalPossibleScore, (String)"0");
        }
    }

    public void setTotalPossibleScore(String ptotalScore) {
        this.totalPossibleScore = ptotalScore;
    }

    public String getAdjustedScore() {
        return this.adjustedScore;
    }

    public void setAdjustedScore(String padjustedScore) {
        this.adjustedScore = padjustedScore;
    }

    public String getQuestionNumber() {
        return this.questionNumber;
    }

    public void setQuestionNumber(String pquestionNumber) {
        this.questionNumber = pquestionNumber;
    }

    public String getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(String ppartNumber) {
        this.partNumber = ppartNumber;
        this.filterInfo();
    }

    public String getMean() {
        return this.mean;
    }

    public void setMean(String pmean) {
        this.mean = pmean;
    }

    public String getMedian() {
        return this.median;
    }

    public void setMedian(String pmedian) {
        this.median = pmedian;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String pmode) {
        this.mode = pmode;
    }

    public String getStandDev() {
        return this.standDev;
    }

    public void setStandDev(String pstandDev) {
        this.standDev = pstandDev;
    }

    public String getLowerQuartile() {
        return this.lowerQuartile;
    }

    public void setLowerQuartile(String plowerQuartile) {
        this.lowerQuartile = plowerQuartile;
    }

    public String getUpperQuartile() {
        return this.upperQuartile;
    }

    public void setUpperQuartile(String pupperQuartile) {
        this.upperQuartile = pupperQuartile;
    }

    public String getQ1() {
        return this.q1;
    }

    public void setQ1(String pq1) {
        this.q1 = pq1;
    }

    public String getQ2() {
        return this.q2;
    }

    public void setQ2(String pq2) {
        this.q2 = pq2;
    }

    public String getQ3() {
        return this.q3;
    }

    public void setQ3(String pq3) {
        this.q3 = pq3;
    }

    public String getQ4() {
        return this.q4;
    }

    public void setQ4(String pq4) {
        this.q4 = pq4;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String prange) {
        this.range = prange;
    }

    public int getNumResponses() {
        return this.numResponses;
    }

    public void setNumResponses(int pnumResponses) {
        this.numResponses = pnumResponses;
    }

    public HistogramBarBean[] getHistogramBars() {
        if (this.histogramBars != null) {
            return this.histogramBars;
        }
        int length = this.getArrayLength();
        int[] height = this.getColumnHeight();
        int[] nums = this.getNumStudentCollection();
        String[] range = this.getRangeCollection();
        this.histogramBars = new HistogramBarBean[length];
        for (int i = 0; i < length; ++i) {
            this.histogramBars[i] = new HistogramBarBean();
            this.histogramBars[i].setColumnHeight(Integer.toString(height[i]));
            this.histogramBars[i].setNumStudents(nums[i]);
            this.histogramBars[i].setRangeInfo(range[i]);
        }
        return this.histogramBars;
    }

    public void setHistogramBars(HistogramBarBean[] bars) {
        this.histogramBars = bars;
    }

    public void addToUpperQuartileStudents(String agentId) {
        if (this.upperQuartileStudents == null) {
            this.upperQuartileStudents = new HashMap();
        }
        this.upperQuartileStudents.put(agentId, agentId);
    }

    public boolean isUpperQuartileStudent(String agentId) {
        if (this.upperQuartileStudents == null) {
            return false;
        }
        return this.upperQuartileStudents.get(agentId) != null;
    }

    public Map getUpperQuartileStudents() {
        if (this.upperQuartileStudents == null) {
            this.upperQuartileStudents = new HashMap();
        }
        return this.upperQuartileStudents;
    }

    public int getNumberOfUpperQuartileStudents() {
        if (this.upperQuartileStudents == null) {
            return 0;
        }
        return this.upperQuartileStudents.size();
    }

    public void addToLowerQuartileStudents(String agentId) {
        if (this.lowerQuartileStudents == null) {
            this.lowerQuartileStudents = new HashMap();
        }
        this.lowerQuartileStudents.put(agentId, agentId);
    }

    public boolean isLowerQuartileStudent(String agentId) {
        if (this.lowerQuartileStudents == null) {
            return false;
        }
        return this.lowerQuartileStudents.get(agentId) != null;
    }

    public Map getLowerQuartileStudents() {
        if (this.lowerQuartileStudents == null) {
            this.lowerQuartileStudents = new HashMap();
        }
        return this.lowerQuartileStudents;
    }

    public int getNumberOfLowerQuartileStudents() {
        if (this.lowerQuartileStudents == null) {
            return 0;
        }
        return this.lowerQuartileStudents.size();
    }

    public void clearUpperQuartileStudents() {
        this.upperQuartileStudents = null;
    }

    public void clearLowerQuartileStudents() {
        this.lowerQuartileStudents = null;
    }

    public int getMaxNumberOfAnswers() {
        return this.maxNumberOfAnswers;
    }

    public void setMaxNumberOfAnswers(int maxNumberOfAnswers) {
        this.maxNumberOfAnswers = maxNumberOfAnswers;
    }

    public Collection getDetailedStatistics() {
        return this.detailedStatistics;
    }

    public void setDetailedStatistics(Collection detailedStatistics) {
        this.detailedStatistics = detailedStatistics;
    }

    public boolean getShowDiscriminationColumn() {
        try {
            if (String.valueOf(EvaluationModelIfc.ALL_SCORE).equals(this.allSubmissions)) {
                return false;
            }
            return this.getTotalScore() == null ? false : Float.parseFloat(this.getTotalScore()) != 0.0f;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public boolean getShowPartAndTotalScoreSpreadsheetColumns() {
        try {
            return this.getTotalScore() == null ? false : Float.parseFloat(this.getTotalScore()) != 0.0f;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public String getUndisplayedStudentResponseInItemAnalysisColumnHeader() {
        if (this.getMaxNumberOfAnswers() < 13) {
            return "";
        }
        int first = 77;
        char firstUndisplayed = (char)first;
        int last = 65 + this.getMaxNumberOfAnswers() - 1;
        char lastUndisplayed = (char)last;
        if (first == last) {
            return String.valueOf(firstUndisplayed);
        }
        return String.valueOf(firstUndisplayed) + " - " + String.valueOf(lastUndisplayed);
    }

    public List<PublishedSectionData> getAssesmentParts() {
        return this.assesmentParts;
    }

    public void setAssesmentParts(List<PublishedSectionData> assesmentParts) {
        this.assesmentParts = assesmentParts;
        this.selectItemParts.clear();
        this.setPartNumber(assesmentParts.get(0).getSequence().toString());
        String defaultStr = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.CommonMessages", (String)"default");
        String partStr = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"part") + " ";
        String poolStr = ", " + ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"pool") + ": ";
        String text = null;
        for (PublishedSectionData section : assesmentParts) {
            text = partStr + String.valueOf(section.getSequence());
            if (!defaultStr.equals(section.getTitle())) {
                text = text + ": " + section.getTitle();
            }
            if (section.getSectionMetaDataByLabel("POOLNAME_FOR_RANDOM_DRAW") != null) {
                text = text + poolStr + section.getSectionMetaDataByLabel("POOLNAME_FOR_RANDOM_DRAW");
            }
            this.selectItemParts.add(new SelectItem((Object)String.valueOf(section.getSequence()), text));
        }
    }

    public List<SelectItem> getSelectItemParts() {
        return this.selectItemParts;
    }

    public int getAssesmentPartCount() {
        return this.assesmentParts == null ? 0 : this.assesmentParts.size();
    }

    private void filterInfo() {
        if (this.partInfo == null) {
            this.partInfo = new ArrayList();
        } else {
            this.partInfo.clear();
        }
        if (this.info == null) {
            return;
        }
        if (this.partNumber == null || this.partNumber.length() == 0) {
            this.partInfo.addAll(this.info);
        } else {
            for (HistogramQuestionScoresBean question : this.info) {
                if (!this.partNumber.equals(question.getPartNumber())) continue;
                this.partInfo.add(question);
            }
        }
    }
}

