/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.evaluation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.jsf.model.PhaseAware;
import org.sakaiproject.tool.assessment.business.entity.RecordingData;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.AgentResults;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.TotalScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.util.Validator;
import org.sakaiproject.tool.assessment.ui.listener.evaluation.SubmissionStatusListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class SubmissionStatusBean
implements Serializable,
PhaseAware {
    private String assessmentId;
    private String publishedId;
    private static final long serialVersionUID = 5517587781720762296L;
    private String assessmentName;
    private String anonymous;
    private String groupName;
    private String maxScore;
    private Collection agents;
    private Collection sortedAgents;
    private String totalScore;
    private String adjustmentTotalScore;
    private String totalScoreComments;
    private String sortProperty;
    private String lateHandling;
    private String dueDate;
    private String sortType;
    private boolean sortAscending = true;
    private String roleSelection;
    private String allSubmissions;
    private RecordingData recordingData;
    private String totalPeople;
    private String firstItem;
    private HashMap answeredItems;
    private static Log log = LogFactory.getLog(SubmissionStatusBean.class);
    private String selectedSectionFilterValue = null;
    private ArrayList allAgents;
    private int firstScoreRow;
    private int maxDisplayedScoreRows;
    private int scoreDataRows;
    private String searchString;
    private String defaultSearchString;
    private Boolean releasedToGroups = null;

    public SubmissionStatusBean() {
        log.debug((Object)"Creating a new SubmissionStatusBean");
        this.resetFields();
    }

    protected void init() {
        this.defaultSearchString = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"search_default_student_search_string");
        if (this.searchString == null) {
            this.searchString = this.defaultSearchString;
        }
        if (this.allAgents == null) {
            this.allAgents = this.getAllAgents();
        }
        ArrayList matchingAgents = this.isFilteredSearch() ? this.findMatchingAgents(this.searchString) : this.allAgents;
        this.scoreDataRows = matchingAgents.size();
        ArrayList newAgents = new ArrayList();
        if (this.maxDisplayedScoreRows == 0) {
            newAgents = matchingAgents;
        } else {
            int nextPageRow = Math.min(this.firstScoreRow + this.maxDisplayedScoreRows, this.scoreDataRows);
            newAgents = new ArrayList(matchingAgents.subList(this.firstScoreRow, nextPageRow));
            log.debug((Object)("init(): subList " + this.firstScoreRow + ", " + nextPageRow));
        }
        this.agents = newAgents;
    }

    public void endProcessValidators() {
        log.debug((Object)"endProcessValidators");
    }

    public void endProcessUpdates() {
        log.debug((Object)"endProcessUpdates");
    }

    public void startRenderResponse() {
        log.debug((Object)"startRenderResponse");
        this.init();
    }

    public String getAssessmentName() {
        return Validator.check((String)this.assessmentName, (String)"N/A");
    }

    public void setAssessmentName(String passessmentName) {
        this.assessmentName = passessmentName;
    }

    public String getAssessmentId() {
        return Validator.check((String)this.assessmentId, (String)"0");
    }

    public void setAssessmentId(String passessmentId) {
        this.assessmentId = passessmentId;
    }

    public String getPublishedId() {
        return Validator.check((String)this.publishedId, (String)"0");
    }

    public void setPublishedId(String ppublishedId) {
        this.publishedId = ppublishedId;
    }

    public String getAnonymous() {
        return Validator.check((String)this.anonymous, (String)"false");
    }

    public void setAnonymous(String panonymous) {
        this.anonymous = panonymous;
    }

    public String getGroupName() {
        return Validator.check((String)this.groupName, (String)"N/A");
    }

    public void setGroupName(String pgroupName) {
        this.groupName = pgroupName;
    }

    public String getMaxScore() {
        return Validator.check((String)this.maxScore, (String)"N/A");
    }

    public void setMaxScore(String pmaxScore) {
        this.maxScore = pmaxScore;
    }

    public Collection getAgents() {
        if (this.agents == null) {
            return new ArrayList();
        }
        return this.agents;
    }

    public void setAgents(Collection pagents) {
        this.agents = pagents;
    }

    public String getAgentInitials() {
        Collection c = this.getAgents();
        StringBuilder initialsbuf = new StringBuilder();
        if (c.isEmpty()) {
            return "";
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            try {
                AgentResults ar = (AgentResults)it.next();
                String initial = ar.getLastInitial();
                initialsbuf.append(initial);
            }
            catch (Exception ex) {
                log.warn((Object)ex.getMessage());
            }
        }
        String initials = initialsbuf.toString();
        return initials.toUpperCase();
    }

    public Object[] getAgentArray() {
        if (this.agents == null) {
            return new Object[0];
        }
        return this.agents.toArray();
    }

    public String getTotalPeople() {
        return Validator.check((String)this.totalPeople, (String)"N/A");
    }

    public void setTotalPeople(String ptotalPeople) {
        this.totalPeople = ptotalPeople;
    }

    public String getTotalScore() {
        return Validator.check((String)this.totalScore, (String)"N/A");
    }

    public void setTotalScore(String pTotalScore) {
        this.totalScore = pTotalScore;
    }

    public String getAdjustmentTotalScore() {
        return Validator.check((String)this.adjustmentTotalScore, (String)"N/A");
    }

    public void setAdjustmentTotalScore(String pAdjustmentTotalScore) {
        this.adjustmentTotalScore = pAdjustmentTotalScore;
    }

    public String getTotalScoreComments() {
        return Validator.check((String)this.totalScoreComments, (String)"");
    }

    public void setTotalScoreComments(String pTotalScoreComments) {
        log.debug((Object)("setting total score comments to " + pTotalScoreComments));
        this.totalScoreComments = pTotalScoreComments;
    }

    public String getLateHandling() {
        return Validator.check((String)this.lateHandling, (String)"1");
    }

    public void setLateHandling(String plateHandling) {
        this.lateHandling = plateHandling;
    }

    public String getDueDate() {
        return Validator.check((String)this.dueDate, (String)"N/A");
    }

    public void setDueDate(String dateString) {
        this.dueDate = dateString;
    }

    public String getSortType() {
        return Validator.check((String)this.sortType, (String)"lastName");
    }

    public void setSortType(String psortType) {
        this.sortType = psortType;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    public String getAllSubmissions() {
        return Validator.check((String)this.allSubmissions, (String)"false");
    }

    public void setAllSubmissions(String pallSubmissions) {
        this.allSubmissions = pallSubmissions;
    }

    public String getRoleSelection() {
        return Validator.check((String)this.roleSelection, (String)"N/A");
    }

    public void setRoleSelection(String proleSelection) {
        this.roleSelection = proleSelection;
    }

    public String getFirstItem() {
        return Validator.check((String)this.firstItem, (String)"");
    }

    public void setFirstItem(String pfirstItem) {
        this.firstItem = pfirstItem;
    }

    public void resetFields() {
        this.agents = new ArrayList();
        this.setAgents(this.agents);
    }

    public RecordingData getRecordingData() {
        return this.recordingData;
    }

    public void setRecordingData(RecordingData rd) {
        this.recordingData = rd;
    }

    public HashMap getAnsweredItems() {
        return this.answeredItems;
    }

    public void setAnsweredItems(HashMap newItems) {
        this.answeredItems = newItems;
    }

    public String getSelectedSectionFilterValue() {
        if (this.selectedSectionFilterValue == null) {
            if (this.isReleasedToGroups()) {
                this.setSelectedSectionFilterValue("-2");
            } else {
                this.setSelectedSectionFilterValue("-1");
            }
        }
        return this.selectedSectionFilterValue;
    }

    public void setSelectedSectionFilterValue(String param) {
        if (!param.equals(this.selectedSectionFilterValue)) {
            this.selectedSectionFilterValue = param;
            this.setFirstRow(0);
        }
    }

    public int getFirstRow() {
        return this.firstScoreRow;
    }

    public void setFirstRow(int firstRow) {
        this.firstScoreRow = firstRow;
    }

    public int getMaxDisplayedRows() {
        return this.maxDisplayedScoreRows;
    }

    public void setMaxDisplayedRows(int maxDisplayedRows) {
        this.maxDisplayedScoreRows = maxDisplayedRows;
    }

    public int getDataRows() {
        return this.scoreDataRows;
    }

    public void setAllAgents(ArrayList allAgents) {
        this.allAgents = allAgents;
    }

    public ArrayList getAllAgents() {
        log.debug((Object)"getAllAgents()");
        TotalScoresBean totalScoresBean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        String publishedId = ContextUtil.lookupParam((String)"publishedId");
        SubmissionStatusListener submissionStatusListener = new SubmissionStatusListener();
        if (!submissionStatusListener.submissionStatus(publishedId, this, totalScoresBean, false)) {
            throw new RuntimeException("failed to call questionScores.");
        }
        return this.allAgents;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        if (StringUtils.trimToNull((String)searchString) == null) {
            searchString = this.defaultSearchString;
        }
        if (!StringUtils.equals((String)searchString, (String)this.searchString)) {
            log.debug((Object)("setSearchString " + searchString));
            this.searchString = searchString;
            this.setFirstRow(0);
        }
    }

    public void search(ActionEvent event) {
        log.debug((Object)"search");
    }

    public void clear(ActionEvent event) {
        log.debug((Object)"clear");
        this.setSearchString(null);
    }

    private boolean isFilteredSearch() {
        return !StringUtils.equals((String)this.searchString, (String)this.defaultSearchString);
    }

    public ArrayList findMatchingAgents(String pattern) {
        ArrayList<AgentResults> filteredList = new ArrayList<AgentResults>();
        for (AgentResults result : this.allAgents) {
            StringBuilder name1 = new StringBuilder(result.getFirstName());
            name1.append(" ");
            name1.append(result.getLastName());
            StringBuilder name2 = new StringBuilder(result.getLastName());
            name2.append(", ");
            name2.append(result.getFirstName());
            if (!result.getFirstName().toLowerCase().startsWith(pattern.toLowerCase()) && !result.getLastName().toLowerCase().startsWith(pattern.toLowerCase()) && !result.getAgentEid().toLowerCase().startsWith(pattern.toLowerCase()) && !name1.toString().toLowerCase().startsWith(pattern.toLowerCase()) && !name2.toString().toLowerCase().startsWith(pattern.toLowerCase())) continue;
            filteredList.add(result);
        }
        return filteredList;
    }

    public boolean isReleasedToGroups() {
        if (this.releasedToGroups == null) {
            PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
            this.releasedToGroups = publishedAssessmentService.isReleasedToGroups(this.publishedId);
        }
        return this.releasedToGroups;
    }
}

