/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.bean.questionpool;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.business.questionpool.QuestionPoolTreeImpl;
import org.sakaiproject.tool.assessment.data.dao.questionpool.QuestionPoolData;
import org.sakaiproject.tool.assessment.data.model.Tree;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.BeanSort;

public class QuestionPoolShareBean
implements Serializable {
    private static final long serialVersionUID = -1154189308380595101L;
    private static Log log = LogFactory.getLog(QuestionPoolShareBean.class);
    private Long questionPoolId;
    private String questionPoolOwnerId;
    private String questionPoolName;
    private String[] destPools = new String[0];
    private String sortPropertyWith = "displayName";
    private boolean sortAscendingWith = true;
    private String sortPropertyWithout = "displayName";
    private boolean sortAscendingWithout = true;
    private Collection<AgentFacade> agentsWithAccess;
    private Collection<AgentFacade> agentsWithoutAccess;

    public String startSharePool() {
        log.debug((Object)"inside startSharePool()");
        String qpid = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("qpid");
        QuestionPoolService delegate = new QuestionPoolService();
        QuestionPoolFacade thepool = delegate.getPool(new Long(qpid), AgentFacade.getAgentString());
        this.setAgentsWithAccess((Collection)delegate.getAgentsWithAccess(new Long(qpid)));
        this.setAgentsWithoutAccess((Collection)delegate.getAgentsWithoutAccess(new Long(qpid), AgentFacade.getCurrentSiteId()));
        this.setQuestionPoolId(new Long(qpid));
        this.setQuestionPoolOwnerId(thepool.getOwnerId());
        this.setQuestionPoolName(thepool.getDisplayName());
        this.sortAgentsWithAccess();
        this.sortAgentsWithoutAccess();
        return "sharePool";
    }

    public String sharePool() {
        QuestionPoolService delegate = new QuestionPoolService();
        QuestionPoolTreeImpl tree = null;
        try {
            tree = new QuestionPoolTreeImpl(delegate.getAllPoolsWithAccess(AgentFacade.getAgentString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        ArrayList revoke = ContextUtil.paramArrayValueLike((String)"revokeCheckbox");
        for (String agentId : revoke) {
            try {
                delegate.removeQuestionPoolAccess((Tree)tree, agentId, this.getQuestionPoolId(), QuestionPoolData.READ_COPY);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        ArrayList grant = ContextUtil.paramArrayValueLike((String)"grantCheckbox");
        for (String agentId : grant) {
            try {
                delegate.addQuestionPoolAccess((Tree)tree, agentId, this.getQuestionPoolId(), QuestionPoolData.READ_COPY);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return "poolList";
    }

    public String sortByColumnHeader() {
        String sortString = ContextUtil.lookupParam((String)"orderBy");
        String ascending = ContextUtil.lookupParam((String)"ascending");
        String list = ContextUtil.lookupParam((String)"list");
        if ("agentsWithAccess".equals(list)) {
            this.setSortPropertyWith(sortString);
            this.setSortAscendingWith(Boolean.valueOf(ascending).booleanValue());
            this.sortAgentsWithAccess();
        } else {
            this.setSortPropertyWithout(sortString);
            this.setSortAscendingWithout(Boolean.valueOf(ascending).booleanValue());
            this.sortAgentsWithoutAccess();
        }
        return "shareList";
    }

    public void sortAgentsWithAccess() {
        BeanSort sort = new BeanSort(this.agentsWithAccess, this.sortPropertyWith);
        sort.toStringSort();
        this.agentsWithAccess = this.sortAscendingWith ? (ArrayList)sort.sort() : (ArrayList)sort.sortDesc();
    }

    public void sortAgentsWithoutAccess() {
        BeanSort sort = new BeanSort(this.agentsWithoutAccess, this.sortPropertyWithout);
        sort.toStringSort();
        this.agentsWithoutAccess = this.sortAscendingWithout ? (ArrayList)sort.sort() : (ArrayList)sort.sortDesc();
    }

    public Collection<AgentFacade> getAgentsWithAccess() {
        return this.agentsWithAccess;
    }

    public void setAgentsWithAccess(Collection<AgentFacade> agentsWithAccess) {
        this.agentsWithAccess = agentsWithAccess;
    }

    public Collection<AgentFacade> getAgentsWithoutAccess() {
        return this.agentsWithoutAccess;
    }

    public void setAgentsWithoutAccess(Collection<AgentFacade> agentsWithoutAccess) {
        this.agentsWithoutAccess = agentsWithoutAccess;
    }

    public String getQuestionPoolOwnerId() {
        return this.questionPoolOwnerId;
    }

    public void setQuestionPoolOwnerId(String questionPoolOwnerId) {
        this.questionPoolOwnerId = questionPoolOwnerId;
    }

    public Long getQuestionPoolId() {
        return this.questionPoolId;
    }

    public void setQuestionPoolId(Long questionPoolId) {
        this.questionPoolId = questionPoolId;
    }

    public String getQuestionPoolName() {
        return this.questionPoolName;
    }

    public void setQuestionPoolName(String questionPoolName) {
        this.questionPoolName = questionPoolName;
    }

    public void setDestPools(String[] destPools) {
        this.destPools = destPools;
    }

    public String[] getDestPools() {
        return this.destPools;
    }

    public void setSortPropertyWith(String sortPropertyWith) {
        this.sortPropertyWith = sortPropertyWith;
    }

    public String getSortPropertyWith() {
        return this.sortPropertyWith;
    }

    public void setSortAscendingWith(boolean sortAscendingWith) {
        this.sortAscendingWith = sortAscendingWith;
    }

    public boolean isSortAscendingWith() {
        return this.sortAscendingWith;
    }

    public void setSortPropertyWithout(String sortPropertyWithout) {
        this.sortPropertyWithout = sortPropertyWithout;
    }

    public String getSortPropertyWithout() {
        return this.sortPropertyWithout;
    }

    public void setSortAscendingWithout(boolean sortAscendingWithout) {
        this.sortAscendingWithout = sortAscendingWithout;
    }

    public boolean isSortAscendingWithout() {
        return this.sortAscendingWithout;
    }
}

