/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentTemplateFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishedAssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.bean.authz.AuthorizationBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.ui.listener.util.TimeUtil;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.ResourceLoader;

public class AuthorActionListener
implements ActionListener {
    private static Log log = LogFactory.getLog(AuthorActionListener.class);
    private HashMap hm = new HashMap();
    private String display_dateFormat = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"output_data_picker_w_sec");
    private SimpleDateFormat displayFormat = new SimpleDateFormat(this.display_dateFormat, new ResourceLoader().getLocale());
    private TimeUtil tu = new TimeUtil();

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        log.debug((Object)("*****Log: inside AuthorActionListener =debugging ActionEvent: " + ae));
        AssessmentService assessmentService = new AssessmentService();
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        GradingService gradingService = new GradingService();
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        author.setProtocol(ContextUtil.getProtocol());
        String showAssessmentTypes = ServerConfigurationService.getString((String)"samigo.showAssessmentTypes");
        if ("false".equalsIgnoreCase(showAssessmentTypes)) {
            author.setShowTemplateList(Boolean.FALSE.booleanValue());
        } else {
            author.setShowTemplateList(Boolean.TRUE.booleanValue());
        }
        ArrayList templateList = assessmentService.getTitleOfAllActiveAssessmentTemplates();
        if (templateList.size() == 1) {
            author.setShowTemplateList(false);
        } else {
            this.removeDefaultTemplate(templateList);
            author.setAssessmentTemplateList(templateList);
        }
        author.setAssessCreationMode("1");
        this.prepareAssessmentsList(author, assessmentService, gradingService, publishedAssessmentService);
        String s = ServerConfigurationService.getString((String)"samigo.editPubAssessment.restricted");
        if (s != null && s.toLowerCase().equals("false")) {
            author.setEditPubAssessmentRestricted(false);
        } else {
            author.setEditPubAssessmentRestricted(true);
        }
        AuthorizationBean authorizationBean = (AuthorizationBean)ContextUtil.lookupBean((String)"authorization");
        author.setIsGradeable(authorizationBean.getGradeAnyAssessment() || authorizationBean.getGradeOwnAssessment());
        author.setIsEditable(authorizationBean.getEditAnyAssessment() || authorizationBean.getEditOwnAssessment());
    }

    public void prepareAssessmentsList(AuthorBean author, AssessmentService assessmentService, GradingService gradingService, PublishedAssessmentService publishedAssessmentService) {
        author.setCoreAssessmentOrderBy("title");
        ArrayList assessmentList = assessmentService.getBasicInfoOfAllActiveAssessments("title", author.isCoreAscending());
        for (AssessmentFacade assessmentFacade : assessmentList) {
            assessmentFacade.setTitle(FormattedText.convertFormattedTextToPlaintext((String)assessmentFacade.getTitle()));
            try {
                String lastModifiedDateDisplay = this.tu.getDisplayDateTime(this.displayFormat, assessmentFacade.getLastModifiedDate());
                assessmentFacade.setLastModifiedDateForDisplay(lastModifiedDateDisplay);
            }
            catch (Exception ex) {
                log.warn((Object)("Unable to format date: " + ex.getMessage()));
            }
        }
        author.setAssessments(assessmentList);
        ArrayList publishedAssessmentList = publishedAssessmentService.getBasicInfoOfAllPublishedAssessments2("title", true, AgentFacade.getCurrentSiteId());
        this.prepareAllPublishedAssessmentsList(author, gradingService, publishedAssessmentList);
    }

    public void prepareAllPublishedAssessmentsList(AuthorBean author, GradingService gradingService, ArrayList publishedAssessmentList) {
        try {
            Site site = SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext());
            Set siteStudentRoles = site.getRolesIsAllowed("section.role.student");
            ArrayList siteUsersIdList = new ArrayList();
            if (siteStudentRoles != null && !siteStudentRoles.isEmpty()) {
                for (String role : siteStudentRoles) {
                    siteUsersIdList.addAll(site.getUsersHasRole(role));
                }
                if (siteUsersIdList.size() != 0) {
                    String siteId = site.getId();
                    this.hm.put(siteId, siteUsersIdList);
                }
            }
            Collection groups = site.getGroups();
            for (Group group : groups) {
                Set groupStudentRoles = group.getRolesIsAllowed("section.role.student");
                ArrayList groupUsersIdList = new ArrayList();
                if (groupStudentRoles == null || groupStudentRoles.isEmpty()) continue;
                for (String role : groupStudentRoles) {
                    groupUsersIdList.addAll(group.getUsersHasRole(role));
                }
                if (groupUsersIdList.size() == 0) continue;
                String groupId = group.getId();
                this.hm.put(groupId, groupUsersIdList);
            }
        }
        catch (IdUnusedException e) {
            log.warn((Object)("IdUnusedException: " + e.getMessage()));
        }
        ArrayList dividedPublishedAssessmentList = this.getTakeableList(publishedAssessmentList, gradingService);
        this.prepareRetractWarningText(author, (ArrayList)dividedPublishedAssessmentList.get(1));
        author.setPublishedAssessments(publishedAssessmentList);
    }

    public void prepareRetractWarningText(AuthorBean author, ArrayList inactivePublishedList) {
        author.setInactivePublishedAssessments(inactivePublishedList);
        boolean isAnyAssessmentRetractForEdit = false;
        for (PublishedAssessmentFacade publishedAssessmentFacade : inactivePublishedList) {
            if (!Integer.valueOf(3).equals(publishedAssessmentFacade.getStatus())) continue;
            isAnyAssessmentRetractForEdit = true;
            break;
        }
        if (isAnyAssessmentRetractForEdit) {
            author.setIsAnyAssessmentRetractForEdit(true);
        } else {
            author.setIsAnyAssessmentRetractForEdit(false);
        }
    }

    private void removeDefaultTemplate(ArrayList templateList) {
        for (int i = 0; i < templateList.size(); ++i) {
            AssessmentTemplateFacade a = (AssessmentTemplateFacade)templateList.get(i);
            if (!a.getAssessmentBaseId().equals(new Long("1"))) continue;
            templateList.remove(a);
            return;
        }
    }

    public ArrayList getTakeableList(ArrayList assessmentList, GradingService gradingService) {
        ArrayList list = new ArrayList();
        ArrayList<PublishedAssessmentFacade> activeList = new ArrayList<PublishedAssessmentFacade>();
        ArrayList<PublishedAssessmentFacade> inActiveList = new ArrayList<PublishedAssessmentFacade>();
        String siteId = AgentFacade.getCurrentSiteId();
        HashMap submissionCountHash = gradingService.getSiteSubmissionCountHash(siteId);
        HashMap inProgressCountHash = gradingService.getSiteInProgressCountHash(siteId);
        HashMap numberRetakeHash = gradingService.getSiteNumberRetakeHash(siteId);
        HashMap actualNumberRetake = gradingService.getSiteActualNumberRetakeHash(siteId);
        List needResubmitList = gradingService.getSiteNeedResubmitList(siteId);
        for (int i = 0; i < assessmentList.size(); ++i) {
            PublishedAssessmentFacade f = (PublishedAssessmentFacade)assessmentList.get(i);
            f.setTitle(FormattedText.convertFormattedTextToPlaintext((String)f.getTitle()));
            Long publishedAssessmentId = f.getPublishedAssessmentId();
            if (this.isActive(f, (HashMap)submissionCountHash.get(publishedAssessmentId), (HashMap)inProgressCountHash.get(publishedAssessmentId), (HashMap)numberRetakeHash.get(publishedAssessmentId), (HashMap)actualNumberRetake.get(publishedAssessmentId), needResubmitList)) {
                f.setActiveStatus(true);
                activeList.add(f);
            } else {
                f.setActiveStatus(false);
                inActiveList.add(f);
            }
            try {
                String lastModifiedDateDisplay = this.tu.getDisplayDateTime(this.displayFormat, f.getLastModifiedDate());
                f.setLastModifiedDateForDisplay(lastModifiedDateDisplay);
                continue;
            }
            catch (Exception ex) {
                log.warn((Object)("Unable to format date: " + ex.getMessage()));
            }
        }
        list.add(activeList);
        list.add(inActiveList);
        return list;
    }

    public boolean isActive(PublishedAssessmentFacade f, HashMap submissionCountHash, HashMap inProgressCountHash, HashMap numberRetakeHash, HashMap actualNumberRetakeHash, List needResubmitList) {
        boolean returnValue = false;
        Integer status = f.getStatus();
        Date currentDate = new Date();
        Date startDate = f.getStartDate();
        Date retractDate = f.getRetractDate();
        Date dueDate = f.getDueDate();
        boolean acceptLateSubmission = AssessmentAccessControlIfc.ACCEPT_LATE_SUBMISSION.equals(f.getLateHandling());
        int maxSubmissionsAllowed = 9999;
        if (Boolean.FALSE.equals(f.getUnlimitedSubmissions())) {
            maxSubmissionsAllowed = f.getSubmissionsAllowed();
        }
        ArrayList userIdList = new ArrayList();
        if (f.getReleaseTo() != null && !"".equals(f.getReleaseTo())) {
            if (f.getReleaseTo().indexOf("Anonymous Users") >= 0) {
                if (submissionCountHash != null) {
                    f.setSubmittedCount(submissionCountHash.size());
                } else {
                    f.setSubmittedCount(0);
                }
                if (inProgressCountHash != null) {
                    f.setInProgressCount(inProgressCountHash.size());
                } else {
                    f.setInProgressCount(0);
                }
                return dueDate == null || !dueDate.before(currentDate);
            }
            if ("Selected Groups".equals(f.getReleaseTo())) {
                PublishedAssessmentSettingsBean publishedAssessmentSettingsBean = (PublishedAssessmentSettingsBean)ContextUtil.lookupBean((String)"publishedSettings");
                publishedAssessmentSettingsBean.setAssessmentId(f.getPublishedAssessmentId());
                String[] groupsAuthorized = publishedAssessmentSettingsBean.getGroupsAuthorized();
                for (int i = 0; i < groupsAuthorized.length; ++i) {
                    if (this.hm.get(groupsAuthorized[i]) == null) continue;
                    userIdList.addAll((ArrayList)this.hm.get(groupsAuthorized[i]));
                }
            } else {
                userIdList = (ArrayList)this.hm.get(AgentFacade.getCurrentSiteId());
            }
            int submittedCounts = 0;
            int inProgressCounts = 0;
            if (userIdList != null) {
                Iterator iter = userIdList.iterator();
                String userId = null;
                boolean isStillAvailable = false;
                while (iter.hasNext()) {
                    userId = (String)iter.next();
                    int totalSubmitted = 0;
                    int totalInProgress = 0;
                    if (submissionCountHash != null && submissionCountHash.get(userId) != null && (totalSubmitted = ((Integer)submissionCountHash.get(userId)).intValue()) > 0) {
                        ++submittedCounts;
                    }
                    if (inProgressCountHash != null && inProgressCountHash.get(userId) != null && (totalInProgress = ((Integer)inProgressCountHash.get(userId)).intValue()) > 0) {
                        ++inProgressCounts;
                    }
                    if (returnValue || !(isStillAvailable = this.isStillAvailable(totalSubmitted, numberRetakeHash, actualNumberRetakeHash, userId, currentDate, dueDate, acceptLateSubmission, maxSubmissionsAllowed))) continue;
                    returnValue = true;
                }
            } else {
                returnValue = true;
            }
            f.setSubmittedCount(submittedCounts);
            f.setInProgressCount(inProgressCounts);
            if (submittedCounts + inProgressCounts > 0) {
                f.setHasAssessmentGradingData(true);
            } else {
                f.setHasAssessmentGradingData(false);
            }
            if (!Integer.valueOf(1).equals(status)) {
                returnValue = false;
            }
            if (startDate != null && startDate.after(currentDate)) {
                returnValue = false;
            }
            if (retractDate != null && retractDate.before(currentDate)) {
                returnValue = false;
            }
            if (needResubmitList.contains(f.getPublishedAssessmentId())) {
                returnValue = true;
            }
        } else {
            returnValue = false;
        }
        return returnValue;
    }

    private boolean isStillAvailable(int totalSubmitted, HashMap numberRetakeHash, HashMap actualNumberRetakeHash, String userId, Date currentDate, Date dueDate, boolean acceptLateSubmission, int maxSubmissionsAllowed) {
        boolean isStillAvailable = false;
        boolean hasSubmittedAtLeastOnce = false;
        int numberRetake = 0;
        if (numberRetakeHash != null && numberRetakeHash.get(userId) != null) {
            numberRetake = (Integer)numberRetakeHash.get(userId);
        }
        if (dueDate != null && dueDate.before(currentDate)) {
            if (acceptLateSubmission && totalSubmitted == 0) {
                return true;
            }
            int actualNumberRetake = 0;
            if (actualNumberRetakeHash != null && actualNumberRetakeHash.get(userId) != null) {
                actualNumberRetake = (Integer)actualNumberRetakeHash.get(userId);
            }
            if (actualNumberRetake < numberRetake) {
                isStillAvailable = true;
            }
        } else if (totalSubmitted < maxSubmissionsAllowed + numberRetake) {
            isStillAvailable = true;
        }
        return isStillAvailable;
    }
}

