/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentTemplateFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.ItemAuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.authz.AuthorizationBean;
import org.sakaiproject.tool.assessment.ui.listener.author.EditAssessmentListener;
import org.sakaiproject.tool.assessment.ui.listener.samlite.NameListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.TextFormat;

public class AuthorAssessmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(AuthorAssessmentListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        AssessmentService assessmentService = new AssessmentService();
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        if ("2".equals(author.getAssessCreationMode())) {
            NameListener nameListener = new NameListener();
            nameListener.processAction(null);
            return;
        }
        AssessmentSettingsBean assessmentSettings = (AssessmentSettingsBean)ContextUtil.lookupBean((String)"assessmentSettings");
        author.setOutcome("createAssessment");
        author.setFirstFromPage("editAssessment");
        if (!this.passAuthz(context)) {
            author.setOutcome("author");
            return;
        }
        AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        ItemAuthorBean itemauthorBean = (ItemAuthorBean)ContextUtil.lookupBean((String)"itemauthor");
        itemauthorBean.setTarget("assessment");
        String assessmentTitle = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)author.getAssessTitle());
        boolean isUnique = assessmentService.assessmentTitleIsUnique("0", assessmentTitle, false);
        if (assessmentTitle != null && assessmentTitle.trim().equals("")) {
            String err1 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"assessmentName_empty");
            context.addMessage(null, new FacesMessage(err1));
            author.setOutcome("author");
            return;
        }
        if (!isUnique) {
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"duplicateName_error");
            context.addMessage(null, new FacesMessage(err));
            author.setOutcome("author");
            return;
        }
        String description = author.getAssessmentDescription();
        String typeId = author.getAssessmentTypeId();
        String templateId = author.getAssessmentTemplateId();
        if (templateId == null) {
            templateId = AssessmentTemplateFacade.DEFAULTTEMPLATE.toString();
        }
        AssessmentFacade assessment = null;
        try {
            assessment = this.createAssessment(assessmentTitle.trim(), description, typeId, templateId);
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.create", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", assessmentId=" + assessment.getAssessmentId()), (boolean)true));
        }
        catch (Exception e) {
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"gradebook_service_error");
            context.addMessage(null, new FacesMessage(err));
            author.setOutcome("author");
            return;
        }
        assessmentSettings.setAssessment(assessment);
        assessmentBean.setAssessment((AssessmentIfc)assessment);
        EditAssessmentListener.showPrintLink((AssessmentBean)assessmentBean);
        author.setAssessTitle("");
        author.setAssessmentDescription("");
        author.setAssessmentTypeId("");
        author.setAssessmentTemplateId(AssessmentTemplateFacade.DEFAULTTEMPLATE.toString());
        author.setIsEditPendingAssessmentFlow(true);
        ArrayList list = assessmentService.getBasicInfoOfAllActiveAssessments("title", true);
        author.setAssessments(list);
        author.setOutcome("createAssessment");
    }

    public AssessmentFacade createAssessment(String assessmentTitle, String description, String typeId, String templateId) throws Exception {
        try {
            AssessmentService assessmentService = new AssessmentService();
            AssessmentFacade assessment = assessmentService.createAssessment(assessmentTitle, description, typeId, templateId);
            return assessment;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public boolean passAuthz(FacesContext context) {
        AuthorizationBean authzBean = (AuthorizationBean)ContextUtil.lookupBean((String)"authorization");
        boolean hasPrivilege = authzBean.getCreateAssessment();
        if (!hasPrivilege) {
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"denied_create_assessment_error");
            context.addMessage(null, new FacesMessage(err));
        }
        return hasPrivilege;
    }
}

