/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.authz.AuthorizationBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.FormattedText;

public class AuthorSettingsListener
implements ActionListener {
    private static Log log = LogFactory.getLog(AuthorSettingsListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        AssessmentSettingsBean assessmentSettings = (AssessmentSettingsBean)ContextUtil.lookupBean((String)"assessmentSettings");
        String assessmentId = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("assessmentId");
        if (assessmentId == null) {
            assessmentId = assessmentSettings.getAssessmentId().toString();
        }
        AssessmentService assessmentService = new AssessmentService();
        AssessmentFacade assessment = assessmentService.getAssessment(assessmentId);
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        author.setOutcome("editAssessmentSettings");
        if (!this.passAuthz(context, assessment.getCreatedBy())) {
            author.setOutcome("author");
            return;
        }
        author.setIsEditPendingAssessmentFlow(true);
        assessmentSettings.setAssessment(assessment);
        assessmentSettings.setAssessmentId(assessment.getAssessmentId());
        assessmentSettings.setAttachmentList(((AssessmentIfc)assessment.getData()).getAssessmentAttachmentList());
        assessmentSettings.setDisplayFormat(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"output_data_picker_w_sec"));
        assessmentSettings.resetIsValidDate();
        assessmentSettings.resetOriginalDateString();
        assessmentSettings.setNoGroupSelectedError(false);
        assessmentSettings.setBlockDivs("");
        assessmentSettings.setTitle(FormattedText.convertFormattedTextToPlaintext((String)assessment.getTitle()));
        assessmentSettings.setAuthors(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentMetaDataByLabel("ASSESSMENT_AUTHORS")));
        assessmentSettings.setFinalPageUrl(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentAccessControl().getFinalPageUrl()));
        assessmentSettings.setBgColor(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentMetaDataByLabel("ASSESSMENT_BGCOLOR")));
        assessmentSettings.setBgImage(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentMetaDataByLabel("ASSESSMENT_BGIMAGE")));
        assessmentSettings.setKeywords(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentMetaDataByLabel("ASSESSMENT_KEYWORDS")));
        assessmentSettings.setObjectives(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentMetaDataByLabel("ASSESSMENT_OBJECTIVES")));
        assessmentSettings.setRubrics(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentMetaDataByLabel("ASSESSMENT_RUBRICS")));
        assessmentSettings.setUsername(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentAccessControl().getUsername()));
        assessmentSettings.setPassword(FormattedText.convertFormattedTextToPlaintext((String)assessment.getAssessmentAccessControl().getPassword()));
        int questionSize = assessmentService.getQuestionSize(assessmentId);
        if (questionSize > 0) {
            assessmentSettings.setHasQuestions(true);
        } else {
            assessmentSettings.setHasQuestions(false);
        }
        if (ae == null) {
            author.setFromPage("author");
        } else {
            author.setFromPage("editAssessment");
        }
    }

    public boolean passAuthz(FacesContext context, String ownerId) {
        boolean hasPrivilege;
        AuthorizationBean authzBean = (AuthorizationBean)ContextUtil.lookupBean((String)"authorization");
        boolean hasPrivilege_any = authzBean.getEditAnyAssessment();
        boolean hasPrivilege_own0 = authzBean.getEditOwnAssessment();
        boolean hasPrivilege_own = hasPrivilege_own0 && this.isOwner(ownerId);
        boolean bl = hasPrivilege = hasPrivilege_any || hasPrivilege_own;
        if (!hasPrivilege) {
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"denied_edit_assessment_error");
            context.addMessage(null, new FacesMessage(err));
        }
        return hasPrivilege;
    }

    public boolean isOwner(String ownerId) {
        boolean isOwner = false;
        String agentId = AgentFacade.getAgentString();
        isOwner = agentId.equals(ownerId);
        return isOwner;
    }
}

