/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import java.util.Date;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.spring.SpringBeanLocator;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishRepublishNotificationBean;
import org.sakaiproject.tool.assessment.ui.bean.authz.AuthorizationBean;
import org.sakaiproject.tool.assessment.ui.listener.author.SaveAssessmentSettings;
import org.sakaiproject.tool.assessment.ui.listener.author.SetFromPageAsAuthorSettingsListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.TextFormat;
import org.sakaiproject.util.FormattedText;

public class ConfirmPublishAssessmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(ConfirmPublishAssessmentListener.class);
    private static final GradebookServiceHelper gbsHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper();
    private static final boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
    private boolean isFromActionSelect = false;

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        PublishedAssessmentService publishedService;
        String releaseTo;
        String releaseGroupError;
        String[] groupsAuthorized;
        String autoSubmitEnabled;
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext extContext = context.getExternalContext();
        AssessmentSettingsBean assessmentSettings = (AssessmentSettingsBean)ContextUtil.lookupBean((String)"assessmentSettings");
        AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        String assessmentId = String.valueOf(assessmentSettings.getAssessmentId());
        SaveAssessmentSettings s = new SaveAssessmentSettings();
        AssessmentService assessmentService = new AssessmentService();
        AssessmentFacade assessment = assessmentService.getAssessment(assessmentId);
        if (!this.passAuthz(context, assessment.getCreatedBy())) {
            assessmentSettings.setOutcomePublish("editAssessmentSettings");
            author.setIsErrorInSettings(true);
            return;
        }
        assessmentBean.setAssessment((AssessmentIfc)assessment);
        assessmentSettings.setHasQuestions(true);
        boolean error = false;
        String assessmentName = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getTitle());
        if (assessmentName != null && assessmentName.trim().equals("")) {
            String nameEmpty_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"assessmentName_empty");
            context.addMessage(null, new FacesMessage(nameEmpty_err));
            error = true;
        }
        if (!assessmentService.assessmentTitleIsUnique(assessmentId, assessmentName, false)) {
            String nameUnique_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"assessmentName_error");
            context.addMessage(null, new FacesMessage(nameUnique_err));
            error = true;
        }
        if (!assessmentSettings.getIsValidStartDate()) {
            String startDateErr = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"invalid_start_date");
            context.addMessage(null, new FacesMessage(startDateErr));
            error = true;
        }
        if (!assessmentSettings.getIsValidDueDate()) {
            String dueDateErr = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"invalid_due_date");
            context.addMessage(null, new FacesMessage(dueDateErr));
            error = true;
        }
        if (!assessmentSettings.getIsValidRetractDate()) {
            String retractDateErr = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"invalid_retrack_date");
            context.addMessage(null, new FacesMessage(retractDateErr));
            error = true;
        }
        Date startDate = assessmentSettings.getStartDate();
        Date dueDate = assessmentSettings.getDueDate();
        Date retractDate = assessmentSettings.getRetractDate();
        boolean isRetractEarlierThanAvaliable = false;
        if (dueDate != null && startDate != null && dueDate.before(startDate) || dueDate != null && startDate == null && dueDate.before(new Date())) {
            String dateError1 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"due_earlier_than_avaliable");
            context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, dateError1, null));
            error = true;
            assessmentSettings.setStartDate(new Date());
        }
        if (retractDate != null && startDate != null && retractDate.before(startDate) || retractDate != null && startDate == null && retractDate.before(new Date())) {
            String dateError2 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"retract_earlier_than_avaliable");
            context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, dateError2, null));
            error = true;
            isRetractEarlierThanAvaliable = true;
            assessmentSettings.setStartDate(new Date());
        }
        if (!isRetractEarlierThanAvaliable && retractDate != null && dueDate != null && retractDate.before(dueDate)) {
            String dateError3 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"retract_earlier_than_due");
            context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, dateError3, null));
            error = true;
        }
        if (assessmentSettings.getLateHandling() != null && AssessmentAccessControlIfc.NOT_ACCEPT_LATE_SUBMISSION.toString().equals(assessmentSettings.getLateHandling()) && retractDate == null && dueDate != null && assessmentSettings.getAutoSubmit()) {
            retractDate = dueDate;
            assessmentSettings.setRetractDate(dueDate);
        }
        if (assessmentSettings.getAutoSubmit() && retractDate == null && "true".equalsIgnoreCase(autoSubmitEnabled = ServerConfigurationService.getString((String)"samigo.autoSubmit.enabled"))) {
            String dateError4 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"retract_required_with_auto_submit");
            context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, dateError4, null));
            error = true;
        }
        if (!this.isFromActionSelect) {
            String scoringType;
            String submission_err;
            String unlimitedSubmissions;
            if (assessmentSettings.getReleaseTo().equals("Selected Groups")) {
                groupsAuthorized = assessmentSettings.getGroupsAuthorizedToSave();
                if (groupsAuthorized == null || groupsAuthorized.length == 0) {
                    releaseGroupError = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"choose_one_group");
                    context.addMessage(null, new FacesMessage(releaseGroupError));
                    error = true;
                    assessmentSettings.setNoGroupSelectedError(true);
                } else {
                    assessmentSettings.setNoGroupSelectedError(false);
                }
            }
            Object time = assessmentSettings.getValueMap().get("hasTimeAssessment");
            boolean isTime = false;
            if (time != null) {
                if (time instanceof String) {
                    isTime = Boolean.getBoolean((String)time);
                } else if (time instanceof Boolean) {
                    isTime = (Boolean)time;
                }
            }
            if (isTime && assessmentSettings.getTimeLimit() == 0) {
                String time_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"timeSelect_error");
                context.addMessage(null, new FacesMessage(time_err));
                error = true;
            }
            boolean ipErr = false;
            String ipString = assessmentSettings.getIpAddresses().trim();
            String[] arraysIp = ipString.split("\n");
            for (int a = 0; a < arraysIp.length; ++a) {
                String currentString = arraysIp[a];
                if (currentString.trim().equals("")) continue;
                if (a < arraysIp.length - 1) {
                    currentString = currentString.substring(0, currentString.length() - 1);
                }
                if (s.isIpValid(currentString)) continue;
                ipErr = true;
                break;
            }
            if (ipErr) {
                error = true;
                String ip_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"ip_error");
                context.addMessage(null, new FacesMessage(ip_err));
            }
            if ((unlimitedSubmissions = assessmentSettings.getUnlimitedSubmissions()) != null && unlimitedSubmissions.equals(AssessmentAccessControlIfc.LIMITED_SUBMISSIONS.toString())) {
                String submissionsAllowed = assessmentSettings.getSubmissionsAllowed().trim();
                try {
                    int submissionAllowed = Integer.parseInt(submissionsAllowed);
                    if (submissionAllowed < 1) {
                        throw new RuntimeException();
                    }
                }
                catch (RuntimeException e) {
                    error = true;
                    submission_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"submissions_allowed_error");
                    context.addMessage(null, new FacesMessage(submission_err));
                }
            }
            if ((scoringType = assessmentSettings.getScoringType()).equals(EvaluationModelIfc.AVERAGE_SCORE.toString()) && "0".equals(assessmentSettings.getUnlimitedSubmissions())) {
                try {
                    String submissionsAllowed = assessmentSettings.getSubmissionsAllowed().trim();
                    int submissionAllowed = Integer.parseInt(submissionsAllowed);
                    if (submissionAllowed < 2) {
                        throw new RuntimeException();
                    }
                }
                catch (RuntimeException e) {
                    error = true;
                    submission_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"averag_grading_single_submission");
                    context.addMessage(null, new FacesMessage(submission_err));
                }
            }
            if (assessmentSettings.getFeedbackDelivery().equals("2") && (assessmentSettings.getFeedbackDateString() == null || assessmentSettings.getFeedbackDateString().equals(""))) {
                error = true;
                String date_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"date_error");
                context.addMessage(null, new FacesMessage(date_err));
            }
        } else if (assessmentSettings.getReleaseTo().equals("Selected Groups")) {
            groupsAuthorized = assessmentSettings.getGroupsAuthorized();
            if (groupsAuthorized == null || groupsAuthorized.length == 0) {
                releaseGroupError = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"choose_release_to");
                context.addMessage(null, new FacesMessage(releaseGroupError));
                error = true;
                assessmentSettings.setNoGroupSelectedError(true);
            } else {
                assessmentSettings.setNoGroupSelectedError(false);
            }
        }
        if (assessmentSettings.getToDefaultGradebook() != null && assessmentSettings.getToDefaultGradebook().equals("1") && assessmentBean.getTotalScore() <= 0.0f) {
            String gb_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"gradebook_exception_min_points");
            context.addMessage(null, new FacesMessage(gb_err));
            error = true;
        }
        GradebookService g = null;
        if (integrated) {
            g = (GradebookService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.service.gradebook.GradebookService");
        }
        String toGradebook = assessmentSettings.getToDefaultGradebook();
        try {
            if (toGradebook != null && toGradebook.equals(EvaluationModelIfc.TO_DEFAULT_GRADEBOOK.toString()) && gbsHelper.isAssignmentDefined(assessmentSettings.getTitle(), g)) {
                String gbConflict_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"gbConflict_error");
                context.addMessage(null, new FacesMessage(gbConflict_err));
                error = true;
            }
        }
        catch (Exception e) {
            log.warn((Object)("external assessment in GB has the same title:" + e.getMessage()));
        }
        if (!this.isFromActionSelect) {
            assessmentSettings.setTitle(FormattedText.convertFormattedTextToPlaintext((String)assessmentSettings.getTitle()));
            assessmentSettings.setAuthors(FormattedText.convertFormattedTextToPlaintext((String)assessmentSettings.getAuthors()));
            assessmentSettings.setFinalPageUrl(FormattedText.convertFormattedTextToPlaintext((String)assessmentSettings.getFinalPageUrl()));
            assessmentSettings.setBgColor(FormattedText.convertFormattedTextToPlaintext((String)assessmentSettings.getBgColor()));
            assessmentSettings.setBgImage(FormattedText.convertFormattedTextToPlaintext((String)assessmentSettings.getBgImage()));
            assessmentSettings.setKeywords(FormattedText.convertFormattedTextToPlaintext((String)assessmentSettings.getKeywords()));
            assessmentSettings.setObjectives(FormattedText.convertFormattedTextToPlaintext((String)assessmentSettings.getObjectives()));
            assessmentSettings.setRubrics(FormattedText.convertFormattedTextToPlaintext((String)assessmentSettings.getRubrics()));
            assessmentSettings.setUsername(FormattedText.convertFormattedTextToPlaintext((String)assessmentSettings.getUsername()));
            assessmentSettings.setPassword(FormattedText.convertFormattedTextToPlaintext((String)assessmentSettings.getPassword()));
        }
        if (error) {
            assessmentSettings.setOutcomePublish("editAssessmentSettings");
            author.setIsErrorInSettings(true);
            return;
        }
        if (!this.isFromActionSelect) {
            assessment = s.save(assessmentSettings, true);
            assessment.setTitle(FormattedText.convertFormattedTextToPlaintext((String)assessment.getTitle()));
            assessmentSettings.setAssessment(assessment);
        }
        if ((releaseTo = assessment.getAssessmentAccessControl().getReleaseTo()) != null) {
            String alias = AgentFacade.getAgentString() + new Date().getTime();
            assessmentSettings.setAlias(alias);
            String server = ((HttpServletRequest)extContext.getRequest()).getRequestURL().toString();
            int index = server.indexOf(extContext.getRequestContextPath() + "/");
            server = server.substring(0, index);
            String url = server + extContext.getRequestContextPath();
            assessmentSettings.setPublishedUrl(url + "/servlet/Login?id=" + alias);
        }
        if (!(publishedService = new PublishedAssessmentService()).publishedAssessmentTitleIsUnique(assessmentId, assessmentName)) {
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"published_assessment_title_not_unique_error");
            context.addMessage(null, new FacesMessage(err));
            assessmentSettings.setOutcomePublish("editAssessmentSettings");
            author.setIsErrorInSettings(true);
            return;
        }
        ArrayList assessmentList = assessmentService.getBasicInfoOfAllActiveAssessments(author.getCoreAssessmentOrderBy(), author.isCoreAscending());
        author.setAssessments(assessmentList);
        PublishRepublishNotificationBean publishRepublishNotification = (PublishRepublishNotificationBean)ContextUtil.lookupBean((String)"publishRepublishNotification");
        publishRepublishNotification.setSendNotification(false);
        publishRepublishNotification.setPrePopulateText(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"pre_populate_text_publish"));
        assessmentSettings.setOutcomePublish("saveSettingsAndConfirmPublish");
        SetFromPageAsAuthorSettingsListener setFromPageAsAuthorSettingsListener = new SetFromPageAsAuthorSettingsListener();
        setFromPageAsAuthorSettingsListener.processAction(null);
    }

    public boolean passAuthz(FacesContext context, String ownerId) {
        boolean hasPrivilege;
        AuthorizationBean authzBean = (AuthorizationBean)ContextUtil.lookupBean((String)"authorization");
        boolean hasPrivilege_any = authzBean.getPublishAnyAssessment();
        boolean hasPrivilege_own0 = authzBean.getPublishOwnAssessment();
        boolean hasPrivilege_own = hasPrivilege_own0 && this.isOwner(ownerId);
        boolean bl = hasPrivilege = hasPrivilege_any || hasPrivilege_own;
        if (!hasPrivilege) {
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"denied_publish_assessment_error");
            context.addMessage(null, new FacesMessage(err));
        }
        return hasPrivilege;
    }

    public boolean isOwner(String ownerId) {
        boolean isOwner = false;
        String agentId = AgentFacade.getAgentString();
        isOwner = agentId.equals(ownerId);
        return isOwner;
    }

    public void setIsFromActionSelect(boolean isFromActionSelect) {
        this.isFromActionSelect = isFromActionSelect;
    }
}

