/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.HashMap;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentMetaData;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.IndexBean;
import org.sakaiproject.tool.assessment.ui.bean.author.TemplateBean;
import org.sakaiproject.tool.assessment.ui.listener.author.TemplateBaseListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class EditTemplateListener
extends TemplateBaseListener
implements ActionListener {
    private static Log log = LogFactory.getLog(EditTemplateListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        TemplateBean templateBean = (TemplateBean)ContextUtil.lookupBean((String)"template");
        templateBean.setOutcome("newTemplate");
        String tempName = templateBean.getNewName();
        AssessmentService assessmentService = new AssessmentService();
        boolean isUnique = assessmentService.assessmentTitleIsUnique("0", tempName, true);
        FacesContext context = FacesContext.getCurrentInstance();
        if (tempName != null && tempName.trim().equals("")) {
            String err1 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.TemplateMessages", (String)"templateName_empty");
            context.addMessage(null, new FacesMessage(err1));
            templateBean.setOutcome("template");
            return;
        }
        if (!isUnique) {
            String error = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.TemplateMessages", (String)"duplicateName_error");
            context.addMessage(null, new FacesMessage(error));
            templateBean.setOutcome("template");
            return;
        }
        templateBean.setTemplateName(tempName);
        templateBean.setIdString("0");
        templateBean.setTypeId(null);
        templateBean.setValueMap(this.getMetaDataMap());
        templateBean.setMarkForReview(Boolean.FALSE);
    }

    private HashMap getMetaDataMap() {
        HashMap<String, String> h = new HashMap<String, String>();
        AssessmentService service = new AssessmentService();
        Iterator iter = service.getDefaultMetaDataSet().iterator();
        while (iter.hasNext()) {
            String label = ((AssessmentMetaData)iter.next()).getLabel();
            if ("releaseTo".equals(label)) {
                h.put(label, "SITE_MEMBERS");
                continue;
            }
            if ("automaticSubmission_isInstructorEditable".equals(label)) {
                IndexBean templateIndex = (IndexBean)ContextUtil.lookupBean((String)"templateIndex");
                if (templateIndex.getAutomaticSubmissionEnabled()) {
                    h.put(label, "true");
                    continue;
                }
                h.put(label, "false");
                continue;
            }
            h.put(label, "true");
        }
        return h;
    }
}

