/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.authz.AuthorizationBean;
import org.sakaiproject.tool.assessment.ui.bean.qti.XMLController;
import org.sakaiproject.tool.assessment.ui.bean.qti.XMLDisplay;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class ExportAssessmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(ExportAssessmentListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        String assessmentId = ContextUtil.lookupParam((String)"assessmentId");
        XMLDisplay xmlDisp = (XMLDisplay)ContextUtil.lookupBean((String)"xml");
        log.info((Object)("ExportAssessmentListener assessmentId=" + assessmentId));
        if (!this.passAuthz(assessmentId)) {
            xmlDisp.setOutcome("exportDenied");
            String thisIp = ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getRemoteAddr();
            log.warn((Object)("Unauthorized attempt to access /samigo-app/jsf/qti/exportAssessment.xml?exportAssessmentId=" + assessmentId + " from IP : " + thisIp));
            return;
        }
        AssessmentService assessmentService = new AssessmentService();
        int success = assessmentService.updateAllRandomPoolQuestions(assessmentService.getAssessment(assessmentId));
        if (success != 0) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (success == 1) {
                String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"update_pool_error_size_too_large");
                context.addMessage(null, new FacesMessage(err));
            } else {
                String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"update_pool_error_unknown");
                context.addMessage(null, new FacesMessage(err));
            }
            xmlDisp.setOutcome("poolUpdateError");
            return;
        }
        XMLController xmlController = (XMLController)ContextUtil.lookupBean((String)"xmlController");
        xmlController.setId(assessmentId);
        xmlController.setQtiVersion(1);
        xmlController.displayAssessmentXml();
        xmlDisp.setOutcome("xmlDisplay");
    }

    private boolean passAuthz(String assessmentId) {
        AuthorizationBean authzBean = (AuthorizationBean)ContextUtil.lookupBean((String)"authorization");
        boolean hasPrivilege_any = authzBean.getEditAnyAssessment();
        boolean hasPrivilege_own0 = authzBean.getEditOwnAssessment();
        boolean hasPrivilege_own = hasPrivilege_own0 && this.isOwner(assessmentId);
        boolean hasPrivilege = hasPrivilege_any || hasPrivilege_own;
        return hasPrivilege;
    }

    private boolean isOwner(String assessmentId) {
        boolean isOwner = false;
        String agentId = AgentFacade.getAgentString();
        AssessmentService assessmentService = new AssessmentService();
        String ownerId = assessmentService.getAssessmentCreatedBy(assessmentId);
        isOwner = agentId.equals(ownerId);
        log.debug((Object)("***isOwner=" + isOwner));
        return isOwner;
    }
}

