/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.email.cover.EmailService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.service.gradebook.shared.AssignmentHasIllegalPointsException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.spring.SpringBeanLocator;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedMetaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.CalendarServiceHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishRepublishNotificationBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.TotalScoresBean;
import org.sakaiproject.tool.assessment.ui.listener.author.AuthorActionListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.TextFormat;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.util.ResourceLoader;

public class PublishAssessmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(PublishAssessmentListener.class);
    private static final GradebookServiceHelper gbsHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper();
    private static final boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
    private static final Lock repeatedPublishLock = new ReentrantLock();
    private static boolean repeatedPublish = false;
    private CalendarServiceHelper calendarService = IntegrationContextFactory.getInstance().getCalendarServiceHelper();
    private ResourceLoader rl = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionEvent ae) throws AbortProcessingException {
        block14: {
            repeatedPublishLock.lock();
            try {
                if (ae == null) {
                    repeatedPublish = false;
                    return;
                }
                UIComponent eventSource = (UIComponent)ae.getSource();
                ValueBinding vb = eventSource.getValueBinding("value");
                if (vb == null) {
                    repeatedPublish = false;
                    return;
                }
                String buttonValue = vb.getExpressionString();
                if (buttonValue.endsWith(".button_unique_save_and_publish}")) {
                    repeatedPublish = false;
                    return;
                }
                if (repeatedPublish) break block14;
                AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
                AssessmentService assessmentService = new AssessmentService();
                AssessmentSettingsBean assessmentSettings = (AssessmentSettingsBean)ContextUtil.lookupBean((String)"assessmentSettings");
                AssessmentFacade assessment = assessmentService.getAssessment(assessmentSettings.getAssessmentId().toString());
                boolean error = this.checkTitle(assessment);
                if (error) {
                    return;
                }
                author.setJustPublishedAnAssessment(true);
                int success = assessmentService.updateAllRandomPoolQuestions(assessment);
                if (success == 0) {
                    assessment = assessmentService.getAssessment(assessment.getAssessmentId().toString());
                    this.publish(assessment, assessmentSettings);
                    GradingService gradingService = new GradingService();
                    PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
                    AuthorActionListener authorActionListener = new AuthorActionListener();
                    authorActionListener.prepareAssessmentsList(author, assessmentService, gradingService, publishedAssessmentService);
                    repeatedPublish = true;
                    break block14;
                }
                repeatedPublish = false;
                FacesContext context = FacesContext.getCurrentInstance();
                if (success == 1) {
                    String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"update_pool_error_size_too_large");
                    context.addMessage(null, new FacesMessage(err));
                } else {
                    String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"update_pool_error_unknown");
                    context.addMessage(null, new FacesMessage(err));
                }
                return;
            }
            finally {
                repeatedPublishLock.unlock();
            }
        }
    }

    private void publish(AssessmentFacade assessment, AssessmentSettingsBean assessmentSettings) {
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        PublishedAssessmentFacade pub = null;
        try {
            assessment.addAssessmentMetaData("ALIAS", assessmentSettings.getAlias());
            pub = publishedAssessmentService.publishAssessment(assessment);
            PublishRepublishNotificationBean publishRepublishNotification = (PublishRepublishNotificationBean)ContextUtil.lookupBean((String)"publishRepublishNotification");
            boolean sendNotification = publishRepublishNotification.getSendNotification();
            String subject = publishRepublishNotification.getNotificationSubject();
            String notificationMessage = this.getNotificationMessage(publishRepublishNotification, assessmentSettings.getTitle(), assessmentSettings.getReleaseTo(), assessmentSettings.getStartDateString(), assessmentSettings.getPublishedUrl(), assessmentSettings.getReleaseToGroupsAsString(), assessmentSettings.getDueDateString(), assessmentSettings.getTimedHours(), assessmentSettings.getTimedMinutes(), assessmentSettings.getUnlimitedSubmissions(), assessmentSettings.getSubmissionsAllowed(), assessmentSettings.getScoringType(), assessmentSettings.getFeedbackDelivery(), assessmentSettings.getFeedbackDateString());
            if (sendNotification) {
                this.sendNotification(pub, publishedAssessmentService, subject, notificationMessage, assessmentSettings.getReleaseTo());
            }
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessment.publish", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", assessmentId=" + assessment.getAssessmentId() + ", publishedAssessmentId=" + pub.getPublishedAssessmentId()), (boolean)true));
            boolean addDueDateToCalendar = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("publishAssessmentForm:calendarDueDate") != null;
            this.calendarService.updateAllCalendarEvents(pub, assessmentSettings.getReleaseTo(), assessmentSettings.getGroupsAuthorized(), this.rl.getString("calendarDueDatePrefix") + " ", addDueDateToCalendar, notificationMessage);
        }
        catch (AssignmentHasIllegalPointsException gbe) {
            log.warn((Object)gbe);
            gbe.printStackTrace();
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"gradebook_exception_min_points");
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(err));
            throw new AbortProcessingException((Throwable)gbe);
        }
        catch (Exception e) {
            log.warn((Object)e);
            e.printStackTrace();
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"gradebook_exception_error");
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(err));
            throw new AbortProcessingException((Throwable)e);
        }
        if ("".equals(assessment.getAssessmentMetaDataByLabel("ALIAS"))) {
            String alias = assessmentSettings.getAlias();
            PublishedMetaData meta = new PublishedMetaData((AssessmentBaseIfc)pub.getData(), "ALIAS", alias);
            publishedAssessmentService.saveOrUpdateMetaData(meta);
        }
    }

    private boolean checkTitle(AssessmentFacade assessment) {
        boolean error = false;
        String assessmentName = assessment.getTitle();
        AssessmentService assessmentService = new AssessmentService();
        String assessmentId = assessment.getAssessmentBaseId().toString();
        if (assessmentName != null && assessmentName.trim().equals("")) {
            String publish_error = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"publish_error_message");
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(publish_error));
            error = true;
        }
        if (!assessmentService.assessmentTitleIsUnique(assessmentId, TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentName), false)) {
            error = true;
            String nameUnique_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"assessmentName_error");
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(nameUnique_err));
        }
        GradebookService g = null;
        if (integrated) {
            g = (GradebookService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.service.gradebook.GradebookService");
        }
        String toGradebook = assessment.getEvaluationModel().getToGradeBook();
        try {
            if (toGradebook != null && toGradebook.equals(EvaluationModelIfc.TO_DEFAULT_GRADEBOOK.toString()) && gbsHelper.isAssignmentDefined(assessmentName, g)) {
                error = true;
                String gbConflict_error = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"gbConflict_error");
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(gbConflict_error));
            }
        }
        catch (Exception e) {
            log.warn((Object)("external assessment in GB has the same title:" + e.getMessage()));
        }
        return error;
    }

    public void sendNotification(PublishedAssessmentFacade pub, PublishedAssessmentService service, String subject, String message, String releaseTo) {
        TotalScoresBean totalScoresBean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        AgentFacade instructor = new AgentFacade();
        InternetAddress fromIA = null;
        try {
            fromIA = new InternetAddress(instructor.getEmail(), instructor.getDisplayName());
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)"UnsupportedEncodingException encountered when constructing instructor's email.");
        }
        boolean groupRelease = "Selected Groups".equals(releaseTo);
        if (groupRelease) {
            totalScoresBean.setSelectedSectionFilterValue("-2");
        } else {
            totalScoresBean.setSelectedSectionFilterValue("-1");
        }
        totalScoresBean.setPublishedId(pub.getPublishedAssessmentId().toString());
        Map useridMap = totalScoresBean.getUserIdMap(7);
        AgentFacade agent = null;
        int size = useridMap.size() + 1;
        ArrayList<InternetAddress> toIAList = new ArrayList<InternetAddress>();
        try {
            toIAList.add(new InternetAddress(instructor.getEmail()));
        }
        catch (AddressException e) {
            log.warn((Object)"AddressException encountered when constructing instructor's email.");
        }
        Iterator iter = useridMap.keySet().iterator();
        boolean i = true;
        while (iter.hasNext()) {
            String userUid = (String)iter.next();
            agent = new AgentFacade(userUid);
            InternetAddress ia = null;
            try {
                ia = new InternetAddress(agent.getEmail());
            }
            catch (AddressException e) {
                log.warn((Object)("AddressException encountered when constructing toIAList email. userUid = " + userUid));
            }
            if (ia == null) continue;
            toIAList.add(ia);
        }
        InternetAddress[] toIA = new InternetAddress[toIAList.size()];
        int count = 0;
        Iterator iter2 = toIAList.iterator();
        while (iter2.hasNext()) {
            toIA[count++] = (InternetAddress)iter2.next();
        }
        String noReplyEmaillAddress = "no-reply@" + ServerConfigurationService.getServerName();
        InternetAddress[] noReply = new InternetAddress[1];
        try {
            noReply[0] = new InternetAddress(noReplyEmaillAddress);
        }
        catch (AddressException e) {
            log.warn((Object)"AddressException encountered when constructing no_reply@serverName email.");
        }
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("Content-Type: text/html");
        EmailService.sendMail((InternetAddress)fromIA, (InternetAddress[])toIA, (String)subject.toString(), (String)message, (InternetAddress[])noReply, (InternetAddress[])noReply, headers);
    }

    public String getNotificationMessage(PublishRepublishNotificationBean publishRepublishNotification, String title, String releaseTo, String startDateString, String publishedURL, String releaseToGroupsAsString, String dueDateString, Integer timedHours, Integer timedMinutes, String unlimitedSubmissions, String submissionsAllowed, String scoringType, String feedbackDelivery, String feedbackDateString) {
        String siteTitle = publishRepublishNotification.getSiteTitle();
        if (siteTitle == null || "".equals(siteTitle)) {
            try {
                Site site = SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext());
                siteTitle = site.getTitle();
                publishRepublishNotification.setSiteTitle(siteTitle);
            }
            catch (IdUnusedException iue) {
                log.warn((Object)iue);
            }
        }
        String newline = "<br />\n";
        String bold_open = "<b>";
        String bold_close = "</b>";
        StringBuilder message = new StringBuilder();
        String prePopulateText = publishRepublishNotification.getPrePopulateText();
        if (!(prePopulateText == null || prePopulateText.trim().equals("") || prePopulateText.trim().equals(this.rl.getString("pre_populate_text_publish")) || prePopulateText.trim().equals(this.rl.getString("pre_populate_text_republish")) || prePopulateText.trim().equals(this.rl.getString("pre_populate_text_regrade_republish")))) {
            message.append(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)prePopulateText));
            message.append(newline);
            message.append(newline);
        }
        message.append("\"");
        message.append(bold_open);
        message.append(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)title));
        message.append(bold_close);
        message.append("\"");
        message.append(" ");
        publishedURL = "<a target=\"_blank\" href=\"" + publishedURL + "\">" + publishedURL + "</a>";
        if ("Anonymous Users".equals(releaseTo)) {
            message.append(MessageFormat.format(this.rl.getString("available_anonymously_at"), startDateString, publishedURL));
        } else if ("Selected Groups".equals(releaseTo)) {
            message.append(MessageFormat.format(this.rl.getString("available_group_at"), startDateString, releaseToGroupsAsString, publishedURL));
        } else {
            message.append(MessageFormat.format(this.rl.getString("available_class_at"), startDateString, publishedURL));
        }
        if (dueDateString != null && !dueDateString.trim().equals("")) {
            message.append(newline);
            message.append(newline);
            message.append(MessageFormat.format(this.rl.getString("it_is_due"), dueDateString));
        }
        message.append(newline);
        message.append(newline);
        if (timedHours > 0 || timedMinutes > 0) {
            message.append(this.rl.getString("the_time_limit_is"));
            message.append(" ");
            message.append(timedHours);
            message.append(" ");
            message.append(this.rl.getString("hours"));
            if (timedMinutes > 0) {
                message.append(", ");
                message.append(timedMinutes);
                message.append(" ");
                message.append(this.rl.getString("minutes"));
            }
            message.append(". ");
            message.append(this.rl.getString("submit_when_time_is_up"));
        } else {
            message.append(this.rl.getString("there_is_no_time_limit"));
        }
        message.append(" ");
        if ("1".equals(unlimitedSubmissions)) {
            message.append(this.rl.getString("student_submit_unlimited_times"));
        } else {
            message.append(MessageFormat.format(this.rl.getString("student_submit_certain_time"), submissionsAllowed));
        }
        message.append(" ");
        if ("1".equals(scoringType)) {
            message.append(this.rl.getString("record_highest"));
        } else {
            message.append(this.rl.getString("record_last"));
        }
        message.append(newline);
        message.append(newline);
        if ("1".equals(feedbackDelivery)) {
            message.append(this.rl.getString("receive_immediate"));
        } else if ("4".equals(feedbackDelivery)) {
            message.append(this.rl.getString("receive_feedback_on_submission"));
        } else if ("3".equals(feedbackDelivery)) {
            message.append(this.rl.getString("receive_no_feedback"));
        } else {
            message.append(MessageFormat.format(this.rl.getString("feedback_available_on"), feedbackDateString));
        }
        message.append(newline);
        message.append(newline);
        StringBuffer siteTitleSb = new StringBuffer();
        siteTitleSb.append(" \"");
        siteTitleSb.append(siteTitle);
        siteTitleSb.append("\" ");
        StringBuffer portalUrlSb = new StringBuffer();
        portalUrlSb.append(" <a href=\"");
        portalUrlSb.append(ServerConfigurationService.getPortalUrl());
        portalUrlSb.append("\" target=\"_blank\">");
        portalUrlSb.append(ServerConfigurationService.getPortalUrl());
        portalUrlSb.append("</a>");
        message.append(MessageFormat.format(this.rl.getString("notification_content"), siteTitleSb.toString(), portalUrlSb.toString()));
        message.append(newline);
        message.append(newline);
        return message.toString();
    }
}

