/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.text.MessageFormat;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishRepublishNotificationBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishedAssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class PublishRepublishNotificationListener
implements ValueChangeListener {
    private static Log log = LogFactory.getLog(PublishRepublishNotificationListener.class);

    public void processValueChange(ValueChangeEvent ae) throws AbortProcessingException {
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        String currentSiteId = "";
        String title = "";
        String startDateString = "";
        PublishRepublishNotificationBean publishRepublishNotification = (PublishRepublishNotificationBean)ContextUtil.lookupBean((String)"publishRepublishNotification");
        boolean isEditPendingAssessmentFlow = author.getIsEditPendingAssessmentFlow();
        if (isEditPendingAssessmentFlow) {
            AssessmentService assessmentService = new AssessmentService();
            AssessmentSettingsBean assessmentSettings = (AssessmentSettingsBean)ContextUtil.lookupBean((String)"assessmentSettings");
            currentSiteId = assessmentService.getAssessmentSiteId(assessmentSettings.getAssessmentId().toString());
            title = assessmentSettings.getTitle();
            startDateString = assessmentSettings.getStartDateString();
        } else {
            PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
            PublishedAssessmentSettingsBean publishedAssessmentSettings = (PublishedAssessmentSettingsBean)ContextUtil.lookupBean((String)"publishedSettings");
            currentSiteId = publishedAssessmentService.getPublishedAssessmentOwner(publishedAssessmentSettings.getAssessmentId());
            title = publishedAssessmentSettings.getTitle();
            startDateString = publishedAssessmentSettings.getStartDateString();
        }
        String newPos = ae.getNewValue().toString();
        log.debug((Object)("**** ae.getNewValue : " + newPos));
        if ("2".equals(newPos)) {
            String siteTitle = "";
            try {
                Site site = SiteService.getSite((String)currentSiteId);
                siteTitle = site.getTitle();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            publishRepublishNotification.setSendNotification(true);
            StringBuilder subject = new StringBuilder("[");
            subject.append(siteTitle);
            subject.append("] \"");
            subject.append(title);
            subject.append("\" ");
            if (isEditPendingAssessmentFlow) {
                if (startDateString == null || startDateString.trim().equals("")) {
                    subject.append(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"is_available_immediately"));
                } else {
                    subject.append(MessageFormat.format(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"is_available_on"), startDateString));
                }
            } else {
                subject.append(ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"was_republished"));
            }
            publishRepublishNotification.setNotificationSubject(subject.toString());
            publishRepublishNotification.setSiteTitle(siteTitle);
        } else {
            publishRepublishNotification.setSendNotification(false);
        }
    }
}

