/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import javax.faces.event.AbortProcessingException;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedSectionFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class ReorderPartsListener
implements ValueChangeListener {
    private static Log log = LogFactory.getLog(ReorderPartsListener.class);

    public void processValueChange(ValueChangeEvent ae) throws AbortProcessingException {
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        boolean isEditPendingAssessmentFlow = author.getIsEditPendingAssessmentFlow();
        log.debug((Object)("**** isEditPendingAssessmentFlow : " + isEditPendingAssessmentFlow));
        String oldPos = ae.getOldValue().toString();
        log.debug((Object)("**** ae.getOldValue : " + oldPos));
        String newPos = ae.getNewValue().toString();
        log.debug((Object)("**** ae.getNewValue : " + newPos));
        if (isEditPendingAssessmentFlow) {
            this.setPropertiesForAssessment(newPos, oldPos);
        } else {
            this.setPropertiesForPublishedAssessment(newPos, oldPos);
        }
    }

    private void setPropertiesForAssessment(String newPos, String oldPos) {
        AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        AssessmentFacade assessment = (AssessmentFacade)assessmentBean.getAssessment();
        SectionFacade section1 = (SectionFacade)assessment.getSection(new Long(oldPos));
        SectionFacade section2 = (SectionFacade)assessment.getSection(new Long(newPos));
        if (section1 != null && section2 != null) {
            section1.setSequence(new Integer(newPos));
            section2.setSequence(new Integer(oldPos));
            AssessmentService service = new AssessmentService();
            service.saveOrUpdateSection(section1);
            service.saveOrUpdateSection(section2);
            service.updateAssessmentLastModifiedInfo((AssessmentIfc)assessment);
        }
        assessmentBean.setAssessment((AssessmentIfc)assessment);
    }

    private void setPropertiesForPublishedAssessment(String newPos, String oldPos) {
        AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        PublishedAssessmentFacade publishedAssessment = (PublishedAssessmentFacade)assessmentBean.getAssessment();
        PublishedSectionData section1 = (PublishedSectionData)publishedAssessment.getSection(new Long(oldPos));
        PublishedSectionData section2 = (PublishedSectionData)publishedAssessment.getSection(new Long(newPos));
        if (section1 != null && section2 != null) {
            section1.setSequence(new Integer(newPos));
            section2.setSequence(new Integer(oldPos));
            PublishedAssessmentService service = new PublishedAssessmentService();
            service.saveOrUpdateSection((SectionFacade)new PublishedSectionFacade((SectionDataIfc)section1));
            service.saveOrUpdateSection((SectionFacade)new PublishedSectionFacade((SectionDataIfc)section2));
            service.updateAssessmentLastModifiedInfo((AssessmentIfc)publishedAssessment);
        }
        assessmentBean.setAssessment((AssessmentIfc)publishedAssessment);
    }
}

