/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.spring.SpringBeanLocator;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedEvaluationModel;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.AssessmentGradingIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.GradebookFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.CalendarServiceHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishRepublishNotificationBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishedAssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.listener.author.AuthorActionListener;
import org.sakaiproject.tool.assessment.ui.listener.author.PublishAssessmentListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.ResourceLoader;

public class RepublishAssessmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(RepublishAssessmentListener.class);
    private static final GradebookServiceHelper gbsHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper();
    private static final boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
    private CalendarServiceHelper calendarService = IntegrationContextFactory.getInstance().getCalendarServiceHelper();
    private ResourceLoader rl = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages");

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
        boolean hasGradingData = assessmentBean.getHasGradingData();
        String publishedAssessmentId = assessmentBean.getAssessmentId();
        log.debug((Object)("publishedAssessmentId = " + publishedAssessmentId));
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        PublishedAssessmentFacade assessment = publishedAssessmentService.getPublishedAssessment(publishedAssessmentId);
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.pubassessment.republish", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", publishedAssessmentId=" + publishedAssessmentId), (boolean)true));
        assessment.setStatus(AssessmentBaseIfc.ACTIVE_STATUS);
        publishedAssessmentService.saveAssessment(assessment);
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        if (author.getIsRepublishAndRegrade() && hasGradingData) {
            this.regradeRepublishedAssessment(publishedAssessmentService, assessment);
        }
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.pubassessment.republish", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", publishedAssessmentId=" + publishedAssessmentId), (boolean)true));
        assessment.setStatus(AssessmentBaseIfc.ACTIVE_STATUS);
        publishedAssessmentService.saveAssessment(assessment);
        this.updateGB(assessment);
        PublishRepublishNotificationBean publishRepublishNotification = (PublishRepublishNotificationBean)ContextUtil.lookupBean((String)"publishRepublishNotification");
        PublishedAssessmentSettingsBean publishedAssessmentSettings = (PublishedAssessmentSettingsBean)ContextUtil.lookupBean((String)"publishedSettings");
        PublishAssessmentListener publishAssessmentListener = new PublishAssessmentListener();
        String subject = publishRepublishNotification.getNotificationSubject();
        String notificationMessage = publishAssessmentListener.getNotificationMessage(publishRepublishNotification, publishedAssessmentSettings.getTitle(), publishedAssessmentSettings.getReleaseTo(), publishedAssessmentSettings.getStartDateString(), publishedAssessmentSettings.getPublishedUrl(), publishedAssessmentSettings.getReleaseToGroupsAsString(), publishedAssessmentSettings.getDueDateString(), publishedAssessmentSettings.getTimedHours(), publishedAssessmentSettings.getTimedMinutes(), publishedAssessmentSettings.getUnlimitedSubmissions(), publishedAssessmentSettings.getSubmissionsAllowed(), publishedAssessmentSettings.getScoringType(), publishedAssessmentSettings.getFeedbackDelivery(), publishedAssessmentSettings.getFeedbackDateString());
        if (publishRepublishNotification.getSendNotification()) {
            publishAssessmentListener.sendNotification(assessment, publishedAssessmentService, subject, notificationMessage, publishedAssessmentSettings.getReleaseTo());
        }
        GradingService gradingService = new GradingService();
        AssessmentService assessmentService = new AssessmentService();
        AuthorActionListener authorActionListener = new AuthorActionListener();
        authorActionListener.prepareAssessmentsList(author, assessmentService, gradingService, publishedAssessmentService);
        author.setJustPublishedAnAssessment(true);
        boolean addDueDateToCalendar = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("publishAssessmentForm:calendarDueDate") != null;
        this.calendarService.updateAllCalendarEvents(assessment, publishedAssessmentSettings.getReleaseTo(), publishedAssessmentSettings.getGroupsAuthorized(), this.rl.getString("calendarDueDatePrefix") + " ", addDueDateToCalendar, notificationMessage);
        author.setOutcome("author");
    }

    private void regradeRepublishedAssessment(PublishedAssessmentService pubService, PublishedAssessmentFacade publishedAssessment) {
        HashMap publishedItemHash = pubService.preparePublishedItemHash((PublishedAssessmentIfc)publishedAssessment);
        HashMap publishedItemTextHash = pubService.preparePublishedItemTextHash((PublishedAssessmentIfc)publishedAssessment);
        HashMap publishedAnswerHash = pubService.preparePublishedAnswerHash((PublishedAssessmentIfc)publishedAssessment);
        PublishedAssessmentSettingsBean publishedAssessmentSettings = (PublishedAssessmentSettingsBean)ContextUtil.lookupBean((String)"publishedSettings");
        boolean updateMostCurrentSubmission = publishedAssessmentSettings.getupdateMostCurrentSubmission();
        GradingService service = new GradingService();
        List list = service.getAllAssessmentGradingData(publishedAssessment.getPublishedAssessmentId());
        Iterator iter = list.iterator();
        if (updateMostCurrentSubmission) {
            publishedAssessment.setLastNeedResubmitDate(new Date());
            String currentAgent = "";
            while (iter.hasNext()) {
                AssessmentGradingData adata = (AssessmentGradingData)iter.next();
                if (!currentAgent.equals(adata.getAgentId())) {
                    if (adata.getForGrade().booleanValue()) {
                        adata.setForGrade(Boolean.FALSE);
                        adata.setStatus(AssessmentGradingIfc.ASSESSMENT_UPDATED_NEED_RESUBMIT);
                    } else {
                        adata.setStatus(AssessmentGradingIfc.ASSESSMENT_UPDATED);
                    }
                    currentAgent = adata.getAgentId();
                }
                service.storeGrades((AssessmentGradingIfc)adata, true, (PublishedAssessmentIfc)publishedAssessment, publishedItemHash, publishedItemTextHash, publishedAnswerHash, true);
            }
        } else {
            while (iter.hasNext()) {
                AssessmentGradingData adata = (AssessmentGradingData)iter.next();
                service.storeGrades((AssessmentGradingIfc)adata, true, (PublishedAssessmentIfc)publishedAssessment, publishedItemHash, publishedItemTextHash, publishedAnswerHash, true);
            }
        }
    }

    private void updateGB(PublishedAssessmentFacade assessment) {
        GradebookService g = null;
        if (integrated) {
            g = (GradebookService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.service.gradebook.GradebookService");
        }
        if (gbsHelper.gradebookExists(GradebookFacade.getGradebookUId(), g)) {
            PublishedEvaluationModel evaluation = (PublishedEvaluationModel)assessment.getEvaluationModel();
            if (evaluation == null) {
                evaluation = new PublishedEvaluationModel();
                evaluation.setAssessmentBase((AssessmentBaseIfc)assessment.getData());
            }
            Integer scoringType = evaluation.getScoringType();
            if (evaluation.getToGradeBook() != null && evaluation.getToGradeBook().equals(EvaluationModelIfc.TO_DEFAULT_GRADEBOOK.toString())) {
                try {
                    log.debug((Object)"before gbsHelper.removeGradebook()");
                    gbsHelper.removeExternalAssessment(GradebookFacade.getGradebookUId(), assessment.getPublishedAssessmentId().toString(), g);
                }
                catch (Exception e1) {
                    log.info((Object)("Exception thrown in updateGB():" + e1.getMessage()));
                }
                try {
                    log.debug((Object)"before gbsHelper.addToGradebook()");
                    gbsHelper.addToGradebook((PublishedAssessmentData)assessment.getData(), g);
                    GradingService gradingService = new GradingService();
                    List list = null;
                    list = scoringType.equals(EvaluationModelIfc.HIGHEST_SCORE) ? gradingService.getHighestSubmittedOrGradedAssessmentGradingList(assessment.getPublishedAssessmentId()) : gradingService.getLastSubmittedOrGradedAssessmentGradingList(assessment.getPublishedAssessmentId());
                    log.debug((Object)("list size =" + list.size()));
                    for (int i = 0; i < list.size(); ++i) {
                        try {
                            AssessmentGradingData ag = (AssessmentGradingData)list.get(i);
                            log.debug((Object)("ag.scores " + ag.getTotalAutoScore()));
                            if (scoringType.equals(EvaluationModelIfc.AVERAGE_SCORE)) {
                                if (ag.getStatus() == 5) {
                                    ag.setFinalScore(ag.getFinalScore());
                                } else {
                                    Float averageScore = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAverageSubmittedAssessmentGrading(Long.valueOf(assessment.getPublishedAssessmentId()), ag.getAgentId());
                                    ag.setFinalScore(averageScore);
                                }
                            }
                            gbsHelper.updateExternalAssessmentScore((AssessmentGradingIfc)ag, g);
                            continue;
                        }
                        catch (Exception e) {
                            log.warn((Object)("Exception occues in " + i + "th record. Message:" + e.getMessage()));
                        }
                    }
                }
                catch (Exception e2) {
                    log.warn((Object)("Exception thrown in updateGB():" + e2.getMessage()));
                }
            } else {
                try {
                    gbsHelper.removeExternalAssessment(GradebookFacade.getGradebookUId(), assessment.getPublishedAssessmentId().toString(), g);
                }
                catch (Exception e) {
                    log.info((Object)("*** oh well, looks like there is nothing to remove:" + e.getMessage()));
                }
            }
        }
    }
}

