/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishedAssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.cover.SessionManager;

public class SaveAssessmentAttachmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(SaveAssessmentAttachmentListener.class);
    private boolean isForAuthorSettings;

    public SaveAssessmentAttachmentListener() {
    }

    public SaveAssessmentAttachmentListener(boolean isForAuthorSettings) {
        this.isForAuthorSettings = isForAuthorSettings;
    }

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        AssessmentService assessmentService = null;
        AssessmentFacade assessment = null;
        List attachmentList = new ArrayList();
        if (this.isForAuthorSettings) {
            assessmentService = new AssessmentService();
            AssessmentSettingsBean assessmentSettingsBean = (AssessmentSettingsBean)ContextUtil.lookupBean((String)"assessmentSettings");
            if (assessmentSettingsBean.getAssessment() != null) {
                assessment = assessmentSettingsBean.getAssessment();
                attachmentList = this.prepareAssessmentAttachment((AssessmentIfc)assessment, assessmentService);
            }
            assessmentSettingsBean.setAttachmentList(attachmentList);
        } else {
            assessmentService = new PublishedAssessmentService();
            PublishedAssessmentSettingsBean publishedAssessmentSettingsBean = (PublishedAssessmentSettingsBean)ContextUtil.lookupBean((String)"publishedSettings");
            if (publishedAssessmentSettingsBean.getAssessment() != null) {
                assessment = publishedAssessmentSettingsBean.getAssessment();
                attachmentList = this.prepareAssessmentAttachment((AssessmentIfc)assessment, assessmentService);
            }
            publishedAssessmentSettingsBean.setAttachmentList(attachmentList);
        }
    }

    private HashMap getResourceIdHash(Set attachmentSet) {
        HashMap<String, AssessmentAttachmentIfc> map = new HashMap<String, AssessmentAttachmentIfc>();
        if (attachmentSet != null) {
            for (AssessmentAttachmentIfc attach : attachmentSet) {
                map.put(attach.getResourceId(), attach);
            }
        }
        return map;
    }

    private List prepareAssessmentAttachment(AssessmentIfc assessment, AssessmentService assessmentService) {
        ToolSession session = SessionManager.getCurrentToolSession();
        if (session.getAttribute("sakaiproject.filepicker.attachments") != null) {
            Set attachmentSet = new HashSet();
            if (assessment != null) {
                attachmentSet = assessment.getAssessmentAttachmentSet();
            }
            HashMap map = this.getResourceIdHash(attachmentSet);
            ArrayList<AssessmentAttachmentIfc> newAttachmentList = new ArrayList<AssessmentAttachmentIfc>();
            String protocol = ContextUtil.getProtocol();
            List refs = (List)session.getAttribute("sakaiproject.filepicker.attachments");
            if (refs != null && refs.size() > 0) {
                for (int i = 0; i < refs.size(); ++i) {
                    Reference ref = (Reference)refs.get(i);
                    String resourceId = ref.getId();
                    if (map.get(resourceId) == null) {
                        log.debug((Object)("**** ref.Id=" + ref.getId()));
                        log.debug((Object)("**** ref.name=" + ref.getProperties().getProperty(ref.getProperties().getNamePropDisplayName())));
                        AssessmentAttachmentIfc newAttach = assessmentService.createAssessmentAttachment(assessment, ref.getId(), ref.getProperties().getProperty(ref.getProperties().getNamePropDisplayName()), protocol);
                        newAttachmentList.add(newAttach);
                        continue;
                    }
                    newAttachmentList.add((AssessmentAttachmentIfc)map.get(resourceId));
                    map.remove(resourceId);
                }
            }
            session.removeAttribute("sakaiproject.filepicker.attachments");
            session.removeAttribute("sakaiproject.filepicker.cancel");
            return newAttachmentList;
        }
        return new ArrayList();
    }
}

