/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.api.SamigoApiFactory;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.shared.api.assessment.SecureDeliveryServiceAPI;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.listener.author.EditAssessmentListener;
import org.sakaiproject.tool.assessment.ui.listener.author.SaveAssessmentSettings;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.TextFormat;
import org.sakaiproject.util.FormattedText;

public class SaveAssessmentSettingsListener
implements ActionListener {
    private static Log log = LogFactory.getLog(SaveAssessmentSettingsListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        String exitPassword;
        String moduleId;
        SecureDeliveryServiceAPI secureDeliveryService;
        String scoringType;
        String unlimitedSubmissions;
        FacesContext context = FacesContext.getCurrentInstance();
        AssessmentSettingsBean assessmentSettings = (AssessmentSettingsBean)ContextUtil.lookupBean((String)"assessmentSettings");
        boolean error = false;
        String assessmentId = String.valueOf(assessmentSettings.getAssessmentId());
        AssessmentService assessmentService = new AssessmentService();
        SaveAssessmentSettings s = new SaveAssessmentSettings();
        String assessmentName = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getTitle());
        if (assessmentName != null && assessmentName.trim().equals("")) {
            String nameEmpty_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"assessmentName_empty");
            context.addMessage(null, new FacesMessage(nameEmpty_err));
            error = true;
        }
        if (!assessmentService.assessmentTitleIsUnique(assessmentId, assessmentName, false)) {
            String nameUnique_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"assessmentName_error");
            context.addMessage(null, new FacesMessage(nameUnique_err));
            error = true;
        }
        if (!assessmentSettings.getIsValidStartDate()) {
            String startDateErr = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"invalid_start_date");
            context.addMessage(null, new FacesMessage(startDateErr));
            error = true;
        }
        if (!assessmentSettings.getIsValidDueDate()) {
            String dueDateErr = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"invalid_due_date");
            context.addMessage(null, new FacesMessage(dueDateErr));
            error = true;
        }
        if (!assessmentSettings.getIsValidRetractDate()) {
            String retractDateErr = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"invalid_retrack_date");
            context.addMessage(null, new FacesMessage(retractDateErr));
            error = true;
        }
        if (assessmentSettings.getReleaseTo().equals("Selected Groups")) {
            String[] groupsAuthorized = assessmentSettings.getGroupsAuthorizedToSave();
            if (groupsAuthorized == null || groupsAuthorized.length == 0) {
                String releaseGroupError = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"choose_one_group");
                context.addMessage(null, new FacesMessage(releaseGroupError));
                error = true;
                assessmentSettings.setNoGroupSelectedError(true);
            } else {
                assessmentSettings.setNoGroupSelectedError(false);
            }
        }
        Object time = assessmentSettings.getValueMap().get("hasTimeAssessment");
        boolean isTime = false;
        try {
            if (time != null) {
                isTime = (Boolean)time;
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Expecting Boolean hasTimeAssessment, got: " + time));
        }
        if (isTime && assessmentSettings.getTimeLimit() == 0) {
            String time_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"timeSelect_error");
            context.addMessage(null, new FacesMessage(time_err));
            error = true;
        }
        String ipString = assessmentSettings.getIpAddresses().trim();
        String[] arraysIp = ipString.split("\n");
        boolean ipErr = false;
        for (int a = 0; a < arraysIp.length; ++a) {
            String currentString = arraysIp[a];
            if (currentString.trim().equals("")) continue;
            if (a < arraysIp.length - 1) {
                currentString = currentString.substring(0, currentString.length() - 1);
            }
            if (s.isIpValid(currentString)) continue;
            ipErr = true;
            break;
        }
        if (ipErr) {
            error = true;
            String ip_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"ip_error");
            context.addMessage(null, new FacesMessage(ip_err));
        }
        if ((unlimitedSubmissions = assessmentSettings.getUnlimitedSubmissions()) != null && unlimitedSubmissions.equals(AssessmentAccessControlIfc.LIMITED_SUBMISSIONS.toString())) {
            try {
                String submissionsAllowed = assessmentSettings.getSubmissionsAllowed().trim();
                int submissionAllowed = Integer.parseInt(submissionsAllowed);
                if (submissionAllowed < 1) {
                    throw new RuntimeException();
                }
            }
            catch (RuntimeException e) {
                error = true;
                String submission_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"submissions_allowed_error");
                context.addMessage(null, new FacesMessage(submission_err));
            }
        }
        if ((scoringType = assessmentSettings.getScoringType()).equals(EvaluationModelIfc.AVERAGE_SCORE.toString()) && "0".equals(assessmentSettings.getUnlimitedSubmissions())) {
            try {
                String submissionsAllowed = assessmentSettings.getSubmissionsAllowed().trim();
                int submissionAllowed = Integer.parseInt(submissionsAllowed);
                if (submissionAllowed < 2) {
                    throw new RuntimeException();
                }
            }
            catch (RuntimeException e) {
                error = true;
                String submission_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"averag_grading_single_submission");
                context.addMessage(null, new FacesMessage(submission_err));
            }
        }
        if (assessmentSettings.getFeedbackDelivery().equals("2")) {
            if (assessmentSettings.getFeedbackDateString() == null || assessmentSettings.getFeedbackDateString().equals("")) {
                error = true;
                String date_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"date_error");
                context.addMessage(null, new FacesMessage(date_err));
            } else if (!assessmentSettings.getIsValidFeedbackDate()) {
                String feedbackDateErr = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"invalid_feedback_date");
                context.addMessage(null, new FacesMessage(feedbackDateErr));
                error = true;
            }
        }
        if ((secureDeliveryService = SamigoApiFactory.getInstance().getSecureDeliveryServiceAPI()).isSecureDeliveryAvaliable() && !"SECURE_DELIVERY_NONE_ID".equals(moduleId = assessmentSettings.getSecureDeliveryModule()) && (exitPassword = assessmentSettings.getSecureDeliveryModuleExitPassword()) != null && exitPassword.length() > 0) {
            for (int i = 0; i < exitPassword.length(); ++i) {
                char c = exitPassword.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
                error = true;
                String submission_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"exit_password_error");
                context.addMessage(null, new FacesMessage(submission_err));
                break;
            }
        }
        if (error) {
            String blockDivs = ContextUtil.lookupParam((String)"assessmentSettingsAction:blockDivs");
            assessmentSettings.setBlockDivs(blockDivs);
            assessmentSettings.setOutcomeSave("editAssessmentSettings");
            return;
        }
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        assessmentSettings.setOutcomeSave(author.getFromPage());
        s.save(assessmentSettings, false);
        ArrayList assessmentList = assessmentService.getBasicInfoOfAllActiveAssessments(author.getCoreAssessmentOrderBy(), author.isCoreAscending());
        for (AssessmentFacade assessmentFacade : assessmentList) {
            assessmentFacade.setTitle(FormattedText.convertFormattedTextToPlaintext((String)assessmentFacade.getTitle()));
        }
        author.setAssessments(assessmentList);
        EditAssessmentListener editA = new EditAssessmentListener();
        editA.setPropertiesForAssessment(author);
    }
}

